﻿using Dapper;
using Nova.Libraries;
using System;
using System.Collections.Generic;
using System.Linq;

namespace Nova.Models.Calculos
{
    public struct DateTimeSpan

    {

        private readonly int years;

        private readonly int months;

        private readonly int days;

        private readonly int hours;

        private readonly int minutes;

        private readonly int seconds;

        private readonly int milliseconds;



        public DateTimeSpan(int years, int months, int days, int hours, int minutes, int seconds, int milliseconds)

        {

            this.years = years;

            this.months = months;

            this.days = days;

            this.hours = hours;

            this.minutes = minutes;

            this.seconds = seconds;

            this.milliseconds = milliseconds;

        }



        public int Years { get { return years; } }

        public int Months { get { return months; } }

        public int Days { get { return days; } }

        public int Hours { get { return hours; } }

        public int Minutes { get { return minutes; } }

        public int Seconds { get { return seconds; } }

        public int Milliseconds { get { return milliseconds; } }



        enum Phase { Years, Months, Days, Done }

        public static DateTimeSpan DateDiffYMD(DateTime f1, DateTime f2)
        {

            int numberOfDays = (int)Math.Round((f2 - f1).TotalDays);
            DateTime date = new DateTime(new TimeSpan(numberOfDays, 0, 0, 0).Ticks);
            string dateUntil = string.Format("{0} year(s), {1} month(s) and {2} day(s)", date.Year - 1, date.Month - 1, date.Day - 1);

            DateTimeSpan spanResult = new DateTimeSpan(date.Year - 1, date.Month - 1, date.Day - 1, 0, 0, 0, 0);

            return spanResult;
        }

        public static DateTimeSpan DateDiff(DateTime dt1, DateTime dt2)
        {

            DateTime zeroTime = new DateTime(1, 1, 1);

            int leapDaysInBetween = CountLeapDays(dt1, dt2);

            TimeSpan span = dt2 - dt1;

            int years = (zeroTime + span).Year - 1;
            int months = (zeroTime + span).Month - 1;
            int days = (zeroTime + span).Day - (leapDaysInBetween % 2 == 1 ? 1 : 0);
            int weeks = days / 7;
            int remainingdays = days % 7;

           
            DateTimeSpan spanResult = new DateTimeSpan(years, months, days, 0, 0, 0, 0);

            return spanResult;
        }

        private static int CountLeapDays(DateTime dt1, DateTime dt2)
        {
            int leapDaysInBetween = 0;
            int year1 = dt1.Year, year2 = dt2.Year;
            DateTime dateValue;

            for (int i = year1; i <= year2; i++)
            {
                if (DateTime.TryParse("02/29/" + i.ToString(), out dateValue))
                {
                    if (dateValue >= dt1 && dateValue <= dt2)
                        leapDaysInBetween++;
                }
            }

            return leapDaysInBetween;
        }



        public static DateTimeSpan CompareDates(DateTime date1, DateTime date2)

        {

           

            int oldMonth = date2.Month;
            while (oldMonth == date2.Month)
            {
                date1 = date1.AddDays(-1);
                date2 = date2.AddDays(-1);
            }

            int years = 0, months = 0, days = 0, hours = 0, minutes = 0, seconds = 0, milliseconds = 0;

            // getting number of years
            while (date2.CompareTo(date1) >= 0)
            {
                years++;
                date2 = date2.AddYears(-1);
            }
            date2 = date2.AddYears(1);
            years--;


            // getting number of months and days
            oldMonth = date2.Month;
            while (date2.CompareTo(date1) >= 0)
            {
                days++;
                date2 = date2.AddDays(-1);
                if ((date2.CompareTo(date1) >= 0) && (oldMonth != date2.Month))
                {
                    months++;
                    days = 0;
                    oldMonth = date2.Month;
                }
            }
            date2 = date2.AddDays(1);
            days--;

            DateTimeSpan span = new DateTimeSpan(years, months, days, 0, 0, 0, 0);

            return span;
     

        }

    }
    public class TrabajadoresCalculosDias
    {


        public int IdTrabajador { get; set; }
        public int Dias { get; set; }
        public int DiasQuinquenio { get; set; }
        public short IdConvenioLaboralTrabajador { get; set; }
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
    }
    public class ConveniosTrabajadores
    {
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public short IdConvenioLaboralTrabajador { get; set; }
        public int IdDistribucionPlazaCategoria { get; set; }
        public short IdEstructuraOrganica { get; set; }
        public bool EsComisionado { get; set; }
        public System.DateTime FechaInicio { get; set; }
        public Nullable<System.DateTime> FechaTermino { get; set; }
        public bool EsCancelado { get; set; }
        public int UserId { get; set; }
        public System.DateTime FechaCreacion { get; set; }
        public string Observacion { get; set; }
        public bool EsCuotaSindical { get; set; }
        public Nullable<System.DateTime> FechaCuotaSindical { get; set; }
        public int IdTrabajador { get; set; }
        public string ConvenioLaboral { get; set; }

    }
    public class DiasComisionesTrabajadores
    {

        public int IdTrabajador { get; set; }
        public int IdIncidenciaTrabajador { get; set; }
        public int Dias { get; set; }
        public int IdIncidencia { get; set; }

    }


    public class Antiguedad
    {
        public DateTime FechaIngreso { get; set; }
        public TimeSpan AntiguedadTrabajador { get; set; }
        public int Years { get; set; }
        public int Months { get; set; }
        public int Days { get; set; }
        public int DiasPermiso { get; set; } = 0;


        public int IdTrabajador { get; set; }
    }
    public class TrabajadorAntiguedad
    {
        private DateTime FechaDeterminada { get; set; }
      
        private static bdAriesEntities db = new bdAriesEntities();
        private static bdNovaEntities dbNova = new bdNovaEntities();
        public bool CalcularParaQuinquenio { get; set; }
        public List<Antiguedad> AntiguedadTrabajadores { get; set; } = new List<Antiguedad>();

        public List<vwDatosAspirantesTrabajadores> TrabajadoresAltas = new List<vwDatosAspirantesTrabajadores>();
        public List<vwDatosAspirantesTrabajadores> TrabajadoresBajas = new List<vwDatosAspirantesTrabajadores>();

        private List<DiasComisionesTrabajadores> diascomisiones { get; set; }
        public Antiguedad getAntiguedadPorTrabajador(int idt)
        {
            Antiguedad rs = this.AntiguedadTrabajadores.FirstOrDefault(w => w.IdTrabajador == idt);
            return rs;
        }

        public Antiguedad SumarUnDia(int idtrabajador)
        {
            var original= AntiguedadTrabajadores.Where(a => a.IdTrabajador == idtrabajador).FirstOrDefault();
            // Convertir años, meses y días a una fecha, tomando una fecha base arbitraria (por ejemplo, 1 de enero de 2000)
            DateTime fechaBase = new DateTime(2000, 1, 1);
            DateTime fechaAntiguedad = fechaBase.AddYears(original.Years).AddMonths(original.Months).AddDays(original.Days);

            // Sumar un día a la fecha de antigüedad
            DateTime nuevaFechaAntiguedad = fechaAntiguedad.AddDays(1);

            Antiguedad nueva = new Antiguedad();
            nueva.IdTrabajador = original.IdTrabajador;
            nueva.AntiguedadTrabajador = original.AntiguedadTrabajador;
            
            nueva.DiasPermiso = original.DiasPermiso;
            

            // Calcular la nueva antigüedad
            int totalDays = (nuevaFechaAntiguedad - fechaBase).Days;
            nueva.Years = totalDays / 365;
            totalDays %= 365;
            nueva.Months = totalDays / 30;
            nueva.Days = totalDays % 30;

            return nueva;

        }

        private List<Kardex_ctTrabajador> ObtenerTrabajadores()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string query;

            query = @"   SELECT IdTrabajador 
                  , IdKardex 
                  , FechaAsignacion 
              FROM   Kardex_ctTrabajador  ";

            List<Kardex_ctTrabajador> trabajadoresbd = new List<Kardex_ctTrabajador>();

            List<vwDatosAspirantesTrabajadores> trabajadoresBajas = new List<vwDatosAspirantesTrabajadores>();
            //List<vwDatosAspirantesTrabajadores> trabajadoresAltas = new List<vwDatosAspirantesTrabajadores>();

            string querybajas;

            querybajas = @"   SELECT * FROM   vwDatosAspirantesTrabajadores where EstatusTrabajador='BAJA' ";
            TrabajadoresBajas= (List<vwDatosAspirantesTrabajadores>)dp.connection.Query<vwDatosAspirantesTrabajadores>(querybajas);

            querybajas = @"   SELECT * FROM   vwDatosAspirantesTrabajadores where EstatusTrabajador='ALTA' ";
            TrabajadoresAltas = (List<vwDatosAspirantesTrabajadores>)dp.connection.Query<vwDatosAspirantesTrabajadores>(querybajas);

            trabajadoresbd = (List<Kardex_ctTrabajador>)dp.connection.Query<Kardex_ctTrabajador>(query);

            return trabajadoresbd;
        }

        private List<ConveniosTrabajadores> ObtenerConveniosComisionesTrabajadores()
        {

            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string query = @"SELECT  IdConvenioLaboralTrabajadorCategoria
      ,a.IdConvenioLaboralTrabajador
      ,a.IdDistribucionPlazaCategoria
      ,a.IdEstructuraOrganica
      ,EsComisionado
      ,a.FechaInicio
      ,a.FechaTermino
      ,EsCancelado
      ,UserId
      ,FechaCreacion
      ,a.Observacion
      ,EsCuotaSindical
      ,FechaCuotaSindical
      ,IdTrabajador,g.ConvenioLaboral
  FROM Convenios_stConvenioLaboralTrabajadorCategoria a
  inner join Convenios_stConvenioLaboralTrabajador b on a.IdConvenioLaboralTrabajador=b.IdConvenioLaboralTrabajador
  inner join Plazas_stDistribucionPlazaCategoria c on a.IdDistribucionPlazaCategoria=c.IdDistribucionPlazaCategoria
  inner join Plazas_ctCategoria d on d.IdCategoria=c.IdCategoria
  inner join Convenios_stRelacionConvenioLaboral e on e.IdRelacionConvenioLaboral=d.IdRelacionConvenioLaboral
    inner join Catalogos_ctConvenioLaboral g on g.IdConvenioLaboral=e.IdConvenioLaboral
where g.ConvenioLaboral NOT  IN ('CONTRATO') and a.EsPlazaBase=1
  order by IdTrabajador,a.FechaInicio,a.FechaTermino";

            List<ConveniosTrabajadores> convenios = new List<ConveniosTrabajadores>();

            convenios = (List<ConveniosTrabajadores>)dp.connection.Query<ConveniosTrabajadores>(query);


            List<TrabajadoresCalculosDias> diasantiguedadlaboral = new List<TrabajadoresCalculosDias>();

 
//            string consulta = @"SELECT   a.IdConvenioLaboralTrabajadorCategoria  FROM Convenios_SuplenciasControl a
//left join  Nomina_SuplenciasSolicitudes b on a.IdSuplenciaSolicitud=b.IdSuplenciaSolicitud
//left join Nomina_SuplenciaTipo c on c.IdTipoSuplencia=b.IdTipoSuplencia
//where (a.IdSuplenciaSolicitud is null  ) or 
 
//(a.IdSuplenciaSolicitud is not null  
//and c.TipoSuplencia like '%COMISIÓN%'  
//)
//or (a.IdSuplenciaSolicitud is not null  
//and c.TipoSuplencia='CAMBIO DE LUGAR FISCO DE TRABAJO'
//)
//or (a.IdSuplenciaSolicitud is not null  
//--and c.TipoSuplencia like '%LICENCIA SIN GOCE DE SUELDO%'
//AND c.TipoSuplencia IN (
//            'LICENCIA CON GOCE DE SUELDO POR REPOSICIÓN DE VACACIONES',
//            'LICENCIA SIN GOCE DE SUELDO PARA OCUPAR PUESTO DE CONFIANZA',
//            'LICENCIA SIN GOCE DE SUELDO POR CAMBIO DE NOMINA',
//            'LICENCIA SIN GOCE DE SUELDO POR ENFERMEDAD TEMPORAL DEFINITIVA'
//        )
//)
//or (a.IdSuplenciaSolicitud is not null  
//and c.TipoSuplencia like '%ESCALAF%'
//)";

//            List<Int64> removercomisiones = new List<Int64>();
//            removercomisiones = (List<Int64>)dp.connection.Query<Int64>(consulta);

//            List<ConveniosTrabajadores> puestos = convenios.Where(w => !removercomisiones.Contains(w.IdConvenioLaboralTrabajadorCategoria)).ToList();


            this.GenerarDiasComisiones();

            return convenios;
            //return puestos;

        }

        private void GenerarDiasComisiones()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");


            string query = @"select * from (
select q.*,w.IdIncidenciaTrabajador as IdIncidencia from(
 SELECT 
idtrabajador,a.IdIncidenciaTrabajador
 ,case when  a.FechaTermino>getdate() then  DATEDIFF(DAY, a.FechaInicio, getdate()) else  
                              DATEDIFF(DAY, a.FechaInicio, a.FechaTermino+1) end as dias
                          FROM IncidenciaPermiso_stIncidenciaTrabajador  a 
                          inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
                          inner join Convenios_stConvenioLaboralTrabajador c on c.IdConvenioLaboralTrabajador=b.IdConvenioLaboralTrabajador
                            INNER JOIN Catalogos_ctTipoIncidencia qq on a.IdTipoIncidencia=qq.IdTipoIncidencia
  inner join Catalogos_ctTipoIncidenciaPermiso ww on ww.IdTipoIncidenciaPermiso=qq.IdTipoIncidenciaPermiso
                          where a.EsCancelada=0 and  qq.EsPermiso=1 and qq.Incidencia in ('LICENCIA SIN GOCE DE SUELDO PARA ATENDER SITUACIONES PERSONALES','LICENCIA SIN GOCE DE SUELDO PARA OCUPAR PUESTO DE ELECCIÓN POPULAR')
                          ) as q 
                           left join vwLicenciasTrabajadores w 
                           on q.IdTrabajador=w.IdTrabajador and w.IdIncidenciaTrabajador=q.IdIncidenciaTrabajador
                           and  ESTATUS<>'PROXIMA' 
                           ) as r where
                           IdIncidencia is not null";

            this.diascomisiones = (List<DiasComisionesTrabajadores>)dp.connection.Query<DiasComisionesTrabajadores>(query);

        }
        private int ObtenerDiasPermisos(int idt)
        {
            int diasPermisos = 0;
            var existendias = diascomisiones.Where(s => s.IdTrabajador == idt).FirstOrDefault();

            if (existendias != null)
                diasPermisos = diascomisiones.Where(s => s.IdTrabajador == idt).Sum(a => a.Dias);

            return diasPermisos;
        }
        public void CalcularFechaIngreso(DateTime fechaDeCorte)
        {
            this.FechaDeterminada = fechaDeCorte;

            // Lógica para obtener los trabajadores y sus contratos
            List<Kardex_ctTrabajador> trabajadoresbd = ObtenerTrabajadores();
            List<ConveniosTrabajadores> convenios = ObtenerConveniosComisionesTrabajadores();

            foreach (var item in trabajadoresbd)
            {
                DateTime fechaIngreso = DateTime.MinValue;
                DateTime fechaTermino = DateTime.MinValue;
                DateTime fechaAnterior = DateTime.MinValue;
                bool SinfechadeterminoUltimocontrato = false;

                List<ConveniosTrabajadores> puestos = convenios
                    .Where(w => w.IdTrabajador == item.IdTrabajador )
                    .ToList();

                
                foreach (var contrato in puestos)
                {
                    if (contrato.FechaInicio > fechaAnterior.AddDays(1))
                    {
                        fechaIngreso = contrato.FechaInicio;
                    }

                    if (contrato.FechaTermino == null)
                    {
                        SinfechadeterminoUltimocontrato = true ;
                    }

                    if (contrato.FechaTermino != null && contrato.FechaTermino < fechaDeCorte
                        )
                    {
                        fechaTermino = contrato.FechaTermino.Value;
                    }
                    else
                        if (contrato.FechaTermino != null
                        && contrato.FechaTermino > fechaTermino)
                    {
                        fechaTermino = contrato.FechaTermino.Value;
                    }

                    fechaAnterior = contrato.FechaTermino ?? DateTime.MinValue;
                }
                if (puestos.Count == 0)
                { //quiere decir qeu tuvo un cambio de ubicacion y el sistema
                    // lo elimino de la lista de convenios
                    //habra que tomar el que trae actulamente
                    var trabajador = TrabajadoresAltas.Where(s => s.IdTrabajador == item.IdTrabajador && s.RestringirMenu!=null ).OrderBy(a=> a.FechaInicio).FirstOrDefault();
                    if (trabajador != null)
                        fechaIngreso = trabajador.FechaInicio.Value;
                    else
                    {
                        var trabajadoralta = TrabajadoresAltas.Where(s => s.IdTrabajador == item.IdTrabajador ).OrderBy(a => a.FechaInicio).FirstOrDefault();
                        if (trabajadoralta != null)
                            fechaIngreso = trabajadoralta.FechaInicio.Value;
                        else
                        {
                            var trabajadorbaja = TrabajadoresBajas.Where(s => s.IdTrabajador == item.IdTrabajador).FirstOrDefault();
                            if (trabajadorbaja != null)
                                fechaIngreso = trabajadorbaja.FechaInicio.Value;
                        }
                    }
                }

                //    TimeSpan antiguedad;

                //    //if (CalcularParaQuinquenio)
                //    //antiguedad = fechaDeCorte.AddDays(1) - fechaIngreso;
                //    //else
                //    antiguedad = fechaDeCorte - fechaIngreso;

                //    // Restar permisos solicitados a la antigüedad
                //    int diasPermisos = ObtenerDiasPermisos(item.IdTrabajador);
                //    antiguedad = antiguedad.Subtract(TimeSpan.FromDays(diasPermisos));
                //    bool bajaantesdefechadecorte = false;
                //    // Ajustar la antigüedad si la fecha de término del contrato es menor a la fecha determinada
                //    if (fechaTermino != DateTime.MinValue && fechaTermino < fechaDeCorte && SinfechadeterminoUltimocontrato==false)
                //    {
                //        bajaantesdefechadecorte = true;

                //            antiguedad = fechaTermino - fechaIngreso;


                //    }

                //    //int años = (int)(antiguedad.Days / 365);
                //    //int meses = (int)((antiguedad.Days % 365) / 30);
                //    //int dias = antiguedad.Days - (años * 365 + meses * 30);
                //    DateTime fechaInicio = fechaIngreso;
                //    DateTime fechaFin = fechaDeCorte;



                //    if (bajaantesdefechadecorte)
                //    {
                //        fechaFin = fechaTermino;
                //    }
                //        int diasDePermiso = diasPermisos; // Restaremos  días de permiso

                //    // Restamos los días de permiso de la fecha de finalización
                //    fechaFin = fechaFin.AddDays(-diasDePermiso);

                //    // Cálculo de la antigüedad
                //    int años = fechaFin.Year - fechaInicio.Year;
                //    if (fechaInicio.Month > fechaFin.Month || (fechaInicio.Month == fechaFin.Month && fechaInicio.Day > fechaFin.Day))
                //    {
                //        años--;
                //    }

                //    DateTime fechaTemporal = fechaInicio.AddYears(años);
                //    int meses = 0;
                //    while (fechaTemporal.AddMonths(meses) <= fechaFin)
                //    {
                //        meses++;
                //    }
                //    meses--; // Restamos 1 porque el bucle contará un mes de más

                //    int dias = (fechaFin.AddDays(1) - fechaTemporal.AddMonths(meses)).Days;




                //    Antiguedad valor = new Antiguedad
                //    {
                //        AntiguedadTrabajador = antiguedad,
                //        IdTrabajador = item.IdTrabajador,
                //        Years = años,
                //        Months = meses,
                //        Days = dias,
                //        DiasPermiso= diasPermisos,
                //          FechaIngreso = fechaIngreso
                //};

                TimeSpan antiguedad;
                int diasPermisos = ObtenerDiasPermisos(item.IdTrabajador);
                DateTime fechaInicio = fechaIngreso.AddDays(diasPermisos);
                DateTime fechaFin = fechaDeCorte;
                bool bajaantesdefechadecorte = false;

                // Ajustar la antigüedad si la fecha de término del contrato es menor a la fecha determinada
                if (fechaTermino != DateTime.MinValue && fechaTermino < fechaDeCorte && SinfechadeterminoUltimocontrato == false)
                {
                    bajaantesdefechadecorte = true;
                    fechaFin = fechaTermino;
                }

                antiguedad = fechaFin - fechaInicio;

                // Cálculo de la antigüedad
                int años = fechaFin.Year - fechaInicio.Year;
                if (fechaInicio.Month > fechaFin.Month || (fechaInicio.Month == fechaFin.Month && fechaInicio.Day > fechaFin.Day))
                {
                    años--;
                }

                DateTime fechaTemporal = fechaInicio.AddYears(años);
                int meses = 0;
                while (fechaTemporal.AddMonths(meses) <= fechaFin)
                {
                    meses++;
                }
                meses--; // Restamos 1 porque el bucle contará un mes de más

                int dias = (fechaFin - fechaTemporal.AddMonths(meses)).Days;

                Antiguedad valor = new Antiguedad
                {
                    AntiguedadTrabajador = antiguedad,
                    IdTrabajador = item.IdTrabajador,
                    Years = años,
                    Months = meses,
                    Days = dias,
                    DiasPermiso = diasPermisos,
                    FechaIngreso = fechaIngreso
                };

                AntiguedadTrabajadores.Add(valor);

            }
        }







        //    public class TrabajadorAntiguedad
        //    {
        //        private DateTime FechaDeterminada { get; set; }
        //        private static bdAriesEntities db = new bdAriesEntities();
        //        private static bdNovaEntities dbNova = new bdNovaEntities();

        //        public List<Antiguedad> AntiguedadTrabajadores { get; set; } = new List<Antiguedad>();



        //        public Antiguedad getAntiguedadPorTrabajador(int idt)
        //        {
        //            Antiguedad rs= new Antiguedad();
        //            rs=this.AntiguedadTrabajadores.Where(w => w.IdTrabajador == idt).FirstOrDefault();
        //            return rs;
        //        }
        //        public void CalcularFechaIngreso(DateTime fechadecorte)
        //        {
        //            this.FechaDeterminada = fechadecorte;

        //            dbNova.Database.CommandTimeout = 0;
        //            // this:Trabajadores = db.vwPlanesEstudioAsignaturas.ToList();
        //            //this.campus = db.vwCampus.ToList();


        //            DapperQuery dp = new DapperQuery("bdNovaEntities");

        //            string query;

        //            query = @"   SELECT IdTrabajador 
        //      , IdKardex 
        //      , FechaAsignacion 
        //  FROM   Kardex_ctTrabajador where idtrabajador=526 ";

        //            List<Kardex_ctTrabajador> trabajadoresbd = new List<Kardex_ctTrabajador>();

        //            List<vwDatosAspirantesTrabajadores> trabajadoresBajas = new List<vwDatosAspirantesTrabajadores>();

        //            string querybajas;

        //            querybajas = @"   SELECT * FROM   vwDatosAspirantesTrabajadores where EstatusTrabajador='BAJA' ";
        //            trabajadoresBajas = (List<vwDatosAspirantesTrabajadores>)dp.connection.Query<vwDatosAspirantesTrabajadores>(querybajas);

        //            trabajadoresbd = (List<Kardex_ctTrabajador>)dp.connection.Query<Kardex_ctTrabajador>(query);

        //            query = "select * from vwLicenciasTrabajadores where   TipoIncidenciaPermiso IN ('COMISIÓN','PERMISO')";
        //            var trabajadoresComisionados = (List<vwLicenciasTrabajadores>)dp.connection.Query<vwLicenciasTrabajadores>(query);

        //            var iddTrabajadoresVigentes = string.Join(",", trabajadoresbd
        //                                       .Select(p => p.IdTrabajador.ToString())); ;

        //            string query2 = @"
        //  SELeCT * FRoM 
        //  Convenios_SuplenciasControl a inner join [IncidenciaPermiso_stIncidenciaTrabajador] b
        //  on a.IdIncidenciaTrabajador=b.IdIncidenciaTrabajador 
        //  inner join Convenios_stConvenioLaboralTrabajadorCategoria z on
        //  z.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoriaAnterior
        //  inner join Convenios_stConvenioLaboralTrabajador x on
        //  z.IdConvenioLaboralTrabajador=x.IdConvenioLaboralTrabajador
        //  inner join Kardex_ctTrabajador y on y.IdTrabajador=x.IdTrabajador
        //  inner join [Catalogos_ctTipoIncidencia] c
        //   on c.IdTipoIncidencia=b.IdTipoIncidencia
        //   inner join Catalogos_ctTipoIncidenciaPermiso d
        //   on d.[IdTipoIncidenciaPermiso]=c.[IdTipoIncidenciaPermiso]
        //  where [IdConvenioLaboralTrabajadorCategoriaAnterior]
        //  in (select [IdConvenioLaboralTrabajadorCategoria] from
        //  [vwDatosAspirantesTrabajadoresHistorial]
        //  where idtrabajador in(" + iddTrabajadoresVigentes + @")

        //  )
        //  )";


        //            query = @"SELECT  IdConvenioLaboralTrabajadorCategoria
        //      ,a.IdConvenioLaboralTrabajador
        //      ,a.IdDistribucionPlazaCategoria
        //      ,a.IdEstructuraOrganica
        //      ,EsComisionado
        //      ,a.FechaInicio
        //      ,a.FechaTermino
        //      ,EsCancelado
        //      ,UserId
        //      ,FechaCreacion
        //      ,a.Observacion
        //      ,EsCuotaSindical
        //      ,FechaCuotaSindical
        //      ,IdTrabajador,g.ConvenioLaboral
        //  FROM Convenios_stConvenioLaboralTrabajadorCategoria a
        //  inner join Convenios_stConvenioLaboralTrabajador b on a.IdConvenioLaboralTrabajador=b.IdConvenioLaboralTrabajador
        //  inner join Plazas_stDistribucionPlazaCategoria c on a.IdDistribucionPlazaCategoria=c.IdDistribucionPlazaCategoria
        //  inner join Plazas_ctCategoria d on d.IdCategoria=c.IdCategoria
        //  inner join Convenios_stRelacionConvenioLaboral e on e.IdRelacionConvenioLaboral=d.IdRelacionConvenioLaboral
        //    inner join Catalogos_ctConvenioLaboral g on g.IdConvenioLaboral=e.IdConvenioLaboral
        //where g.ConvenioLaboral NOT  IN ('HONORARIOS')
        //  order by IdTrabajador,a.FechaInicio,a.FechaTermino";

        //            List<ConveniosTrabajadores> convenios = new List<ConveniosTrabajadores>();

        //            convenios = (List<ConveniosTrabajadores>)dp.connection.Query<ConveniosTrabajadores>(query);


        //            List<TrabajadoresCalculosDias> diasantiguedadlaboral = new List<TrabajadoresCalculosDias>();

        //            string consulta = @"SELECT IdConvenioLaboralTrabajadorCategoria
        //  FROM vwDatosAspirantesTrabajadoresHistorial 
        //  where
        // cast(IdTrabajador as nvarchar(10))+'-'+ cast(cast(fechainicio  as date)as nvarchar(10))+'-' + cast(cast(fechatermino as date) as nvarchar(10))  in 
        //   (select  cast(IdTrabajador as nvarchar(10))+'-'+cast(cast(fechainicioincidencia as date) as nvarchar(10)) + '-' + cast(cast(fechaterminoincidencia as date) as nvarchar(10))
        //   from vwLicenciasTrabajadores where (TipoIncidenciaPermiso='COMISIÓN' or Incidencia='LICENCIA SIN GOCE DE SUELDO PARA OCUPAR PUESTO DE CONFIANZA')
        //   )";
        //            consulta = @"SELECT   a.IdConvenioLaboralTrabajadorCategoria  FROM Convenios_SuplenciasControl a
        //left join  Nomina_SuplenciasSolicitudes b on a.IdSuplenciaSolicitud=b.IdSuplenciaSolicitud
        //left join Nomina_SuplenciaTipo c on c.IdTipoSuplencia=b.IdTipoSuplencia
        //where (a.IdSuplenciaSolicitud is null  ) or (a.IdSuplenciaSolicitud is not null  and 
        //c.TipoSuplencia<>'POR NECESIDADES DEL CENTRO'
        //)";
        //            //         string consulta = @"SELECT IdConvenioLaboralTrabajadorCategoria
        //            //from vwLicenciasTrabajadores where  ESTATUS<>'ACTIVA' and (TipoIncidenciaPermiso='COMISIÓN' or Incidencia='LICENCIA SIN GOCE DE SUELDO PARA OCUPAR PUESTO DE CONFIANZA')";

        //            List<Int64> removercomisiones = new List<Int64>();
        //            removercomisiones = (List<Int64>)dp.connection.Query<Int64>(consulta);


        //            foreach (var item in trabajadoresbd)
        //            {
        //                DateTime fechaIngreso = DateTime.MinValue;
        //                DateTime fechaAnterior = DateTime.MinValue;
        //                DateTime fechacorte = DateTime.MinValue;





        //                List<ConveniosTrabajadores> puestos = convenios.Where(w => w.IdTrabajador == item.IdTrabajador && !removercomisiones.Contains(w.IdConvenioLaboralTrabajadorCategoria)).ToList();
        //                fechacorte = FechaDeterminada.AddDays(1);
        //                foreach (var contrato in puestos)
        //                {

        //                    if (contrato.FechaTermino != null)
        //                    {
        //                        fechaAnterior = contrato.FechaTermino.Value;
        //                    }


        //                    if ((fechaIngreso == DateTime.MinValue || contrato.FechaInicio > fechaAnterior.AddDays(1)))
        //                    {


        //                        fechaIngreso = contrato.FechaInicio;
        //                    }


        //                }

        //                TimeSpan antiguedad = fechacorte - fechaIngreso;

        //                query = @"select * from (
        //select q.*,w.IdIncidenciaTrabajador as IdIncidencia from(
        // SELECT 
        //idtrabajador,a.IdIncidenciaTrabajador
        // ,case when  a.FechaTermino>getdate() then  DATEDIFF(DAY, a.FechaInicio, getdate()) else  
        //                              DATEDIFF(DAY, a.FechaInicio, a.FechaTermino) end as dias
        //                          FROM IncidenciaPermiso_stIncidenciaTrabajador  a 
        //                          inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
        //                          inner join Convenios_stConvenioLaboralTrabajador c on c.IdConvenioLaboralTrabajador=b.IdConvenioLaboralTrabajador
        //                            INNER JOIN Catalogos_ctTipoIncidencia qq on a.IdTipoIncidencia=qq.IdTipoIncidencia
        //  inner join Catalogos_ctTipoIncidenciaPermiso ww on ww.IdTipoIncidenciaPermiso=qq.IdTipoIncidenciaPermiso
        //                          where  qq.EsPermiso=1 and qq.Incidencia in ('LICENCIA SIN GOCE DE SUELDO PARA ATENDER SITUACIONES PERSONALES','LICENCIA SIN GOCE DE SUELDO PARA OCUPAR PUESTO DE ELECCIÓN POPULAR')
        //                          ) as q 
        //                           left join vwLicenciasTrabajadores w 
        //                           on q.IdTrabajador=w.IdTrabajador and w.IdIncidenciaTrabajador=q.IdIncidenciaTrabajador
        //                           and  ESTATUS<>'PROXIMA' 
        //                           ) as r where
        //                           IdIncidencia is not null";
        //                // int diasPermisos = dp.connection.ExecuteScalar<int>(query);
        //                List<DiasComisionesTrabajadores> diascomisiones = new List<DiasComisionesTrabajadores>();

        //                diascomisiones = (List<DiasComisionesTrabajadores>)dp.connection.Query<DiasComisionesTrabajadores>(query);
        //                int diasPermisos = 0;
        //                var existendias = diascomisiones.Where(s => s.IdTrabajador == item.IdTrabajador).FirstOrDefault();

        //                if (existendias != null)
        //                    diasPermisos = diascomisiones.Where(s => s.IdTrabajador == item.IdTrabajador).Sum(a => a.Dias);

        //                TimeSpan ts = TimeSpan.FromTicks(diasPermisos);

        //                antiguedad = antiguedad-ts;



        //                int años = (int)(antiguedad.Days / 365.25);
        //                int meses = (int)((antiguedad.Days % 365.25) / 30.436875);
        //                int dias = (int)((antiguedad.Days % 365.25) % 30.436875);

        //                Antiguedad valor = new Antiguedad { AntiguedadTrabajador = antiguedad, IdTrabajador = item.IdTrabajador,Years=años,Months=meses,Days=dias };
        //                AntiguedadTrabajadores.Add(valor);

        //            }

        //            //public TimeSpan CalcularAntiguedad()
        //            //{
        //            //    DateTime fechaIngreso = CalcularFechaIngreso();

        //            //    TimeSpan antiguedad = FechaDeterminada - fechaIngreso;

        //            //    return antiguedad;
        //            //}
        //        }


        //    }
    }
}