﻿using Dapper;
using DevExpress.DataProcessing.InMemoryDataProcessor;
using DevExpress.Web.ASPxHtmlEditor.Internal;
using DocumentFormat.OpenXml.Drawing.Charts;
using DocumentFormat.OpenXml.Spreadsheet;
using Nova.Models.Estatus;
using Seguridad;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;
using static Nova.Models.PlantillasNomina;

namespace Nova.Models.Calculos.SUA
{
    public class SuaTrabajadores
    {
        public int IdTrabajador { get; set; }
        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }

        public string ApellidoMaterno { get; set; }

        public string Categoria { get; set; }

        public string RelacionConvenioLaboral { get; set; }
        public string NSS { get; set; }
        public  int  IdConvenioLaboralTrabajadorCategoria { get; set; }

        public string Tipo { get; set; }

        public string Clave { get; set; }
        public decimal SalarioDiarioIntegrado { get; set; }
        public DateTime FechaInicio { get; set; }
    }

    public class SdiTrabajadores
    {
        public int Año { get; set; }
        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }
        public int MesNomina { get; set; }
        public string QuincenaMes { get; set; }
        public string MesGeneracion { get; set; }
        public int IdTrabajador { get; set; }
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public decimal SalarioDiarioIntegrado { get; set; }
        public string NSS { get; set; }
        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }

        public string ApellidoMaterno { get; set; }

        public string Categoria { get; set; }

        public string Plantilla { get; set; }

        public string TipoCalculo { get; set; }

        public string AliasNomina { get; set; }
        public string TipoNomina { get; set; }

        public string PeriodoNomina { get; set; }
        public string EsCerrada { get; set; }
        public string PlantillaGrupo { get; set; }
        public string RelacionConvenioLaboral { get; set; }
        public string RelacionLaboral { get; set; }

        public string ConvenioLaboral { get; set; }
        
        
    }

    public class SuaTrabajadoresSdi
    {
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }

        public decimal SalarioDiarioIntegradoQnaActual { get; set; }

    

      
    }

    public class Sua
    {

        public List<SuaTrabajadores> Trabajadores { get; set; } = new List<SuaTrabajadores>();

        public List<SdiTrabajadores> SdiTrabajadores { get; set; } = new List<SdiTrabajadores>();
        //public Nomina_stNomina Nomina = new Nomina_stNomina();
        public bdNovaEntities db = new bdNovaEntities();

        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino{ get; set; }
        public Sua(DateTime fechaInicio, DateTime fechaTermino)
        {
            FechaInicio = fechaInicio;
            FechaTermino = fechaTermino;
        
        }
        public void getSdi()
        {
            string sql = @"SELECT c.Año, c.FechaInicio,c.FechaTermino,month (c.FechaTermino) as MesNomina, SalarioDiarioIntegrado,y.IdTrabajador, v.Nombre,v.ApellidoPaterno,v.ApellidoMaterno,r.RelacionConvenioLaboral,d.Plantilla
,f.Mes as MesGenracion,g.QuincenaMes,h.TipoCalculo,c.AliasNomina,I.TipoNomina,J.PeriodoNomina,s.RelacionLaboral,p.ConvenioLaboral,m.PlantillaGrupo
,d.CalculoPorSolicitud as NominaPPFL
,case when c.EsCerrada=1 then 'SI' ELSE 'NO' END EsCerrada,z.IdConvenioLaboralTrabajadorCategoria,t.Categoria,NSS
  FROM [Nomina_stNominaTrabajador] a
  INNER JOIN Convenios_stConvenioLaboralTrabajadorCategoria Z ON z.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
  INNER JOIN Convenios_stConvenioLaboralTrabajador x ON x.IdConvenioLaboralTrabajador=z.IdConvenioLaboralTrabajador
  INNER JOIN Kardex_ctTrabajador y ON y.IdTrabajador=x.IdTrabajador
  INNER JOIN Kardex_ctDatosPersonales v on v.IdKardex=y.IdKardex
  INNER JOIN Plazas_stDistribucionPlazaCategoria w on w.IdDistribucionPlazaCategoria=z.IdDistribucionPlazaCategoria
  inner join Plazas_ctCategoria t on t.IdCategoria=w.IdCategoria
  inner join Convenios_stRelacionConvenioLaboral r on r.IdRelacionConvenioLaboral=t.IdRelacionConvenioLaboral 
  inner join Catalogos_ctRelacionLaboral s on s.IdRelacionLaboral=r.IdRelacionLaboral
  inner join Catalogos_ctConvenioLaboral p on p.IdConvenioLaboral=r.IdConvenioLaboral
  inner join [Nomina_stNomina] c on c.idnomina=a.idnomina
  inner join Nomina_ctPlantillaNomina d on d.IdPlantillaNomina=c.IdPlantillaNomina
  inner join Catalogos_ctMes f on f.idmes=c.IdMesGeneracion
  inner join Catalogos_ctQuincenaMes g on g.IdQuincenaMes=c.IdQuincenaMes
  inner join bdNova.dbo.Nomina_ctTipoCalculo h on h.IdTipoCalculo=c.IdTipoCalculo
  inner join bdNova.dbo.Nomina_ctTipoNomina I on I.IdTipoNomina=D.IdTipoNomina
  inner join bdNova.dbo.Catalogos_ctPeriodoNomina J ON J.IdPeriodoNomina=D.IdPeriodoNomina
  inner join Nomina_ctPlantillaGrupo m on m.IdPlantillaGrupo=d.IdPlantillaGrupo
  where SalarioDiarioIntegrado>0 and c.fechainicio>='" + FechaInicio.ToString("yyyyMMdd") + "'  and ( c.fechainicio<='" + FechaTermino.ToString("yyyyMMdd") + @"' or c.FechaInicio is null) ";


            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");



            this.SdiTrabajadores= (List<SdiTrabajadores>)dp.connection.Query<SdiTrabajadores>(sql);


            dp.Close();


        }

        public void getReporte()
        {

            getNuevosringresos();
            getReingresos();
            setBajasEnQuincena();
            getModificacionSalario();
            getLicencias();

        }

        public void getNuevosringresos()
        {
            string sql = @"    select l.IdTrabajador,t.Nombre,t.ApellidoPaterno,t.ApellidoMaterno,p.Categoria,r.RelacionConvenioLaboral,t.NSS,
             f.IdConvenioLaboralTrabajadorCategoria,'REINGRESO' Tipo,'08' AS Clave, F.SalarioDiarioIntegrado from
            Nomina_stNominaTrabajador f inner join
              Convenios_stConvenioLaboralTrabajadorCategoria z on f.IdConvenioLaboralTrabajadorCategoria = z.IdConvenioLaboralTrabajadorCategoria
              inner join Convenios_stConvenioLaboralTrabajador x on z.IdConvenioLaboralTrabajador = x.IdConvenioLaboralTrabajador
              inner join Plazas_stDistribucionPlazaCategoria s on s.IdDistribucionPlazaCategoria = z.IdDistribucionPlazaCategoria
              inner join Plazas_ctCategoria p on p.IdCategoria = s.IdCategoria
              inner join Convenios_stRelacionConvenioLaboral r on r.IdRelacionConvenioLaboral = p.IdRelacionConvenioLaboral
              inner join Kardex_ctTrabajador l on l.IdTrabajador = x.IdTrabajador
              inner join Kardex_ctDatosPersonales t on t.IdKardex = l.IdKardex
              inner join Nomina_stNomina b on b.IdNomina = f.IdNomina
            inner join Nomina_ctPlantillaNomina c on b.IdPlantillaNomina = c.IdPlantillaNomina
              inner join(
                select IdTrabajador, MAX(IdConvenioLaboralTrabajadorCategoria) IdConvenioLaboralTrabajadorCategoria  from Convenios_stConvenioLaboralTrabajadorCategoria a
              inner join Convenios_stConvenioLaboralTrabajador b on a.IdConvenioLaboralTrabajador= b.IdConvenioLaboralTrabajador
              group by IdTrabajador having COUNT(idtrabajador) = 0
              ) as q on q.idtrabajador = x.IdTrabajador and q.IdConvenioLaboralTrabajadorCategoria = f.IdConvenioLaboralTrabajadorCategoria
            inner join(
            select f.IdConvenioLaboralTrabajadorCategoria, MIn(b.FechaInicio) as FechaInicio
            from
            Nomina_stNominaTrabajador f
            inner
            join Nomina_stNomina b on b.IdNomina = f.IdNomina
            inner
            join Nomina_ctPlantillaNomina c on b.IdPlantillaNomina = c.IdPlantillaNomina
            where c.Plantilla like '%sueldo%' and SueldoBruto> 0
            group by f.IdConvenioLaboralTrabajadorCategoria
            ) as rr on rr.IdConvenioLaboralTrabajadorCategoria = f.IdConvenioLaboralTrabajadorCategoria
            and rr.FechaInicio = b.FechaInicio
              where z.fechainicio >= '" + FechaInicio.ToString("yyyyMMdd") + "'  and(z.fechainicio <= '" + FechaTermino.ToString("yyyyMMdd") + @"' or z.FechaInicio is null)
              and c.Plantilla like '%sueldo%' ";

         

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");



            var REINGRESOS = (List<SuaTrabajadores>)dp.connection.Query<SuaTrabajadores>(sql);


            dp.Close();

            //var nuevos= db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(s => (s.FechaInicio >= FechaInicio && s.FechaInicioPago == null)
            // || s.FechaInicioPago >= FechaInicio).Select(s=> s.Convenios_stConvenioLaboralTrabajador.IdTrabajador).ToArray();

            //var ingresos=db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(a => nuevos.Contains(a.Convenios_stConvenioLaboralTrabajador.IdTrabajador))
            //    .GroupBy(a => a.Convenios_stConvenioLaboralTrabajador.IdTrabajador).Where(a => a.Count() > 1).Select(s => s.Key).ToArray();

            //var nomina=db.Nomina_stNominaTrabajador.Where(a=> a.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO") &&   a.Nomina_stNomina.FechaInicio==FechaInicio && a.Nomina_stNomina.FechaTermino==FechaTermino
            //&& ingresos.Contains(a.IdConvenioLaboralTrabajadorCategoria) ).Select(x => new SuaTrabajadores { IdConvenioLaboralTrabajadorCategoria = x.IdConvenioLaboralTrabajadorCategoria, Tipo = "REINGRESO", Clave = "08",SalarioDiarioIntegrado=x.SalarioDiarioIntegrado }).ToList();

            Trabajadores.AddRange(REINGRESOS);
        }

        public void getReingresos()
        {
            string sql = @" SELECT 
                l.IdTrabajador,
                t.Nombre,
                t.ApellidoPaterno,
                t.ApellidoMaterno,
                p.Categoria,
                r.RelacionConvenioLaboral,
                t.NSS,
                f.IdConvenioLaboralTrabajadorCategoria,
                'REINGRESO' AS Tipo,
                '08' AS Clave,
                f.SalarioDiarioIntegrado
            FROM 
                Nomina_stNominaTrabajador f
            INNER JOIN Convenios_stConvenioLaboralTrabajadorCategoria z ON f.IdConvenioLaboralTrabajadorCategoria = z.IdConvenioLaboralTrabajadorCategoria
            INNER JOIN Convenios_stConvenioLaboralTrabajador x ON z.IdConvenioLaboralTrabajador = x.IdConvenioLaboralTrabajador
            INNER JOIN Plazas_stDistribucionPlazaCategoria s ON s.IdDistribucionPlazaCategoria = z.IdDistribucionPlazaCategoria
            INNER JOIN Plazas_ctCategoria p ON p.IdCategoria = s.IdCategoria
            INNER JOIN Convenios_stRelacionConvenioLaboral r ON r.IdRelacionConvenioLaboral = p.IdRelacionConvenioLaboral
            INNER JOIN Kardex_ctTrabajador l ON l.IdTrabajador = x.IdTrabajador
            INNER JOIN Kardex_ctDatosPersonales t ON t.IdKardex = l.IdKardex
            INNER JOIN Nomina_stNomina b ON b.IdNomina = f.IdNomina
            INNER JOIN Nomina_ctPlantillaNomina c ON b.IdPlantillaNomina = c.IdPlantillaNomina
            INNER JOIN (
             select * from
            (   SELECT
                    c1.IdTrabajador,
                    c2.IdConvenioLaboralTrabajadorCategoria,
                    CASE 
                        WHEN c1.RowNum = 2 AND c2.FechaInicio = DATEADD(DAY, 1, c1.FechaTermino) THEN 'Sí'
                        ELSE 'No'
                    END AS TieneContinuidad
                FROM
                    (
                        SELECT
                            b.IdTrabajador,
                            a.IdConvenioLaboralTrabajadorCategoria,
                            a.FechaInicio,
                            a.FechaTermino,
                            ROW_NUMBER() OVER (PARTITION BY b.IdTrabajador ORDER BY a.FechaInicio DESC) AS RowNum
                        FROM
                            Convenios_stConvenioLaboralTrabajadorCategoria a
                        INNER JOIN
                            Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
                    ) c1
                JOIN
                    (
                        SELECT
                            b.IdTrabajador,
                            a.IdConvenioLaboralTrabajadorCategoria,
                            a.FechaInicio,
                            a.FechaTermino,
                            ROW_NUMBER() OVER (PARTITION BY b.IdTrabajador ORDER BY a.FechaInicio DESC) AS RowNum
                        FROM
                            Convenios_stConvenioLaboralTrabajadorCategoria a
                        INNER JOIN
                            Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
                    ) c2 ON c1.IdTrabajador = c2.IdTrabajador AND c2.RowNum = 1
                WHERE
                    c1.RowNum = 2
		            --AND c2.FechaInicio = DATEADD(DAY, 1, c1.FechaTermino) 
		            ) x where TieneContinuidad='No'
            ) q ON q.IdTrabajador = x.IdTrabajador AND q.IdConvenioLaboralTrabajadorCategoria = f.IdConvenioLaboralTrabajadorCategoria
            INNER JOIN (
                SELECT
                    f.IdConvenioLaboralTrabajadorCategoria,
                    MIN(b.FechaInicio) AS FechaInicio
                FROM
                    Nomina_stNominaTrabajador f
                INNER JOIN Nomina_stNomina b ON b.IdNomina = f.IdNomina 
                INNER JOIN Nomina_ctPlantillaNomina c ON b.IdPlantillaNomina = c.IdPlantillaNomina 
                WHERE
                    c.Plantilla LIKE '%sueldo%' AND SueldoBruto > 0
                GROUP BY
                    f.IdConvenioLaboralTrabajadorCategoria
            ) rr ON rr.IdConvenioLaboralTrabajadorCategoria = f.IdConvenioLaboralTrabajadorCategoria AND rr.FechaInicio = b.FechaInicio
            --WHERE z.fechainicio >= '20231001' AND (z.fechainicio <= '20231015' OR z.FechaInicio IS NULL) 
            WHERE z.fechainicio>='" + FechaInicio.ToString("yyyyMMdd") + "'  and ( z.fechainicio<='" + FechaTermino.ToString("yyyyMMdd") + @"' or z.FechaInicio is null) 
                AND c.Plantilla LIKE '%sueldo%' ";

// select l.IdTrabajador,t.Nombre,t.ApellidoPaterno,t.ApellidoMaterno,p.Categoria,r.RelacionConvenioLaboral,t.NSS,
// f.IdConvenioLaboralTrabajadorCategoria,'REINGRESO' Tipo,'08' AS Clave, F.SalarioDiarioIntegrado from
//Nomina_stNominaTrabajador f inner join
//  Convenios_stConvenioLaboralTrabajadorCategoria z on f.IdConvenioLaboralTrabajadorCategoria = z.IdConvenioLaboralTrabajadorCategoria
//  inner join Convenios_stConvenioLaboralTrabajador x on z.IdConvenioLaboralTrabajador = x.IdConvenioLaboralTrabajador
//  inner join Plazas_stDistribucionPlazaCategoria s on s.IdDistribucionPlazaCategoria = z.IdDistribucionPlazaCategoria
//  inner join Plazas_ctCategoria p on p.IdCategoria = s.IdCategoria
//  inner join Convenios_stRelacionConvenioLaboral r on r.IdRelacionConvenioLaboral = p.IdRelacionConvenioLaboral
//  inner join Kardex_ctTrabajador l on l.IdTrabajador = x.IdTrabajador
//  inner join Kardex_ctDatosPersonales t on t.IdKardex = l.IdKardex
//  inner join Nomina_stNomina b on b.IdNomina = f.IdNomina
//inner join Nomina_ctPlantillaNomina c on b.IdPlantillaNomina = c.IdPlantillaNomina
//  inner join(
//    select IdTrabajador, MAX(IdConvenioLaboralTrabajadorCategoria) IdConvenioLaboralTrabajadorCategoria  from Convenios_stConvenioLaboralTrabajadorCategoria a
//  inner join Convenios_stConvenioLaboralTrabajador b on a.IdConvenioLaboralTrabajador= b.IdConvenioLaboralTrabajador
//  group by IdTrabajador having COUNT(idtrabajador) > 1
//  ) as q on q.idtrabajador = x.IdTrabajador and q.IdConvenioLaboralTrabajadorCategoria = f.IdConvenioLaboralTrabajadorCategoria
//inner join(
//select f.IdConvenioLaboralTrabajadorCategoria, MIn(b.FechaInicio) as FechaInicio
//from
//Nomina_stNominaTrabajador f
//inner
//join Nomina_stNomina b on b.IdNomina = f.IdNomina
//inner
//join Nomina_ctPlantillaNomina c on b.IdPlantillaNomina = c.IdPlantillaNomina
//where c.Plantilla like '%sueldo%' and SueldoBruto> 0
//group by f.IdConvenioLaboralTrabajadorCategoria
//) as rr on rr.IdConvenioLaboralTrabajadorCategoria = f.IdConvenioLaboralTrabajadorCategoria
//and rr.FechaInicio = b.FechaInicio
//  where z.fechainicio >= '" + FechaInicio.ToString("yyyyMMdd") + "'  and(z.fechainicio <= '" + FechaTermino.ToString("yyyyMMdd") + @"' or z.FechaInicio is null)
//  and c.Plantilla like '%sueldo%'

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");



            var REINGRESOS = (List<SuaTrabajadores>)dp.connection.Query<SuaTrabajadores>(sql);


            dp.Close();

            //var nuevos= db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(s => (s.FechaInicio >= FechaInicio && s.FechaInicioPago == null)
            // || s.FechaInicioPago >= FechaInicio).Select(s=> s.Convenios_stConvenioLaboralTrabajador.IdTrabajador).ToArray();

            //var ingresos=db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(a => nuevos.Contains(a.Convenios_stConvenioLaboralTrabajador.IdTrabajador))
            //    .GroupBy(a => a.Convenios_stConvenioLaboralTrabajador.IdTrabajador).Where(a => a.Count() > 1).Select(s => s.Key).ToArray();

            //var nomina=db.Nomina_stNominaTrabajador.Where(a=> a.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO") &&   a.Nomina_stNomina.FechaInicio==FechaInicio && a.Nomina_stNomina.FechaTermino==FechaTermino
            //&& ingresos.Contains(a.IdConvenioLaboralTrabajadorCategoria) ).Select(x => new SuaTrabajadores { IdConvenioLaboralTrabajadorCategoria = x.IdConvenioLaboralTrabajadorCategoria, Tipo = "REINGRESO", Clave = "08",SalarioDiarioIntegrado=x.SalarioDiarioIntegrado }).ToList();

            Trabajadores.AddRange(REINGRESOS);
        }

        public void getLicencias()
        {

            string sql = @" SELECT
                        a.IdTrabajador,
                        a.Nombre,
                        a.ApellidoPaterno,
                        a.ApellidoMaterno,
                        a.Categoria,
                        a.RelacionConvenioLaboral,
                        a.NSS,
                        a.IdConvenioLaboralTrabajadorCategoria,
                        'REINGRESO' AS Tipo,
                        '08' AS Clave,
                        --b.SalarioDiarioIntegrado,
                        a.FechaInicioIncidencia,
                        a.FechaTerminoIncidencia,
                       -- c.FechaInicio,
                        --c.FechaTermino,
						a.IdTipoIncidencia
                    FROM
                        vwLicenciasTrabajadores a
                    
                    WHERE
					a.IdTipoIncidencia IN (10, 11, 12) 
                    
						AND 
						
						((a.FechaTerminoIncidencia between '" + FechaInicio.ToString("yyyyMMdd") + @"' and '" + FechaTermino.ToString("yyyyMMdd") + @"') OR a.FechaTerminoIncidencia IS NULL) ";






            //string sql = @" SELECT
            //            a.IdTrabajador,
            //            a.Nombre,
            //            a.ApellidoPaterno,
            //            a.ApellidoMaterno,
            //            a.Categoria,
            //            a.RelacionConvenioLaboral,
            //            a.NSS,
            //            a.IdConvenioLaboralTrabajadorCategoria,
            //            'REINGRESO' AS Tipo,
            //            '08' AS Clave,
            //            b.SalarioDiarioIntegrado,
            //            a.FechaInicioIncidencia,
            //            a.FechaTerminoIncidencia,
            //            c.FechaInicio,
            //            c.FechaTermino
            //        FROM
            //            vwLicenciasTrabajadores a
            //        INNER JOIN
            //            Nomina_stNominaTrabajador b ON a.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria
            //        INNER JOIN
            //            Nomina_stNomina c ON c.IdNomina = b.IdNomina
            //        INNER JOIN
            //            Nomina_ctPlantillaNomina d ON c.IdPlantillaNomina = d.IdPlantillaNomina
            //        WHERE
            //            IdTipoIncidencia IN (10, 11, 12) 
            //            AND  b.SalarioDiarioIntegrado > 0
            //            AND d.Plantilla LIKE '%sueldo%' 
            //            AND SueldoBruto > 0
            //            AND (
            //                a.FechaTerminoIncidencia >= '" + FechaInicio.ToString("yyyyMMdd") + @"' -- Fecha de inicio de licencia 
            //                AND (a.FechaTerminoIncidencia <= '" + FechaTermino.ToString("yyyyMMdd") + @"' OR a.FechaTerminoIncidencia IS NULL)
            //            )
            //            AND (
            //                c.FechaInicio = 
            //                    CASE 
            //                        WHEN DAY('" + FechaTermino.ToString("yyyyMMdd") + @"') + 1 >   
            //                            DAY(DATEADD(DAY, -1, DATEADD(MONTH, 1, '" + FechaInicio.ToString("yyyyMMdd") + @"')))
            //                        THEN DATEADD(DAY, 1, DATEADD(MONTH, 1, '" + FechaInicio.ToString("yyyyMMdd") + @"')) 
            //                        ELSE DATEADD(DAY, 15, '" + FechaInicio.ToString("yyyyMMdd") + @"')
            //                    END)
			         //           order by a.IdTrabajador ";

            // select l.IdTrabajador,t.Nombre,t.ApellidoPaterno,t.ApellidoMaterno,p.Categoria,r.RelacionConvenioLaboral,t.NSS,
            // f.IdConvenioLaboralTrabajadorCategoria,'REINGRESO' Tipo,'08' AS Clave, F.SalarioDiarioIntegrado from
            //Nomina_stNominaTrabajador f inner join
            //  Convenios_stConvenioLaboralTrabajadorCategoria z on f.IdConvenioLaboralTrabajadorCategoria = z.IdConvenioLaboralTrabajadorCategoria
            //  inner join Convenios_stConvenioLaboralTrabajador x on z.IdConvenioLaboralTrabajador = x.IdConvenioLaboralTrabajador
            //  inner join Plazas_stDistribucionPlazaCategoria s on s.IdDistribucionPlazaCategoria = z.IdDistribucionPlazaCategoria
            //  inner join Plazas_ctCategoria p on p.IdCategoria = s.IdCategoria
            //  inner join Convenios_stRelacionConvenioLaboral r on r.IdRelacionConvenioLaboral = p.IdRelacionConvenioLaboral
            //  inner join Kardex_ctTrabajador l on l.IdTrabajador = x.IdTrabajador
            //  inner join Kardex_ctDatosPersonales t on t.IdKardex = l.IdKardex
            //  inner join Nomina_stNomina b on b.IdNomina = f.IdNomina
            //inner join Nomina_ctPlantillaNomina c on b.IdPlantillaNomina = c.IdPlantillaNomina
            //  inner join(
            //    select IdTrabajador, MAX(IdConvenioLaboralTrabajadorCategoria) IdConvenioLaboralTrabajadorCategoria  from Convenios_stConvenioLaboralTrabajadorCategoria a
            //  inner join Convenios_stConvenioLaboralTrabajador b on a.IdConvenioLaboralTrabajador= b.IdConvenioLaboralTrabajador
            //  group by IdTrabajador having COUNT(idtrabajador) > 1
            //  ) as q on q.idtrabajador = x.IdTrabajador and q.IdConvenioLaboralTrabajadorCategoria = f.IdConvenioLaboralTrabajadorCategoria
            //inner join(
            //select f.IdConvenioLaboralTrabajadorCategoria, MIn(b.FechaInicio) as FechaInicio
            //from
            //Nomina_stNominaTrabajador f
            //inner
            //join Nomina_stNomina b on b.IdNomina = f.IdNomina
            //inner
            //join Nomina_ctPlantillaNomina c on b.IdPlantillaNomina = c.IdPlantillaNomina
            //where c.Plantilla like '%sueldo%' and SueldoBruto> 0
            //group by f.IdConvenioLaboralTrabajadorCategoria
            //) as rr on rr.IdConvenioLaboralTrabajadorCategoria = f.IdConvenioLaboralTrabajadorCategoria
            //and rr.FechaInicio = b.FechaInicio
            //  where z.fechainicio >= '" + FechaInicio.ToString("yyyyMMdd") + "'  and(z.fechainicio <= '" + FechaTermino.ToString("yyyyMMdd") + @"' or z.FechaInicio is null)
            //  and c.Plantilla like '%sueldo%'

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");



            var REINGRESOS = (List<SuaTrabajadores>)dp.connection.Query<SuaTrabajadores>(sql);


            dp.Close();

            //var nuevos= db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(s => (s.FechaInicio >= FechaInicio && s.FechaInicioPago == null)
            // || s.FechaInicioPago >= FechaInicio).Select(s=> s.Convenios_stConvenioLaboralTrabajador.IdTrabajador).ToArray();

            //var ingresos=db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(a => nuevos.Contains(a.Convenios_stConvenioLaboralTrabajador.IdTrabajador))
            //    .GroupBy(a => a.Convenios_stConvenioLaboralTrabajador.IdTrabajador).Where(a => a.Count() > 1).Select(s => s.Key).ToArray();

            //var nomina=db.Nomina_stNominaTrabajador.Where(a=> a.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO") &&   a.Nomina_stNomina.FechaInicio==FechaInicio && a.Nomina_stNomina.FechaTermino==FechaTermino
            //&& ingresos.Contains(a.IdConvenioLaboralTrabajadorCategoria) ).Select(x => new SuaTrabajadores { IdConvenioLaboralTrabajadorCategoria = x.IdConvenioLaboralTrabajadorCategoria, Tipo = "REINGRESO", Clave = "08",SalarioDiarioIntegrado=x.SalarioDiarioIntegrado }).ToList();

            Trabajadores.AddRange(REINGRESOS);
        }

        public void setBajasEnQuincena()
        {

            // bajas por renuncias


            List<IncidenciaPermiso_stIncidenciaTrabajador> model =db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z =>
              (z.Catalogos_ctTipoIncidencia.Incidencia == "BAJA POR RENUNCIA" || z.Catalogos_ctTipoIncidencia.Incidencia == "BAJA POR DEFUNCIÓN"
|| z.Catalogos_ctTipoIncidencia.Incidencia == "BAJA POR JUBILACIÓN")
              && z.FechaInicio >= this.FechaInicio && z.FechaTermino <= this.FechaTermino)
                .ToList();

            string ides = string.Join(",", model
                                        .Select(p => p.IdConvenioLaboralTrabajadorCategoria.ToString()));
            if (ides == "")
                ides = "0";

            //string sql = @"
            //            select l.IdTrabajador,t.Nombre,t.ApellidoPaterno,t.ApellidoMaterno,p.Categoria,r.RelacionConvenioLaboral,t.NSS,dd.IdConvenioLaboralTrabajadorCategoria,'BAJAS' Tipo,'02' AS Clave,dd.SalarioDiarioIntegrado 
            //            from Nomina_stNominaTrabajador dd
            //            inner join Nomina_stNomina ww on dd.IdNomina=ww.IdNomina
            //            inner join Nomina_ctPlantillaNomina c on ww.IdPlantillaNomina=c.IdPlantillaNomina
            //            inner join 
            //              Convenios_stConvenioLaboralTrabajadorCategoria z on dd.IdConvenioLaboralTrabajadorCategoria=z.IdConvenioLaboralTrabajadorCategoria
            //              inner join Convenios_stConvenioLaboralTrabajador x on z.IdConvenioLaboralTrabajador=x.IdConvenioLaboralTrabajador
            //              inner join Plazas_stDistribucionPlazaCategoria s on s.IdDistribucionPlazaCategoria=z.IdDistribucionPlazaCategoria
            //              inner join Plazas_ctCategoria p on p.IdCategoria=s.IdCategoria
            //              inner join Convenios_stRelacionConvenioLaboral r on r.IdRelacionConvenioLaboral=p.IdRelacionConvenioLaboral
            //              inner join Kardex_ctTrabajador l on l.IdTrabajador=x.IdTrabajador
            //              inner join Kardex_ctDatosPersonales t on t.IdKardex=l.IdKardex
            //            inner join (
            //            select IdConvenioLaboralTrabajadorCategoria,
            //            MAX(b.fechainicio) as fechainicio
            //            from Nomina_stNominaTrabajador a
            //            inner join Nomina_stNomina b on a.IdNomina=b.IdNomina
            //            inner join Nomina_ctPlantillaNomina c on b.IdPlantillaNomina=c.IdPlantillaNomina
            //            where c.Plantilla like '%sueldo%'and IdConvenioLaboralTrabajadorCategoria in (" + ides + @") group by IdConvenioLaboralTrabajadorCategoria
            //            ) as ff  on dd.IdConvenioLaboralTrabajadorCategoria=ff.IdConvenioLaboralTrabajadorCategoria
            //            and ff.fechainicio=ww.FechaInicio 
            //            inner join (
            //            select f.IdConvenioLaboralTrabajadorCategoria,MIn(b.FechaInicio) as FechaInicio
            //            from 
            //            Nomina_stNominaTrabajador f 
            //            inner join Nomina_stNomina b on b.IdNomina=f.IdNomina 
            //            inner join Nomina_ctPlantillaNomina c on b.IdPlantillaNomina=c.IdPlantillaNomina 
            //            where  c.Plantilla like '%sueldo%' and SueldoBruto>0
            //            group by f.IdConvenioLaboralTrabajadorCategoria
            //            ) as rr on rr.IdConvenioLaboralTrabajadorCategoria=dd.IdConvenioLaboralTrabajadorCategoria
            //            and rr.FechaInicio=ww.FechaInicio
            //            where c.Plantilla like '%sueldo%'";


            string sql = @"select max(IdTrabajador) as IdTrabajador,max(Nombre) as Nombre,max(ApellidoPaterno) as ApellidoPaterno,max(ApellidoMaterno) as ApellidoMaterno,max(Categoria) as Categoria,max(RelacionConvenioLaboral) as RelacionConvenioLaboral,max(NSS) as NSS, IdConvenioLaboralTrabajadorCategoria, max (Tipo) as Tipo, max(Clave) as Clave, max (SalarioDiarioIntegrado) as SalarioDiarioIntegrado, max (FechaInicio) as FechaInicio from (
                        select l.IdTrabajador,t.Nombre,t.ApellidoPaterno,t.ApellidoMaterno,p.Categoria,r.RelacionConvenioLaboral,t.NSS,dd.IdConvenioLaboralTrabajadorCategoria,'BAJAS' Tipo,'02' AS Clave,dd.SalarioDiarioIntegrado, rr.FechaInicio 
                        from Nomina_stNominaTrabajador dd
                        inner join Nomina_stNomina ww on dd.IdNomina=ww.IdNomina
                        inner join Nomina_ctPlantillaNomina c on ww.IdPlantillaNomina=c.IdPlantillaNomina
                        inner join 
                          Convenios_stConvenioLaboralTrabajadorCategoria z on dd.IdConvenioLaboralTrabajadorCategoria=z.IdConvenioLaboralTrabajadorCategoria
                          inner join Convenios_stConvenioLaboralTrabajador x on z.IdConvenioLaboralTrabajador=x.IdConvenioLaboralTrabajador
                          inner join Plazas_stDistribucionPlazaCategoria s on s.IdDistribucionPlazaCategoria=z.IdDistribucionPlazaCategoria
                          inner join Plazas_ctCategoria p on p.IdCategoria=s.IdCategoria
                          inner join Convenios_stRelacionConvenioLaboral r on r.IdRelacionConvenioLaboral=p.IdRelacionConvenioLaboral
                          inner join Kardex_ctTrabajador l on l.IdTrabajador=x.IdTrabajador
						  inner join IncidenciaPermiso_stIncidenciaTrabajador hh on dd.IdConvenioLaboralTrabajadorCategoria = hh.IdConvenioLaboralTrabajadorCategoria
						inner join Catalogos_ctTipoIncidencia gg on hh.IdTipoIncidencia= gg.IdTipoIncidencia
                          inner join Kardex_ctDatosPersonales t on t.IdKardex=l.IdKardex
                        inner join (
                       select a.IdConvenioLaboralTrabajadorCategoria,
                        MAX(d.fechainicio) as fechainicio
                        from Nomina_stNominaTrabajador a
                        inner join Nomina_stNomina b on a.IdNomina=b.IdNomina
                        inner join Nomina_ctPlantillaNomina c on b.IdPlantillaNomina=c.IdPlantillaNomina
						inner join IncidenciaPermiso_stIncidenciaTrabajador d on a.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
						inner join Catalogos_ctTipoIncidencia g on d.IdTipoIncidencia= g.IdTipoIncidencia
                        where  c.Plantilla like '%sueldo%'    and  g.IdTipoIncidencia in (53,54,55,56,57,67,68,70,71,72,80,81)
                        and a.IdConvenioLaboralTrabajadorCategoria in  (" + ides + @") group by a.IdConvenioLaboralTrabajadorCategoria
                        ) as ff  on dd.IdConvenioLaboralTrabajadorCategoria=ff.IdConvenioLaboralTrabajadorCategoria
                        and ff.fechainicio=hh.FechaInicio 
                        inner join (
                        select f.IdConvenioLaboralTrabajadorCategoria,MIn(d.FechaInicio) as FechaInicio
                        from 
                        Nomina_stNominaTrabajador f 
                        inner join Nomina_stNomina b on b.IdNomina=f.IdNomina 
                        inner join Nomina_ctPlantillaNomina c on b.IdPlantillaNomina=c.IdPlantillaNomina 
						inner join IncidenciaPermiso_stIncidenciaTrabajador d on f.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
						inner join Catalogos_ctTipoIncidencia g on d.IdTipoIncidencia= g.IdTipoIncidencia
                        where  c.Plantilla like '%sueldo%' and SueldoBruto>0   and  g.IdTipoIncidencia in (53,54,55,56,57,67,68,70,71,72,80,81)
                        group by f.IdConvenioLaboralTrabajadorCategoria
                        ) as rr on rr.IdConvenioLaboralTrabajadorCategoria=dd.IdConvenioLaboralTrabajadorCategoria
                        and rr.FechaInicio=hh.FechaInicio
                        where c.Plantilla like '%sueldo%'
				) as y
				group by IdConvenioLaboralTrabajadorCategoria";


            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");



            var bajas = (List<SuaTrabajadores>)dp.connection.Query<SuaTrabajadores>(sql);


            dp.Close();

          
            Trabajadores.AddRange(bajas);
        }

        public void getModificacionSalario( )
            {

          


                             string sql = @"  select z.IdTrabajador,max(z.Nombre) as Nombre, max(z.ApellidoPaterno) as ApellidoPaterno, max(z.ApellidoMaterno) as ApellidoMaterno, 
                                max(z.Categoria) as Categoria, max(z.RelacionConvenioLaboral) as RelacionConvenioLaboral, max(z.NSS) as NSS,
                                 max(z.IdConvenioLaboralTrabajadorCategoria) as IdConvenioLaboralTrabajadorCategoria,max (z.Tipo) as Tipo, max(z.Clave) as Clave, max(z.SalarioDiarioIntegrado) as SalarioDiarioIntegrado
                                from(
                                select l.IdTrabajador, t.Nombre, t.ApellidoPaterno, t.ApellidoMaterno, p.Categoria, r.RelacionConvenioLaboral, t.NSS,
                                            q.IdConvenioLaboralTrabajadorCategoria, 'MODIFICACION DE SALARIO' Tipo, '07' AS Clave, SalarioDiarioIntegradoQnaActual as SalarioDiarioIntegrado
                                             from
                                             (select q1.*, case when q2.SalarioDiarioIntegradoQnaAnterior IS null
                                             then 0 else case when
                                                    q1.SalarioDiarioIntegradoQnaActual<> q2.SalarioDiarioIntegradoQnaAnterior
                                             then 1 end end as Cambiosalario from
                                             (SELECT IdConvenioLaboralTrabajadorCategoria, SalarioDiarioIntegrado
                                             SalarioDiarioIntegradoQnaActual FROM
                                              [Nomina_stNominaTrabajador]
                                             a inner join  Nomina_stNomina b on a.IdNomina = b.idnomina
                                             inner join Nomina_ctPlantillaNomina c
                                             on c.IdPlantillaNomina = b.IdPlantillaNomina
                                              where FechaInicio='" + FechaInicio.ToString("yyyyMMdd") + @"'
                                             and C.Plantilla LIKE '%sueldo%') as q1
                                             left join
                                              (select IdConvenioLaboralTrabajadorCategoria, SalarioDiarioIntegrado as
                                              SalarioDiarioIntegradoQnaAnterior
                                              FROM[Nomina_stNominaTrabajador] a
                                              inner join Nomina_stNomina
                                              b on a.IdNomina = b.idnomina inner join bdNova.dbo.Nomina_ctPlantillaNomina
                                              c on c.IdPlantillaNomina = b.IdPlantillaNomina
                                              where fechatermino='"+ FechaInicio.AddDays(-1).ToString("yyyyMMdd") + @"' 
                                              and C.Plantilla LIKE '%sueldo%') as q2
                                              on q1.IdConvenioLaboralTrabajadorCategoria = q2.IdConvenioLaboralTrabajadorCategoria
                                              ) as q
                                            inner join
                                              Convenios_stConvenioLaboralTrabajadorCategoria z on q.IdConvenioLaboralTrabajadorCategoria = z.IdConvenioLaboralTrabajadorCategoria
                                              inner join Convenios_stConvenioLaboralTrabajador x on z.IdConvenioLaboralTrabajador = x.IdConvenioLaboralTrabajador
                                              inner join Plazas_stDistribucionPlazaCategoria s on s.IdDistribucionPlazaCategoria = z.IdDistribucionPlazaCategoria
                                              inner join Plazas_ctCategoria p on p.IdCategoria = s.IdCategoria
                                              inner join Convenios_stRelacionConvenioLaboral r on r.IdRelacionConvenioLaboral = p.IdRelacionConvenioLaboral
                                              inner join Kardex_ctTrabajador l on l.IdTrabajador = x.IdTrabajador
                                              inner join Kardex_ctDatosPersonales t on t.IdKardex = l.IdKardex

                                              inner join vwDatosAspirantesTrabajadores xx on xx.IdConvenioLaboralTrabajadorCategoria = q.IdConvenioLaboralTrabajadorCategoria
                                            where q.cambiosalario = 1

                                            and xx.EstatusTrabajador = 'ALTA' and RestringirMenu IS NULL and q.SalarioDiarioIntegradoQnaActual > 0) as z

                                            group by z.IdTrabajador";



            //string sql = @"select l.IdTrabajador,t.Nombre,t.ApellidoPaterno,t.ApellidoMaterno,p.Categoria,r.RelacionConvenioLaboral,t.NSS,
            //q.IdConvenioLaboralTrabajadorCategoria,'MODIFICACION DE SALARIO' Tipo,'07' AS Clave,SalarioDiarioIntegradoQnaActual as SalarioDiarioIntegrado
            // from 
            // ( select q1.*, case when q2.SalarioDiarioIntegradoQnaAnterior IS null 
            // then 0 else case when 
            // q1.SalarioDiarioIntegradoQnaActual<>q2.SalarioDiarioIntegradoQnaAnterior 
            // then 1 end end as Cambiosalario from 
            // ( SELECT IdConvenioLaboralTrabajadorCategoria,SalarioDiarioIntegrado 
            // SalarioDiarioIntegradoQnaActual FROM 
            //  [Nomina_stNominaTrabajador] 
            // a inner join  Nomina_stNomina b on a.IdNomina=b.idnomina 
            // inner join Nomina_ctPlantillaNomina c 
            // on c.IdPlantillaNomina=b.IdPlantillaNomina 
            // where FechaInicio='" + FechaInicio.ToString("yyyyMMdd") + @"'
            // and C.Plantilla LIKE '%sueldo%' ) as q1 
            // left join
            //  ( select IdConvenioLaboralTrabajadorCategoria,SalarioDiarioIntegrado as 
            //  SalarioDiarioIntegradoQnaAnterior 
            //  FROM  [Nomina_stNominaTrabajador] a 
            //  inner join  Nomina_stNomina 
            //  b on a.IdNomina=b.idnomina inner join bdNova.dbo.Nomina_ctPlantillaNomina 
            //  c on c.IdPlantillaNomina=b.IdPlantillaNomina 
            //  where fechatermino='"+ FechaInicio.AddDays(-1).ToString("yyyyMMdd") + @"' 
            //  and C.Plantilla LIKE '%sueldo%') as q2 
            //  on q1.IdConvenioLaboralTrabajadorCategoria=q2.IdConvenioLaboralTrabajadorCategoria 
            //  ) as q
            //inner join 
            //  Convenios_stConvenioLaboralTrabajadorCategoria z on q.IdConvenioLaboralTrabajadorCategoria=z.IdConvenioLaboralTrabajadorCategoria
            //  inner join Convenios_stConvenioLaboralTrabajador x on z.IdConvenioLaboralTrabajador=x.IdConvenioLaboralTrabajador
            //  inner join Plazas_stDistribucionPlazaCategoria s on s.IdDistribucionPlazaCategoria=z.IdDistribucionPlazaCategoria
            //  inner join Plazas_ctCategoria p on p.IdCategoria=s.IdCategoria
            //  inner join Convenios_stRelacionConvenioLaboral r on r.IdRelacionConvenioLaboral=p.IdRelacionConvenioLaboral
            //  inner join Kardex_ctTrabajador l on l.IdTrabajador=x.IdTrabajador
            //  inner join Kardex_ctDatosPersonales t on t.IdKardex=l.IdKardex 
            //where q.cambiosalario=1";


           

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");



            var cambioddesalario = (List<SuaTrabajadores>)dp.connection.Query<SuaTrabajadores>(sql);

            
            dp.Close();
            Trabajadores.AddRange(cambioddesalario);
          //  Trabajadores.AddRange(db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(a => cambioddesalario.Contains(a.Convenios_stConvenioLaboralTrabajador.IdTrabajador)).Select(x => new SuaTrabajadores { IdTrabajador=x.Convenios_stConvenioLaboralTrabajador.IdTrabajador,Nombre=x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre, ApellidoPaterno = x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno, ApellidoMaterno = x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno, Categoria=x.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria, RelacionConvenioLaboral = x.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral,NSS= x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.NSS, IdConvenioLaboralTrabajadorCategoria = x.IdConvenioLaboralTrabajadorCategoria, Tipo = "MODIFICACION DE SALARIO", Clave = "07" }).ToList());
        }

        public MemoryStream Txt()
        {
          


            MemoryStream memoryStream = new MemoryStream();
            TextWriter tw = new StreamWriter(memoryStream);


            string registroControl = "";

            #region Registro global - Importación

            string control = "";
            foreach (var item in Trabajadores)

            {
                registroControl = "D6838796102";
                if (item.NSS!=null)
                registroControl = registroControl +item.NSS.ToString().PadLeft(11, '0');
                else
                    registroControl = registroControl + "ERORR-IMSS-";

                registroControl = registroControl +item.Clave;
                registroControl = registroControl + this.FechaTermino.ToString("ddMMyyyy").PadLeft(8, '0'); ;
                registroControl = registroControl + control.PadLeft(8, ' ');
                registroControl = registroControl + item.SalarioDiarioIntegrado.ToString().Replace(".","").PadLeft(7, '0');
                //registroControl = registroControl + "01";


                //registroControl = registroControl + item.Importe.ToString().Replace(".", "").PadLeft(10, '0');


                //registroControl = registroControl + "100316";


                //registroControl = registroControl + item.Cuenta.PadLeft(16, '0') + "   ";

                //registroControl = registroControl + item.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador.ToString().PadRight(13, ' ');

                //var nombre = item.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + item.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + item.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

                //registroControl = registroControl + nombre;

                tw.WriteLine(registroControl);

            }


            #endregion

            tw.Flush();
            tw.Close();

            return memoryStream;
        }

    }
}