﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;
using Nova.Libraries;
using Dapper;
 

namespace Nova.Models.Calculos.Deducciones
{

    public class SDI : IDeduccionBehavior
    {
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            //if (!NominaTrabajador.TrabajadorConGuarderiaActiva)
                if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "IMSS").FirstOrDefault() != null)
            {
                var totalpercepciones = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && v.EsGrabable == true).Sum(f => f.Importe);

                if (totalpercepciones > 0)
                {


                    VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();
                    Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();

                    var diaslaborados = NominaTrabajador.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "DIASLABORADOS").FirstOrDefault().Importe;

                    decimal QuinquenioDiario = 0;

                    var quinquenios = NominaTrabajador.PlantillaNominaPercepciones.Where(s => s.Percepciones_ctPercepcion.Percepcion.Contains("QUINQUENIO")).Select(x => x.IdPlantillaNominaPercepcion).ToArray();

                    QuinquenioDiario = Math.Round((NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && quinquenios.Contains(v.IdPlantillaNominaPercepcion)).Sum(f => f.Importe) / diaslaborados), 2);



                    var material = NominaTrabajador.PlantillaNominaPercepciones.Where(s => s.Percepciones_ctPercepcion.Percepcion.Contains("MATERIAL")).Select(x => x.IdPlantillaNominaPercepcion).ToArray();
                    var materialDiario = Math.Round((NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && material.Contains(v.IdPlantillaNominaPercepcion)).Sum(f => f.Importe) / diaslaborados), 2);

                    var SepagaAyudaDespensa = AyudaDespensaExcepciones.Calcular(ConvenioLaboralTrabajadorCategoria);

                    Percepciones_stPlantillaNominaPercepciones existeayuda;

                   
                    
                   var  existedespensa = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(s => !s.Nomina_ctPlantillaNomina.Plantilla.Contains("PROPORCIONALES") && s.Percepciones_ctPercepcion.Percepcion == "VALES DE DESPENSA" && s.Calcular == true).OrderByDescending(q => q.Percepciones_ctPercepcion).FirstOrDefault();

                    Decimal despensacosto = 0M;
                    if (existedespensa != null)
                    {
                       // despensacosto = (decimal)existedespensa.Importe;
                        despensacosto = (decimal)((costos.CostoValesDespensa* 7) * 15)*2;
                    }

                    //if (SepagaAyudaDespensa)
                    //    existeayuda = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(s => !s.Nomina_ctPlantillaNomina.Plantilla.Contains("PROPORCIONALES") && s.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA DESPENSA" ).FirstOrDefault();
                    //else
                    //existeayuda = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(s => !s.Nomina_ctPlantillaNomina.Plantilla.Contains("PROPORCIONALES") && s.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA DESPENSA" && s.Calcular == true).FirstOrDefault();


                    Decimal ayudacosto = 0M;
                    //if (existeayuda != null)
                    //    if (SepagaAyudaDespensa)
                    //{
                    //    ayudacosto = (decimal)existeayuda.Importe;
                    //}

                    var existeayudabd = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => !x.Nomina_ctPlantillaNomina.Plantilla.Contains("PROPORCIONALES") && x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA DESPENSA").FirstOrDefault();

                    Boolean esnominaayudaconacceso = false;

                    //if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("AYUDA PARA DESPENSA"))
                    if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("CONFIANZA"))
                    {
                        if (AyudaDespensaExcepciones.Calcular(ConvenioLaboralTrabajadorCategoria))
                            esnominaayudaconacceso = true;
                    }
                    else
                    {
                        if (NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA DESPENSA" && x.Calcular == true).FirstOrDefault() != null)
                            esnominaayudaconacceso = true;
                    }


                    if (existeayudabd != null)
                        if (esnominaayudaconacceso)
                        {
                            //ayudacosto = (decimal)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA DESPENSA" && x.Calcular == true).FirstOrDefault().Importe;
                            if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("CONFIANZA"))
                                
                            ayudacosto = (decimal)(costos.CostoAyudaDespensa * 8) * 15;
                            else

                            ayudacosto = (decimal)(costos.CostoAyudaDespensa * 7) * 15;
                        }
                    
                

                var fdespensa = despensacosto / 30;
                    var fayudacosto = ayudacosto / 15;
                    var tempfdespensafayudacosto = fayudacosto + fdespensa;

                    var uma40 = NominaTrabajador.ctUMA.Monto * .40M;


                    Decimal Despensa = 0;

                    if (tempfdespensafayudacosto > 0)
                        Despensa = tempfdespensafayudacosto - uma40;




                    var sueldopercep = NominaTrabajador.PlantillaNominaPercepciones.Where(s => s.Percepciones_ctPercepcion.Percepcion.Contains("SUELDO")).Select(x => x.IdPlantillaNominaPercepcion).ToArray();
                    Decimal Sueldodiario = (decimal)NominaTrabajador.ListaPercepcionesTrabajadores.Where(x => sueldopercep.Contains(x.IdPlantillaNominaPercepcion) && x.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(a => a.Importe) / diaslaborados

                    , FactorAguinaldo = decimal.Round(NominaTrabajador.Truncate(Convert.ToDecimal(NominaTrabajador.ParametrosRelacionLaboral.DiasAguinaldo / 365M), 5), 4)


                    , FactorPrimaVacacional = NominaTrabajador.Truncate(Convert.ToDecimal(NominaTrabajador.ParametrosRelacionLaboral.DiasPrimaVacacional / 365M), 5)



                    , Limite = NominaTrabajador.Truncate(0.4M * NominaTrabajador.SalarioMinimoDF.Monto, 4);


                    Decimal gastoDiario = 0;
                    var trabajadorconprestacionescongasto = NominaTrabajador.TrabajadoresConPercepcionesCongasto.Where(f => f.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();

                    decimal AguinaldoGastoAdmivo = 0;
                    decimal PrimaVacGastoAdmivo = 0;



                    if (trabajadorconprestacionescongasto != null)
                    {
                        //var plantillagasto = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GASTO ADMINISTRATIVO").FirstOrDefault();
                        //if (plantillagasto != null)
                        //{
                        //    var IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GASTO ADMINISTRATIVO").FirstOrDefault().IdPlantillaNominaPercepcion;

                            //var datosgastoadministrativo = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion && v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                            var gastoadministrativo = NominaTrabajador.PercepcionPersonalizada.Where(x =>
                            x.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                          && x.FechaInicioPercepcion <= NominaTrabajador.Nomina_stNomina.FechaInicio &&
                (x.FechaTermino == null || x.FechaTermino <= NominaTrabajador.Nomina_stNomina.FechaTermino)
                            && x.Percepciones_ctPercepcion.Percepcion == "GASTO ADMINISTRATIVO").FirstOrDefault();

                            decimal diariogastoadministrativo = 0;
                            if (gastoadministrativo != null)
                                diariogastoadministrativo = (gastoadministrativo.Importe / 15);

                            gastoDiario = diariogastoadministrativo;

                            PrimaVacGastoAdmivo = gastoDiario * FactorPrimaVacacional;
                            AguinaldoGastoAdmivo = gastoDiario * FactorAguinaldo;
                        //}
                    }


                    else
                    {
                        var gastoadministrativo = NominaTrabajador.PercepcionPersonalizada.Where(x =>
                          x.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                          && x.FechaInicioPercepcion <= NominaTrabajador.Nomina_stNomina.FechaInicio &&
                (x.FechaTermino == null || x.FechaTermino <= NominaTrabajador.Nomina_stNomina.FechaTermino)
                          && x.Percepciones_ctPercepcion.Percepcion == "GASTO ADMINISTRATIVO").FirstOrDefault();
                        bool esvalida = true;

                        if (gastoadministrativo != null)
                        {
                            if (gastoadministrativo.FechaTermino != null)
                                if (gastoadministrativo.FechaInicioPercepcion <= NominaTrabajador.Nomina.FechaInicio && gastoadministrativo.FechaTermino >= NominaTrabajador.Nomina.FechaTermino)
                                    esvalida = true;
                                else
                                    esvalida = false;

                            if (gastoadministrativo.FechaInicioPercepcion <= NominaTrabajador.Nomina.FechaInicio && esvalida)
                            {
                                gastoDiario = gastoadministrativo.Importe / 15;
                            }
                        }
                    }

                     

                    decimal PrimaVacacionalDiaria = 0;

                    decimal AguinaldoDiario = 0;
                    if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral
                        .Catalogos_ctConvenioLaboral.ConvenioLaboral == "BASE"  
                             && ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado )
                    {
                        AguinaldoDiario = decimal.Round((QuinquenioDiario + Sueldodiario) * FactorAguinaldo, 2);
                        PrimaVacacionalDiaria = decimal.Round((materialDiario + QuinquenioDiario + Sueldodiario) * FactorPrimaVacacional, 2);
                    }
                    else
                    {
                        AguinaldoDiario = decimal.Round(Sueldodiario * FactorAguinaldo, 2);
                        PrimaVacacionalDiaria = decimal.Round((materialDiario + Sueldodiario) * FactorPrimaVacacional, 2);
                    }


                    if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == "CONTRATO")
                    {
                        PrimaVacacionalDiaria = PrimaVacacionalDiaria * 0.25M;
                    }

                    //if (trabajadorconprestacionescongasto != null)
                    //{
                    //    var IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GASTO ADMINISTRATIVO").FirstOrDefault().IdPlantillaNominaPercepcion;

                    //    var datosgastoadministrativo = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion && v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                    //    var diariogastoadministrativo = (datosgastoadministrativo.Importe / 15);

                    //    gastoDiario = diariogastoadministrativo;
                    //}
                    //else {
                    //    var gastoadministrativo = NominaTrabajador.PercepcionPersonalizada.Where(x =>
                    //      x.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                    //      && x.Percepciones_ctPercepcion.Percepcion == "GASTO ADMINISTRATIVO").FirstOrDefault();
                    //    bool esvalida = true;

                    //    if (gastoadministrativo != null)
                    //    {
                    //        if (gastoadministrativo.FechaTermino != null)
                    //            if (gastoadministrativo.FechaInicioPercepcion <= NominaTrabajador.Nomina.FechaInicio && gastoadministrativo.FechaTermino >= NominaTrabajador.Nomina.FechaTermino)
                    //                esvalida = true;
                    //            else
                    //                esvalida = false;

                    //        if (gastoadministrativo.FechaInicioPercepcion <= NominaTrabajador.Nomina.FechaInicio && esvalida)
                    //        {
                    //            gastoDiario = gastoadministrativo.Importe / 15;
                    //        }
                    //    }
                    //    }





                    //var zonamarginalpercep = NominaTrabajador.PlantillaNominaPercepciones.Where(s => s.Percepciones_ctPercepcion.Percepcion.Contains("APOYO ZONA MARGINAL")).Select(x => x.IdPlantillaNominaPercepcion).ToArray();
                    //Decimal zonamarginalDiario = (decimal)NominaTrabajador.ListaPercepcionesTrabajadores.Where(x => zonamarginalpercep.Contains(x.IdPlantillaNominaPercepcion) && x.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(a => a.Importe) / diaslaborados;
                    Decimal zonamarginalDiario = 0;
                    Percepciones_stPercepcionesPersonalizadas zonamarginal = null;

                    zonamarginal = NominaTrabajador.PercepcionPersonalizada.Where(x =>
                         x.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                          && x.FechaInicioPercepcion <= NominaTrabajador.Nomina_stNomina.FechaInicio &&
                (x.FechaTermino == null || x.FechaTermino <= NominaTrabajador.Nomina_stNomina.FechaTermino)
                         && x.Percepciones_ctPercepcion.Percepcion == "APOYO ZONA MARGINAL").OrderByDescending(a=> a.FechaInicioPercepcion ).FirstOrDefault();
                    bool esvalidazm = true;

                    if (zonamarginal != null)
                    {
                        if (zonamarginal.FechaTermino != null)
                            if (zonamarginal.FechaInicioPercepcion <= NominaTrabajador.Nomina.FechaInicio && zonamarginal.FechaTermino >= NominaTrabajador.Nomina.FechaTermino)
                                esvalidazm = true;
                            else
                                esvalidazm = false;

                        if (zonamarginal.FechaInicioPercepcion <= NominaTrabajador.Nomina.FechaInicio && esvalidazm)
                        {
                            zonamarginalDiario = zonamarginal.Importe / 15;
                        }
                    }

                    //var transportepercep = NominaTrabajador.PlantillaNominaPercepciones.Where(s => s.Percepciones_ctPercepcion.Percepcion.Contains("AYUDA PARA TRANSPORTE")).Select(x => x.IdPlantillaNominaPercepcion).ToArray();
                    //Decimal transporteDiario = (decimal)NominaTrabajador.ListaPercepcionesTrabajadores.Where(x => transportepercep.Contains(x.IdPlantillaNominaPercepcion) && x.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(a => a.Importe) / diaslaborados;

                    Decimal transporteDiario = (decimal)((costos.CostoAyudaTransporte * 7) * 15)/ diaslaborados;
                

                var eficienciapercep = NominaTrabajador.PlantillaNominaPercepciones.Where(s => s.Percepciones_ctPercepcion.Percepcion.Contains("EFICIENCIA EN EL TRABAJO")).Select(x => x.IdPlantillaNominaPercepcion).ToArray();
                    Decimal eficienciaDiario = (decimal)NominaTrabajador.ListaPercepcionesTrabajadores.Where(x => eficienciapercep.Contains(x.IdPlantillaNominaPercepcion) && x.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(a => a.Importe) / diaslaborados;

                    //var culturapercep = NominaTrabajador.PlantillaNominaPercepciones.Where(s => s.Percepciones_ctPercepcion.Percepcion.Contains("APOYO PARA LA CULTURA Y EL DEPORTE")).Select(x => x.IdPlantillaNominaPercepcion).ToArray();
                    //Decimal culturaDiario = (decimal)NominaTrabajador.ListaPercepcionesTrabajadores.Where(x => culturapercep.Contains(x.IdPlantillaNominaPercepcion) && x.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(a => a.Importe) / diaslaborados;
                    Decimal culturaDiario = (decimal)((costos.CostoApoyoCulturaDeporte * 7) * 15) / diaslaborados;

                    var guarderiapercep = NominaTrabajador.PlantillaNominaPercepciones.Where(s => s.Percepciones_ctPercepcion.Percepcion.Contains("GUARDERIA")).Select(x => x.IdPlantillaNominaPercepcion).ToArray();
                    Decimal guarderiaDiario = (decimal)NominaTrabajador.ListaPercepcionesTrabajadores.Where(x => guarderiapercep.Contains(x.IdPlantillaNominaPercepcion) && x.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(a => a.Importe) / diaslaborados;

                    var RDLDiario = Math.Round(NominaTrabajador.PercepcionesPersonalizadas.Where(x => x.Percepciones_ctPercepcion.Percepcion == "REMUNERACIÓN AL DESEMPEÑO LABORAL"
                    && x.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(d => d.Importe) / 30, 2);


                    var rdlbimestreajustes = NominaTrabajador.SdiImportesVariablesRDL.Where(z => z.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).Sum(q => q.Importe);

                    RDLDiario = RDLDiario + rdlbimestreajustes;


                    var productividadpercep = NominaTrabajador.PlantillaNominaPercepciones.Where(s => s.Percepciones_ctPercepcion.Percepcion.Contains("COMPENSACION POR ACTUACION Y PRODUCTIVIDAD")).Select(x => x.IdPlantillaNominaPercepcion).ToArray();
                    Decimal productividadDiario = (decimal)NominaTrabajador.ListaPercepcionesTrabajadores.Where(x => productividadpercep.Contains(x.IdPlantillaNominaPercepcion) && x.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(a => a.Importe) / diaslaborados;

                    var otroConceptosFijos = Despensa + RDLDiario + zonamarginalDiario + transporteDiario + eficienciaDiario + culturaDiario
                        + guarderiaDiario + productividadDiario;


                   

                    List<SdiImportesVariables> ValoresVariablesBimestrePuntualidad = new List<SdiImportesVariables>();

                    List<SdiImportesVariables> ValoresVariablesBimestre = new List<SdiImportesVariables>();

                    decimal sumaVariablesDiario = 0M;
                    decimal sumaVariablesDiarioPuntualidad = 0M;
                    if (NominaTrabajador.Nomina_stNomina.Año == 2021
                        && (NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "09" || NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "10"
                       || NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "11" || NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "12"))
                    {
                        ValoresVariablesBimestrePuntualidad = NominaTrabajador.SdiImportesVariablesTrabajadores.Where(x => x.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                        && (x.Percepcion.Contains("ESTÍMULO POR PUNTUALIDAD Y ASISTENCIA") || x.Percepcion == "OTRAS PRESTACIONES")).ToList();
                        ValoresVariablesBimestre = NominaTrabajador.SdiImportesVariablesTrabajadores.Where(x => x.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                    && (!x.Percepcion.Contains( "ESTÍMULO POR PUNTUALIDAD Y ASISTENCIA") && x.Percepcion != "OTRAS PRESTACIONES")).ToList();
                    }
                    else
                    {
                        ValoresVariablesBimestrePuntualidad = NominaTrabajador.SdiImportesVariablesTrabajadores.Where(x => x.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                    && x.Percepcion.Contains("ESTÍMULO POR PUNTUALIDAD Y ASISTENCIA")).ToList();

                        ValoresVariablesBimestre = NominaTrabajador.SdiImportesVariablesTrabajadores.Where(x => x.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                     && !x.Percepcion.Contains("ESTÍMULO POR PUNTUALIDAD Y ASISTENCIA")).ToList();
                    }


                    //if (ValoresVariablesBimestrePuntualidad.Count>0)
                    foreach (var item in ValoresVariablesBimestrePuntualidad)
                    {
                        sumaVariablesDiarioPuntualidad = sumaVariablesDiarioPuntualidad + item.Importe;
                    }

                       // if (ValoresVariablesBimestre.Count>0)
                        foreach (var item in ValoresVariablesBimestre)
                        {
                            sumaVariablesDiario = sumaVariablesDiario + item.Importe;
                        }
                        


 

                    var limitesdi = 25 * NominaTrabajador.ctUMA.Monto;

                    
                    Decimal SDIFijo = otroConceptosFijos + gastoDiario+materialDiario + QuinquenioDiario +Sueldodiario + AguinaldoDiario
                        + PrimaVacacionalDiaria + AguinaldoGastoAdmivo + PrimaVacGastoAdmivo ;
                    //if (SDIFijo > limitesdi)
                    //    SDIFijo = limitesdi;

                        vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    vnt.Concepto = "SUELDO DIARIO";
                    vnt.Importe = Sueldodiario;
                    NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt);

                    VariablesNominaTrabajador vnt2 = new VariablesNominaTrabajador();
                    vnt2.Concepto = "SALARIO DIARIO INTEGRADO";
                    vnt2.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    DeduccionesNominaTrabajador dnt = new DeduccionesNominaTrabajador();
                    dnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    dnt.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "ISR").FirstOrDefault().IdPlantillaNominaDeduccion;
                    dnt.IdNomina = NominaTrabajador.IdNomina;
                    dnt.EsImprimibleRecibo = true;

                    var cayuda = NominaTrabajador.PlantillaNominaPercepciones.Where(g => (g.Percepciones_ctPercepcion.Percepcion.Trim() != "AYUDA PARA DESPENSA" && g.Percepciones_ctPercepcion.Percepcion.Trim() != "VALES DE DESPENSA") && g.Importe != null).Select(H => H.IdPlantillaNominaPercepcion).ToArray();
                    decimal percepcionesfijas = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v =>
                      v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                      && cayuda.Contains(v.IdPlantillaNominaPercepcion)).Sum(f => f.Importe);

                    decimal exento = (gastoDiario + materialDiario + QuinquenioDiario + Sueldodiario + AguinaldoDiario
                        + PrimaVacacionalDiaria + AguinaldoGastoAdmivo + PrimaVacGastoAdmivo) *0.10M;
                    //exento = exento * NominaTrabajador.DiasBimestre();

                    sumaVariablesDiarioPuntualidad = sumaVariablesDiarioPuntualidad / NominaTrabajador.DiasBimestre();
                    //if (sumaVariablesDiarioPuntualidad > exento)
                        sumaVariablesDiarioPuntualidad = sumaVariablesDiarioPuntualidad-exento ;

                    if (sumaVariablesDiarioPuntualidad < 0)
                        sumaVariablesDiarioPuntualidad = 0;

                    sumaVariablesDiario = (sumaVariablesDiario + sumaVariablesDiarioPuntualidad) / NominaTrabajador.diasBimestre;

                    decimal sumabimestre = 0;

                    int qnasdi = Nova.Libraries.ConvertToInt.ConvertToInt16(NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes);
                    if (
                        
                            NominaTrabajador.Nomina_stNomina.Año == 2024 && qnasdi <5)
                    {
                        DapperQuery dp = new DapperQuery("bdNovaEntities");

                        string query = "";

                        query = @"SELECT    [ide]
      ,[CURP]
      ,[NOMBRE]
      ,[sdifijo]
      ,[sumaconceptos]
      ,[sumavar]
      ,[SDIOK]
  FROM  Nomina_SdiInicial where ide =" + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador+ "";

                        List<Nomina_SdiInicial> datos = (List<Nomina_SdiInicial>)dp.connection.Query<Nomina_SdiInicial>(query);





                        //if (datos.Count > 0)
                        //    sumabimestre = Math.Round(System.Convert.ToDecimal(datos.First().sumavar), 2);

                        //decimal sdivariable = 0;
                        //if (sumabimestre > 0)
                        //    sdivariable = decimal.Round(sumabimestre / NominaTrabajador.DiasBimestre(), 2);

                        //vnt2.Importe = SDIFijo + sdivariable;
                        //dnt.Importe = SDIFijo + sdivariable;

                        decimal sdivariable = 0;
                        if (datos.Count > 0)
                            SDIFijo= Math.Round(System.Convert.ToDecimal(datos.First().sumavar), 2);

                        

                        vnt2.Importe = SDIFijo + sdivariable;
                        dnt.Importe = SDIFijo + sdivariable;

                        dp.Close();
                    }
                    else
                    {
                        sumabimestre = NominaTrabajador.ListaNominasAnteriormentePagadasTrabajadores.Where(z=> z.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador==ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador)
                            .Sum(x => x.SumaPercepcionesVariables);

                        decimal sdivariable = 0;
                        if (sumabimestre > 0) 
                            sdivariable = decimal.Round(sumabimestre / NominaTrabajador.DiasBimestre(), 2);
                        vnt2.Importe = SDIFijo + sumaVariablesDiario+ sdivariable;
                        dnt.Importe = SDIFijo + sumaVariablesDiario+ sdivariable;
                    }

                    // decimal LimiteSDI = NominaTrabajador.SalarioMinimoDF.Monto * 25;
                  

                    if (vnt2.Importe > limitesdi)
                        vnt2.Importe = limitesdi;

                    NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt2);

                    // NominaTrabajador.ListaDeduccionesTrabajadores.Add(dnt);
                    //DeduccionesNominaTrabajador ld = new DeduccionesNominaTrabajador();
                    //ld.EsImprimibleRecibo = false;
                    //ld.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    //ld.IdNomina = NominaTrabajador.IdNomina;
                    //ld.IdPlantillaNominaDeduccion=NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Deducciones_stPlantillaNominaDeducciones.Where(d=> d.Deducciones_ctDeduccion.Deduccion=="")
                }

            }
        }

 

    }
    //}
}