﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;
using Nova.Libraries;
using Dapper;

namespace Nova.Models.Calculos.Percepciones
{
    public class VacacionesPartesProporcionales : IPercepcionBehavior
    {

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {

            if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "VACACIONES").FirstOrDefault() != null)
            {
                var percepcionCalculo = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "VACACIONES").FirstOrDefault();
                if (percepcionCalculo.Calcular)

                {
                    var solicitud = NominaTrabajador.Nomina_PartesProporcionales.Where(a => a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();

                    //aqui solo valida que sea un contrato par aun calculo nada mas por año
                    var ultimocontrato = NominaTrabajador.PartesProporcionalesUltimoContrato.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                     ).FirstOrDefault();
                    if (solicitud != null && ultimocontrato!=null)
                        if (solicitud.CalcularVacaciones)
                            {

                           

                            NominaParaContrato sueldos = new NominaParaContrato();

                            CalculadoraSueldo calculadora = new CalculadoraSueldo();
                                if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral == "ADMINISTRATIVO")
                                {
                                    sueldos = calculadora.getSueldoVigente(ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria, 0, NominaTrabajador.Nomina_stNomina.FechaInicio);
                                }
                                else
                                {
                                    NominaTrabajador.setHorariosDocentes(solicitud.Convenios_stConvenioLaboralTrabajadorCategoria.FechaTermino.Value.ToString("yyyyMMdd"));
                                    var horariodocente = NominaTrabajador.getHorarioActualDocente(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex);
                                    var horas = (int)horariodocente.NominaHorariosDocentesDetalle.Where(q => q.TipoHoras != "HORAS CLUB").Sum(q=> q.Horas);
                                    sueldos = calculadora.getSueldoVigente(ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria, horas,NominaTrabajador.Nomina_stNomina.FechaInicio);
                                }
                                
                             
                            int idtrabajador = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;


                    DapperQuery dp = new DapperQuery("bdNovaEntities");

                   string   sqlnomina = @"select b.* from Nomina_stNominaTrabajador a
inner join Nomina_stNomina b on a.idnomina=b.idnomina
inner join [Nomina_ctPlantillaNomina] c on b.idplantillanomina=c.idplantillanomina
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria f on f.IdDistribucionPlazaCategoria=d.IdDistribucionPlazaCategoria
  inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
where EstatusNominaGrupo ='PARA PAGO' and b.EsCerrada=1 and year(b.fechainicio)=" + solicitud.Año + " and  c.Plantilla like '%sueldo%' and w.IdTrabajador=" + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador + "  order by b.fechatermino desc";

                    List<Nomina_stNomina> ultimanominas = (List<Nomina_stNomina>)dp.connection.Query<Nomina_stNomina>(sqlnomina).ToList();

                     sqlnomina = @"select a.* from Nomina_stNominaTrabajador a
inner join Nomina_stNomina b on a.idnomina=b.idnomina
inner join [Nomina_ctPlantillaNomina] c on b.idplantillanomina=c.idplantillanomina
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria f on f.IdDistribucionPlazaCategoria=d.IdDistribucionPlazaCategoria
  inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
where EstatusNominaGrupo ='PARA PAGO' and b.EsCerrada=1 and year(b.fechainicio)=" + solicitud.Año  + " and  c.Plantilla like '%sueldo%' and w.IdTrabajador=" + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador + " order by b.fechatermino desc";

                    List<Nomina_stNominaTrabajador> ultimanominapagada = (List<Nomina_stNominaTrabajador>)dp.connection.Query<Nomina_stNominaTrabajador>(sqlnomina).ToList();



                            short diasefectivoslaborados = 0;
                            int mesescon31dias = 0;
                            int diasFebrero = 0;
                            double diasremanentes = 0;

                            DateTime FechaTermino = DateTime.Now;
                            DateTime FechaInicio = DateTime.Now;

                            if (ultimanominas.Count > 0)
                            {


                                var contratostrabajador = NominaTrabajador.ListaAguinaldoTrabajadores.Where(z => z.IdTrabajador == idtrabajador
                                && z.IdConvenioLaboralTrabajadorCategoria <= ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).OrderBy(a => a.FechaInicio).ToList();

                                var plazatrabajador = NominaTrabajador.Plazas_ctCategoria.Where(s => s.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.IdCategoria).FirstOrDefault();
                                var existenDiasEntreContrato = false;
                                int c = 1;
                                //DateTime inicio = contratostrabajador.FirstOrDefault().FechaInicio;
                                if (ConvenioLaboralTrabajadorCategoria.FechaTermino == null && solicitud != null)
                                {
                                    //BUSCAR SU INCIDENCIA
                                    string consulta = $@"  select * from vwLicenciasTrabajadores
                                            where idtrabajador={ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador }
                                            and Incidencia like '%SIN GOCE DE SUELDO%'
                                            AND YEAR(FechaInicioIncidencia)={solicitud.Año} order by FechaTerminoIncidencia ";
                                    List<vwLicenciasTrabajadores> licencias = (List<vwLicenciasTrabajadores>)dp.connection.Query<vwLicenciasTrabajadores>(consulta).ToList();

                                    if (licencias.Count > 0)
                                    {
                                        ///
                                        //inicio año
                                        //DateTime inicioaño = DateTime.Parse(solicitud.Año + "-01-01");

                                        ////TimeSpan Diff_dates1 = inicioaño.Subtract(ultimanominas.FirstOrDefault().FechaTermino);
                                        //TimeSpan Diff_dates1 = ultimanominas.FirstOrDefault().FechaTermino.Subtract(inicioaño);
                                        //diasremanentes = Diff_dates1.Days;
                                        //FechaTermino = ultimanominas.FirstOrDefault().FechaTermino;
                                        //FechaInicio = inicioaño;

                                        diasremanentes = DiasDelPeriodo(licencias[0].FechaInicioIncidencia);

                                        //if (plazatrabajador.CalcularNominaDiasCalendario == false)
                                        //{
                                        //    mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(FechaInicio, FechaTermino);
                                        //    diasFebrero = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(FechaInicio, FechaTermino);
                                        //}
                                        //diasremanentes = diasremanentes + mesescon31dias + diasFebrero;
                                        diasefectivoslaborados = (short)(diasefectivoslaborados + (short)diasremanentes);
                                    }
                                }
                                else
                                    for (int i = 0; i < contratostrabajador.Count; i++)
                                    {
                                        c = c + i;
                                        if (c < contratostrabajador.Count)
                                        {
                                            if (contratostrabajador[c].FechaInicio.Subtract(contratostrabajador[i].FechaTermino).TotalDays == 1)
                                            {
                                                if (contratostrabajador[i].FechaInicio.Year < solicitud.Año)
                                                {
                                                    DateTime dt = DateTime.Parse(solicitud.Año.ToString() + "-01-01");
                                                    TimeSpan Diff_dates = contratostrabajador[i].FechaTermino.Subtract(dt.AddDays(-1));
                                                    diasremanentes = Diff_dates.Days;
                                                }
                                                else
                                                {
                                                    TimeSpan Diff_dates = contratostrabajador[c].FechaInicio.AddDays(1).Subtract(contratostrabajador[i].FechaTermino.AddDays(-1));
                                                    diasremanentes = Diff_dates.Days;
                                                }
                                                if (plazatrabajador.CalcularNominaDiasCalendario == false)
                                                {
                                                    mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(contratostrabajador[i].FechaInicio, contratostrabajador[i].FechaTermino);
                                                    diasFebrero = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(contratostrabajador[i].FechaInicio, contratostrabajador[i].FechaTermino);
                                                }
                                                //101 / 365 // se fue 10 de dic 2021
                                                //fecha de baja de la licanceia
                                                diasremanentes = diasremanentes + mesescon31dias + diasFebrero;
                                                diasefectivoslaborados = (short)(diasefectivoslaborados + (short)diasremanentes);


                                            }

                                        }
                                        else
                                        {

                                            if (contratostrabajador[i].FechaInicio.Year < solicitud.Año)
                                            {
                                                DateTime dt = DateTime.Parse(solicitud.Año.ToString() + "-01-01");
                                                TimeSpan Diff_dates = contratostrabajador[i].FechaTermino.Subtract(dt.AddDays(-1));
                                                diasremanentes = Diff_dates.Days;
                                            }
                                            else
                                            {
                                                TimeSpan Diff_dates = contratostrabajador[i].FechaTermino.AddDays(1).Subtract(contratostrabajador[i].FechaInicio);
                                                diasremanentes = Diff_dates.Days;
                                            }
                                            if (plazatrabajador.CalcularNominaDiasCalendario == false)
                                            {
                                                mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(contratostrabajador[i].FechaInicio, contratostrabajador[i].FechaTermino);
                                                diasFebrero = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(contratostrabajador[i].FechaInicio, contratostrabajador[i].FechaTermino);
                                            }
                                            diasremanentes = diasremanentes + mesescon31dias + diasFebrero;
                                            diasefectivoslaborados = (short)(diasefectivoslaborados + (short)diasremanentes);


                                            //}
                                        }
                                    }





                                Decimal SueldoQuinquenioDiario = ultimanominapagada.FirstOrDefault().SueldoDiario;

                                var importebase = NominaTrabajador.ctUMA.Monto;



                                //TimeSpan Diff_dates =ConvenioLaboralTrabajadorCategoria.FechaTermino.Value.AddDays(1).Subtract(ultimanominas.LastOrDefault().FechaInicio.AddDays(-1));
                                //diasremanentes = Diff_dates.Days;
                                //if (plazatrabajador.CalcularNominaDiasCalendario == false)
                                //{
                                //    mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(ultimanominas.LastOrDefault().FechaInicio, ultimanominas.FirstOrDefault().FechaTermino);
                                //    diasFebrero = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(ultimanominas.LastOrDefault().FechaInicio, ultimanominas.FirstOrDefault().FechaTermino);
                                //}
                                //diasremanentes = diasremanentes + mesescon31dias + diasFebrero;
                                //diasefectivoslaborados = (short)diasremanentes;



                                string conveniolaboral = ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral;

                                decimal factor = 0;

                                PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();
                                bdNovaEntities aa = new bdNovaEntities();
                                percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                percepcion.IdNomina = NominaTrabajador.IdNomina;
                                percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "VACACIONES").FirstOrDefault().IdPlantillaNominaPercepcion;
                                percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "VACACIONES").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                                percepcion.IdPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == percepcion.IdPlantillaNominaPercepcion).FirstOrDefault().IdPercepcion;
                                percepcion.Percepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == percepcion.IdPlantillaNominaPercepcion).FirstOrDefault().Percepciones_ctPercepcion.Percepcion;


                                switch (conveniolaboral)
                                {

                                    case "MANDO MEDIO Y SUPERIOR":
                                        ////factor = (diasefectivoslaborados * diasaguinaldo) / 365M;
                                        ////percepcion.Importe = percepcion.Importe + (SueldoQuinquenioDiario * factor);

                                        factor = (15 / 365M) * diasefectivoslaborados;
                                        percepcion.Importe = SueldoQuinquenioDiario * factor;
                                        break;
                                    case "CONFIANZA":
                                        factor = (15 / 365M) * diasefectivoslaborados;
                                        percepcion.Importe = SueldoQuinquenioDiario * factor;

                                        break;
                                    case "BASE":
                                        factor = (35 / 365M) * diasefectivoslaborados;
                                        percepcion.Importe = SueldoQuinquenioDiario * factor;
                                        break;
                                    case "CONTRATO":
                                        //factor = (diasefectivoslaborados * diasaguinaldo) / 365M;
                                        //percepcion.Importe = percepcion.Importe + (SueldoQuinquenioDiario * factor);

                                        factor = (15 / 365M) * diasefectivoslaborados;
                                        percepcion.Importe = SueldoQuinquenioDiario * factor;

                                        break;
                                    default:
                                        break;
                                }

                                percepcion.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "VACACIONES").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                                NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);

                            }
                            else
                            {
                                //nuevo calculo BARRITA


                                //var contratostrabajador = NominaTrabajador.ListaAguinaldoTrabajadores.Where(z => z.IdTrabajador == idtrabajador
                                //).OrderBy(a => a.FechaInicio).ToList();

                                var plazatrabajador = NominaTrabajador.Plazas_ctCategoria.Where(s => s.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.IdCategoria).FirstOrDefault();
                                var existenDiasEntreContrato = false;
                                int c = 1;
                                //DateTime inicio = contratostrabajador.FirstOrDefault().FechaInicio;
                                if (ConvenioLaboralTrabajadorCategoria.FechaTermino == null && solicitud != null)
                                {
                                    //BUSCAR SU INCIDENCIA
                                    string consulta = $@"  select * from vwLicenciasTrabajadores
                                            where idtrabajador={ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador }
                                            and Incidencia like '%SIN GOCE DE SUELDO%'
                                            AND YEAR(FechaInicioIncidencia)={solicitud.Año} order by FechaTerminoIncidencia ";
                                    List<vwLicenciasTrabajadores> licencias = (List<vwLicenciasTrabajadores>)dp.connection.Query<vwLicenciasTrabajadores>(consulta).ToList();

                                    if (licencias.Count > 0)
                                    {
                                        
                                        diasremanentes = DiasDelPeriodo(licencias[0].FechaInicioIncidencia);

                                               diasefectivoslaborados = (short)(diasefectivoslaborados + (short)diasremanentes);
                                    }
                                }
                                else
                                    //for (int i = 0; i < contratostrabajador.Count; i++)
                                    {
                                        //c = c + i;
                                        //if (c < contratostrabajador.Count)
                                        //{
                                            //if (ConvenioLaboralTrabajadorCategoria.FechaInicio.Subtract(ConvenioLaboralTrabajadorCategoria.FechaTermino.Value).TotalDays == 1)
                                            //{
                                                 
                                                    TimeSpan Diff_dates = ConvenioLaboralTrabajadorCategoria.FechaTermino.Value.AddDays(1).Subtract(ConvenioLaboralTrabajadorCategoria.FechaInicio);
                                                    diasremanentes = Diff_dates.Days;
                                                //}
                                                //if (plazatrabajador.CalcularNominaDiasCalendario == false)
                                                //{
                                                //    mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(ConvenioLaboralTrabajadorCategoria.FechaInicio, ConvenioLaboralTrabajadorCategoria.FechaTermino.Value);
                                                //    diasFebrero = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(ConvenioLaboralTrabajadorCategoria.FechaInicio, ConvenioLaboralTrabajadorCategoria.FechaTermino.Value);
                                                //}
                                                ////101 / 365 // se fue 10 de dic 2021
                                                ////fecha de baja de la licanceia
                                                //diasremanentes = diasremanentes + mesescon31dias + diasFebrero;
                                                diasefectivoslaborados = (short)(diasefectivoslaborados + (short)diasremanentes);


                                            //}

                                        
                                        //else
                                        //{

                                        //    //if (contratostrabajador[i].FechaInicio.Year < solicitud.Año)
                                        //    //{
                                        //    //    DateTime dt = DateTime.Parse(solicitud.Año.ToString() + "-01-01");
                                        //    //    TimeSpan Diff_dates = contratostrabajador[i].FechaTermino.Subtract(dt.AddDays(-1));
                                        //    //    diasremanentes = Diff_dates.Days;
                                        //    //}
                                        //    //else
                                        //    //{
                                        //        TimeSpan Diff_dates = contratostrabajador[i].FechaTermino.AddDays(1).Subtract(contratostrabajador[i].FechaInicio);
                                        //        diasremanentes = Diff_dates.Days;
                                        //    //}
                                        //    if (plazatrabajador.CalcularNominaDiasCalendario == false)
                                        //    {
                                        //        mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(contratostrabajador[i].FechaInicio, contratostrabajador[i].FechaTermino);
                                        //        diasFebrero = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(contratostrabajador[i].FechaInicio, contratostrabajador[i].FechaTermino);
                                        //    }
                                        //    diasremanentes = diasremanentes + mesescon31dias + diasFebrero;
                                        //    diasefectivoslaborados = (short)(diasefectivoslaborados + (short)diasremanentes);


                                        //    //}
                                        //}
                                    }





                                Decimal SueldoQuinquenioDiario = sueldos.Sueldo/15;

                                var importebase = NominaTrabajador.ctUMA.Monto;



                                //TimeSpan Diff_dates =ConvenioLaboralTrabajadorCategoria.FechaTermino.Value.AddDays(1).Subtract(ultimanominas.LastOrDefault().FechaInicio.AddDays(-1));
                                //diasremanentes = Diff_dates.Days;
                                //if (plazatrabajador.CalcularNominaDiasCalendario == false)
                                //{
                                //    mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(ultimanominas.LastOrDefault().FechaInicio, ultimanominas.FirstOrDefault().FechaTermino);
                                //    diasFebrero = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(ultimanominas.LastOrDefault().FechaInicio, ultimanominas.FirstOrDefault().FechaTermino);
                                //}
                                //diasremanentes = diasremanentes + mesescon31dias + diasFebrero;
                                //diasefectivoslaborados = (short)diasremanentes;



                                string conveniolaboral = ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral;

                                decimal factor = 0;

                                PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();
                                bdNovaEntities aa = new bdNovaEntities();
                                percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                percepcion.IdNomina = NominaTrabajador.IdNomina;
                                percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "VACACIONES").FirstOrDefault().IdPlantillaNominaPercepcion;
                                percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "VACACIONES").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                                percepcion.IdPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == percepcion.IdPlantillaNominaPercepcion).FirstOrDefault().IdPercepcion;
                                percepcion.Percepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == percepcion.IdPlantillaNominaPercepcion).FirstOrDefault().Percepciones_ctPercepcion.Percepcion;


                                switch (conveniolaboral)
                                {

                                    case "MANDO MEDIO Y SUPERIOR":
                                        ////factor = (diasefectivoslaborados * diasaguinaldo) / 365M;
                                        ////percepcion.Importe = percepcion.Importe + (SueldoQuinquenioDiario * factor);

                                        factor = (15 / 365M) * diasefectivoslaborados;
                                        percepcion.Importe = SueldoQuinquenioDiario * factor;
                                        break;
                                    case "CONFIANZA":
                                        factor = (15 / 365M) * diasefectivoslaborados;
                                        percepcion.Importe = SueldoQuinquenioDiario * factor;

                                        break;
                                    case "BASE":
                                        factor = (35 / 365M) * diasefectivoslaborados;
                                        percepcion.Importe = SueldoQuinquenioDiario * factor;
                                        break;
                                    case "CONTRATO":
                                        //factor = (diasefectivoslaborados * diasaguinaldo) / 365M;
                                        //percepcion.Importe = percepcion.Importe + (SueldoQuinquenioDiario * factor);

                                        factor = (12 / 365M) * diasefectivoslaborados;
                                        percepcion.Importe = SueldoQuinquenioDiario * factor;

                                        break;
                                    default:
                                        break;
                                }

                                percepcion.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "VACACIONES").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                                NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);
                            }
                            dp.Close();

                        }

                }
            }
        }

        private int DiasDelPeriodo(DateTime inicioincidencia)
        {
            int dias = 0;
            int añoinici = inicioincidencia.Year;
            DateTime ini = new DateTime();
            DateTime fin = inicioincidencia;
            if (inicioincidencia.Month < 5)
            {
                 ini = DateTime.Parse(añoinici + "-01-01");

                TimeSpan Diff_dates = fin.AddDays(1).Subtract(ini);
                dias = (int)Diff_dates.TotalDays;
            }
            else
                if (inicioincidencia.Month < 9)
            {
                ini = DateTime.Parse(añoinici + "-05-01");

                TimeSpan Diff_dates = fin.AddDays(1).Subtract(ini);
                dias = (int)Diff_dates.TotalDays;
            }
            else
            {
                ini = DateTime.Parse(añoinici + "-09-01");
                //fin = DateTime.Parse(añoinici + "08-31");
                TimeSpan Diff_dates = fin.AddDays(1).Subtract(ini);
                dias = (int)Diff_dates.TotalDays;
            }
            return dias;
        }
        void IPercepcionBehavior.Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }
    }
}


