﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;
using Nova.Libraries;
using Dapper;

namespace Nova.Models.Calculos.Percepciones
{

    public class SueldoPartesProporcionales : IPercepcionBehavior
    {
     
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {
            if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.CalculoPorSolicitud && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES")) 
            {
                var percepcionCalculo = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault();
                if (percepcionCalculo!=null)

                {
                    DapperQuery dp = new DapperQuery("bdNovaEntities");

                    string sqlnomina = @"select b.* from Nomina_stNominaTrabajador a
inner join Nomina_stNomina b on a.idnomina=b.idnomina
inner join [Nomina_ctPlantillaNomina] c on b.idplantillanomina=c.idplantillanomina
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria f on f.IdDistribucionPlazaCategoria=d.IdDistribucionPlazaCategoria
  inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
where EstatusNominaGrupo ='PARA PAGO' and  b.EsCerrada=1 and year(b.fechainicio)=" + NominaTrabajador.Nomina_stNomina.FechaInicio.Year + " and  c.Plantilla like '%sueldo%' and w.IdTrabajador=" + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador + "  order by b.fechatermino desc";

                    List<Nomina_stNomina> ultimanominas = (List<Nomina_stNomina>)dp.connection.Query<Nomina_stNomina>(sqlnomina).ToList();

                    DateTime fechaultiimanomina = NominaTrabajador.Nomina.FechaTermino.AddDays(1);
                    if (ultimanominas.Count > 0)
                    {
                        fechaultiimanomina = ultimanominas[0].FechaTermino.AddDays(1);
                    }


                    //SingletonAntiguedad antiguedad = SingletonAntiguedad.Instance;

                    //AntiguedadLaboralQuinquenioTrabajador antiguedadtrabajador = antiguedad.getAntiguedad(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador);

                    //var tiempo = DateTimeSpan.CompareDates(antiguedadtrabajador.FechaInicioQuinquenio, fechaultiimanomina);
                    var tiempo = NominaTrabajador.TrabajadorAntiguedad.getAntiguedadPorTrabajador(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador);

                    decimal importeexcento = (NominaTrabajador.ctUMA.Monto * 90);
                    int años = tiempo.Years;
                    Double dias = 0;
                    if (tiempo.Years > 0)
                    {
                        importeexcento = importeexcento * tiempo.Years;
                    }



                    var indeminazacion = NominaTrabajador.Nomina_ctTipoPartesProporcionales.Where(s => s.TipoPartesProporcionales == "INDEMNIZACION").FirstOrDefault();

                    var solicitud = NominaTrabajador.Nomina_PartesProporcionales.Where(a => a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();
                    var ultimocontrato = NominaTrabajador.PartesProporcionalesUltimoContrato.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                  && s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                    if (solicitud != null)
                    {
                        if (solicitud.IdTipoPartesProporcionales == indeminazacion.IdTipoPartesProporcionales)
                        {
                            if (solicitud.ImporteIndemnizacion > 0 || solicitud.DiasIndemnizacion > 0)
                            {
                                if (solicitud != null && ultimocontrato != null)
                                    if (solicitud.ImporteIndemnizacion > 0)
                                    {
                                        if (solicitud.ImporteIndemnizacion > importeexcento)
                                        {
                                            PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();




                                            percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                            percepcion.IdNomina = NominaTrabajador.IdNomina;
                                            percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "INDEMNIZACIÓN GRAVADA").FirstOrDefault().IdPlantillaNominaPercepcion;


                                            percepcion.Importe = solicitud.ImporteIndemnizacion - importeexcento;

                                            solicitud.ImporteIndemnizacion = solicitud.ImporteIndemnizacion - (solicitud.ImporteIndemnizacion - importeexcento);

                                            percepcion.Tipo = "NORMAL";
                                            percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "INDEMNIZACIÓN GRAVADA").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                                            percepcion.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "INDEMNIZACIÓN GRAVADA").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                                            percepcion.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "INDEMNIZACIÓN GRAVADA").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;

                                            percepcion.IdPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == percepcion.IdPlantillaNominaPercepcion).FirstOrDefault().IdPercepcion;
                                            percepcion.Percepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == percepcion.IdPlantillaNominaPercepcion).FirstOrDefault().Percepciones_ctPercepcion.Percepcion;

                                            NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);
                                        }


                                        var ExisteyaSueldo1 = NominaTrabajador.ListaVariablesNominaTrabajador.Where(a => a.Concepto == "INDEMNIZACIONPARTESPROPORCIONALES" && a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();
                                        if (ExisteyaSueldo1 == null)
                                        {

                                            PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();




                                            percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                            percepcion.IdNomina = NominaTrabajador.IdNomina;
                                            percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "INDEMNIZACIÓN EXENTA").FirstOrDefault().IdPlantillaNominaPercepcion;


                                            percepcion.Importe = solicitud.ImporteIndemnizacion;



                                            percepcion.Tipo = "NORMAL";
                                            percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "INDEMNIZACIÓN EXENTA").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                                            percepcion.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "INDEMNIZACIÓN EXENTA").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                                            percepcion.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "INDEMNIZACIÓN EXENTA").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                                            percepcion.IdPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == percepcion.IdPlantillaNominaPercepcion).FirstOrDefault().IdPercepcion;
                                            percepcion.Percepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == percepcion.IdPlantillaNominaPercepcion).FirstOrDefault().Percepciones_ctPercepcion.Percepcion;


                                            NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);

                                            VariablesNominaTrabajador vnt44 = new VariablesNominaTrabajador();
                                            vnt44.Concepto = "INDEMNIZACIONPARTESPROPORCIONALES";
                                            vnt44.IdTrabajador = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                                            vnt44.Importe = percepcion.Importe;
                                            NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt44);
                                        }
                                    }
                            }
                        }
                        else
                        if (solicitud.ImporteIndemnizacion > 0)
                        {

                            var ExisteyaSueldo = NominaTrabajador.ListaVariablesNominaTrabajador.Where(a => a.Concepto == "SUELDOPARTESPROPORCIONALES" && a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();
                            if (ExisteyaSueldo == null)
                            {

                                PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();




                                percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                percepcion.IdNomina = NominaTrabajador.IdNomina;
                                percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().IdPlantillaNominaPercepcion;


                                percepcion.Importe = solicitud.ImporteIndemnizacion;




                                percepcion.Tipo = "NORMAL";
                                percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                                percepcion.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                                percepcion.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;

                                percepcion.IdPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == percepcion.IdPlantillaNominaPercepcion).FirstOrDefault().IdPercepcion;
                                percepcion.Percepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == percepcion.IdPlantillaNominaPercepcion).FirstOrDefault().Percepciones_ctPercepcion.Percepcion;

                                NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);

                                VariablesNominaTrabajador vnt44 = new VariablesNominaTrabajador();
                                vnt44.Concepto = "SUELDOPARTESPROPORCIONALES";
                                vnt44.IdTrabajador = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                                vnt44.Importe = percepcion.Importe;
                                NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt44);
                            }
                        }
                    }
                }

               // CalcularDiferenciasCreditos(ConvenioLaboralTrabajadorCategoria, NominaTrabajador, per);
            }
        }
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }
    }
}