﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;

namespace Nova.Models.Calculos.Percepciones
{

    public class Quinquenio : IPercepcionBehavior
    {

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador,string per="")
        {
            if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "QUINQUENIO").FirstOrDefault() != null)
            {
                PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

                if (NominaTrabajador.ParametrosRelacionLaboral.EsCalcularQuinquenio)

                {

                    percepcion.Importe = ImporteQuinquenioTrabajador(ConvenioLaboralTrabajadorCategoria, NominaTrabajador);
                    if (NominaTrabajador.Nomina_stNomina.Año == 2024
                        && NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "02")
                    {
                     if ( ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == 2018
                        )
                        percepcion.Importe = 1140.06M;

                        if (
                            ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == 2830
                            )
                            percepcion.Importe = 845.78M;

                       
                    }
                    if (percepcion.Importe != 0)
                    {


                        percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        percepcion.IdNomina = NominaTrabajador.IdNomina;
                        percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "QUINQUENIO").FirstOrDefault().IdPlantillaNominaPercepcion;
                        percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "QUINQUENIO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                        percepcion.IdPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == percepcion.IdPlantillaNominaPercepcion).FirstOrDefault().IdPercepcion;
                        percepcion.Percepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == percepcion.IdPlantillaNominaPercepcion).FirstOrDefault().Percepciones_ctPercepcion.Percepcion;

                        percepcion.Tipo = "NORMAL";
                        percepcion.EsPrevisionSocial = false;
                        NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);

                    }

                }
            }
        }

        public decimal ImporteQuinquenioTrabajador (Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            int idtrabajador = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdTrabajador;
            // bdNovaEntities qq = new bdNovaEntities();

            Decimal SueldoQuincenal = 0;


            Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
            SueldoQuincenal = NominaTrabajador.Truncate(costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMinimo * costos.CostoPorHora, 2)*15;

            var sueldopercep = NominaTrabajador.PlantillaNominaPercepciones.Where(s => s.Percepciones_ctPercepcion.Percepcion.Contains("SUELDO")).Select(x => x.IdPlantillaNominaPercepcion).ToArray();
            var SueldoQuincenalPercep = (decimal)NominaTrabajador.ListaPercepcionesTrabajadores.Where(x => sueldopercep.Contains(x.IdPlantillaNominaPercepcion) && x.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(a => a.Importe);

            if (SueldoQuincenalPercep > 0)
                SueldoQuincenal = SueldoQuincenalPercep;

            decimal Importe = 0;

            //SingletonAntiguedad antiguedad = SingletonAntiguedad.Instance;

            //AntiguedadLaboralQuinquenioTrabajador quinquenio= antiguedad.getAntiguedad(idtrabajador);



            
            try
            {
                //  var quinquenioNomina = DateTimeSpan.CompareDates(quinquenio.FechaInicioQuinquenio, NominaTrabajador.Nomina.FechaTermino.AddDays(1));
                var quinquenioNomina = NominaTrabajador.QuinquenioTrabajadorAntiguedad.getAntiguedadPorTrabajador(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador);




                if (quinquenioNomina.Years >= NominaTrabajador.ParametrosRelacionLaboral.AñosQuinquenio)
            {
                if (quinquenioNomina.Years >= 21)
                    Importe = SueldoQuincenal * (0.025M * quinquenioNomina.Years);     
                else
                    Importe = SueldoQuincenal * (Convert.ToDecimal(NominaTrabajador.ParametrosRelacionLaboral.PorcentajeQuinquenio) * quinquenioNomina.Years);     
            }

            }
            catch (Exception ex)
            {

                var s = ex;
            }
            return Importe;
        }




        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }
    }

}