﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;
using Nova.Libraries;
using Dapper;
using DevExpress.DashboardCommon;

namespace Nova.Models.Calculos.Percepciones
{
    public class PrimaVacacionalContrato : IPercepcionBehavior
    {
       
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {

            if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA VACACIONAL EXENTA").FirstOrDefault() != null)
            {
                var percepcionCalculo = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA VACACIONAL EXENTA").FirstOrDefault();
                if (percepcionCalculo.Calcular)

                {
                    decimal totalfactor = 0;
                    var calcula = true;
                    var partesproporcionales = false;
                    var solicitud = NominaTrabajador.Nomina_PartesProporcionales.Where(a => a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();
                    var ultimocontrato = NominaTrabajador.PartesProporcionalesUltimoContrato.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                  && s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                    var plazatrabajador = NominaTrabajador.Plazas_ctCategoria.Where(s => s.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.IdCategoria).FirstOrDefault();

                    if (solicitud != null)
                    {
                        
                        if (solicitud.CalcularPrimaVacacional == false || ultimocontrato == null)
                        { calcula = false; }
                        if (solicitud.CalcularVacaciones)
                        {
                            partesproporcionales = true;
                            calcula = true;
                        }
                    }

                    if (calcula)
                    {
                        List<Nomina_stNomina> existePrimaexenta = new List<Nomina_stNomina>();

                        //    SingletonAntiguedad antiguedad = SingletonAntiguedad.Instance;

                        //AntiguedadLaboralQuinquenioTrabajador antiguedadtrabajador = antiguedad.getAntiguedad(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador);


                        //       var tiempo = DateTimeSpan.DateDiffYMD(antiguedadtrabajador.FechaInicioQuinquenio, NominaTrabajador.Nomina.FechaTermino.AddDays(1));

                        //var tiempo = NominaTrabajador.TrabajadorAntiguedad.getAntiguedadPorTrabajador(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador);
                        var tiempo = NominaTrabajador.QuinquenioTrabajadorAntiguedad.SumarUnDia(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador);

                        List<int> idesconderecho = new List<int>();
                        idesconderecho.Add(3313);
                        idesconderecho.Add(3428);
                        idesconderecho.Add(4075);
                        bool conderecho = false;
                        if (idesconderecho.Contains(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador)) 
                            conderecho = true;

                        bool Derechopartesproporcionales = false;

                        if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.CalculoPorSolicitud && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES"))
                            if (tiempo.Years >= 1  )
                                Derechopartesproporcionales = true;

                                ///if (tiempo.Years >= 1 || partesproporcionales || conderecho )
                                if (conderecho )
                    

                            {


                        PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();
                        bdNovaEntities qq = new bdNovaEntities();
                        Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
                        Decimal Sueldodiario = 0;

                        //busca si termino una licencia
                        var regresadeLicencia = NominaTrabajador.LicenciasTrabajadoresPrimavacacional.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                        decimal diasAPagar = 12.0M;

                            NominaParaContrato sueldos = new NominaParaContrato();

                            CalculadoraSueldo calculadora = new CalculadoraSueldo();
                            if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral == "ADMINISTRATIVO")
                            {
                                sueldos = calculadora.getSueldoVigente(ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria, 0, NominaTrabajador.Nomina_stNomina.FechaInicio);
                            }
                            else
                            {
                                NominaTrabajador.setHorariosDocentes(solicitud.Convenios_stConvenioLaboralTrabajadorCategoria.FechaTermino.Value.ToString("yyyyMMdd"));
                                var horariodocente = NominaTrabajador.getHorarioActualDocente(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex);
                                var horas = (int)horariodocente.NominaHorariosDocentesDetalle.Where(q => q.TipoHoras != "HORAS CLUB").Sum(q => q.Horas);
                                sueldos = calculadora.getSueldoVigente(ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria, horas, NominaTrabajador.Nomina_stNomina.FechaInicio);
                            }


                            //Sueldodiario = NominaTrabajador.Truncate(costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMinimo * costos.CostoPorHora, 2);
                            Sueldodiario = sueldos.Sueldo/15;
                            int diasDiferencias = 0;



                            if (regresadeLicencia != null)
                        {
                            if (regresadeLicencia.FechaTerminoIncidencia != null)
                                    if (regresadeLicencia.FechaTerminoIncidencia <= NominaTrabajador.Nomina_stNomina.FechaTermino)
                                    {
                                diasAPagar = diasAPagar - NominaTrabajador.DiasdePrima(ConvenioLaboralTrabajadorCategoria, regresadeLicencia);

                            }
                        }
                        else
                        {
                                if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.CalculoPorSolicitud && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES"))
                                {
                                    bdNovaEntities bd = new bdNovaEntities();
                                    var parametrosAñoPrima = bd.Catalogos_ctParametrosRelacionLaboral.Where(a => a.IdRelacionConvenioLaboral== NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral && a.FechaFinal.Value.Year == solicitud.Año).FirstOrDefault();



                                    DapperQuery dp = new DapperQuery("bdNovaEntities");




                                    string queryPrima = @"select a.* from 
Nomina_stNomina a 
inner join Nomina_stNominaTrabajador b on a.idnomina=b.IdNomina 
inner join Percepciones_stNominaTrabajadorPercepciones ss on ss.IdNominaTrabajador=b.IdNominaTrabajador
inner join Nomina_ctPlantillaNomina c on c.IdPlantillaNomina=a.IdPlantillaNomina 
inner join Percepciones_stPlantillaNominaPercepciones pp on pp.IdPlantillaNominaPercepcion=ss.IdPlantillaNominaPercepcion
inner join Percepciones_ctPercepcion per on per.IdPercepcion=pp.IdPercepcion
inner join Nomina_stNominaTrabajadorEstatus d on d.IdNominaTrabajadorEstatus=b.IdNominaTrabajadorEstatus 
inner join Convenios_stConvenioLaboralTrabajadorCategoria f on f.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria 
inner join Convenios_stConvenioLaboralTrabajador g on g.IdConvenioLaboralTrabajador =f.IdConvenioLaboralTrabajador 
inner join Nomina_stNominaTrabajadorEstatusGrupo w on w.IdNominaTrabajadorEstatusGrupo=d.IdNominaTrabajadorEstatusGrupo 
where a.EsCerrada=1 and g.IdTrabajador=" + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador + @" and w.EstatusNominaGrupo='PARA PAGO' AND YEAR(A.FECHATERMINO)=" + solicitud.Año + " and per.Percepcion like '%PRIMA VACACIONAL EXENTA%' order by  a.fechatermino desc";

                                    existePrimaexenta = (List<Nomina_stNomina>)dp.connection.Query<Nomina_stNomina>(queryPrima.ToString());




                                    string sqlnomina = @"select b.* from Nomina_stNominaTrabajador a
inner join Nomina_stNomina b on a.idnomina=b.idnomina
inner join [Nomina_ctPlantillaNomina] c on b.idplantillanomina=c.idplantillanomina
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria f on f.IdDistribucionPlazaCategoria=d.IdDistribucionPlazaCategoria
inner join Nomina_stNominaTrabajadorEstatus r on r.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus 
inner join Nomina_stNominaTrabajadorEstatusGrupo z on z.IdNominaTrabajadorEstatusGrupo=r.IdNominaTrabajadorEstatusGrupo 
where z.EstatusNominaGrupo='PARA PAGO'  and b.EsCerrada=1 and year(b.fechainicio)=" + solicitud.Año + " and  c.Plantilla like '%sueldo%' and w.IdTrabajador=" + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador + "  order by b.fechatermino desc";

                                    List<Nomina_stNomina> ultimanominas = (List<Nomina_stNomina>)dp.connection.Query<Nomina_stNomina>(sqlnomina).ToList();

                                    bool AccesoAPagarprima = false;

                            

                                    if (existePrimaexenta.Count > 0)
                                    {
                                        if (parametrosAñoPrima.Prima1 == existePrimaexenta.FirstOrDefault().IdQuincenaMes)
                                            if (ultimanominas.FirstOrDefault().IdQuincenaMes >= 9)
                                                AccesoAPagarprima = true;
                                            else
                                            {
                                                DateTime f1 = DateTime.Parse(solicitud.Año+"-04-30");
                                                    TimeSpan Diff_dates1 = f1.Subtract(ConvenioLaboralTrabajadorCategoria.FechaTermino.Value);
                                                diasDiferencias = Diff_dates1.Days / 15 ;
                                            }



                                        if (parametrosAñoPrima.Prima2 == existePrimaexenta.FirstOrDefault().IdQuincenaMes)
                                            if (ultimanominas.FirstOrDefault().IdQuincenaMes >= 18)
                                                AccesoAPagarprima = true;
                                             else
                                                {
                                                    DateTime f1 = DateTime.Parse(solicitud.Año + "-08-30");
                                                if (plazatrabajador.CalcularNominaDiasCalendario == true)
                                                    f1 = f1.AddDays(1);

                                                TimeSpan Diff_dates1 = f1.Subtract(ConvenioLaboralTrabajadorCategoria.FechaTermino.Value);
                                                //   diasDiferencias = Diff_dates1.Days;
                                                diasDiferencias = Diff_dates1.Days / 15;
                                            }
                                            


                                        //if (parametrosAñoPrima.Prima3 == existePrimaexenta.FirstOrDefault().IdQuincenaMes)
                                        //    if (ultimanominas.FirstOrDefault().IdQuincenaMes > parametrosAñoPrima.Prima3)
                                        //        AccesoAPagarprima = true;

                                    }
                                     

                                   // if (AccesoAPagarprima)
                                    //{
                                        sqlnomina = @"select a.* from Nomina_stNominaTrabajador a
inner join Nomina_stNomina b on a.idnomina=b.idnomina
inner join [Nomina_ctPlantillaNomina] c on b.idplantillanomina=c.idplantillanomina
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria f on f.IdDistribucionPlazaCategoria=d.IdDistribucionPlazaCategoria
  inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
where EstatusNominaGrupo ='PARA PAGO' and b.EsCerrada=1 and year(b.fechainicio)=" + solicitud.Año + " and  c.Plantilla like '%sueldo%' and w.IdTrabajador=" + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador + " order by b.fechatermino desc";

                                        List<Nomina_stNominaTrabajador> ultimanominapagada = (List<Nomina_stNominaTrabajador>)dp.connection.Query<Nomina_stNominaTrabajador>(sqlnomina).ToList();

                                        dp.Close();
                                    if (ultimanominas.Count > 0)
                                    {
                                        Sueldodiario = ultimanominapagada.FirstOrDefault().SueldoDiario;

                                        double diasremanentes = 0;
                                        short diasefectivoslaborados = 0;
                                        int mesescon31dias = 0;
                                        int diasFebrero = 0;



                                        ///TimeSpan Diff_dates = ultimanominas.FirstOrDefault().FechaTermino.Subtract(ultimanominas.LastOrDefault().FechaInicio);

                                        if (diasDiferencias > 0)
                                            diasremanentes = diasDiferencias;
                                        else
                                            if (existePrimaexenta.Count > 0)
                                        {
                                            TimeSpan Diff_dates1 = ConvenioLaboralTrabajadorCategoria.FechaTermino.Value.Subtract(existePrimaexenta.FirstOrDefault().FechaTermino);
                                            diasremanentes = Diff_dates1.Days;
                                            //diasremanentes = Diff_dates1.Days / 15;
                                        }
                                        else
                                        {
                                            TimeSpan Diff_dates = ConvenioLaboralTrabajadorCategoria.FechaTermino.Value.AddDays(1).Subtract(ultimanominas.LastOrDefault().FechaInicio);
                                            diasremanentes = Diff_dates.Days;
                                            //diasremanentes = Diff_dates.Days / 15;
                                        }

                                        ////if (plazatrabajador.CalcularNominaDiasCalendario == false)
                                        //{
                                        mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(ultimanominas.LastOrDefault().FechaInicio, ConvenioLaboralTrabajadorCategoria.FechaTermino.Value.AddDays(1));
                                        diasFebrero = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(ultimanominas.LastOrDefault().FechaInicio, ConvenioLaboralTrabajadorCategoria.FechaTermino.Value.AddDays(1));
                                        //}

                                        diasremanentes = diasremanentes + mesescon31dias + diasFebrero;

                                        diasremanentes = Math.Truncate(diasremanentes / 15);

                                        //diasefectivoslaborados = (short)diasremanentes;
                                        //diasAPagar = (diasefectivoslaborados * 24);
                                        //diasAPagar = diasAPagar / 365M;
                                        //diasAPagar = Math.Round((decimal)((diasefectivoslaborados * 24) / 365),4);
                                        diasAPagar = (decimal)diasremanentes;
                                    }
                                    else {
                                        //nuevo calculo barrita

                                        
                                            Sueldodiario = sueldos.Sueldo/15;

                                            decimal diasremanentes = 0;
                                            short diasefectivoslaborados = 0;
                                            int mesescon31dias = 0;
                                            int diasFebrero = 0;

                                        List<int> ideexlcuidos = new List<int>();
                                        ideexlcuidos.Add(3313);
                                        ideexlcuidos.Add(3428);
                                        ideexlcuidos.Add(4075);


                                        if (ideexlcuidos.Contains(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador))
                                            {
                                            diasDiferencias = 12;
                                        }

                                            ///TimeSpan Diff_dates = ultimanominas.FirstOrDefault().FechaTermino.Subtract(ultimanominas.LastOrDefault().FechaInicio);

                                            if (diasDiferencias > 0)
                                                diasremanentes = diasDiferencias;
                                            else
                                                if (existePrimaexenta.Count > 0)
                                            {
                                                TimeSpan Diff_dates1 = ConvenioLaboralTrabajadorCategoria.FechaTermino.Value.Subtract(existePrimaexenta.FirstOrDefault().FechaTermino);
                                                diasremanentes = Diff_dates1.Days;
                                                //diasremanentes = Diff_dates1.Days / 15;
                                            }
                                            else
                                            {
                                                TimeSpan Diff_dates = ConvenioLaboralTrabajadorCategoria.FechaTermino.Value.AddDays(1).Subtract(ConvenioLaboralTrabajadorCategoria.FechaInicio);
                                                diasremanentes = Diff_dates.Days;
                                                //diasremanentes = Diff_dates.Days / 15;
                                            }


                                        //mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(ultimanominas.LastOrDefault().FechaInicio, ConvenioLaboralTrabajadorCategoria.FechaTermino.Value.AddDays(1));
                                        //diasFebrero = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(ultimanominas.LastOrDefault().FechaInicio, ConvenioLaboralTrabajadorCategoria.FechaTermino.Value.AddDays(1));


                                        //diasremanentes = diasremanentes + mesescon31dias + diasFebrero;
                                        //decimal factor = (12.0M / 365);
                                        //factor =  ((decimal)diasremanentes* factor) * 0.25M;
                                        //    diasremanentes = Math.Truncate((double)factor);

                                            
                                        //    diasAPagar = (decimal)diasremanentes;

                                        

                                        decimal factor = 12.0m / 365;
                                        Console.WriteLine($"fac   {factor}");
                                        totalfactor = (diasremanentes * factor) * 0.25M;
                                       // factor = Math.Truncate(factor);

                                    }
                                    //}
                                    //else
                                    //    diasAPagar = 0;
                                }
                                else
                                 if (regresadeLicencia != null)
                                    diasAPagar = diasAPagar - NominaTrabajador.DiasdePrimaPorbaja(ConvenioLaboralTrabajadorCategoria);

                                    
                                

                        }

                        var QuincenaMes = Nova.Libraries.ConvertToInt.ConvertToInt16(NominaTrabajador.Nomina.Catalogos_ctQuincenaMes.QuincenaMes);
                        if (QuincenaMes == NominaTrabajador.ParametrosRelacionLaboral.Prima1 || QuincenaMes == NominaTrabajador.ParametrosRelacionLaboral.Prima3 || QuincenaMes == NominaTrabajador.ParametrosRelacionLaboral.Prima2
                            || (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.CalculoPorSolicitud && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES"))
                            )
                        {
                            var apoyoNomina = NominaTrabajador.ListaNominaApoyoEstudios.Where(z => z.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();
                            Decimal PorcentajeApoyo = 0M;
                            if (apoyoNomina != null)
                                PorcentajeApoyo = apoyoNomina.PorcentajeApoyo;


                            decimal importeexcento = 0;
                            var trabajadorconprestacionescongasto = NominaTrabajador.TrabajadoresConPercepcionesCongasto.Where(f => f.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();



                            PercepcionesNominaTrabajador PrimaVacacionalGrava = new PercepcionesNominaTrabajador();

                            VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();

                            var diaslaborados = NominaTrabajador.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "DIASLABORADOS").FirstOrDefault().Importe;

                            
                            decimal SueldoQuinquenioDiario = 0;



                            //if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("BASE"))
                            //{
                            //    Quinquenio quinqueniobase = new Quinquenio();
                            //    SueldoQuinquenioDiario = quinqueniobase.ImporteQuinquenioTrabajador(ConvenioLaboralTrabajadorCategoria, NominaTrabajador);
                            //    SueldoQuinquenioDiario = SueldoQuinquenioDiario / 15;
                            //}



                            if (PorcentajeApoyo > 0)
                            {
                                Sueldodiario = (PorcentajeApoyo * Sueldodiario) / 100;
                                SueldoQuinquenioDiario = (PorcentajeApoyo * SueldoQuinquenioDiario) / 100;
                            }

                                //decimal importegrava = ((Sueldodiario + SueldoQuinquenioDiario) * diasAPagar)*0.25M;
                                if (conderecho)
                                {

                                    decimal factor = 12.0m *0.25M;
                                    Console.WriteLine($"fac   {factor}");
                                    totalfactor = 12.0m * 0.25M;
                                }

                                decimal importegravatempo = (Sueldodiario * totalfactor);

                                decimal importegrava = importegravatempo;

                                if (solicitud != null)
                                {
                                    if (solicitud.CalcularVacaciones)
                                    {
                                    }
                                }
                                        if (solicitud != null)
                                {
                                    if (solicitud.CalcularVacaciones)
                                    {
                                        var IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "VACACIONES").FirstOrDefault().IdPlantillaNominaPercepcion;
                                        var percepcionvacaciones=NominaTrabajador.ListaPercepcionesTrabajadores.Where(a=> a.IdConvenioLaboralTrabajadorCategoria==ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                                        && a.IdPlantillaNominaPercepcion== IdPlantillaNominaPercepcion).FirstOrDefault();

                                        if (percepcionvacaciones != null)
                                        {
                                            importegrava = (percepcionvacaciones.Importe * 0.25M);
                                            
                                            
                                        }

                                        

                                    }
                                }


                            if (QuincenaMes == NominaTrabajador.ParametrosRelacionLaboral.Prima1
                                || (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.CalculoPorSolicitud && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES"))
                                )
                            {
                                    if (existePrimaexenta.Count == 0)
                                    {
                                        PercepcionesNominaTrabajador PrimaVacacionalExenta = new PercepcionesNominaTrabajador();

                                        importeexcento = NominaTrabajador.ctUMA.Monto * 15;

                                        if (importegrava <= importeexcento)
                                            importeexcento = importegrava;


                                        if (diasDiferencias > 0)
                                        //hay qeu hacer un ajuste por los dias que se le pago de mas
                                        // 1 dias por cada quincena 

                                        {
                                            DeduccionesNominaTrabajador deduccioncuotafija = new DeduccionesNominaTrabajador();
                                            deduccioncuotafija.EsImprimibleRecibo = true;
                                            deduccioncuotafija.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                            deduccioncuotafija.IdNomina = NominaTrabajador.Nomina_stNomina.IdNomina;
                                            deduccioncuotafija.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(z => z.Deducciones_ctDeduccion.Deduccion == "DESCUENTO POR PAGO INDEBIDO").SingleOrDefault().IdPlantillaNominaDeduccion;
                                            deduccioncuotafija.Importe = importeexcento;
                                            deduccioncuotafija.Concepto = "PRIMA VACACIONAL EXENTA";

                                            NominaTrabajador.ListaDeduccionesTrabajadores.Add(deduccioncuotafija);

                                        }
                                        else
                                        {

                                            PrimaVacacionalExenta.Importe = importeexcento;

                                            PrimaVacacionalExenta.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                            PrimaVacacionalExenta.IdNomina = NominaTrabajador.IdNomina;
                                            PrimaVacacionalExenta.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA VACACIONAL EXENTA").FirstOrDefault().IdPlantillaNominaPercepcion;
                                            PrimaVacacionalExenta.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA VACACIONAL EXENTA").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                                            PrimaVacacionalExenta.EsImprimibleRecibo = true;
                                            PrimaVacacionalExenta.Tipo = "NORMAL";
                                            PrimaVacacionalExenta.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA VACACIONAL EXENTA").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                                            NominaTrabajador.ListaPercepcionesTrabajadores.Add(PrimaVacacionalExenta);
                                        }
                                    }
                            }
                            else
                                 if (PorcentajeApoyo > 0)
                                importegrava = (PorcentajeApoyo * importegrava) / 100;


                            PrimaVacacionalGrava.Importe = importegrava - importeexcento;

                            PrimaVacacionalGrava.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            PrimaVacacionalGrava.IdNomina = NominaTrabajador.IdNomina;
                            PrimaVacacionalGrava.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA VACACIONAL GRAVADA").FirstOrDefault().IdPlantillaNominaPercepcion;
                            PrimaVacacionalGrava.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA VACACIONAL GRAVADA").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                            PrimaVacacionalGrava.EsImprimibleRecibo = true;
                            PrimaVacacionalGrava.Tipo = "NORMAL";
                            PrimaVacacionalGrava.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA VACACIONAL GRAVADA").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;

                                if (diasDiferencias > 0)
                                //hay qeu hacer un ajuste por los dias que se le pago de mas
                                // 1 dias por cada quincena 

                                {
                                    DeduccionesNominaTrabajador deduccioncuotafija = new DeduccionesNominaTrabajador();
                                    deduccioncuotafija.EsImprimibleRecibo = true;
                                    deduccioncuotafija.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                    deduccioncuotafija.IdNomina = NominaTrabajador.Nomina_stNomina.IdNomina;
                                    deduccioncuotafija.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(z => z.Deducciones_ctDeduccion.Deduccion == "DESCUENTO POR PAGO INDEBIDO").SingleOrDefault().IdPlantillaNominaDeduccion;
                                    deduccioncuotafija.Importe = PrimaVacacionalGrava.Importe;
                                    deduccioncuotafija.Concepto = "PRIMA VACACIONAL GRAVADA";

                                    NominaTrabajador.ListaDeduccionesTrabajadores.Add(deduccioncuotafija);

                                }
                                else
                                {

                                    if (PrimaVacacionalGrava.Importe > 0)
                                        NominaTrabajador.ListaPercepcionesTrabajadores.Add(PrimaVacacionalGrava);
                                }

                            // aplica para los de base que se les dio el derecho de gasto adminitrativo
                            if (trabajadorconprestacionescongasto != null)
                            {
                                var IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GASTO ADMINISTRATIVO").FirstOrDefault().IdPlantillaNominaPercepcion;

                                var datosgastoadministrativo = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion && v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                                var diariogastoadministrativo = (datosgastoadministrativo.Importe / 15) * diasAPagar;

                                PercepcionesNominaTrabajador PrimaGastoAdministativo = new PercepcionesNominaTrabajador();

                                PrimaGastoAdministativo.Importe = diariogastoadministrativo;
                                PrimaGastoAdministativo.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                PrimaGastoAdministativo.IdNomina = NominaTrabajador.IdNomina;
                                PrimaGastoAdministativo.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA VACACIONAL GASTO ADMINISTRATIVO").FirstOrDefault().IdPlantillaNominaPercepcion;
                                PrimaGastoAdministativo.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA VACACIONAL GASTO ADMINISTRATIVO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                                PrimaGastoAdministativo.EsImprimibleRecibo = true;
                                PrimaGastoAdministativo.Tipo = "NORMAL";
                                PrimaGastoAdministativo.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA VACACIONAL GASTO ADMINISTRATIVO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;

                                    if (PrimaGastoAdministativo.Importe > 0)
                                        NominaTrabajador.ListaPercepcionesTrabajadores.Add(PrimaGastoAdministativo);


                            }


                        }
                    }
                }
                }
            }
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }

        void IPercepcionBehavior.Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }

    }
}