﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;

namespace Nova.Models.Calculos.Percepciones
{

    public class PremioAntiguedadDocente : IPercepcionBehavior
    {

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {
            if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado == false)
            {
                if (ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.EsCuotaSindical == true)
                    if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PREMIO DE ANTIGUEDAD").FirstOrDefault() != null)
                {

                    //SingletonAntiguedad antiguedad = SingletonAntiguedad.Instance;

                    var premioantiguedad = NominaTrabajador.TrabajadorAntiguedad.getAntiguedadPorTrabajador(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador);

                    
                    //var antiguedadtrabajador = antiguedad.getAntiguedad(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador);

                    if (premioantiguedad != null)
                    {
                        bool conderecho = false;



                        //                        conderecho = ((premioantiguedad.Years == 10 && premioantiguedad.Months == 0 && premioantiguedad.Days >= 15))
                        //|| ((premioantiguedad.Years == 15 && premioantiguedad.Months == 0 && premioantiguedad.Days >= 15)) 
                        //|| ((premioantiguedad.Years == 20 && premioantiguedad.Months == 0 && premioantiguedad.Days >= 15)) 
                        //|| ((premioantiguedad.Years == 25 && premioantiguedad.Months == 0 && premioantiguedad.Days >= 15))
                        //|| ((premioantiguedad.Years == 30 && premioantiguedad.Months == 0 && premioantiguedad.Days >= 15));

                        conderecho = ((premioantiguedad.Years == 10  ))
                    || ((premioantiguedad.Years == 15  ))
                    || ((premioantiguedad.Years == 20   ))
                    || ((premioantiguedad.Years == 25   ))
                    || ((premioantiguedad.Years == 30   ));

                        var pagar = NominaTrabajador.DeberiaRecibirPagoEnEstaNomina(premioantiguedad.FechaIngreso, NominaTrabajador.Nomina_stNomina.FechaInicio, NominaTrabajador.Nomina_stNomina.FechaTermino);

                        if (conderecho && pagar)
                        {
                            var info = NominaTrabajador.ListaPremioAntiguedadPagados.Where(e => e.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                            if (info == null)
                            {


                                PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

                                percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                percepcion.IdNomina = NominaTrabajador.IdNomina;
                                percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PREMIO DE ANTIGUEDAD").FirstOrDefault().IdPlantillaNominaPercepcion;
                                percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PREMIO DE ANTIGUEDAD").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                                decimal importe = 0;
                                switch (premioantiguedad.Years)
                                {
                                    case 10:
                                        importe = (decimal)NominaTrabajador.ParametrosRelacionLaboral.Premio10;
                                        break;
                                    case 15:
                                        importe = (decimal)NominaTrabajador.ParametrosRelacionLaboral.Premio15; ;
                                        break;
                                    case 20:
                                        importe = (decimal)NominaTrabajador.ParametrosRelacionLaboral.Premio20; ;
                                        break;

                                    case 25:
                                        importe = (decimal)NominaTrabajador.ParametrosRelacionLaboral.Premio25;
                                        break;
                                    case 30:
                                        importe = (decimal)NominaTrabajador.ParametrosRelacionLaboral.Premio30;
                                        break;


                                }

                                percepcion.Importe = importe;

                                percepcion.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PREMIO DE ANTIGUEDAD").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                                NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);
                            }
                        }
                    }
                }
            }
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }

        void IPercepcionBehavior.Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }
    }

}