﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;

namespace Nova.Models.Calculos.Percepciones
{

    public class OnomasticoDocente : IPercepcionBehavior
    {

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {
            if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "ONOMÁSTICO").FirstOrDefault() != null)
            {
                if (ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.EsCuotaSindical == true)
                {
                    var datospersonales = NominaTrabajador.TrabajadoresVigentesKardex_ctDatosPersonales.Where(a => a.IdKardex == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex).FirstOrDefault();
                    if (NominaTrabajador.EsPagoOnomastico(datospersonales.FechaNacimiento, NominaTrabajador.Nomina.FechaInicio, NominaTrabajador.Nomina.FechaTermino))
                    {
                        PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

                        percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        percepcion.IdNomina = NominaTrabajador.IdNomina;
                        percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "ONOMÁSTICO").FirstOrDefault().IdPlantillaNominaPercepcion;
                        percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "ONOMÁSTICO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                        //Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();

                        if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado)
                        {

                            //var idsueldo = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO JORNADA").FirstOrDefault();
                            //var percepcionsueldo = NominaTrabajador.ListaPercepcionesTrabajadores.Where(z => z.IdPlantillaNominaPercepcion == idsueldo.IdPlantillaNominaPercepcion && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                            //var idsueldoExcedentes = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO HORAS EXCEDENTE").FirstOrDefault();
                            //var percepcionsueldoExcedentes = NominaTrabajador.ListaPercepcionesTrabajadores.Where(z => z.IdPlantillaNominaPercepcion == idsueldoExcedentes.IdPlantillaNominaPercepcion && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                            //cambio ODES
                            var idsueldo = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO JORNADA").FirstOrDefault();
                            var percepcionsueldo = NominaTrabajador.ListaPercepcionesTrabajadoresODES.Where(z => z.Tipo=="ODES" &&  z.IdPercepcion == idsueldo.IdPercepcion && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                            var idsueldoExcedentes = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO HORAS EXCEDENTE").FirstOrDefault();
                            var percepcionsueldoExcedentes = NominaTrabajador.ListaPercepcionesTrabajadoresODES.Where(z => z.Tipo == "ODES" && z.IdPercepcion == idsueldoExcedentes.IdPercepcion && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                            if (percepcionsueldo != null)
                            {
                                percepcion.Importe = percepcionsueldo.Importe;
                                if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("HORAS EXTRAORDINARIAS"))
                                {
                                    percepcion.Importe = percepcion.Importe ;
                                }
                                else
                                {
                                    if (percepcionsueldoExcedentes != null)
                                    {
                                        percepcion.Importe = percepcion.Importe + percepcionsueldoExcedentes.Importe;
                                    }
                                }
                            }
                        }
                        else
                        {
                            //var idsueldo = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO DOCENTE").FirstOrDefault();
                            //var percepcionsueldo = NominaTrabajador.ListaPercepcionesTrabajadores.Where(z => z.IdPlantillaNominaPercepcion == idsueldo.IdPlantillaNominaPercepcion && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                            var idsueldo = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO DOCENTE").FirstOrDefault();
                            var percepcionsueldo = NominaTrabajador.ListaPercepcionesTrabajadoresODES.Where(z => z.Tipo == "ODES" && z.IdPercepcion == idsueldo.IdPercepcion && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                            if (percepcionsueldo != null)
                            {
                                percepcion.Importe = percepcionsueldo.Importe;
                            }

                        }

                        percepcion.Importe = Decimal.Round(percepcion.Importe / 15, 2);




                        percepcion.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "ONOMÁSTICO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                        NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);
                    }
                }
            }
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }

        void IPercepcionBehavior.Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }
    }

}