﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Models.Calculos.Percepciones
{
    
    public class GuarderiaBaseDocente : IPercepcionBehavior
    {
   
    public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
    {
            if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GUARDERIA").FirstOrDefault() != null)
            {
                var guarderiaconcedida = NominaTrabajador.PercepcionesConcedidas.Where(z => z.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador && z.Percepciones_ctPercepcion.Percepcion == "GUARDERIA").FirstOrDefault();
                if (guarderiaconcedida != null)
                {

                    PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

                    if (NominaTrabajador.ParametrosRelacionLaboral.EsAplicaGuarderia )
                    {
                        var hijos = HijosGuarderia(ConvenioLaboralTrabajadorCategoria, NominaTrabajador);
                        if (hijos > 0)
                        {
                            percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            percepcion.IdNomina = NominaTrabajador.IdNomina;
                            percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GUARDERIA").FirstOrDefault().IdPlantillaNominaPercepcion;
                            percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GUARDERIA").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                            short HorasSemanaMes = (short)NominaTrabajador.ListaVariablesNominaTrabajador.Where(q => q.Concepto == "HorasSemanaMes" && q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Select(e => e.Importe).FirstOrDefault();
                            short HorasExcedentes = (short)NominaTrabajador.ListaVariablesNominaTrabajador.Where(q => q.Concepto == "HorasExcedentes" && q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Select(e => e.Importe).FirstOrDefault();
                            HorasSemanaMes = (short)(HorasSemanaMes + HorasExcedentes);

                            foreach (var item in NominaTrabajador.ListaVariablesNominaTrabajador.Where(q => q.Concepto == "GUARDERIAHIJOS" && q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).ToList())
                            {
                                if (item.Importe == NominaTrabajador.DiasNomina)
                                {
                                    var importe100 = ((decimal)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GUARDERIA").FirstOrDefault().Porcentaje * HorasSemanaMes);
                                    importe100 = ((importe100 * NominaTrabajador.DiasPagados) / NominaTrabajador.DiasNomina);
                                    percepcion.Importe = percepcion.Importe + importe100;
                                    //percepcion.Importe = percepcion.Importe +
                                    //((decimal)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GUARDERIA").FirstOrDefault().Porcentaje * HorasSemanaMes);
                                }
                                else
                                {
                                    var importe100 = (((decimal)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GUARDERIA").FirstOrDefault().Porcentaje * HorasSemanaMes) / NominaTrabajador.DiasNomina) * item.Importe;
                                    importe100 = ((importe100 * NominaTrabajador.DiasPagados) / NominaTrabajador.DiasNomina);
                                    percepcion.Importe = percepcion.Importe + importe100;
                                    //percepcion.Importe = percepcion.Importe +
                                    //(((decimal)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GUARDERIA").FirstOrDefault().Porcentaje * HorasSemanaMes) / NominaTrabajador.DiasNomina) * item.Importe;
                                }

                            }




                            //  percepcion.Importe = (NominaTrabajador.DiasPagados * percepcion.Importe) / NominaTrabajador.DiasNomina;

                            percepcion.Tipo = "NORMAL";
                            percepcion.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GUARDERIA").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                            percepcion.TratamientoEspecialIncapacidadesSueldoIsr = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GUARDERIA").FirstOrDefault().Percepciones_ctPercepcion.TratamientoEspecialIncapacidadesSueldoIsr;
                            NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);
                        }
                    }
                }
            }
    }

    private int HijosGuarderia(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
    {


            //var listahijosmenores = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Kardex_stDatosFamiliares
            //    .Where(x => x.EsAutorizado==true && x.Kardex_ctParentesco.Parentesco == "HIJA" || x.Kardex_ctParentesco.Parentesco == "HIJO").ToList();
            var idk = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            var listahijosmenores = NominaTrabajador.TrabajadoresVigentesKardex_stDatosFamiliares.Where(x=> x.IdKardex== idk
                && x.EsAutorizado == true && (x.Kardex_ctParentesco.Parentesco == "HIJA" || x.Kardex_ctParentesco.Parentesco == "HIJO")).ToList();
            int hijosmenores = 0;
        foreach (var item in listahijosmenores)
        {
                var dias = 15;
                VariablesNominaTrabajador vnt3 = new VariablesNominaTrabajador();
                vnt3.Concepto = "GUARDERIAHIJOS";
                vnt3.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                vnt3.Importe = NominaTrabajador.DiasNomina;

                

                if (hijosmenores<=2)
                { var edad = DateTimeSpan.CompareDates(item.FechaNacimiento, NominaTrabajador.Nomina_stNomina.FechaTermino);

                  var edadInicioQna = DateTimeSpan.CompareDates(item.FechaNacimiento, NominaTrabajador.Nomina_stNomina.FechaInicio);

                    if (edadInicioQna.Years < 6 && edad.Years == 6)
                    //quiere decir que se le paga
                    {
                        var fechanacimientoañoactual = new DateTime(NominaTrabajador.Nomina_stNomina.FechaInicio.Year, item.FechaNacimiento.Month, item.FechaNacimiento.Day);
                        var resta = (TimeSpan)((DateTime)fechanacimientoañoactual.AddDays(1) - NominaTrabajador.Nomina_stNomina.FechaInicio);

                        vnt3.Importe = (decimal)resta.TotalDays;
                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt3);
                        hijosmenores++;
                    }
                    else
                        if (edad.Years < 6)
                                {
                                    hijosmenores++;
                                     NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt3);
                    }

                }
        }
        return hijosmenores;
    }





    void IPercepcionBehavior.Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
    {
        throw new NotImplementedException();
    }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }
    }
}