﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;
using Nova.Libraries;
using Dapper;
using System.Numerics;

namespace Nova.Models.Calculos.Percepciones
{
    

    public class DiasEconomicos : IPercepcionBehavior
    {
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {
            if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DÍAS ECONOMICOS NO DISFRUTADOS").FirstOrDefault() != null)
            {
                var percepcionCalculo = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.EsVigente &&
                x.Percepciones_ctPercepcion.Percepcion == "DÍAS ECONOMICOS NO DISFRUTADOS").FirstOrDefault();
                
                if (percepcionCalculo.Calcular)

                {
                    var solicitud = NominaTrabajador.Nomina_PartesProporcionales.Where(a => a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();
                    var ultimocontrato = NominaTrabajador.PartesProporcionalesUltimoContrato.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                     && s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                   
                        bool calcularpercepcion = false;

                    decimal diasAPagar = 12;
                    decimal diasAPagarPorGasto = 12;

                    if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == "BASE")
                        calcularpercepcion = true;
                    else
                        if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == "CONFIANZA")
                    {  // solo oficinas centrales
                        var plaza = NominaTrabajador.Plazas_stDistribucionPlazaCategoria.Where(q => q.IdDistribucionPlazaCategoria == ConvenioLaboralTrabajadorCategoria.IdDistribucionPlazaCategoria).FirstOrDefault();
                        // solo oficinas centrales
                        var convenioltc = NominaTrabajador.ConveniosTrabajadoresTodos.Where(a => a.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                        if (convenioltc.Catalogos_ctEstructuraOrganica.IdModalidadEstudio == 0)
                            if (plaza.Plazas_ctCategoria.Categoria == "COORDINADOR DE TÉCNICOS ESPECIALIZADOS"
                            || plaza.Plazas_ctCategoria.Categoria == "SUPERVISOR"
                            || plaza.Plazas_ctCategoria.Categoria == "SECRETARIA DE DIRECTOR DE ÁREA"
                            || plaza.Plazas_ctCategoria.Categoria == "INGENIERO EN SISTEMAS"
                            )
                                calcularpercepcion = true;
                    }

                    decimal SueldoQuinquenioDiario = 0;
                    Decimal Sueldodiario = 0;

                    var diasdifrutadostrabajador = NominaTrabajador.diasdifrutados.Where(a => a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).ToList();


                    if (calcularpercepcion && solicitud != null && ultimocontrato != null && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES"))
                    {
                        DateTime fechatermino = DateTime.Now;
                        DapperQuery dp = new DapperQuery("bdNovaEntities");

                        if (ConvenioLaboralTrabajadorCategoria.FechaTermino ==null)
                        {
                            //BUSCAR SU INCIDENCIA
                            string consulta = $@"  select * from vwLicenciasTrabajadores
                                            where idtrabajador={ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador }
                                            and Incidencia like '%SIN GOCE DE SUELDO%'
                                            AND YEAR(FechaInicioIncidencia)={solicitud.Año} order by FechaTerminoIncidencia ";
                            List<vwLicenciasTrabajadores> licencias = (List<vwLicenciasTrabajadores>)dp.connection.Query<vwLicenciasTrabajadores>(consulta).ToList();
                            if (licencias.Count() > 0)
                                fechatermino = licencias[0].FechaInicioIncidencia;
                        }
                        else
                            fechatermino = ConvenioLaboralTrabajadorCategoria.FechaTermino.Value;




                        //                            string diasecon = $@"SELECT a.*
                        //FROM IncidenciaPermiso_stIncidenciaTrabajador a
                        //inner join Catalogos_ctTipoIncidencia c on a.IdTipoIncidencia=c.IdTipoIncidencia
                        //inner join Convenios_stConvenioLaboralTrabajadorCategoria s on s.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                        //inner join Convenios_stConvenioLaboralTrabajador t on t.IdConvenioLaboralTrabajador=s.IdConvenioLaboralTrabajador
                        //inner join Plazas_stDistribucionPlazaCategoria p on p.IdDistribucionPlazaCategoria=s.IdDistribucionPlazaCategoria
                        //inner join Plazas_ctCategoria r on r.IdCategoria=p.IdCategoria
                        //inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral=r.IdRelacionConvenioLaboral
                        //  inner join  Catalogos_ctTipoIncidenciaPermiso d on c.IdTipoIncidenciaPermiso=d.IdTipoIncidenciaPermiso
                        //left join Incidencia_ctJustificacion j on j.IdIncidenciaJustificacion=a.IdIncidenciaJustificacion
                        //                    WHERE   year(a.FechaInicio)={solicitud.Año} and t.Idtrabajador={solicitud.IdTrabajador}
                        //and  c.Incidencia='DÍAS ECONÓMICOS' 
                        //and (h.RelacionConvenioLaboral like '%BASE%' or h.RelacionConvenioLaboral like '%CONFIANZA%')
                        //                     and EsCerrada=1 and ((Autorizo=1 and a.IdIncidenciaJustificacion=0) or Autorizo=0 OR EsCancelada=1 )";
                        //                        List<IncidenciaPermiso_stIncidenciaTrabajador> diasdifrutados = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(diasecon).ToList();

     
                      string  sqlnomina = @"select a.* from Nomina_stNominaTrabajador a
inner join Nomina_stNomina b on a.idnomina=b.idnomina
inner join [Nomina_ctPlantillaNomina] c on b.idplantillanomina=c.idplantillanomina
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria f on f.IdDistribucionPlazaCategoria=d.IdDistribucionPlazaCategoria
  inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
where EstatusNominaGrupo ='PARA PAGO' and b.EsCerrada=1 and year(b.fechainicio)=" + solicitud.Año + " and  c.Plantilla like '%sueldo%' and w.IdTrabajador=" + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador + " order by b.fechatermino desc";

                        List<Nomina_stNominaTrabajador> ultimanominapagada = (List<Nomina_stNominaTrabajador>)dp.connection.Query<Nomina_stNominaTrabajador>(sqlnomina).ToList();



                        dp.Close();
                       diasAPagar = DiasEconomicosSegunFecha(fechatermino);
                        diasAPagarPorGasto = diasAPagar;
                        if (diasdifrutadostrabajador.Count > 0)
                        {
                            diasAPagar = diasAPagar - diasdifrutadostrabajador.Count;
                            diasAPagarPorGasto = diasAPagarPorGasto - diasdifrutadostrabajador.Count;
                        }

                        NominaTrabajador.setSalariosDiariosDocentesPartesProporcionales(solicitud.Año, solicitud.IdTrabajador);
                        if (NominaTrabajador.SalariosDiarioDocentesParaPartesProporcionales.Count > 0)
                        {
                            if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado)
                                Sueldodiario = NominaTrabajador.SalariosDiarioDocentesParaPartesProporcionales.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault().Importe;
                            else
                                Sueldodiario = NominaTrabajador.SalariosDiarioDocentesParaPartesProporcionales.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault().ImporteSinMatQuin;
                        }
                        
                    }
                    
                    if (calcularpercepcion && (NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "24")
                        || (calcularpercepcion && solicitud != null && ultimocontrato != null)
                        )
                    {
                        //SingletonAntiguedad antiguedad = SingletonAntiguedad.Instance;

                        //AntiguedadLaboralQuinquenioTrabajador antiguedadtrabajador = antiguedad.getAntiguedad(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador);
                      
                       // var tiempo = DateTimeSpan.CompareDates(antiguedadtrabajador.FechaInicioQuinquenio, NominaTrabajador.Nomina.FechaTermino.AddDays(1));
                        var tiempo = NominaTrabajador.TrabajadorAntiguedad.getAntiguedadPorTrabajador(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador);


                        if (tiempo.Years > 0 || (tiempo.Years == 0 && tiempo.Months >= 6))
                        {

                            var perdioPuntualidad = NominaTrabajador.TrabajadoresPuntualidadYAsistenciaPerdidas.Where(a => a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();

                            

                            if (diasAPagar > 0)
                            {


                                var apoyoNomina = NominaTrabajador.ListaNominaApoyoEstudios.Where(z => z.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();
                                Decimal PorcentajeApoyo = 0M;
                                if (apoyoNomina != null)
                                    PorcentajeApoyo = apoyoNomina.PorcentajeApoyo;

                                PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();
                                bdNovaEntities qq = new bdNovaEntities();
                                Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();



                                //busca si termino una licencia
                                //var regresadeLicencia = NominaTrabajador.LicenciasTrabajadoresPrimavacacional.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();

                                //int diasAPagar = 8;
                                //if (regresadeLicencia != null)
                                //    if (regresadeLicencia.FechaTerminoIncidencia != null)
                                //    {
                                //        diasAPagar = diasAPagar - NominaTrabajador.DiasdePrima(ConvenioLaboralTrabajadorCategoria, regresadeLicencia);

                                //    }

                                var regresadeLicencia = NominaTrabajador.LicenciasTrabajadoresPrimavacacional.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();

                            
                                if (regresadeLicencia != null)
                                    if (regresadeLicencia.FechaTerminoIncidencia != null)
                                        if (regresadeLicencia.FechaTerminoIncidencia <= NominaTrabajador.Nomina_stNomina.FechaTermino)
                                        {
                                            // diasAPagar = diasAPagar -NominaTrabajador.DiasdePrima(ConvenioLaboralTrabajadorCategoria, regresadeLicencia);
                                            diasAPagar = diasAPagar - NominaTrabajador.DiasEconomicosADescontarPorLicencias((DateTime)regresadeLicencia.FechaTerminoIncidencia.Value.AddDays(1), regresadeLicencia.FechaInicioIncidencia);

                                        }
                                        else

                                            diasAPagar = diasAPagar - NominaTrabajador.DiasdePrimaPorbaja(ConvenioLaboralTrabajadorCategoria);

                                if (diasdifrutadostrabajador.Count > 0)
                                {
                                    diasAPagar = diasAPagar - diasdifrutadostrabajador.Count();
                                }

                                    var QuincenaMes = Nova.Libraries.ConvertToInt.ConvertToInt16(NominaTrabajador.Nomina.Catalogos_ctQuincenaMes.QuincenaMes);


                                var trabajadorconprestacionescongasto = NominaTrabajador.TrabajadoresConPercepcionesCongasto.Where(f => f.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();



                                PercepcionesNominaTrabajador estimulo = new PercepcionesNominaTrabajador();

                                VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();
                                
                                if ((calcularpercepcion && solicitud != null && ultimocontrato != null)==false)
                                
                                {
                                    Sueldodiario = NominaTrabajador.Truncate(costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMinimo * costos.CostoPorHora, 2);
                                  

                                    // var QuinquenioDiario = NominaTrabajador.SueldosParaPrimaVacaional.Where(s => s.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador

                                    Quinquenio quinqueniobase = new Quinquenio();

                                    SueldoQuinquenioDiario = quinqueniobase.ImporteQuinquenioTrabajador(ConvenioLaboralTrabajadorCategoria, NominaTrabajador);
                                    SueldoQuinquenioDiario = SueldoQuinquenioDiario / 15;

                                }

                                if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("DOCENTE"))
                                {
                                    if (NominaTrabajador.SalariosDiarioDocentesParaPrima.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault() != null)
                                    {
                                        if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado)
                                            Sueldodiario = NominaTrabajador.SalariosDiarioDocentesParaPrima.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault().Importe;
                                        else
                                            Sueldodiario = NominaTrabajador.SalariosDiarioDocentesParaPrima.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault().ImporteSinMatQuin;
                                    }
                                }

                                if (PorcentajeApoyo > 0)
                                {
                                    Sueldodiario = (PorcentajeApoyo * Sueldodiario) / 100;
                                    SueldoQuinquenioDiario = (PorcentajeApoyo * SueldoQuinquenioDiario) / 100;
                                }

                                 decimal importetotal = ((Sueldodiario + SueldoQuinquenioDiario) * diasAPagar);

                                //solo sueldo
                                //decimal importetotal = ((Sueldodiario) * diasAPagar);
                                //if (QuincenaMes == NominaTrabajador.ParametrosRelacionLaboral.Prima1)
                                //{
                                //    PercepcionesNominaTrabajador PrimaVacacionalExenta = new PercepcionesNominaTrabajador();

                                //    importeexcento = NominaTrabajador.ctUMA.Monto * 15;

                                //    if (importetotal < importeexcento)
                                //        importeexcento = importetotal;



                                //    PrimaVacacionalExenta.Importe = importeexcento;

                                //    PrimaVacacionalExenta.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                //    PrimaVacacionalExenta.IdNomina = NominaTrabajador.IdNomina;
                                //    PrimaVacacionalExenta.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DÍAS ECONOMICOS NO DISFRUTADOS").FirstOrDefault().IdPlantillaNominaPercepcion;
                                //    PrimaVacacionalExenta.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DÍAS ECONOMICOS NO DISFRUTADOS").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                                //    PrimaVacacionalExenta.EsImprimibleRecibo = true;
                                //    PrimaVacacionalExenta.Tipo = "NORMAL";
                                //    PrimaVacacionalExenta.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DÍAS ECONOMICOS NO DISFRUTADOS").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                                //    NominaTrabajador.ListaPercepcionesTrabajadores.Add(PrimaVacacionalExenta);

                                //}
                                //else

                                if (PorcentajeApoyo > 0)
                                    importetotal = (PorcentajeApoyo * importetotal) / 100;




                                estimulo.Importe = importetotal;

                                if (importetotal > 0)
                                {
                                    estimulo.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                    estimulo.IdNomina = NominaTrabajador.IdNomina;
                                    estimulo.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DÍAS ECONOMICOS NO DISFRUTADOS").FirstOrDefault().IdPlantillaNominaPercepcion;
                                    estimulo.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DÍAS ECONOMICOS NO DISFRUTADOS").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                                    estimulo.EsImprimibleRecibo = true;
                                    estimulo.Tipo = "NORMAL";
                                    estimulo.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DÍAS ECONOMICOS NO DISFRUTADOS").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                                    NominaTrabajador.ListaPercepcionesTrabajadores.Add(estimulo);
                                }

                                //// aplica para los de base que se les dio el derecho de gasto adminitrativo
                                //if (trabajadorconprestacionescongasto != null)
                                //{


                                //    var GASTO = NominaTrabajador.PercepcionPersonalizada.Where(c => c.Percepciones_ctPercepcion.Percepcion == "GASTO ADMINISTRATIVO").FirstOrDefault();

                                //    if (PorcentajeApoyo > 0)
                                //        GASTO.Importe = (PorcentajeApoyo * GASTO.Importe) / 100;

                                //    var diariogastoadministrativo = (GASTO.Importe / 15) * diasAPagarPorGasto;

                                //    PercepcionesNominaTrabajador PrimaGastoAdministativo = new PercepcionesNominaTrabajador();

                                //    PrimaGastoAdministativo.Importe = diariogastoadministrativo;
                                //    PrimaGastoAdministativo.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                //    PrimaGastoAdministativo.IdNomina = NominaTrabajador.IdNomina;
                                //    PrimaGastoAdministativo.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "ESTÍMULO POR PUNTUALIDAD Y ASISTENCIA GASTO ADMINISTRATIVO").FirstOrDefault().IdPlantillaNominaPercepcion;
                                //    PrimaGastoAdministativo.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "ESTÍMULO POR PUNTUALIDAD Y ASISTENCIA GASTO ADMINISTRATIVO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                                //    PrimaGastoAdministativo.EsImprimibleRecibo = true;
                                //    PrimaGastoAdministativo.Tipo = "NORMAL";
                                //    PrimaGastoAdministativo.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "ESTÍMULO POR PUNTUALIDAD Y ASISTENCIA GASTO ADMINISTRATIVO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                                //    NominaTrabajador.ListaPercepcionesTrabajadores.Add(PrimaGastoAdministativo);


                                //}



                            }
                        }
                    }
                }
            }
        }

        private int DiasEconomicosSegunFecha(DateTime inicioincidencia)
        {
            int dias = 0;
            int mesfinal = inicioincidencia.Month;
            int days = System.DateTime.DaysInMonth(inicioincidencia.Year, mesfinal);
            if (inicioincidencia.Day < days)
                mesfinal = mesfinal - 1;

         

            return mesfinal;
        }
        void IPercepcionBehavior.Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }
    }
}