﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;

namespace Nova.Models.Calculos.Percepciones
{
    public class DiasDescansoBase : IPercepcionBehavior
    {
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {
            if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIA DE DESCANSO").FirstOrDefault() != null)
            {
                var tienedias = NominaTrabajador.TrabajadoresConDiasDescanso.Where(a => a.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).ToList();

                if (tienedias.Count > 0)
                {
                    Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
                    if (costos == null) throw new ApplicationException("No existe costo-hora-jornada para la categoría: " + ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria.ToString());

                    PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

                    percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    percepcion.IdNomina = NominaTrabajador.IdNomina;
                    percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIA DE DESCANSO").FirstOrDefault().IdPlantillaNominaPercepcion;
                    percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIA DE DESCANSO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                    percepcion.Importe = (costos.CostoPorHora * costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo) * 2* tienedias.Count;




                    percepcion.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIA DE DESCANSO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                    NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);
                }
            }
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }

        void IPercepcionBehavior.Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }
    }
}