﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Models.Calculos.Percepciones
{
     

    public class DiasDeDescansoObligatorioDocente : IPercepcionBehavior
    {
        public int ObtenerDiasDescansoObligatorio(int año, DateTime? fechaInicioLicencia = null, DateTime? fechaFinLicencia = null)
        {
            int diasDescanso = 0;

            // Días obligatorios independientes del día de la semana
            var diasObligatorios = new List<DateTime>
        {
            new DateTime(año, 1, 1),   // Año Nuevo
            new DateTime(año, 12, 25)  // Navidad
        };

            // Lista de fechas festivas que deben caer en fin de semana
            var fechasFestivas = new List<DateTime>
        {
            new DateTime(año, 3, 8),   // Día Internacional de la Mujer
            new DateTime(año, 5, 1),   // Día del Trabajo
            new DateTime(año, 5, 5),   // 5 de Mayo
            new DateTime(año, 5, 10),  // Día de las Madres
            new DateTime(año, 5, 15),  // Día del Maestro
            new DateTime(año, 7, 4),   // Aniversario STSCECyTEO
            new DateTime(año, 9, 16),  // Día de la Independencia
            new DateTime(año, 11, 1),  // Día de Muertos
            new DateTime(año, 11, 2),  // Día de Muertos
            new DateTime(año, 11, 19)  // Día Internacional del Hombre
        };

            // Verificar los días obligatorios (1 enero y 25 diciembre)
            foreach (var fecha in diasObligatorios)
            {
                bool estaEnPeriodoLicencia = false;
                if (fechaInicioLicencia.HasValue && fechaFinLicencia.HasValue)
                {
                    estaEnPeriodoLicencia = fecha >= fechaInicioLicencia.Value &&
                                          fecha <= fechaFinLicencia.Value;
                }

                // Si no está en período de licencia, lo contamos
                if (!estaEnPeriodoLicencia)
                {
                    diasDescanso++;
                }
            }

            // Verificar las fechas festivas que deben caer en fin de semana
            bool encontradoFinDeSemana = false;
            foreach (var fecha in fechasFestivas)
            {
                // Primero verificamos si es sábado o domingo
                bool esFinDeSemana = fecha.DayOfWeek == DayOfWeek.Saturday ||
                                    fecha.DayOfWeek == DayOfWeek.Sunday;

                if (!esFinDeSemana)
                    continue;

                // Si hay licencia, verificamos que la fecha no esté dentro del período de licencia
                bool estaEnPeriodoLicencia = false;
                if (fechaInicioLicencia.HasValue && fechaFinLicencia.HasValue)
                {
                    estaEnPeriodoLicencia = fecha >= fechaInicioLicencia.Value &&
                                          fecha <= fechaFinLicencia.Value;
                }

                // Si la fecha es fin de semana Y no está en período de licencia Y aún no hemos encontrado uno
                if (esFinDeSemana && !estaEnPeriodoLicencia && !encontradoFinDeSemana)
                {
                    encontradoFinDeSemana = true;
                    diasDescanso++;
                    break;
                }
            }

            return diasDescanso;
        }


        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {

            int diasAjuste = 0;
            bool calcular = false;
            int añocalculo = 0;
            var ajuste = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DÍA DE DESCANSO OBLIGATORIO").FirstOrDefault();

            if (NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "24")
            {
                bool calcularpercepcion = false;




                if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == "BASE")
                {
                    
                        if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("SPD"))
                        {
                        var tiempo = NominaTrabajador.QuinquenioTrabajadorAntiguedad.SumarUnDia(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador);

                        // if (tiempo.Years>0 || (tiempo.Years == 0  && tiempo.Months > 5 && tiempo.Days > 0))
                        if (tiempo.Years > 0 || (tiempo.Years == 0 && tiempo.Months >= 6))
                        {
                            calcularpercepcion = true;
                        }
                    }
                    else
                        calcularpercepcion = true;
                }
                else
                if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == "CONFIANZA")
                {  // solo oficinas centrales
                    var plaza = NominaTrabajador.Plazas_stDistribucionPlazaCategoria.Where(q => q.IdDistribucionPlazaCategoria == ConvenioLaboralTrabajadorCategoria.IdDistribucionPlazaCategoria).FirstOrDefault();
                    // solo oficinas centrales
                    var convenioltc = NominaTrabajador.ConveniosTrabajadoresTodos.Where(a => a.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                    if (convenioltc.Catalogos_ctEstructuraOrganica.IdModalidadEstudio == 0)
                        if (plaza.Plazas_ctCategoria.Categoria == "COORDINADOR DE TÉCNICOS ESPECIALIZADOS"
                        || plaza.Plazas_ctCategoria.Categoria == "SUPERVISOR"
                        || plaza.Plazas_ctCategoria.Categoria == "SECRETARIA DE DIRECTOR DE ÁREA"
                        || plaza.Plazas_ctCategoria.Categoria == "INGENIERO EN SISTEMAS"
                        )
                            calcularpercepcion = true;
                }

                if (calcularpercepcion)
                {

                    int diasAPagar = 0;
                    var regresadeLicencia = NominaTrabajador.LicenciasTrabajadoresPrimavacacional.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();

                    diasAPagar = ObtenerDiasDescansoObligatorio(NominaTrabajador.Nomina_stNomina.FechaTermino.Year);

                    if (regresadeLicencia != null)
                    {


                        // diasAPagar = diasAPagar -NominaTrabajador.DiasdePrima(ConvenioLaboralTrabajadorCategoria, regresadeLicencia);
                        diasAPagar = ObtenerDiasDescansoObligatorio(NominaTrabajador.Nomina_stNomina.FechaTermino.Year, (DateTime)regresadeLicencia.FechaTerminoIncidencia.Value.AddDays(1), regresadeLicencia.FechaInicioIncidencia);


                    }




                    Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
                    Decimal Sueldodiario = 0;

                    //Sueldodiario = NominaTrabajador.Truncate(costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMinimo * costos.CostoPorHora, 2);
                    //decimal SueldoQuinquenioDiario = 0;

                    //// var QuinquenioDiario = NominaTrabajador.SueldosParaPrimaVacaional.Where(s => s.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador

                    //Quinquenio quinqueniobase = new Quinquenio();

                    //SueldoQuinquenioDiario = quinqueniobase.ImporteQuinquenioTrabajador(ConvenioLaboralTrabajadorCategoria, NominaTrabajador);
                    //SueldoQuinquenioDiario = SueldoQuinquenioDiario / 15;

                    //decimal importegrava = ((Sueldodiario + SueldoQuinquenioDiario) * diasAPagar);


                    if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("HORAS EXTRAORD"))
                    {
                        if (NominaTrabajador.SalariosDiarioDocentesParaPrimaHorasExtras.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault() != null)
                        {
                            if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado)
                                Sueldodiario = NominaTrabajador.SalariosDiarioDocentesParaPrimaHorasExtras.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault().Importe;
                            else
                                Sueldodiario = NominaTrabajador.SalariosDiarioDocentesParaPrimaHorasExtras.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault().ImporteSinMatQuin;
                        }
                    }
                    else

                            if (NominaTrabajador.SalariosDiarioDocentesParaPrima.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault() != null)
                    {
                        if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado)
                            Sueldodiario = NominaTrabajador.SalariosDiarioDocentesParaPrima.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault().Importe;
                        else
                            Sueldodiario = NominaTrabajador.SalariosDiarioDocentesParaPrima.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault().ImporteSinMatQuin;
                    }

                    PercepcionesNominaTrabajador DiasOligatorios = new PercepcionesNominaTrabajador();


                    decimal importegrava = ((Sueldodiario ) * diasAPagar);


                    DiasOligatorios.Importe = importegrava;

                    DiasOligatorios.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    DiasOligatorios.IdNomina = NominaTrabajador.IdNomina;
                    DiasOligatorios.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DÍA DE DESCANSO OBLIGATORIO").FirstOrDefault().IdPlantillaNominaPercepcion;
                    DiasOligatorios.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DÍA DE DESCANSO OBLIGATORIO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                    DiasOligatorios.EsImprimibleRecibo = true;
                    DiasOligatorios.Tipo = "NORMAL";
                    DiasOligatorios.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DÍA DE DESCANSO OBLIGATORIO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                    if (DiasOligatorios.Importe>0)
                        NominaTrabajador.ListaPercepcionesTrabajadores.Add(DiasOligatorios);
                }
            }

        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste = false)
        {
            throw new NotImplementedException();
        }
    }
}