﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using Nova.Models;
using Nova.Models.Calculos;

namespace Nova.Models.Calculos.Percepciones
{
    public class DevolucionFaltasDeDocente : IPercepcionBehavior
    {
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null)
        {
            // Check if the worker is eligible for refund of absences
            if ((NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("ODES")
                && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("BASE"))
                || (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("CONTRATO")
                && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO"))
                )
                if (!NominaTrabajador.TrabajadorConIncapacipdadActiva)
                {
                    // Check if there are deductions for absences
                    if (NominaTrabajador.PlantillaNominaDeducciones.Any(x => x.Deducciones_ctDeduccion.Deduccion.Contains("FALTA")))
                    {
                        // Process the refunds for the absences
                        CalcularDevolucionFaltas(ConvenioLaboralTrabajadorCategoria, NominaTrabajador);
                    }
                }
        }
 

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste = false)
        {
            throw new NotImplementedException();
        }

        private void CalcularDevolucionFaltas(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            // Get the list of absences that were previously deducted
            var faltasDeducidas = NominaTrabajador.DevolucionesFaltasDocentes
                .Where(d => d.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                            )
                .ToList();

            if (faltasDeducidas.Any())
            {

              

                foreach (var faltaDeducida in faltasDeducidas)
                {
               var incidencias = faltaDeducida.IdNominaTrabajador;

                    List<IncidenciaPermiso_stIncidenciaTrabajador> incidenciasporañoyqna;
                    List<IncidenciaPermiso_stIncidenciaTrabajador> faltasOriginales;

                    using (var dbContext = new bdNovaEntities())
                    {
                        dbContext.Database.Connection.Open();

                        var faltabd = dbContext.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking()
                            .Where(a => a.IdNominaTrabajador == incidencias).FirstOrDefault();

                        incidenciasporañoyqna = dbContext.IncidenciaPermiso_stIncidenciaTrabajador
        .AsNoTracking()
             .Where(d => d.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
             && d.AñoParaNomina==faltabd.AñoParaNomina && d.QuincenaParaNomina==faltabd.QuincenaParaNomina &&
            d.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA")
            && d.IdNominaTrabajador!=null)
        .ToList();
                        dbContext.Database.Connection.Close();
                    }

                    int totalhoras = incidenciasporañoyqna.Sum(a => a.Horas);

                    var incide = incidenciasporañoyqna.Where(a => a.IdNominaTrabajador == faltaDeducida.IdNominaTrabajador).FirstOrDefault();
                    // Calculate the refund amount based on the deduction
                    decimal importeDevolucion = faltaDeducida.Importe;
                    var total = (importeDevolucion/ totalhoras) * incide.Horas;

                    // Create a new perception for the refund
                    var percepcion = new PercepcionesNominaTrabajador();
                    ConfigurarPercepcion(percepcion, ConvenioLaboralTrabajadorCategoria, NominaTrabajador, faltaDeducida.Deducciones_stPlantillaNominaDeducciones.Deducciones_ctDeduccion.Deduccion);

                    percepcion.Importe = total;
              
                   // percepcion.Concepto = $"DEVOLUCIÓN {faltaDeducida.PlantillaNominaDeducciones.Deducciones_ctDeduccion.Deduccion}";

                    // Add the perception to the worker's payroll
                    NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);
                }

                // Optionally, you can update variables or other records if needed
              //  ActualizarVariablesDevolucion(NominaTrabajador, ConvenioLaboralTrabajadorCategoria, NominaTrabajador.ListaVariablesNominaTrabajador);
            }
        }

       
        // Método para configurar las propiedades comunes de la percepción
        private void ConfigurarPercepcion(PercepcionesNominaTrabajador percepcion, Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string conceptoPercepcion)
        {
            percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
            percepcion.IdNomina = NominaTrabajador.IdNomina;

            var plantillaPercepcion = NominaTrabajador.PlantillaNominaPercepciones
                .FirstOrDefault(x => x.Percepciones_ctPercepcion.Percepcion == "DEVOLUCIÓN");

            if (plantillaPercepcion != null)
            {
                percepcion.IdPlantillaNominaPercepcion = plantillaPercepcion.IdPlantillaNominaPercepcion;
                percepcion.EsGrabable = plantillaPercepcion.Percepciones_ctPercepcion.EsGravable;
                percepcion.EsVariable = (bool)plantillaPercepcion.Percepciones_ctPercepcion.EsVariable;
                percepcion.EsPrevisionSocial = plantillaPercepcion.Percepciones_ctPercepcion.EsPrevisionSocial;
                percepcion.Tipo = "NORMAL";
                percepcion.EsDevolucionFaltas = true;
                percepcion.EsImprimibleRecibo = true;
                percepcion.Concepto = $" {conceptoPercepcion}";
            }
            else
            {
                throw new Exception($"No se encontró la percepción '{conceptoPercepcion}' en la plantilla de percepciones.");
            }
        }
    }
}
