﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
 

namespace Nova.Models.Calculos.Percepciones
{
    public class DevolucionFaltasBase : IDeduccionBehavior
    {
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            TimeSpan intervalo;
            int diasfaltas = 0;
            int totaldiasfaltas = 0;
             
                var faltastrabajador = NominaTrabajador.DevolucionesFaltasTrabajador.ToList();
                    

                Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
                foreach (var item in faltastrabajador)
                {
                    //FaltasTrabajador ft = new FaltasTrabajador();
                    //FaltasTrabajador faltaAyuda = new FaltasTrabajador();
                    //FaltasTrabajador faltaEficiencia = new FaltasTrabajador();

                    PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();
                    PercepcionesNominaTrabajador faltaAyuda = new PercepcionesNominaTrabajador();
                    PercepcionesNominaTrabajador faltaEficiencia = new PercepcionesNominaTrabajador();


                    intervalo = item.FechaTermino.Value - item.FechaInicio;
                    diasfaltas = System.Convert.ToInt32(intervalo.TotalDays) + 1;
                    totaldiasfaltas = totaldiasfaltas + diasfaltas;
                    var regsueldo = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault();
                    if (regsueldo != null)
                    {
                        percepcion.Importe = costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMinimo * costos.CostoPorHora * diasfaltas;

                        percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        percepcion.IdNomina = NominaTrabajador.IdNomina;

                        percepcion.IdPlantillaNominaPercepcion = regsueldo.IdPlantillaNominaPercepcion;

                        percepcion.EsDevolucionFaltas = true;

                        percepcion.Tipo = "NORMAL";
                        percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                        percepcion.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                        percepcion.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                        NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);
                    }
                    // falta ayuda
                    if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA TRANSPORTE").FirstOrDefault() != null)
                    {

                        faltaAyuda.Importe = (decimal)(NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA TRANSPORTE").FirstOrDefault().Importe / 15) * diasfaltas;
                        faltaAyuda.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        faltaAyuda.IdNomina = NominaTrabajador.IdNomina;
                        faltaAyuda.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA TRANSPORTE").FirstOrDefault().IdPlantillaNominaPercepcion;
                        faltaAyuda.EsDevolucionFaltas = true;
                        faltaAyuda.Tipo = "NORMAL";
                        faltaAyuda.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA TRANSPORTE").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                        faltaAyuda.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA TRANSPORTE").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                        faltaAyuda.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA TRANSPORTE").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                        NominaTrabajador.ListaPercepcionesTrabajadores.Add(faltaAyuda);
                    }


                    //falta eficiencia
                    if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO").FirstOrDefault() != null)
                    {
                        

                        faltaEficiencia.Importe = (decimal)(NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO").FirstOrDefault().Importe / 15) * diasfaltas;
                        faltaEficiencia.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        faltaEficiencia.IdNomina = NominaTrabajador.IdNomina;
                        faltaEficiencia.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO").FirstOrDefault().IdPlantillaNominaPercepcion;
                        faltaEficiencia.EsDevolucionFaltas = true;
                        faltaEficiencia.Tipo = "NORMAL";
                        faltaEficiencia.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                        faltaEficiencia.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                        faltaEficiencia.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                        NominaTrabajador.ListaPercepcionesTrabajadores.Add(faltaEficiencia);
                    }

                }

                //if (diasfaltas > 0)
                //{
                    
 
                //    NominaTrabajador.DiasPagados = (short)(NominaTrabajador.DiasPagados + totaldiasfaltas);

                   

                //}

             
        }
    }
}