﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;

namespace Nova.Models.Calculos.Percepciones
{

    public class CompensacionActuacionProductividad : IPercepcionBehavior
    {

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {
            if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "COMPENSACION POR ACTUACION Y PRODUCTIVIDAD").FirstOrDefault() != null)
            {
                if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado
                    || ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria.Contains("CECYT II")
                    || ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria.Contains("CECYT III")
                    || ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria.Contains("CECYT IV")
                        || ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria.Contains("EMSAD II")
                        || ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria.Contains("EMSAD III")
                        || ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria.Contains("EMSAD IV")
                   )

                {

                    PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

                    percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    percepcion.IdNomina = NominaTrabajador.IdNomina;
                    percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "COMPENSACION POR ACTUACION Y PRODUCTIVIDAD").FirstOrDefault().IdPlantillaNominaPercepcion;
                    percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "COMPENSACION POR ACTUACION Y PRODUCTIVIDAD").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                    decimal ImporteApagar = (decimal)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "COMPENSACION POR ACTUACION Y PRODUCTIVIDAD").FirstOrDefault().Importe;
                    int diaslaborados = (int)NominaTrabajador.ListaVariablesNominaTrabajador.Where(s => s.Concepto == "DIASLABORADOS" && s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().Importe;

                    var existhh = NominaTrabajador.ListaVariablesNominaTrabajador.Where(s => s.Concepto == "HorasHHBASE" && s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                    if (existhh != null)
                    { diaslaborados = (int)existhh.Importe; }

                    if (NominaTrabajador.HorasSemanaMes + NominaTrabajador.HorasExcedentes < 40)
                    {
                        var importe100 = decimal.Round((NominaTrabajador.HorasSemanaMes + NominaTrabajador.HorasExcedentes) * (ImporteApagar / 40M), 4);

                        percepcion.Importe = ((importe100 * diaslaborados) / NominaTrabajador.DiasNomina);
                        //percepcion.Importe = decimal.Round((NominaTrabajador.HorasSemanaMes + NominaTrabajador.HorasExcedentes) * (ImporteApagar/ 40M), 4);
                    }
                    else
                    {
                        percepcion.Importe = ((ImporteApagar * diaslaborados) / NominaTrabajador.DiasNomina);
                        //percepcion.Importe = ImporteApagar;
                    }



                    percepcion.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "COMPENSACION POR ACTUACION Y PRODUCTIVIDAD").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;

                    if (percepcion.Importe > 0)
                        NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);

                }
            }
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }

        void IPercepcionBehavior.Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }
    }

}