﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;
using Nova.Models.Calculos.Percepciones;
using Nova.Models.Calculos.Deducciones;
using System.Transactions;
using EntityFramework.BulkInsert.Extensions;



namespace Nova.Models.Calculos
{
    public class NominaMandosMedios : Nomina
    {
        private Nomina_stNominaTrabajador NominaTrabajador;

        private bdNovaEntities bd = new bdNovaEntities();
        //{
        public NominaMandosMedios(Nomina_stNominaTrabajador Nt)
        {
            NominaTrabajador = Nt;
        }

        //public override void GenerarRetroactivo(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        //{





        //    foreach (var item in this.NominaTrabajador.ListaPercepcionesRetroActivoTrabajador.Where(w => w.IdConvenioLaboralTrabajadorCategoria == cltc.IdConvenioLaboralTrabajadorCategoria ))
        //    {

        //        Nova.Models.Nomina.PercepcionesNominaTrabajador percepcion = new Nova.Models.Nomina.PercepcionesNominaTrabajador();

        //        percepcion.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
        //        percepcion.IdNomina = NominaTrabajador.IdNomina;
        //        percepcion.IdPlantillaNominaPercepcion = item.IdPlantillaNominaPercepcion;

        //        decimal ImporteRetroActivoC = 0;
        //        decimal PorcentajeRetroActivoC = 0;

        //        if (item.ImporteRetroActivoC != null)
        //            ImporteRetroActivoC = item.ImporteRetroActivoC;

        //        if (item.PorcentajeRetroActivoC != null)
        //            PorcentajeRetroActivoC = item.PorcentajeRetroActivoC;


        //        if (ImporteRetroActivoC > 0)
        //            percepcion.Importe = ImporteRetroActivoC * item.TotalQuincenas;
        //        else
        //            if (PorcentajeRetroActivoC > 0)
        //                percepcion.Importe = item.Importe * item.PorcentajeRetroActivoC;
        //            else
        //                if (item.ImporteRetroActivo>0 )
        //                    percepcion.Importe = item.ImporteRetroActivo * item.TotalQuincenas;
        //                else
        //                    percepcion.Importe = item.Importe * item.PorcentajeRetroActivo;


        //        percepcion.Tipo = "NORMAL";
        //        percepcion.EsGrabable =item.EsGravable;

        //        percepcion.EsVariable = item.EsVariable;
        //        percepcion.EsPrevisionSocial = item.EsPrevisionSocial; ;


        //        NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);
        //    }

        //    Nova.Models.Calculos.Deducciones.ISRRETROACTIVO isr = new Nova.Models.Calculos.Deducciones.ISRRETROACTIVO();
        //    isr.Calcular(cltc, this.NominaTrabajador);

        //    Nova.Models.Calculos.Deducciones.Pension cre = new Nova.Models.Calculos.Deducciones.Pension();
        //    cre.Calcular(cltc, this.NominaTrabajador);


        //}

        public override void GenerarDeducciones(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {

            Nova.Models.Calculos.Deducciones.FaltasConfianza faltas = new Nova.Models.Calculos.Deducciones.FaltasConfianza();
            faltas.Calcular(cltc, this.NominaTrabajador);

            Nova.Models.Calculos.Deducciones.DeduccionesPersonalizadas deducionpersonalizada = new Nova.Models.Calculos.Deducciones.DeduccionesPersonalizadas();
            deducionpersonalizada.Calcular(cltc, this.NominaTrabajador);

            Nova.Models.Calculos.Deducciones.SDI sdi = new Nova.Models.Calculos.Deducciones.SDI();
            sdi.Calcular(cltc, this.NominaTrabajador);
            Nova.Models.Calculos.Deducciones.IMSS imss = new Nova.Models.Calculos.Deducciones.IMSS();
            imss.Calcular(cltc, this.NominaTrabajador);


            Nova.Models.Calculos.Deducciones.ISR isr = new Nova.Models.Calculos.Deducciones.ISR();
            isr.Calcular(cltc, this.NominaTrabajador);






        }
        public override void GenerarPercepciones(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            //SUELDO 
            Nova.Models.Calculos.Percepciones.SueldoMandoMedio sueldo = new Nova.Models.Calculos.Percepciones.SueldoMandoMedio();
            sueldo.Calcular(cltc, this.NominaTrabajador, null);


            // AYUDA PARA DESPENSA
            Nova.Models.Calculos.Percepciones.AyudaDespensa ayudadespensa = new Nova.Models.Calculos.Percepciones.AyudaDespensa();
            ayudadespensa.Calcular(cltc, this.NominaTrabajador, null);

            //VALES DE DESPENSA
            Nova.Models.Calculos.Percepciones.ValesDespensa valesdespensa = new Nova.Models.Calculos.Percepciones.ValesDespensa();
            valesdespensa.Calcular(cltc, this.NominaTrabajador, null);

            //PERCEPCIONES PERSONALIZADAS (GASTO ADMINISTRATIVO || NÓMINA RDL)
            Nova.Models.Calculos.Percepciones.PercepcionPersonalizada percepcionpersonalizada = new Nova.Models.Calculos.Percepciones.PercepcionPersonalizada();
            percepcionpersonalizada.Calcular(cltc, this.NominaTrabajador, null,null);

            Nova.Models.Calculos.Percepciones.Aguinaldo aguinaldo = new Nova.Models.Calculos.Percepciones.Aguinaldo();
            aguinaldo.Calcular(cltc, this.NominaTrabajador, null);

            // se debe de calcular primero el SALARIO DIARIO
            PrimaVacacional prima = new PrimaVacacional();
            prima.Calcular(cltc, this.NominaTrabajador, null);

            PrestacionesAdicionales adicionales = new PrestacionesAdicionales();
            adicionales.Calcular(cltc, this.NominaTrabajador, null);

           

            Nova.Models.Calculos.Percepciones.AjusteDiasCalendario AjusteDiasCalendario = new Nova.Models.Calculos.Percepciones.AjusteDiasCalendario();
            AjusteDiasCalendario.Calcular(cltc, this.NominaTrabajador, null);


            Nova.Models.Calculos.Percepciones.aguinaldoPartesProporcionales aguinaldopp = new Nova.Models.Calculos.Percepciones.aguinaldoPartesProporcionales();
            aguinaldopp.Calcular(cltc, this.NominaTrabajador, null);

            Nova.Models.Calculos.Percepciones.PrimaAntiguedad primaantiguedad = new Nova.Models.Calculos.Percepciones.PrimaAntiguedad();
            primaantiguedad.Calcular(cltc, this.NominaTrabajador, null);

            Nova.Models.Calculos.Percepciones.VacacionesPartesProporcionales vacaciones = new Nova.Models.Calculos.Percepciones.VacacionesPartesProporcionales();
            vacaciones.Calcular(cltc, this.NominaTrabajador, null);

            Nova.Models.Calculos.Percepciones.SueldoPartesProporcionales sueldopp = new Nova.Models.Calculos.Percepciones.SueldoPartesProporcionales();
            sueldopp.Calcular(cltc, this.NominaTrabajador, null);
        }
        public override void GenerarIncapacidades(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            Nova.Models.Calculos.Deducciones.EnfermedadGeneralConfianza enfermedadgeneral = new Nova.Models.Calculos.Deducciones.EnfermedadGeneralConfianza();
            enfermedadgeneral.Calcular(cltc, this.NominaTrabajador);
          
        }


        public override void GenerarDeduccionesRetroactivo(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            
            Nova.Models.Calculos.Deducciones.SDI sdi = new Nova.Models.Calculos.Deducciones.SDI();
            sdi.Calcular(cltc, this.NominaTrabajador);
            

            Nova.Models.Calculos.Deducciones.ISR isr = new Nova.Models.Calculos.Deducciones.ISR();
            isr.Calcular(cltc, this.NominaTrabajador);

            
          
         

        }
        public override void GenerarCreditos(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            Nova.Models.Calculos.Deducciones.Credito cre = new Nova.Models.Calculos.Deducciones.Credito();
            cre.Calcular(cltc, this.NominaTrabajador);


        }
        public override void GenerarPensiones(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            Nova.Models.Calculos.Deducciones.Pension cre = new Nova.Models.Calculos.Deducciones.Pension();
            cre.Calcular(cltc, this.NominaTrabajador);


        }


        public override void CalcularNomina()
        {
            if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
            {

                this.NominaTrabajador.getPercepcionesRetroactivo();
            }
           

            foreach (var Trabajador in this.NominaTrabajador.TrabajadoresVigentes)
            {
                //try
                //{
                bool CalcularNomina = false;
                if (Trabajador.FechaInicioPago != null && Trabajador.EsPrimerCalculo)
                {
                    if (Trabajador.FechaInicioPago >= this.NominaTrabajador.Nomina_stNomina.FechaInicio
                       && Trabajador.FechaInicioPago <= this.NominaTrabajador.Nomina_stNomina.FechaTermino)
                        CalcularNomina = true;
                    else
                        if (Trabajador.FechaInicioPago <= this.NominaTrabajador.Nomina_stNomina.FechaInicio
                       && Trabajador.EsPrimerCalculo == true)
                        CalcularNomina = true;



                    this.NominaTrabajador.TrabajadoresConCalculoConFechaAnterior.Add(Trabajador);
                }
                else
                    CalcularNomina = true;


                if (CalcularNomina)
                {

                    if (this.NominaTrabajador.EsRecalculoPorTrabajador == false)
                        NominaTrabajador.DiasPagados = NominaTrabajador.DiasNomina;


                  
                    int IdConvenioLaboralTrabajadorCategoria = Trabajador.IdConvenioLaboralTrabajadorCategoria;
                    int IdTrabajador = Trabajador.Convenios_stConvenioLaboralTrabajador.IdTrabajador;

                    Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == Trabajador.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();

                    // jc HttpContext.Current.Session["IdTrabajador"] = IdTrabajador;

                    //short IdJornadaLaboral = 0;
                    //short IdCostoHoraJornada = 0;

                    //if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo != "RETROACTIVO")
                    //{
                    //    Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == Trabajador.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();

                    //    IdJornadaLaboral = (short)costos.Plazas_ctCategoria.IdJornadaLaboral;
                    //    IdCostoHoraJornada = costos.IdCostoHoraJornada;
                    //    this.NominaTrabajador.setJornadaLaboral(IdJornadaLaboral);
                    //}


                    /////////////////////////////////////////////////

                    //this.setConvenioLaboralTrabajador(IdTrabajador);
                    // this.NominaTrabajador.setCostoHoraJornada(IdCostoHoraJornada);
                    this.NominaTrabajador.setIncidenciaTrabajador(IdTrabajador);

                    //this.NominaTrabajador.DiasEfectivosLaborados = this.NominaTrabajador.ObtenDiasIncidenciasTrabajador();

                    //this.NominaTrabajador.setJornadaLaboral(IdJornadaLaboral);

                    //this.setNominaTrabajadorPercepciones(IdTrabajador);
                    this.NominaTrabajador.setParametrosCreditosTrabajador(IdTrabajador);
                    this.NominaTrabajador.setPensionesTrabajador(IdTrabajador);
                    this.NominaTrabajador.setPercepcionesPersonalizadas(IdConvenioLaboralTrabajadorCategoria, this.NominaTrabajador.Nomina.Nomina_ctPlantillaNomina.IdPeriodoNomina);
                   // this.NominaTrabajador.setDeduccionesPersonalizadas(IdConvenioLaboralTrabajadorCategoria, this.NominaTrabajador.Nomina.Nomina_ctPlantillaNomina.IdPeriodoNomina);
                    //this.setCatalogoKardexTrabajadorCuentas(IdTrabajador);
                    //this.setTrabajador(IdConvenioLaboralTrabajadorCategoria);
                   // this.NominaTrabajador.setBimestreAnteriorPagadasTrabajador(IdConvenioLaboralTrabajadorCategoria);


                    //}
                    //catch (Exception e)
                    //{
                    //    throw new InvalidProgramException(e.Message);

                    //}


                    if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
                    {

                        NominaTrabajador.GenerarRetroactivo(Trabajador);
                        this.GenerarDeduccionesRetroactivo(Trabajador);
                        this.GenerarPensiones(Trabajador);


                    }
                    else
                    {
                        GenerarPermisos(Trabajador);
                        this.GenerarPercepciones(Trabajador);
                        this.NominaTrabajador.GenerarAjustesPerpceciones(Trabajador);

                         this.NominaTrabajador.GenerarAjustesSueldosCambioContrato(Trabajador);
                        this.NominaTrabajador.AjustesPorBajasSinPago(Trabajador);

                        //esta linea debe de ser procesada despues de haber calculado percepciones

                        this.NominaTrabajador.setMaternidadRiesgoTrabajoTrabajador(Trabajador);
                        this.GenerarIncapacidades(Trabajador);

                        if (!NominaTrabajador.TrabajadorConIncapacipdadActiva)
                        {
                            this.GenerarDeducciones(Trabajador);
                            //ccalcula IMSS diferecnias
                            this.NominaTrabajador.GenerarAjustesPerpceciones(Trabajador, true);

                            this.GenerarPensiones(Trabajador);
                            this.GenerarCreditos(Trabajador);

                            this.NominaTrabajador.CalcularAjusteDeduccionInfonavit(Trabajador);
                        }

                    }
                    //  Console.WriteLine("--- fin --- " + DateTime.Now + " ** ");
                }
            }

            GrabarStNominaTrabajador();
         
        }

        public override void GenerarPermisos(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {

            Nova.Models.Calculos.Deducciones.RiesgoTrabajo incapacidad = new Nova.Models.Calculos.Deducciones.RiesgoTrabajo();
            incapacidad.Calcular(cltc, this.NominaTrabajador);



        }
        public override void GrabarStNominaTrabajador()
        {
            NominaTrabajador.CreditosDelTrabajadorNoAplicados = new List<Creditos_stNominaCreditoTrabajadorNoAplicados>();
            NominaTrabajador.CreditosDelTrabajador = new List<Creditos_stNominaCreditoTrabajador>();
            NominaTrabajador.PercepcionesDelTrabajador = new List<Percepciones_stNominaTrabajadorPercepciones>();
            NominaTrabajador.DeduccionesDelTrabajador = new List<Deducciones_stNominaTrabajadorDeduccion>();
            NominaTrabajador.SubDeduccionesDelTrabajador = new List<Deducciones_stNominaTrabajadorSubDeducciones>();
            NominaTrabajador.PensionesDelTrabajador = new List<Pensiones_stNominaPensionTrabajador>();
                int y = 0;

                foreach (var item in NominaTrabajador.TrabajadoresVigentes)
                {

             //   if (NominaTrabajador.ListaPercepcionesTrabajadores.Where(v =>
             //v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && v.Importe > 0).ToList().Count > 0)
             //       NominaTrabajador.AgregarSubsidio(item.IdConvenioLaboralTrabajadorCategoria);

                y++;

                    NominaTrabajador.trabajadornomina = null;
                    NominaTrabajador.trabajadornomina = new Nomina_stNominaTrabajador();
                    NominaTrabajador.trabajadornomina.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                    NominaTrabajador.trabajadornomina.IdNomina = NominaTrabajador.IdNomina;
                //    NominaTrabajador.trabajadornomina.SueldoBruto = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe);
                //    NominaTrabajador.trabajadornomina.SueldoDiario = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "SUELDO DIARIO" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();
                //    decimal percepciones = NominaTrabajador.trabajadornomina.Truncate(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe), 2)
                //        , deducciones = NominaTrabajador.trabajadornomina.Truncate(NominaTrabajador.ListaDeduccionesTrabajadores.Where(i => i.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe), 2)
                //        , creditos = NominaTrabajador.trabajadornomina.Truncate(NominaTrabajador.ListaCreditosTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe), 2)
                //        , pensiones = NominaTrabajador.trabajadornomina.Truncate(NominaTrabajador.ListaPensionesTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe), 2);

                ////if (percepciones == 0)
                ////    throw new ApplicationException(item.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre+" "+ item.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno+" "+ item.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno+ ": Esta nomina ha generado valores en 0, revise su información puede ser que la nomina para esta quincena no sea aplicable");

                //NominaTrabajador.trabajadornomina.SueldoNeto = percepciones - deducciones - creditos - pensiones;


                //NominaTrabajador.trabajadornomina.SueldoNeto = decimal.Round(NominaTrabajador.Truncate(NominaTrabajador.trabajadornomina.SueldoNeto, 4), 2);

                NominaTrabajador.trabajadornomina.SueldoBruto = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList());
                NominaTrabajador.trabajadornomina.SueldoTabular = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.Concepto.Contains("SUELDO") && v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList());
                NominaTrabajador.trabajadornomina.PercepcionesAdicionales = (NominaTrabajador.trabajadornomina.SueldoBruto - NominaTrabajador.trabajadornomina.SueldoTabular.Value);


                NominaTrabajador.trabajadornomina.SueldoDiario = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "SUELDO DIARIO" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();
                NominaTrabajador.trabajadornomina.TotalDeducciones = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaDeduccionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList());
                NominaTrabajador.trabajadornomina.SueldoNeto = NominaTrabajador.trabajadornomina.SueldoBruto

                        - NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaDeduccionesTrabajadores.Where(i => i.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList())
                        - NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaCreditosTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList())
                        - NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaPensionesTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList());


                NominaTrabajador.trabajadornomina.SueldoTransferencia = 0;
                    NominaTrabajador.trabajadornomina.SueldoMonedero = 0;
                NominaTrabajador.trabajadornomina.TotalDeducciones = NominaTrabajador.ListaDeduccionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe);

                var rdl = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "Rdl" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();
                    var isr = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "Isr" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();

                    NominaTrabajador.trabajadornomina.Isr = isr;

                     
                    if (rdl >0)
                    {
                        NominaTrabajador.trabajadornomina.Rdl = rdl;
                        NominaTrabajador.trabajadornomina.IsrRdl = decimal.Round(NominaTrabajador.Truncate(((isr * rdl) / NominaTrabajador.trabajadornomina.SueldoNeto), 4), 2); ;
                    }
                //List<Kardex_stTrabajadorCuentas> cta = NominaTrabajador.CatalogoKardexTrabajadoresCuentas.Where(w => w.IdTrabajador == item.Convenios_stConvenioLaboralTrabajador.IdTrabajador && w.EsVigente && (w.Catalogos_ctFormaDePago.FormaDePago == "TRANSFERENCIA ELECTRÓNICA" || w.Catalogos_ctFormaDePago.FormaDePago == "EFECTIVO")).ToList();
                //if (cta.Count > 0)
                //{
                //    var cayuda = NominaTrabajador.PlantillaNominaPercepciones.Where(g => g.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA DESPENSA" || g.Percepciones_ctPercepcion.Percepcion == "VALES DE DESPENSA").Select(H => H.IdPlantillaNominaPercepcion).ToArray();

                //    decimal vales = NominaTrabajador.ListaPercepcionesTrabajadores.Where(d => d.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && cayuda.Contains(d.IdPlantillaNominaPercepcion)).Sum(d => d.Importe);

                //    NominaTrabajador.trabajadornomina.SueldoTransferencia = NominaTrabajador.trabajadornomina.SueldoNeto - vales;
                //    NominaTrabajador.trabajadornomina.IdTrabajadorCuentasTransferencia = cta.FirstOrDefault().IdTrabajadorCuentas;

                //}
                //else
                //{
                //    throw new InvalidProgramException("El trabajador " + item.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + item.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + item.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno + " con Id: " + item.Convenios_stConvenioLaboralTrabajador.IdTrabajador.ToString() + " no tiene cuenta para transferencia electrónica o efectivo");
                //}

                //List<Kardex_stTrabajadorCuentas> ctamonedero = NominaTrabajador.CatalogoKardexTrabajadoresCuentas.Where(w => w.IdTrabajador == item.Convenios_stConvenioLaboralTrabajador.IdTrabajador && w.Catalogos_ctFormaDePago.FormaDePago == "MONEDERO ELECTRÓNICO").OrderByDescending(c => c.IdTrabajadorCuentas).ToList();
                //if (ctamonedero.Count > 0)
                //{
                //    var cayuda = NominaTrabajador.PlantillaNominaPercepciones.Where(g => g.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA DESPENSA" || g.Percepciones_ctPercepcion.Percepcion == "VALES DE DESPENSA").Select(H => H.IdPlantillaNominaPercepcion).ToArray();

                //    NominaTrabajador.trabajadornomina.SueldoMonedero = NominaTrabajador.ListaPercepcionesTrabajadores.Where(d => d.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && cayuda.Contains(d.IdPlantillaNominaPercepcion)).Sum(d => d.Importe);
                //    NominaTrabajador.trabajadornomina.IdTrabajadorCuentasMonedero = ctamonedero.FirstOrDefault().IdTrabajadorCuentas;
                //}
                //else
                //{
                //    throw new InvalidProgramException("El trabajador " + item.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + item.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + item.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno + " con Id: " + item.Convenios_stConvenioLaboralTrabajador.IdTrabajador.ToString() + " no tiene Monedero electrónico para transferencia");

                //}

                //NominaTrabajador.DiasPagados = (short)NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "DiasPagados" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();
                //decimal faltas = NominaTrabajador.ListaVariablesNominaTrabajador.Where(F => F.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && F.Concepto == "FALTAS").Sum(e => e.Importe);
                //NominaTrabajador.DiasPagados = (short)(NominaTrabajador.DiasPagados - (short)faltas);

                NominaTrabajador.DiasPagados = (short)NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "DIASLABORADOS" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();
                decimal faltas = NominaTrabajador.ListaVariablesNominaTrabajador.Where(F => F.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && F.Concepto == "FALTAS").Sum(e => e.Importe);
                NominaTrabajador.DiasFaltas = (short)faltas;

                NominaTrabajador.trabajadornomina.DiasPagados = NominaTrabajador.DiasPagados;
                NominaTrabajador.trabajadornomina.DiasEfectivosLaborados = NominaTrabajador.DiasPagados;


                Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == item.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();

                    NominaTrabajador.trabajadornomina.HorasSemanaMes = 0;
                    NominaTrabajador.trabajadornomina.HorasSemanaMesTrabajadas = 0;
                    NominaTrabajador.trabajadornomina.HorasTrabajadasExcedentes = 0;
                    NominaTrabajador.trabajadornomina.HorasTrabajadasInterinas = 0;
                    NominaTrabajador.trabajadornomina.DiasEfectivosLaborados = NominaTrabajador.trabajadornomina.DiasPagados;
                    if (costos != null)
                    {
                        NominaTrabajador.trabajadornomina.CostoPorHora = costos.CostoPorHora;
                        //NominaTrabajador.trabajadornomina.HorasEfectivasDeTrabajo = (short)(NominaTrabajador.DiasPagados * costos.CostoPorHora);
                        NominaTrabajador.trabajadornomina.HorasEfectivasDeTrabajo = (short)(NominaTrabajador.trabajadornomina.DiasEfectivosLaborados * costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo);


                    }
                    NominaTrabajador.trabajadornomina.CostoPorHoraExcedente = 0;
                    NominaTrabajador.trabajadornomina.CostoPorHorasInterinas = 0;





                    NominaTrabajador.trabajadornomina.SalarioDiarioIntegrado = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "SALARIO DIARIO INTEGRADO" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();

                    NominaTrabajador.trabajadornomina.QuinquenioDiario = 0;
                    NominaTrabajador.trabajadornomina.MaterialDidacticoDiario = 0;

                    var idquinqueniopercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "QUINQUENIO").FirstOrDefault();
                var idpercesueldo = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion.Contains("SUELDO")).Select(z => z.IdPlantillaNominaPercepcion).ToArray();

                decimal sueldobrutosueldo = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && idpercesueldo.Contains(v.IdPlantillaNominaPercepcion)).ToList());

                if (idquinqueniopercepcion != null)
                    NominaTrabajador.trabajadornomina.SueldoBrutoQuinquenioDiario = sueldobrutosueldo + NominaTrabajador.ListaPercepcionesTrabajadores.Where(g => g.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && idquinqueniopercepcion.IdPlantillaNominaPercepcion == g.IdPlantillaNominaPercepcion).Sum(r => r.Importe);
                else
                    NominaTrabajador.trabajadornomina.SueldoBrutoQuinquenioDiario = sueldobrutosueldo; ;

                if (NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
                {
                    NominaTrabajador.trabajadornomina.SumaPercepcionesVariables = NominaTrabajador.trabajadornomina.SueldoBruto;
                }
                else
                {
                    NominaTrabajador.trabajadornomina.SumaPercepcionesVariables = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && v.EsVariable == true).ToList());
                }

                NominaTrabajador.trabajadornomina.SalarioBrutoGravable = NominaTrabajador.trabajadornomina.SumaPercepcionesVariables;


                NominaTrabajador.trabajadornomina.Isr = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "Isr" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();


                    NominaTrabajador.trabajadornomina.Rdl = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "Rdl" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();
                //NominaTrabajador.trabajadornomina.EsDevolucion = false;

                NominaTrabajador.trabajadornomina.BaseGravable = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "BASE GRAVABLE" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();

                NominaTrabajador.trabajadornomina.SalarioBrutoGravable = NominaTrabajador.ListaNominaPercepcionesTrabajador.Where(z => z.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion.EsGravable == true).Sum(x => x.Importe);
                //bd.Nomina_stNominaTrabajador.Add(NominaTrabajador.trabajadornomina);

                if (NominaTrabajador.EsRecalculoPorTrabajador)
                {
                    NominaTrabajador.trabajadornomina.EsMedioRecibo = true;
                    NominaTrabajador.trabajadornomina.IdNominaTrabajadorEstatus = this.NominaTrabajador.IdNominaTrabajadorEstatusRecalculo;
                }

                var trabajadorFechaingreso = NominaTrabajador.QuinquenioTrabajadorAntiguedad.getAntiguedadPorTrabajador(item.Convenios_stConvenioLaboralTrabajador.IdTrabajador);

                NominaTrabajador.trabajadornomina.FechaIngreso = trabajadorFechaingreso.FechaIngreso;
                NominaTrabajador.trabajadornomina.EsAlta = item.EsPrimerCalculo;

                NominaTrabajador.Nomina_stNominaTrabajadorLista.Add(NominaTrabajador.trabajadornomina);

                //EntityFrameworkExtensions.SaveChanges(ref bd, y, 100, true);


                ///IMSS/////
                var diasqnaimss = NominaTrabajador.ListaVariablesNominaTrabajador.Where(a => a.Concepto == "DiasQuincenaIMSS"
                 && a.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                if (diasqnaimss != null)
                {

                    NominaTrabajador.trabajadornomina.DiasRetencion = (short)diasqnaimss.Importe;
                }


                var totalDIASIncidencias = NominaTrabajador.ListaVariablesNominaTrabajador.Where(v => v.Concepto == "INCIDENCIA_DIAS_IMSS" && v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
         ).Sum(a => a.Importe);

                NominaTrabajador.trabajadornomina.DiasIncapacidadImss = (short)totalDIASIncidencias;


                var CesantiaVejezTrabajador = NominaTrabajador.ListaVariablesNominaTrabajador.Where(v => v.Concepto == "CesantiaVejezTrabajador" && v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
           ).Sum(a => a.Importe);

                NominaTrabajador.trabajadornomina.Obrero_RCV = CesantiaVejezTrabajador;

                var imss = NominaTrabajador.ListaVariablesNominaTrabajador.Where(v => v.Concepto == "deduccionimss" && v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
           ).Sum(a => a.Importe);

                NominaTrabajador.trabajadornomina.Obrero_IMSS = imss;
                ///IMSS/////
                ///

            }

            NominaTrabajador.GrabarNominaBaseDatos();
            
        }



        public override void CalcularSueldo()
        {
            if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
            {

                this.NominaTrabajador.getPercepcionesRetroactivo();
            }



            foreach (var item in this.NominaTrabajador.TrabajadoresVigentes)
            {



                int IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                int IdTrabajador = item.Convenios_stConvenioLaboralTrabajador.IdTrabajador;

                this.NominaTrabajador.setIncidenciaTrabajador(IdConvenioLaboralTrabajadorCategoria);

                this.NominaTrabajador.setParametrosCreditosTrabajador(IdTrabajador);
                this.NominaTrabajador.setPensionesTrabajador(IdTrabajador);
                this.NominaTrabajador.setPercepcionesPersonalizadas(IdConvenioLaboralTrabajadorCategoria, this.NominaTrabajador.Nomina.Nomina_ctPlantillaNomina.IdPeriodoNomina);
                //this.NominaTrabajador.setCostoHoraJornada(item.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Plazas_ctCostoHoraJornada.IdCostoHoraJornada);
                //this.NominaTrabajador.setBimestreAnteriorPagadasTrabajador(IdConvenioLaboralTrabajadorCategoria);



                Nova.Models.Calculos.Percepciones.Sueldo sueldo = new Nova.Models.Calculos.Percepciones.Sueldo();
                sueldo.Calcular(item, this.NominaTrabajador, null);

            }



        }


        public override void CalcularAyudaDespensa()
        {
            if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
            {

                this.NominaTrabajador.getPercepcionesRetroactivo();
            }



            foreach (var item in this.NominaTrabajador.TrabajadoresVigentes)
            {



                int IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                int IdTrabajador = item.Convenios_stConvenioLaboralTrabajador.IdTrabajador;

                this.NominaTrabajador.setIncidenciaTrabajador(IdConvenioLaboralTrabajadorCategoria);

                this.NominaTrabajador.setParametrosCreditosTrabajador(IdTrabajador);
                this.NominaTrabajador.setPensionesTrabajador(IdTrabajador);
                this.NominaTrabajador.setPercepcionesPersonalizadas(IdConvenioLaboralTrabajadorCategoria, this.NominaTrabajador.Nomina.Nomina_ctPlantillaNomina.IdPeriodoNomina);
                //this.NominaTrabajador.setCostoHoraJornada(item.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Plazas_ctCostoHoraJornada.IdCostoHoraJornada);
               // this.NominaTrabajador.setBimestreAnteriorPagadasTrabajador(IdConvenioLaboralTrabajadorCategoria);



                Nova.Models.Calculos.Percepciones.AyudaDespensa Ayuda = new Nova.Models.Calculos.Percepciones.AyudaDespensa();
                Ayuda.Calcular(item, this.NominaTrabajador, null);

            }



        }


    }
}
