﻿using log4net;
using Nova.Libraries;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Web;

namespace Nova.Models.Calculos
{
    public class NominaLogger
    {
        public static readonly ILog log = LogManager.GetLogger(typeof(MvcApplication));
        public void EjecutarMetodoConLog(Action metodo)
            {
                var nombreMetodo = metodo.Method.Name;

            log.Info($"{nombreMetodo} iniciado.");
            
            var cronometro = Stopwatch.StartNew();

                metodo();

                cronometro.Stop();

                Logger.LogTiempoEjecucion(nombreMetodo, cronometro.Elapsed);
            }

        public void EjecutarMetodoConLog(string nombreMetodo, Action metodo)
        {
            log.Info($"{nombreMetodo} iniciado.");

            var cronometro = Stopwatch.StartNew();

            metodo();

            cronometro.Stop();

            Logger.LogTiempoEjecucion(nombreMetodo, cronometro.Elapsed);
        }
    }
}