﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;
using Nova.Models.Calculos.Percepciones;
using Nova.Models.Calculos.Deducciones;
using System.Transactions;
using EntityFramework.BulkInsert.Extensions;
using Nova.Models.Designpattern;

namespace Nova.Models.Calculos
{
    public class NominaInterinoAdministrativa : Nomina
    {
        private Nomina_stNominaTrabajador NominaTrabajador;

        private bdNovaEntities bd = new bdNovaEntities();
        //{
        public NominaInterinoAdministrativa(Nomina_stNominaTrabajador Nt)
        {
            NominaTrabajador = Nt;
        }


        public override void GenerarPercepciones(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina != "EXTRAORDINARIA")
            {
                //SUELDO 
                Nova.Models.Calculos.Percepciones.Sueldo sueldo = new Nova.Models.Calculos.Percepciones.Sueldo();
                sueldo.Calcular(cltc, this.NominaTrabajador, null);
            }

            //this.NominaTrabajador.HoraInicioProceso = DateTime.Now;
            //PERCEPCIONES PERSONALIZADAS (GASTO ADMINISTRATIVO || NÓMINA RDL || ZONA MARGINAL 
            Nova.Models.Calculos.Percepciones.PercepcionPersonalizada percepcionpersonalizada = new Nova.Models.Calculos.Percepciones.PercepcionPersonalizada();
            percepcionpersonalizada.Calcular(cltc, this.NominaTrabajador, null,null);

            if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina != "EXTRAORDINARIA")
            {
                // AYUDA PARA DESPENSA
                Nova.Models.Calculos.Percepciones.AyudaDespensa ayudadespensa = new Nova.Models.Calculos.Percepciones.AyudaDespensa();
                ayudadespensa.Calcular(cltc, this.NominaTrabajador, null);

                //VALES DE DESPENSA
                Nova.Models.Calculos.Percepciones.ValesDespensa valesdespensa = new Nova.Models.Calculos.Percepciones.ValesDespensa();
                valesdespensa.Calcular(cltc, this.NominaTrabajador, null);

                ////EFICIENCIA EN EL TRABAJO
                EficienciaTrabajo eficienciaTrabajo = new EficienciaTrabajo();
                eficienciaTrabajo.Calcular(cltc, this.NominaTrabajador, null);

                AyudaTransporte ayudatransporte = new AyudaTransporte();
                ayudatransporte.Calcular(cltc, this.NominaTrabajador, null);

                Nova.Models.Calculos.Percepciones.VacacionesPartesProporcionalesContrato vacaciones = new Nova.Models.Calculos.Percepciones.VacacionesPartesProporcionalesContrato();
                vacaciones.Calcular(cltc, this.NominaTrabajador, null);

                PrimaVacacionalContrato prima = new PrimaVacacionalContrato();
                prima.Calcular(cltc, this.NominaTrabajador, null);

                // Aguinaldo
                Nova.Models.Calculos.Percepciones.Aguinaldo aguinaldo = new Nova.Models.Calculos.Percepciones.Aguinaldo();
                aguinaldo.Calcular(cltc, this.NominaTrabajador, null);


                Nova.Models.Calculos.Percepciones.AjusteDiasCalendario AjusteDiasCalendario = new Nova.Models.Calculos.Percepciones.AjusteDiasCalendario();
                AjusteDiasCalendario.Calcular(cltc, this.NominaTrabajador, null);

                Nova.Models.Calculos.Percepciones.aguinaldoPartesProporcionales aguinaldopp = new Nova.Models.Calculos.Percepciones.aguinaldoPartesProporcionales();
                aguinaldopp.Calcular(cltc, this.NominaTrabajador, null);


                Nova.Models.Calculos.Percepciones.CompensacionGarantizada CompensacionGarantizada = new Nova.Models.Calculos.Percepciones.CompensacionGarantizada();
                CompensacionGarantizada.Calcular(cltc, this.NominaTrabajador, null);

                Nova.Models.Calculos.Percepciones.MedidaBienestar MedidaBienestar = new Nova.Models.Calculos.Percepciones.MedidaBienestar();
                MedidaBienestar.Calcular(cltc, this.NominaTrabajador, null);


                Nova.Models.Calculos.Percepciones.SueldoPartesProporcionales sueldopp = new Nova.Models.Calculos.Percepciones.SueldoPartesProporcionales();
                sueldopp.Calcular(cltc, this.NominaTrabajador, null);


                //DEVOLUCIONES DE FALTAS
                Nova.Models.Calculos.Percepciones.DevolucionesDeFaltasBase devfaltas = new Nova.Models.Calculos.Percepciones.DevolucionesDeFaltasBase();
                devfaltas.Calcular(cltc, this.NominaTrabajador);
            }
        }

        public override void GenerarIncapacidades(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            Nova.Models.Calculos.Deducciones.EnfermedadGeneral enfermedadgeneral = new Nova.Models.Calculos.Deducciones.EnfermedadGeneral();
            enfermedadgeneral.Calcular(cltc, this.NominaTrabajador);

        }
        public override void GenerarDeduccionesRetroactivo(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {

            Nova.Models.Calculos.Deducciones.SDI sdi = new Nova.Models.Calculos.Deducciones.SDI();
            sdi.Calcular(cltc, this.NominaTrabajador);


            Nova.Models.Calculos.Deducciones.ISR isr = new Nova.Models.Calculos.Deducciones.ISR();
            isr.Calcular(cltc, this.NominaTrabajador);





        }
        public override void GenerarDeducciones(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina != "EXTRAORDINARIA")
            {
                Nova.Models.Calculos.Deducciones.FaltasContrato faltas = new Nova.Models.Calculos.Deducciones.FaltasContrato();
                faltas.Calcular(cltc, this.NominaTrabajador);
            }
            Nova.Models.Calculos.Deducciones.DeduccionesPersonalizadas deducionpersonalizada = new Nova.Models.Calculos.Deducciones.DeduccionesPersonalizadas();
            deducionpersonalizada.Calcular(cltc, this.NominaTrabajador);

            Nova.Models.Calculos.Deducciones.SDI sdi = new Nova.Models.Calculos.Deducciones.SDI();
            sdi.Calcular(cltc, this.NominaTrabajador);
            Nova.Models.Calculos.Deducciones.IMSS imss = new Nova.Models.Calculos.Deducciones.IMSS();
            imss.Calcular(cltc, this.NominaTrabajador);

           


            Nova.Models.Calculos.Deducciones.ISR isr = new Nova.Models.Calculos.Deducciones.ISR();
            isr.Calcular(cltc, this.NominaTrabajador);

            
            
           

        }
        //public override void GenerarCreditos(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        //{
        //    Nova.Models.Calculos.Deducciones.Credito cre = new Nova.Models.Calculos.Deducciones.Credito();
        //    cre.Calcular(cltc, this.NominaTrabajador);


        //}
        //public override void GenerarPensiones(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        //{
        //    Nova.Models.Calculos.Deducciones.Pension cre = new Nova.Models.Calculos.Deducciones.Pension();
        //    cre.Calcular(cltc, this.NominaTrabajador);


        //}


        public override void CalcularNomina()
        {
            if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
            {

                this.NominaTrabajador.getPercepcionesRetroactivo();
            }

            NominaTrabajador.HoraInicioProceso = DateTime.Now;
            foreach (var item in this.NominaTrabajador.TrabajadoresVigentes)
            {
                bool CalcularNomina = false;
                if (item.FechaInicioPago != null && item.EsPrimerCalculo)
                {
                    if (item.FechaInicioPago >= this.NominaTrabajador.Nomina_stNomina.FechaInicio
                       && item.FechaInicioPago <= this.NominaTrabajador.Nomina_stNomina.FechaTermino)
                        CalcularNomina = true;
                    else
                        if (item.FechaInicioPago <= this.NominaTrabajador.Nomina_stNomina.FechaInicio
                       && item.EsPrimerCalculo == true)
                        CalcularNomina = true;



                    this.NominaTrabajador.TrabajadoresConCalculoConFechaAnterior.Add(item);
                }
                else
                    CalcularNomina = true;


                if (CalcularNomina)
                {

                    if (this.NominaTrabajador.EsRecalculoPorTrabajador == false)
                        NominaTrabajador.DiasPagados = NominaTrabajador.DiasNomina;

                    
                    int IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                    int IdTrabajador = item.Convenios_stConvenioLaboralTrabajador.IdTrabajador;

                    this.NominaTrabajador.setIncidenciaTrabajador(IdTrabajador);

                    this.NominaTrabajador.setParametrosCreditosTrabajador(IdTrabajador);
                    this.NominaTrabajador.setPensionesTrabajador(IdTrabajador);
                    this.NominaTrabajador.setPercepcionesPersonalizadas(IdConvenioLaboralTrabajadorCategoria, this.NominaTrabajador.Nomina.Nomina_ctPlantillaNomina.IdPeriodoNomina);
                   // this.NominaTrabajador.setDeduccionesPersonalizadas(IdConvenioLaboralTrabajadorCategoria, this.NominaTrabajador.Nomina.Nomina_ctPlantillaNomina.IdPeriodoNomina);

                    //this.NominaTrabajador.setCostoHoraJornada(item.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Plazas_ctCostoHoraJornada.IdCostoHoraJornada);
                    //this.NominaTrabajador.setBimestreAnteriorPagadasTrabajador(IdConvenioLaboralTrabajadorCategoria);


                    if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
                    {

                        NominaTrabajador.GenerarRetroactivo(item);

                        this.GenerarDeduccionesRetroactivo(item);
                        this.GenerarPensiones(item);

                    }
                    else
                    {
                        this.GenerarPercepciones(item);
                        if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina != "EXTRAORDINARIA")
                        {
                            this.NominaTrabajador.GenerarAjustesPerpceciones(item);
                            this.NominaTrabajador.GenerarAjustesSueldosCambioContrato(item);


                            //esta linea debe de ser procesada despues de haber calculado percepciones
                            //y deducciones
                            this.NominaTrabajador.setMaternidadRiesgoTrabajoTrabajador(item);

                            this.GenerarIncapacidades(item);
                        }

                        if (!NominaTrabajador.TrabajadorConIncapacipdadActiva)
                        {
                            this.GenerarDeducciones(item);

                            if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina != "EXTRAORDINARIA")
                            {
                                //ccalcula IMSS diferecnias
                                this.NominaTrabajador.GenerarAjustesPerpceciones(item, true);

                                this.GenerarPensiones(item);
                                this.GenerarCreditos(item);
                                this.NominaTrabajador.CalcularAjusteDeduccionInfonavit(item);
                            }
                            else
                                this.GenerarPensiones(item);
                        }

                        if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina != "EXTRAORDINARIA")
                        {
                            this.NominaTrabajador.AjustesPorBajasSinPago(item);
                        }

                    }
                }
                NominaTrabajador.HoraFinProceso = DateTime.Now;
            }

            GrabarStNominaTrabajador();

        }

        public override void GenerarCreditos(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            Nova.Models.Calculos.Deducciones.Credito cre = new Nova.Models.Calculos.Deducciones.Credito();
            cre.Calcular(cltc, this.NominaTrabajador);


        }
        public override void GenerarPensiones(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            Nova.Models.Calculos.Deducciones.Pension cre = new Nova.Models.Calculos.Deducciones.Pension();
            cre.Calcular(cltc, this.NominaTrabajador);


        }
        public override void GrabarStNominaTrabajador()
        {
            NominaTrabajador.CreditosDelTrabajadorNoAplicados = new List<Creditos_stNominaCreditoTrabajadorNoAplicados>();
            NominaTrabajador.CreditosDelTrabajador = new List<Creditos_stNominaCreditoTrabajador>();
            NominaTrabajador.PercepcionesDelTrabajador = new List<Percepciones_stNominaTrabajadorPercepciones>();
            NominaTrabajador.DeduccionesDelTrabajador = new List<Deducciones_stNominaTrabajadorDeduccion>();
            NominaTrabajador.SubDeduccionesDelTrabajador = new List<Deducciones_stNominaTrabajadorSubDeducciones>();
            //NominaTrabajador.PensionesDelTrabajador = new List<Pensiones_stNominaPensionTrabajador>();




            int contador = 0;

            foreach (var item in NominaTrabajador.TrabajadoresVigentes)
            {

             //   if (NominaTrabajador.ListaPercepcionesTrabajadores.Where(v =>
             //v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && v.Importe > 0).ToList().Count > 0)
             //       NominaTrabajador.AgregarSubsidio(item.IdConvenioLaboralTrabajadorCategoria);

                contador++;
                NominaTrabajador.trabajadornomina = null;
                NominaTrabajador.trabajadornomina = new Nomina_stNominaTrabajador();
                NominaTrabajador.trabajadornomina.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                NominaTrabajador.trabajadornomina.IdNomina = NominaTrabajador.IdNomina;
                NominaTrabajador.trabajadornomina.SueldoBruto = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList());
                NominaTrabajador.trabajadornomina.SueldoTabular = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.Concepto.Contains("SUELDO") && v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList());
                NominaTrabajador.trabajadornomina.PercepcionesAdicionales = (NominaTrabajador.trabajadornomina.SueldoBruto - NominaTrabajador.trabajadornomina.SueldoTabular.Value);


                NominaTrabajador.trabajadornomina.SueldoDiario = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "SUELDO DIARIO" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();
                NominaTrabajador.trabajadornomina.TotalDeducciones = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaDeduccionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList());
                NominaTrabajador.trabajadornomina.SueldoNeto = NominaTrabajador.trabajadornomina.SueldoBruto

                        - NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaDeduccionesTrabajadores.Where(i => i.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList())
                        - NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaCreditosTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList())
                        - NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaPensionesTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList());

                //NominaTrabajador.trabajadornomina.SueldoNeto = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe)

                //    - NominaTrabajador.ListaDeduccionesTrabajadores.Where(i => i.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe)
                //    - NominaTrabajador.ListaCreditosTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe)
                //    - NominaTrabajador.ListaPensionesTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe);

                NominaTrabajador.trabajadornomina.SueldoTransferencia = 0;
                NominaTrabajador.trabajadornomina.SueldoMonedero = 0;
 

                //List<Kardex_stTrabajadorCuentas> ctamonedero = NominaTrabajador.CatalogoKardexTrabajadoresCuentas.Where(w => w.IdTrabajador == item.Convenios_stConvenioLaboralTrabajador.IdTrabajador && w.Catalogos_ctFormaDePago.FormaDePago == "MONEDERO ELECTRÓNICO").OrderByDescending(c => c.IdTrabajadorCuentas).ToList();

                //cayuda = NominaTrabajador.PlantillaNominaPercepciones.Where(g => g.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA DESPENSA" || g.Percepciones_ctPercepcion.Percepcion == "VALES DE DESPENSA").Select(H => H.IdPlantillaNominaPercepcion).ToArray();

                //NominaTrabajador.trabajadornomina.SueldoMonedero = NominaTrabajador.ListaPercepcionesTrabajadores.Where(d => d.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && cayuda.Contains(d.IdPlantillaNominaPercepcion)).Sum(d => d.Importe);


                NominaTrabajador.DiasPagados = (short)NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "DIASLABORADOS" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();
                decimal faltas = NominaTrabajador.ListaVariablesNominaTrabajador.Where(F => F.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && F.Concepto == "FALTAS").Sum(e => e.Importe);
                NominaTrabajador.DiasFaltas = (short)faltas;

                NominaTrabajador.trabajadornomina.DiasPagados = NominaTrabajador.DiasPagados;
                NominaTrabajador.trabajadornomina.DiasEfectivosLaborados = NominaTrabajador.DiasPagados;


                Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == item.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
                if (costos != null)
                {
                    NominaTrabajador.trabajadornomina.CostoPorHora = costos.CostoPorHora;


                }
                NominaTrabajador.trabajadornomina.HorasSemanaMes = 0;
                NominaTrabajador.trabajadornomina.HorasSemanaMesTrabajadas = 0;
                NominaTrabajador.trabajadornomina.HorasTrabajadasExcedentes = 0;
                NominaTrabajador.trabajadornomina.HorasTrabajadasInterinas = 0;
                NominaTrabajador.trabajadornomina.DiasEfectivosLaborados = NominaTrabajador.DiasPagados;
                NominaTrabajador.trabajadornomina.CostoPorHoraExcedente = 0;
                NominaTrabajador.trabajadornomina.CostoPorHorasInterinas = 0;


                //NominaTrabajador.trabajadornomina.HorasEfectivasDeTrabajo = (short)(NominaTrabajador.DiasPagados * costos.CostoPorHora);



                NominaTrabajador.trabajadornomina.SalarioDiarioIntegrado = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "SALARIO DIARIO INTEGRADO" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();

                NominaTrabajador.trabajadornomina.QuinquenioDiario = 0;
                NominaTrabajador.trabajadornomina.MaterialDidacticoDiario = 0;

                var idquinqueniopercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "QUINQUENIO").FirstOrDefault();
                var idpercesueldo = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion.Contains("SUELDO")).Select(z => z.IdPlantillaNominaPercepcion).ToArray();

                decimal sueldobrutosueldo = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && idpercesueldo.Contains(v.IdPlantillaNominaPercepcion)).ToList());


                var hayajustenuevacontrato = NominaTrabajador.ListaVariablesNominaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
               && z.Concepto == "ajustepercepciones").FirstOrDefault();
                if (hayajustenuevacontrato != null)
                {
                    NominaTrabajador.trabajadornomina.DiasDeAjuste = System.Convert.ToInt32(hayajustenuevacontrato.Importe);
                }

                var idperceAjustessueldo = NominaTrabajador.PlantillaNominaPercepciones
                    .Where(x => x.Percepciones_ctPercepcion.Percepcion.Contains("AJUSTE")
                    || x.Percepciones_ctPercepcion.Percepcion.Contains("DEVOLUCIÓN")
                    || x.Percepciones_ctPercepcion.Percepcion.Contains("DIFERENCIA")
                ).Select(z => z.IdPlantillaNominaPercepcion).ToArray();

                decimal difsueldos = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
                && idperceAjustessueldo.Contains(v.IdPlantillaNominaPercepcion)
                && (v.Concepto.Contains("SUELDO") || v.Concepto.Contains("QUINQUENIO"))).ToList());

                decimal restardifsueldos = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaDeduccionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
                && (v.Concepto.Contains("SUELDO") || v.Concepto.Contains("QUINQUENIO"))).ToList());

                sueldobrutosueldo = (sueldobrutosueldo + difsueldos) - restardifsueldos;


                if (idquinqueniopercepcion != null)
                    NominaTrabajador.trabajadornomina.SueldoBrutoQuinquenioDiario = sueldobrutosueldo + NominaTrabajador.ListaPercepcionesTrabajadores.Where(g => g.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && idquinqueniopercepcion.IdPlantillaNominaPercepcion == g.IdPlantillaNominaPercepcion).Sum(r => r.Importe);
                else
                    NominaTrabajador.trabajadornomina.SueldoBrutoQuinquenioDiario = sueldobrutosueldo;

                //NominaTrabajador.trabajadornomina.SumaPercepcionesVariables = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe) - NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && v.EsVariable == true).Sum(f => f.Importe);
                //NominaTrabajador.trabajadornomina.BaseGravable = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "BASE GRAVABLE" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();


                if (NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
                {
                    NominaTrabajador.trabajadornomina.SumaPercepcionesVariables = NominaTrabajador.trabajadornomina.SueldoBruto;
                }
                else
                {
                    NominaTrabajador.trabajadornomina.SumaPercepcionesVariables = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && v.EsVariable == true).ToList());
                }

                NominaTrabajador.trabajadornomina.SalarioBrutoGravable = NominaTrabajador.trabajadornomina.SumaPercepcionesVariables;

                NominaTrabajador.trabajadornomina.BaseGravable = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "BASE GRAVABLE" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();

                if (NominaTrabajador.EsRecalculoPorTrabajador)
                {
                    NominaTrabajador.trabajadornomina.EsMedioRecibo = true;
                    NominaTrabajador.trabajadornomina.IdNominaTrabajadorEstatus = this.NominaTrabajador.IdNominaTrabajadorEstatusRecalculo;
                }

                var trabajadorFechaingreso = NominaTrabajador.QuinquenioTrabajadorAntiguedad.getAntiguedadPorTrabajador(item.Convenios_stConvenioLaboralTrabajador.IdTrabajador);

                NominaTrabajador.trabajadornomina.FechaIngreso = trabajadorFechaingreso.FechaIngreso;
                NominaTrabajador.trabajadornomina.EsAlta = item.EsPrimerCalculo;

                NominaTrabajador.Nomina_stNominaTrabajadorLista.Add(NominaTrabajador.trabajadornomina);


                ///IMSS/////
                var diasqnaimss = NominaTrabajador.ListaVariablesNominaTrabajador.Where(a => a.Concepto == "DiasQuincenaIMSS"
                 && a.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                var diascalendario = (NominaTrabajador.Nomina_stNomina.FechaTermino - NominaTrabajador.Nomina_stNomina.FechaInicio).Days + 1;

                NominaTrabajador.trabajadornomina.DiasRetencion = 0;
                if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO"))
                {
                    if (diasqnaimss != null)
                    {
                        if (diasqnaimss.Importe >= diascalendario)
                            NominaTrabajador.trabajadornomina.DiasRetencion = 0;
                        else
                            NominaTrabajador.trabajadornomina.DiasRetencion = (short)diasqnaimss.Importe;
                    }
                    else
                        NominaTrabajador.trabajadornomina.DiasRetencion = (short)diascalendario;
                }


                var totalDIASIncidencias = NominaTrabajador.ListaVariablesNominaTrabajador.Where(v => v.Concepto == "INCIDENCIA_DIAS_IMSS" && v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
         ).Sum(a => a.Importe);

                NominaTrabajador.trabajadornomina.DiasIncapacidadImss = (short)totalDIASIncidencias;


                var CesantiaVejezTrabajador = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaVariablesNominaTrabajador.Where(v => v.Concepto == "CesantiaVejezTrabajador" && v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
            ).ToList());


                NominaTrabajador.trabajadornomina.Obrero_RCV = CesantiaVejezTrabajador;


                var imss = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaVariablesNominaTrabajador.Where(v => v.Concepto == "deduccionimss" && v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
           ).ToList());


                NominaTrabajador.trabajadornomina.Obrero_IMSS = imss;
                ///IMSS/////
                ///


                var diasfaltas = NominaTrabajador.ListaVariablesNominaTrabajador
   .FirstOrDefault(x => x.Concepto == "TOTAL_FALTAS_QNA"
                    && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria);
                if (diasfaltas != null)
                {
                    NominaTrabajador.trabajadornomina.DiasFaltas = (int)diasfaltas.Importe;
                }

            }
            NominaTrabajador.GrabarNominaBaseDatos();
        }

        public override void CalcularSueldo()
        {



            foreach (var item in this.NominaTrabajador.TrabajadoresVigentes)
            {



                int IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                int IdTrabajador = item.Convenios_stConvenioLaboralTrabajador.IdTrabajador;


                Models.Nomina.VariablesNominaTrabajador diaslaborados = NominaTrabajador.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "DIASLABORADOS").FirstOrDefault();

                NominaTrabajador.ListaVariablesNominaTrabajador.Remove(diaslaborados);
                diaslaborados.Importe = this.NominaTrabajador.DiasNomina;
                NominaTrabajador.ListaVariablesNominaTrabajador.Add(diaslaborados);

                Nova.Models.Calculos.Percepciones.Sueldo sueldo = new Nova.Models.Calculos.Percepciones.Sueldo();
                sueldo.Calcular(item, this.NominaTrabajador, null);

            }



        }
        public override void CalcularEficiencia()
        {
             


            foreach (var item in this.NominaTrabajador.TrabajadoresVigentes)
            {



                int IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                int IdTrabajador = item.Convenios_stConvenioLaboralTrabajador.IdTrabajador;


                Models.Nomina.VariablesNominaTrabajador diaslaborados = NominaTrabajador.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "DIASLABORADOS").FirstOrDefault();

                NominaTrabajador.ListaVariablesNominaTrabajador.Remove(diaslaborados);
                diaslaborados.Importe = this.NominaTrabajador.DiasNomina;
                NominaTrabajador.ListaVariablesNominaTrabajador.Add(diaslaborados);

                Nova.Models.Calculos.Percepciones.EficienciaTrabajo sueldo = new Nova.Models.Calculos.Percepciones.EficienciaTrabajo();
                sueldo.Calcular(item, this.NominaTrabajador, null);

            }



        }


        public override void CalcularAyudaDespensa()
        {
            


            foreach (var item in this.NominaTrabajador.TrabajadoresVigentes)
            {



                int IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                int IdTrabajador = item.Convenios_stConvenioLaboralTrabajador.IdTrabajador;

                this.NominaTrabajador.setParametrosCreditosTrabajador(IdTrabajador);
                this.NominaTrabajador.setPensionesTrabajador(IdTrabajador);

                Models.Nomina.VariablesNominaTrabajador diaslaborados = NominaTrabajador.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "DIASLABORADOS").FirstOrDefault();

                NominaTrabajador.ListaVariablesNominaTrabajador.Remove(diaslaborados);
                diaslaborados.Importe = this.NominaTrabajador.DiasNomina;
                NominaTrabajador.ListaVariablesNominaTrabajador.Add(diaslaborados);



                Nova.Models.Calculos.Percepciones.AyudaDespensa Ayuda = new Nova.Models.Calculos.Percepciones.AyudaDespensa();
                Ayuda.Calcular(item, this.NominaTrabajador, null);

            }



        }




    }
}