﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;
using Nova.Models.Calculos.Percepciones;
using Nova.Models.Calculos.Deducciones;
using System.Transactions;

namespace Nova.Models.Calculos
{
    public class NominaBaseRetroactivo : Nomina
    {
        private Nomina_stNominaTrabajador NominaTrabajador;

        private bdNovaEntities bd = new bdNovaEntities();
        //{
        public NominaBaseRetroactivo(Nomina_stNominaTrabajador Nt)
        {
            NominaTrabajador = Nt;
        }

        public override void GenerarPercepciones(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            short numeropercepcuiones = 7;
            if (NominaTrabajador.PlantillaNominaPercepciones.Count() < numeropercepcuiones)
            {
                throw new Exception("Error en el proceso: Faltan percepciones en la plantilla de retroactivo base ");
            }
            //SUELDO 
            Nova.Models.Calculos.Percepciones.PercepcionRetroactivoPorcentaje sueldo = new Nova.Models.Calculos.Percepciones.PercepcionRetroactivoPorcentaje();
            sueldo.Calcular(cltc, this.NominaTrabajador,"SUELDO");
            //QUINQUENIO RETRO
            PercepcionRetroactivoPorcentaje quinquenio = new PercepcionRetroactivoPorcentaje();
            quinquenio.Calcular(cltc, this.NominaTrabajador,"QUINQUENIO");
            ////Prima vacacional
            PercepcionRetroactivoPorcentaje primavacacional = new PercepcionRetroactivoPorcentaje();
            primavacacional.Calcular(cltc, this.NominaTrabajador, "PRIMA VACACIONAL");
            //Onomástico
            PercepcionRetroactivoPorcentaje onomastico = new PercepcionRetroactivoPorcentaje();
            onomastico.Calcular(cltc, this.NominaTrabajador,"ONOMÁSTICO");
            //Día del empleado 
            PercepcionRetroactivoPorcentaje diaempleado = new PercepcionRetroactivoPorcentaje();
            diaempleado.Calcular(cltc, this.NominaTrabajador, "DÍA DEL EMPLEADO CECyTE");
            //Día stscecyteo
            PercepcionRetroactivoPorcentaje diastscecyteo = new PercepcionRetroactivoPorcentaje();
            diastscecyteo.Calcular(cltc, this.NominaTrabajador, "ANIVERSARIO DEL SINDICATO CECyTEO");
            //PuntualidadAsistencia
            PercepcionRetroactivoPorcentaje puntualidadasistencia = new PercepcionRetroactivoPorcentaje();
            puntualidadasistencia.Calcular(cltc, this.NominaTrabajador, "ESTÍMULO POR PUNTUALIDAD Y ASISTENCIA");
            ////Puntualidad
            //PercepcionRetroactivoPorcentaje cuotasindical = new PercepcionRetroactivoPorcentaje();
            //cuotasindical.Calcular(cltc, this.NominaTrabajador, "CUOTA SINDICAL");

            

            



        }

        public override void GenerarDeducciones(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            //Nova.Models.Calculos.Deducciones.EnfermedadGeneral enfermedadgeneral = new Nova.Models.Calculos.Deducciones.EnfermedadGeneral();
            //enfermedadgeneral.Calcular(cltc, this.NominaTrabajador);

            //Nova.Models.Calculos.Deducciones.RiesgoTrabajo incapacidad = new Nova.Models.Calculos.Deducciones.RiesgoTrabajo();
            //incapacidad.Calcular(cltc, this.NominaTrabajador);

            //Nova.Models.Calculos.Deducciones.Faltas faltas = new Nova.Models.Calculos.Deducciones.Faltas();
            //faltas.Calcular(cltc, this.NominaTrabajador);

            //Nova.Models.Calculos.Deducciones.SDI sdi = new Nova.Models.Calculos.Deducciones.SDI();
            //sdi.Calcular(cltc, this.NominaTrabajador);
            //Nova.Models.Calculos.Deducciones.IMSS imss = new Nova.Models.Calculos.Deducciones.IMSS();
            //imss.Calcular(cltc, this.NominaTrabajador);
            //Nova.Models.Calculos.Deducciones.ISRRETROACTIVO isr = new Nova.Models.Calculos.Deducciones.ISRRETROACTIVO();
            //isr.Calcular(cltc, this.NominaTrabajador);


        }
        //public override void GenerarCreditos(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        //{
        //    Nova.Models.Calculos.Deducciones.Credito cre = new Nova.Models.Calculos.Deducciones.Credito();
        //    cre.Calcular(cltc, this.NominaTrabajador);


        //}
        public override void GenerarPensiones(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            Nova.Models.Calculos.Deducciones.Pension cre = new Nova.Models.Calculos.Deducciones.Pension();
            cre.Calcular(cltc, this.NominaTrabajador);


        }


        public override void CalcularNomina()
        {
            foreach (var item in this.NominaTrabajador.TrabajadoresVigentes)
            {

                this.GenerarPercepciones(item);
                this.GenerarDeducciones(item);
                //this.GenerarCreditos(item);
                this.GenerarPensiones(item);
            }

            GrabarNomina();
        }
        public override void GrabarStNominaTrabajador()
        {
            foreach (var item in NominaTrabajador.TrabajadoresVigentes)
            {
                NominaTrabajador.trabajadornomina = null;
                NominaTrabajador.trabajadornomina = new Nomina_stNominaTrabajador();
                NominaTrabajador.trabajadornomina.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                NominaTrabajador.trabajadornomina.IdNomina = NominaTrabajador.IdNomina;
                NominaTrabajador.trabajadornomina.SueldoBruto = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe);
                NominaTrabajador.trabajadornomina.SueldoDiario = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "SUELDO DIARIO" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();

                NominaTrabajador.trabajadornomina.SueldoNeto = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe)

                    - NominaTrabajador.ListaDeduccionesTrabajadores.Where(i => i.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe)
                    - NominaTrabajador.ListaCreditosTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe)
                    - NominaTrabajador.ListaPensionesTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe);

                NominaTrabajador.trabajadornomina.SueldoTransferencia = 0;
                NominaTrabajador.trabajadornomina.SueldoMonedero = 0;
                List<Kardex_stTrabajadorCuentas> cta = NominaTrabajador.CatalogoKardexTrabajadorCuentas.Where(w => w.EsVigente && w.Catalogos_ctFormaDePago.FormaDePago == "TRANSFERENCIA ELECTRÓNICA").OrderByDescending(c => c.IdTrabajadorCuentas).ToList();

                if (cta.Count > 0)
                {
                    var cayuda = bd.Percepciones_stPlantillaNominaPercepciones.Where(g => g.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA DESPENSA" || g.Percepciones_ctPercepcion.Percepcion == "VALES DE DESPENSA").Select(H => H.IdPlantillaNominaPercepcion).ToArray();

                    decimal vales = NominaTrabajador.ListaPercepcionesTrabajadores.Where(d => d.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && cayuda.Contains(d.IdPlantillaNominaPercepcion)).Sum(d => d.Importe);

                    NominaTrabajador.trabajadornomina.SueldoTransferencia = NominaTrabajador.trabajadornomina.SueldoNeto - vales;
                    NominaTrabajador.trabajadornomina.IdTrabajadorCuentasTransferencia = cta.FirstOrDefault().IdTrabajadorCuentas;

                }

                List<Kardex_stTrabajadorCuentas> ctamonedero = NominaTrabajador.CatalogoKardexTrabajadorCuentas.Where(w => w.EsVigente && w.Catalogos_ctFormaDePago.FormaDePago == "MONEDERO").OrderByDescending(c => c.IdTrabajadorCuentas).ToList();
                if (ctamonedero.Count > 0)
                {
                    var cayuda = bd.Percepciones_stPlantillaNominaPercepciones.Where(g => g.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA DESPENSA" || g.Percepciones_ctPercepcion.Percepcion == "VALES DE DESPENSA").Select(H => H.IdPlantillaNominaPercepcion).ToArray();

                    NominaTrabajador.trabajadornomina.SueldoMonedero = NominaTrabajador.ListaPercepcionesTrabajadores.Where(d => d.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && cayuda.Contains(d.IdPlantillaNominaPercepcion)).Sum(d => d.Importe);
                    NominaTrabajador.trabajadornomina.IdTrabajadorCuentasMonedero = ctamonedero.FirstOrDefault().IdTrabajadorCuentas;
                }

                NominaTrabajador.trabajadornomina.HorasSemanaMes = 0;
                NominaTrabajador.trabajadornomina.HorasSemanaMesTrabajadas = 0;
                NominaTrabajador.trabajadornomina.HorasTrabajadasExcedentes = 0;
                NominaTrabajador.trabajadornomina.HorasTrabajadasInterinas = 0;
                NominaTrabajador.trabajadornomina.DiasEfectivosLaborados = NominaTrabajador.DiasPagados;

                Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == item.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
         
                NominaTrabajador.trabajadornomina.CostoPorHora = costos.CostoPorHora;
                NominaTrabajador.trabajadornomina.CostoPorHoraExcedente = 0;
                NominaTrabajador.trabajadornomina.CostoPorHorasInterinas = 0;


                NominaTrabajador.trabajadornomina.HorasEfectivasDeTrabajo = (short)(NominaTrabajador.DiasPagados * costos.CostoPorHora);



                NominaTrabajador.trabajadornomina.SalarioDiarioIntegrado = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "SALARIO DIARIO INTEGRADO" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();

                NominaTrabajador.trabajadornomina.QuinquenioDiario = 0;
                NominaTrabajador.trabajadornomina.MaterialDidacticoDiario = 0;

                

                var idquinqueniopercepcion= NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "QUINQUENIO").FirstOrDefault();
                if (idquinqueniopercepcion!=null)
                NominaTrabajador.trabajadornomina.SueldoBrutoQuinquenioDiario = NominaTrabajador.trabajadornomina.SueldoBruto+ NominaTrabajador.ListaPercepcionesTrabajadores.Where(g=> g.IdConvenioLaboralTrabajadorCategoria==item.IdConvenioLaboralTrabajadorCategoria && idquinqueniopercepcion.IdPlantillaNominaPercepcion==g.IdPlantillaNominaPercepcion).Sum(r=> r.Importe);
                else
                NominaTrabajador.trabajadornomina.SueldoBrutoQuinquenioDiario = NominaTrabajador.trabajadornomina.SueldoBruto;

                

                NominaTrabajador.trabajadornomina.SumaPercepcionesVariables = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe) - NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && v.EsVariable == true).Sum(f => f.Importe);
                NominaTrabajador.trabajadornomina.BaseGravable = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "BASE GRAVABLE" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();

                

                NominaTrabajador.trabajadornomina.HorasEfectivasDeTrabajo = (short)(NominaTrabajador.trabajadornomina.DiasEfectivosLaborados * costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo);
                

                bd.Nomina_stNominaTrabajador.Add(NominaTrabajador.trabajadornomina);
                bd.SaveChanges();

                GrabarPercepciones();
                GrabarDeducciones();
                GrabarCreditos();
                GrabarPensiones();
            }
        }

        public override void GrabarPercepciones()
        {


            foreach (var item in NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == NominaTrabajador.trabajadornomina.IdConvenioLaboralTrabajadorCategoria))
            {
                Percepciones_stNominaTrabajadorPercepciones per = new Percepciones_stNominaTrabajadorPercepciones();
                per.IdNominaTrabajador = NominaTrabajador.trabajadornomina.IdNominaTrabajador;
                per.IdPlantillaNominaPercepcion = item.IdPlantillaNominaPercepcion;
                per.Importe = item.Importe;
                bd.Percepciones_stNominaTrabajadorPercepciones.Add(per);
                bd.SaveChanges();

            }




        }
        public override void GrabarDeducciones()
        {


            foreach (var item in NominaTrabajador.ListaDeduccionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == NominaTrabajador.trabajadornomina.IdConvenioLaboralTrabajadorCategoria))
            {
                Deducciones_stNominaTrabajadorDeduccion dec = new Deducciones_stNominaTrabajadorDeduccion();
                dec.IdNominaTrabajador = NominaTrabajador.trabajadornomina.IdNominaTrabajador;
                dec.IdPlantillaNominaDeduccion = item.IdPlantillaNominaDeduccion;
                dec.EsImprimibleRecibo = item.EsImprimibleRecibo;

                dec.Importe = item.Importe;
                bd.Deducciones_stNominaTrabajadorDeduccion.Add(dec);
                bd.SaveChanges();

                if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Deducciones_stPlantillaNominaDeducciones.Where(f => f.IdPlantillaNominaDeduccion == item.IdPlantillaNominaDeduccion && f.Deducciones_ctDeduccion.Deduccion == "IMSS").FirstOrDefault() != null)
                {
                    foreach (var ele in NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == NominaTrabajador.trabajadornomina.IdConvenioLaboralTrabajadorCategoria && v.IdPlantillaNominaDeduccion == item.IdPlantillaNominaDeduccion))
                    {
                        Deducciones_stNominaTrabajadorSubDeducciones sub = new Deducciones_stNominaTrabajadorSubDeducciones();
                        sub.IdNominaTrabajadorDeduccion = dec.IdNominaTrabajadorDeduccion;
                        sub.IdSubDeduccion = ele.IdSubDeduccion;
                        sub.Importe = ele.Importe;
                        bd.Deducciones_stNominaTrabajadorSubDeducciones.Add(sub);
                        bd.SaveChanges();

                    }
                }

            }




        }
        public override void GrabarCreditos()
        {


            foreach (var item in NominaTrabajador.ListaCreditosTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == NominaTrabajador.trabajadornomina.IdConvenioLaboralTrabajadorCategoria))
            {
                Creditos_stNominaCreditoTrabajador cr = new Creditos_stNominaCreditoTrabajador();
                cr.IdCreditoTrabajador = item.IdCreditoTrabajador;
                cr.IdNominaTrabajador = NominaTrabajador.trabajadornomina.IdNominaTrabajador;
                cr.Importe = item.Importe;
                bd.Creditos_stNominaCreditoTrabajador.Add(cr);
                bd.SaveChanges();

            }




        }

        public override void GrabarPensiones()
        {


            foreach (var item in NominaTrabajador.ListaPensionesTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == NominaTrabajador.trabajadornomina.IdConvenioLaboralTrabajadorCategoria))
            {
                Pensiones_stNominaPensionTrabajador pen = new Pensiones_stNominaPensionTrabajador();
                pen.IdNominaTrabajador = NominaTrabajador.trabajadornomina.IdNominaTrabajador;
                pen.IdPensionTrabajador = item.IdPensionTrabajador;
                pen.Importe = item.Importe;
                bd.Pensiones_stNominaPensionTrabajador.Add(pen);
                bd.SaveChanges();

            }




        }
        public override void BorrarNomina(int idn, int idconveniolaboraltrabajadorcategoria = 0)
        {
            bdNovaEntities datos = new bdNovaEntities();


            List<PersonalNomina> trabajadoresUni = datos.Nomina_stNominaTrabajador.Where(z => z.IdNomina == idn && z.Nomina_stNomina.EsCerrada == false).Select(x => new PersonalNomina { IdNominaTrabajador = x.IdNominaTrabajador }).ToList();

            if (idconveniolaboraltrabajadorcategoria > 0)
                trabajadoresUni = datos.Nomina_stNominaTrabajador.Where(z => z.IdNomina == idn && z.Nomina_stNomina.EsCerrada == false && z.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == idconveniolaboraltrabajadorcategoria).Select(x => new PersonalNomina { IdNominaTrabajador = x.IdNominaTrabajador }).ToList();
            if (trabajadoresUni.Count() > 0)
            {
                var trabajadores = trabajadoresUni.Select(r => r.IdNominaTrabajador).ToArray();
                List<Pensiones_stNominaPensionTrabajador> pt = datos.Pensiones_stNominaPensionTrabajador.Where(z => trabajadores.Contains(z.IdNominaTrabajador)).ToList();
                datos.Pensiones_stNominaPensionTrabajador.RemoveRange(pt);
                List<Creditos_stNominaCreditoTrabajador> crent = datos.Creditos_stNominaCreditoTrabajador.Where(z => trabajadores.Contains(z.IdNominaTrabajador)).ToList();
                datos.Creditos_stNominaCreditoTrabajador.RemoveRange(crent);
                // incluir subdeducciones
                List<Deducciones_stNominaTrabajadorDeduccion> deduc = datos.Deducciones_stNominaTrabajadorDeduccion.Where(z => trabajadores.Contains(z.IdNominaTrabajador)).ToList();
                datos.Deducciones_stNominaTrabajadorDeduccion.RemoveRange(deduc);
                List<Percepciones_stNominaTrabajadorPercepcionesPersonalizadas> peper = datos.Percepciones_stNominaTrabajadorPercepcionesPersonalizadas.Where(z => trabajadores.Contains(z.IdNominaTrabajador)).ToList();
                datos.Percepciones_stNominaTrabajadorPercepcionesPersonalizadas.RemoveRange(peper);

                //datos.SaveChanges();
                List<Percepciones_stNominaTrabajadorPercepciones> pert = datos.Percepciones_stNominaTrabajadorPercepciones.Where(z => trabajadores.Contains(z.IdNominaTrabajador)).ToList();
                datos.Percepciones_stNominaTrabajadorPercepciones.RemoveRange(pert);
                //datos.SaveChanges();
                //datos.SaveChanges();
                List<Nomina_stNominaTrabajador> not = datos.Nomina_stNominaTrabajador.Where(z => trabajadores.Contains(z.IdNominaTrabajador)).ToList();
                datos.Nomina_stNominaTrabajador.RemoveRange(not);
                List<Deducciones_stNominaTrabajadorSubDeducciones> subt = datos.Deducciones_stNominaTrabajadorSubDeducciones.Where(z => trabajadores.Contains(z.Deducciones_stNominaTrabajadorDeduccion.IdNominaTrabajador)).ToList();
                datos.Deducciones_stNominaTrabajadorSubDeducciones.RemoveRange(subt);

                datos.SaveChanges();
            }

        }

        public override void GrabarNomina()
        {
            TransactionOptions transactionoptions1 = new TransactionOptions();
            transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
            {
                BorrarNomina(NominaTrabajador.IdNomina, Convert.ToInt16(HttpContext.Current.Session["IdConvenioLaboralTrabajadorCategoria"]));
                GrabarStNominaTrabajador();
                scope.Complete();
            }



        }

    }
}
