﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;
using Nova.Models.Calculos.Percepciones;
using Nova.Models.Calculos.Deducciones;
using System.Transactions;
using EntityFramework.BulkInsert.Extensions;

namespace Nova.Models.Calculos
{
    public class NominaBaseDefinitivo : Nomina
    {
        private Nomina_stNominaTrabajador NominaTrabajador;

        private bdNovaEntities bd = new bdNovaEntities();
        //{
        public NominaBaseDefinitivo(Nomina_stNominaTrabajador Nt)
        {
            NominaTrabajador = Nt;
        }

        //public override void GenerarRetroactivo(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        //{





        //    foreach (var item in this.NominaTrabajador.ListaPercepcionesRetroActivoTrabajador.Where(w => w.IdConvenioLaboralTrabajadorCategoria == cltc.IdConvenioLaboralTrabajadorCategoria))
        //    {

        //        Nova.Models.Nomina.PercepcionesNominaTrabajador percepcion = new Nova.Models.Nomina.PercepcionesNominaTrabajador();

        //        percepcion.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
        //        percepcion.IdNomina = NominaTrabajador.IdNomina;
        //        percepcion.IdPlantillaNominaPercepcion = item.IdPlantillaNominaPercepcion;


        //        if (item.ImporteRetroActivo > 0)
        //            percepcion.Importe = item.ImporteRetroActivo * item.TotalQuincenas;
        //        else
        //            percepcion.Importe = item.Importe * item.PorcentajeRetroActivo;


        //        percepcion.Tipo = "NORMAL";
        //        percepcion.EsGrabable = item.EsGravable;

        //        percepcion.EsVariable = item.EsVariable;
        //        percepcion.EsPrevisionSocial = item.EsPrevisionSocial; ;


        //        NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);
        //    }

        //    Nova.Models.Calculos.Deducciones.ISRRETROACTIVO isr = new Nova.Models.Calculos.Deducciones.ISRRETROACTIVO();
        //    isr.Calcular(cltc, this.NominaTrabajador);

        //    Nova.Models.Calculos.Deducciones.Pension cre = new Nova.Models.Calculos.Deducciones.Pension();
        //    cre.Calcular(cltc, this.NominaTrabajador);


        //}

        public override void GenerarPermisos(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            //SUELDO 
            Nova.Models.Calculos.Deducciones.PermisoSinGoceSueldoBase permiso = new Nova.Models.Calculos.Deducciones.PermisoSinGoceSueldoBase();
            permiso.Calcular(cltc, this.NominaTrabajador);

            //Nova.Models.Calculos.Deducciones.RiesgoTrabajo incapacidad = new Nova.Models.Calculos.Deducciones.RiesgoTrabajo();
            //incapacidad.Calcular(cltc, this.NominaTrabajador);

            //Nova.Models.Calculos.Deducciones.Maternidad maternidad = new Nova.Models.Calculos.Deducciones.Maternidad();
            //maternidad.Calcular(cltc, this.NominaTrabajador);


        }
        public override void GenerarPercepciones(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina != "EXTRAORDINARIA")
            {
                //SUELDO 
                Nova.Models.Calculos.Percepciones.Sueldo sueldo = new Nova.Models.Calculos.Percepciones.Sueldo();
                sueldo.Calcular(cltc, this.NominaTrabajador, null);



                //QUINQUENIO
                Quinquenio quinquenio = new Quinquenio();
                quinquenio.Calcular(cltc, this.NominaTrabajador, null);

                ////EFICIENCIA EN EL TRABAJO

                EficienciaTrabajo eficienciaTrabajo = new EficienciaTrabajo();
                eficienciaTrabajo.Calcular(cltc, this.NominaTrabajador, null);



                // AYUDA PARA DESPENSA
                Nova.Models.Calculos.Percepciones.AyudaDespensa ayudadespensa = new Nova.Models.Calculos.Percepciones.AyudaDespensa();
                ayudadespensa.Calcular(cltc, this.NominaTrabajador, null);

               

            }
            //PERCEPCIONES PERSONALIZADAS (GASTO ADMINISTRATIVO || NÓMINA RDL || ZONA MARGINAL 
                Nova.Models.Calculos.Percepciones.PercepcionPersonalizada percepcionpersonalizada = new Nova.Models.Calculos.Percepciones.PercepcionPersonalizada();
                percepcionpersonalizada.Calcular(cltc, this.NominaTrabajador, "", null);

            if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina != "EXTRAORDINARIA")
            {
                //GUARDERIA
                Guarderia guarderia = new Guarderia();
                guarderia.Calcular(cltc, this.NominaTrabajador, null);





                PremioAntiguedad premioantiguedad = new PremioAntiguedad();
                premioantiguedad.Calcular(cltc, this.NominaTrabajador, null);

                EstimuloAntiguedad estimuloantiguedad = new EstimuloAntiguedad();
                estimuloantiguedad.Calcular(cltc, this.NominaTrabajador, null);

                // se debe de calcular primero el SALARIO DIARIO
                PrimaVacacionalBase prima = new PrimaVacacionalBase();
                prima.Calcular(cltc, this.NominaTrabajador, null);

                PrimaDominicalBase primaDominical = new PrimaDominicalBase();
                primaDominical.Calcular(cltc, this.NominaTrabajador, null);

                DiasDescansoBase diasdescanso = new DiasDescansoBase();
                diasdescanso.Calcular(cltc, this.NominaTrabajador, null);


                DiasEconomicos DiasEconomicos = new DiasEconomicos();
                DiasEconomicos.Calcular(cltc, this.NominaTrabajador, null);



                PrestacionesAdicionales adicionales = new PrestacionesAdicionales();
                adicionales.Calcular(cltc, this.NominaTrabajador, null);



                Nova.Models.Calculos.Percepciones.PuntualidadyAsistencia puntualidad = new Nova.Models.Calculos.Percepciones.PuntualidadyAsistencia();
                puntualidad.Calcular(cltc, this.NominaTrabajador, null);

                // Aguinaldo
                Nova.Models.Calculos.Percepciones.Aguinaldo aguinaldo = new Nova.Models.Calculos.Percepciones.Aguinaldo();
                aguinaldo.Calcular(cltc, this.NominaTrabajador, null);

               
                Nova.Models.Calculos.Percepciones.AjusteDiasCalendario AjusteDiasCalendario = new Nova.Models.Calculos.Percepciones.AjusteDiasCalendario();
                AjusteDiasCalendario.Calcular(cltc, this.NominaTrabajador, null);

                Nova.Models.Calculos.Percepciones.aguinaldoPartesProporcionales aguinaldopp = new Nova.Models.Calculos.Percepciones.aguinaldoPartesProporcionales();
                aguinaldopp.Calcular(cltc, this.NominaTrabajador, null);

                Nova.Models.Calculos.Percepciones.PrimaAntiguedad primaantiguedad = new Nova.Models.Calculos.Percepciones.PrimaAntiguedad();
                primaantiguedad.Calcular(cltc, this.NominaTrabajador, null);

                Nova.Models.Calculos.Percepciones.VacacionesPartesProporcionales vacaciones = new Nova.Models.Calculos.Percepciones.VacacionesPartesProporcionales();
                vacaciones.Calcular(cltc, this.NominaTrabajador, null);


                Nova.Models.Calculos.Percepciones.DiasDeDescansoObligatorio diasobligatorio = new Nova.Models.Calculos.Percepciones.DiasDeDescansoObligatorio();
                diasobligatorio.Calcular(cltc, this.NominaTrabajador, null);


                Nova.Models.Calculos.Percepciones.CompensacionGarantizada CompensacionGarantizada = new Nova.Models.Calculos.Percepciones.CompensacionGarantizada();
                CompensacionGarantizada.Calcular(cltc, this.NominaTrabajador, null);

                Nova.Models.Calculos.Percepciones.MedidaBienestar MedidaBienestar = new Nova.Models.Calculos.Percepciones.MedidaBienestar();
                MedidaBienestar.Calcular(cltc, this.NominaTrabajador, null);

                //DEVOLUCIONES DE FALTAS
                Nova.Models.Calculos.Percepciones.DevolucionesDeFaltasBase devfaltas = new Nova.Models.Calculos.Percepciones.DevolucionesDeFaltasBase();
                devfaltas.Calcular(cltc, this.NominaTrabajador);
            }
        }

        public override void GenerarIncapacidades(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            Nova.Models.Calculos.Deducciones.EnfermedadGeneral enfermedadgeneral = new Nova.Models.Calculos.Deducciones.EnfermedadGeneral();
            enfermedadgeneral.Calcular(cltc, this.NominaTrabajador);

        }

        public override void GenerarDeduccionesRetroactivo(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {

            Nova.Models.Calculos.Deducciones.SDI sdi = new Nova.Models.Calculos.Deducciones.SDI();
            sdi.Calcular(cltc, this.NominaTrabajador);


            Nova.Models.Calculos.Deducciones.ISR isr = new Nova.Models.Calculos.Deducciones.ISR();
            isr.Calcular(cltc, this.NominaTrabajador);





        }
        public override void GenerarDeducciones(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina != "EXTRAORDINARIA")
            {

                Nova.Models.Calculos.Deducciones.FaltasBase faltas = new Nova.Models.Calculos.Deducciones.FaltasBase();
                faltas.Calcular(cltc, this.NominaTrabajador);

                Nova.Models.Calculos.Deducciones.DescuentosDiasEconomicosYPuntualidad dia = new Nova.Models.Calculos.Deducciones.DescuentosDiasEconomicosYPuntualidad();
                dia.Calcular(cltc, this.NominaTrabajador);

                Nova.Models.Calculos.Deducciones.DescuentosPuntualidad puntualidad = new Nova.Models.Calculos.Deducciones.DescuentosPuntualidad();
                puntualidad.Calcular(cltc, this.NominaTrabajador);
            }


            Nova.Models.Calculos.Deducciones.DeduccionesPersonalizadas deducionpersonalizada = new Nova.Models.Calculos.Deducciones.DeduccionesPersonalizadas();
            deducionpersonalizada.Calcular(cltc, this.NominaTrabajador);
         
            Nova.Models.Calculos.Deducciones.SDI sdi = new Nova.Models.Calculos.Deducciones.SDI();
            sdi.Calcular(cltc, this.NominaTrabajador);
            Nova.Models.Calculos.Deducciones.IMSS imss = new Nova.Models.Calculos.Deducciones.IMSS();
            imss.Calcular(cltc, this.NominaTrabajador);


            Nova.Models.Calculos.Deducciones.ISR isr = new Nova.Models.Calculos.Deducciones.ISR();
            isr.Calcular(cltc, this.NominaTrabajador);









        }
        public override void GenerarCreditos(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            Nova.Models.Calculos.Deducciones.Credito cre = new Nova.Models.Calculos.Deducciones.Credito();
            cre.Calcular(cltc, this.NominaTrabajador);


        }
        public override void GenerarPensiones(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            Nova.Models.Calculos.Deducciones.Pension cre = new Nova.Models.Calculos.Deducciones.Pension();
            cre.Calcular(cltc, this.NominaTrabajador);


        }


        public override void CalcularNomina()
        {
            int Y = 0;

            if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
            {

                this.NominaTrabajador.getPercepcionesRetroactivo();
            }

            foreach (var Trabajador in this.NominaTrabajador.TrabajadoresVigentes)
            {
                bool CalcularNomina = false;


                if (Trabajador.FechaInicioPago != null && Trabajador.EsPrimerCalculo)
                {
                    if (Trabajador.FechaInicioPago >= this.NominaTrabajador.Nomina_stNomina.FechaInicio
                       && Trabajador.FechaInicioPago <= this.NominaTrabajador.Nomina_stNomina.FechaTermino)
                        CalcularNomina = true;
                    else
                        if (Trabajador.FechaInicioPago <= this.NominaTrabajador.Nomina_stNomina.FechaInicio
                       && Trabajador.EsPrimerCalculo == true)
                        CalcularNomina = true;



                    this.NominaTrabajador.TrabajadoresConCalculoConFechaAnterior.Add(Trabajador);
                }
                else
                    CalcularNomina = true;


                if (CalcularNomina)
                {

                    //try
                    //{
                    Y++;
                    //Console.WriteLine("Inicio TRABAJADOR "+Y+" " + DateTime.Now + " ** ");

                    if (this.NominaTrabajador.EsRecalculoPorTrabajador == false)
                        NominaTrabajador.DiasPagados = NominaTrabajador.DiasNomina;


                    int IdConvenioLaboralTrabajadorCategoria = Trabajador.IdConvenioLaboralTrabajadorCategoria;
                    int IdTrabajador = Trabajador.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                    //  HttpContext.Current.Session["IdTrabajador"] = IdTrabajador;
                    //short IdJornadaLaboral = Trabajador.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Plazas_ctCostoHoraJornada.IdJornadaLaboral;
                    //short IdCostoHoraJornada = Trabajador.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCostoHoraJornada;



                    /////////////////////////////////////////////////

                    //this.setConvenioLaboralTrabajador(IdTrabajador);
                    //     this.NominaTrabajador.setCostoHoraJornada(IdCostoHoraJornada);
                    this.NominaTrabajador.setIncidenciaTrabajador(IdTrabajador);

                    //   this.NominaTrabajador.DiasEfectivosLaborados = this.NominaTrabajador.ObtenDiasIncidenciasTrabajador();

                    //  this.NominaTrabajador.setJornadaLaboral(IdJornadaLaboral);

                    //this.setNominaTrabajadorPercepciones(IdTrabajador);
                    this.NominaTrabajador.setParametrosCreditosTrabajador(IdTrabajador);
                    this.NominaTrabajador.setPensionesTrabajador(IdTrabajador);
                    this.NominaTrabajador.setPercepcionesPersonalizadas(IdConvenioLaboralTrabajadorCategoria, this.NominaTrabajador.Nomina.Nomina_ctPlantillaNomina.IdPeriodoNomina);
                    //this.NominaTrabajador.setDeduccionesPersonalizadas(IdConvenioLaboralTrabajadorCategoria, this.NominaTrabajador.Nomina.Nomina_ctPlantillaNomina.IdPeriodoNomina);
                    //this.setCatalogoKardexTrabajadorCuentas(IdTrabajador);
                    //this.setTrabajador(IdConvenioLaboralTrabajadorCategoria);
                    //this.NominaTrabajador.setBimestreAnteriorPagadasTrabajador(IdConvenioLaboralTrabajadorCategoria);


                    //}
                    //catch (Exception e)
                    //{
                    //    throw new InvalidProgramException(e.Message);

                    //}

                    if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
                    {

                        NominaTrabajador.GenerarRetroactivo(Trabajador);

                        this.GenerarDeduccionesRetroactivo(Trabajador);
                        this.GenerarPensiones(Trabajador);

                    }
                    else
                    {

                        this.GenerarPermisos(Trabajador);
                        this.GenerarPercepciones(Trabajador);
                        if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina != "EXTRAORDINARIA")
                        {
                            this.NominaTrabajador.GenerarAjustesPerpceciones(Trabajador);
                            this.NominaTrabajador.CalcularAjustePercepcionesLicencias(Trabajador);

                            this.NominaTrabajador.GenerarAjustesSueldosCambioContrato(Trabajador);
                            this.NominaTrabajador.AjustesPorBajasSinPago(Trabajador);

                            //esta linea debe de ser procesada despues de haber calculado percepciones
                            this.NominaTrabajador.setMaternidadRiesgoTrabajoTrabajador(Trabajador);
                            this.GenerarIncapacidades(Trabajador);
                            }
                            if (!NominaTrabajador.TrabajadorConIncapacipdadActiva)
                            {
                                this.GenerarDeducciones(Trabajador);
                            if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina != "EXTRAORDINARIA")
                            {
                                //ccalcula IMSS diferecnias
                                this.NominaTrabajador.GenerarAjustesPerpceciones(Trabajador, true);
                                this.NominaTrabajador.CalcularAjusteDeduccionesLicenciasUHorasEntreHorarios(Trabajador);


                                this.GenerarPensiones(Trabajador);
                                this.GenerarCreditos(Trabajador);

                                this.NominaTrabajador.CalcularAjusteDeduccionInfonavit(Trabajador);
                            }
                            else
                                this.GenerarPensiones(Trabajador);
                        }
                         

                    }
                }
                //Console.WriteLine("FIN TRABAJADOR " +  DateTime.Now + " ** ");
            }

            GrabarStNominaTrabajador();
        }


        //public override void GenerarIncidenciasPermisos(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        //{
        //    FaltasBase falta = new FaltasBase();
        //    falta.Calcular(cltc, this.NominaTrabajador);
        //}

        public override void GrabarStNominaTrabajador()
        {
            NominaTrabajador.CreditosDelTrabajador = new List<Creditos_stNominaCreditoTrabajador>();
            NominaTrabajador.CreditosDelTrabajadorNoAplicados = new List<Creditos_stNominaCreditoTrabajadorNoAplicados>();
            NominaTrabajador.PercepcionesDelTrabajador = new List<Percepciones_stNominaTrabajadorPercepciones>();
            NominaTrabajador.DeduccionesDelTrabajador = new List<Deducciones_stNominaTrabajadorDeduccion>();
            NominaTrabajador.SubDeduccionesDelTrabajador = new List<Deducciones_stNominaTrabajadorSubDeducciones>();
            NominaTrabajador.PensionesDelTrabajador = new List<Pensiones_stNominaPensionTrabajador>();




            int contador = 0;

            foreach (var item in NominaTrabajador.TrabajadoresVigentes)
            {
                if (NominaTrabajador.ListaPercepcionesTrabajadores.Where(v =>
             v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && v.Importe > 0).ToList().Count > 0)
                    NominaTrabajador.AgregarSubsidio(item.IdConvenioLaboralTrabajadorCategoria);

                contador++;
 
               

                NominaTrabajador.trabajadornomina = null;
                NominaTrabajador.trabajadornomina = new Nomina_stNominaTrabajador();
                NominaTrabajador.trabajadornomina.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                NominaTrabajador.trabajadornomina.IdNomina = NominaTrabajador.IdNomina;


                NominaTrabajador.trabajadornomina.SueldoBruto = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList());

                NominaTrabajador.trabajadornomina.SueldoTabular = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.Concepto.Contains("SUELDO") && v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList());
                NominaTrabajador.trabajadornomina.PercepcionesAdicionales = (NominaTrabajador.trabajadornomina.SueldoBruto - NominaTrabajador.trabajadornomina.SueldoTabular.Value);


                NominaTrabajador.trabajadornomina.SueldoDiario = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "SUELDO DIARIO" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();
                NominaTrabajador.trabajadornomina.TotalDeducciones = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaDeduccionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList());
                NominaTrabajador.trabajadornomina.SueldoNeto = NominaTrabajador.trabajadornomina.SueldoBruto

                        - NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaDeduccionesTrabajadores.Where(i => i.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList())
                        - NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaCreditosTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList())
                        - NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaPensionesTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList());

                //NominaTrabajador.trabajadornomina.SueldoBruto = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe);
                //NominaTrabajador.trabajadornomina.SueldoDiario = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "SUELDO DIARIO" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();
                //NominaTrabajador.trabajadornomina.TotalDeducciones = NominaTrabajador.ListaDeduccionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe);

                //decimal percepciones = NominaTrabajador.trabajadornomina.Truncate(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe), 2)
                //        , deducciones = NominaTrabajador.trabajadornomina.Truncate(NominaTrabajador.ListaDeduccionesTrabajadores.Where(i => i.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe), 2)
                //        , creditos = NominaTrabajador.trabajadornomina.Truncate(NominaTrabajador.ListaCreditosTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe), 2)
                //        , pensiones = NominaTrabajador.trabajadornomina.Truncate(NominaTrabajador.ListaPensionesTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe), 2);



                //if (percepciones == 0)
                //    throw new ApplicationException("Esta nomina ha generado valores en 0, revise su información puede ser que la nomina para esta quincena no sea aplicable");

                //NominaTrabajador.trabajadornomina.SueldoNeto = percepciones - deducciones - creditos - pensiones;

                if (NominaTrabajador.trabajadornomina.SueldoNeto < 0)
                {
                    NominaTrabajador.trabajadornomina.SueldoNeto = 0;
                    NominaTrabajador.trabajadornomina.SueldoDiario = 0;
                }
                //NominaTrabajador.trabajadornomina.SueldoNeto = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe)

                //    - NominaTrabajador.ListaDeduccionesTrabajadores.Where(i => i.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe)
                //    - NominaTrabajador.ListaCreditosTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe)
                //    - NominaTrabajador.ListaPensionesTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe);

                NominaTrabajador.trabajadornomina.SueldoTransferencia = 0;
                NominaTrabajador.trabajadornomina.SueldoMonedero = 0;



                NominaTrabajador.DiasPagados = (short)NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "DIASLABORADOS" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();
                decimal faltas = NominaTrabajador.ListaVariablesNominaTrabajador.Where(F => F.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && F.Concepto == "FALTAS").Sum(e => e.Importe);
                NominaTrabajador.DiasFaltas = (short)faltas;

                NominaTrabajador.trabajadornomina.DiasPagados = NominaTrabajador.DiasPagados;
                NominaTrabajador.trabajadornomina.DiasEfectivosLaborados = NominaTrabajador.DiasPagados;

                Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == item.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
                if (costos != null)
                {
                    NominaTrabajador.trabajadornomina.CostoPorHora = costos.CostoPorHora;

                    NominaTrabajador.trabajadornomina.HorasEfectivasDeTrabajo = (short)(NominaTrabajador.trabajadornomina.DiasEfectivosLaborados * costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo);
                }


                NominaTrabajador.trabajadornomina.HorasSemanaMes = 0;
                NominaTrabajador.trabajadornomina.HorasSemanaMesTrabajadas = 0;
                NominaTrabajador.trabajadornomina.HorasTrabajadasExcedentes = 0;
                NominaTrabajador.trabajadornomina.HorasTrabajadasInterinas = 0;


                NominaTrabajador.trabajadornomina.CostoPorHoraExcedente = 0;
                NominaTrabajador.trabajadornomina.CostoPorHorasInterinas = 0;






                NominaTrabajador.trabajadornomina.SalarioDiarioIntegrado = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "SALARIO DIARIO INTEGRADO" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();

                NominaTrabajador.trabajadornomina.QuinquenioDiario = 0;
                NominaTrabajador.trabajadornomina.MaterialDidacticoDiario = 0;

                //var idquinqueniopercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "QUINQUENIO").FirstOrDefault();
                var idquinqueniopercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion.Contains("QUINQUENIO")).Select(a => a.IdPlantillaNominaPercepcion).ToList();
                
                var idpercesueldo = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion.Contains("SUELDO")).Select(z => z.IdPlantillaNominaPercepcion).ToArray();
                

                decimal sueldobrutosueldo = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && idpercesueldo.Contains(v.IdPlantillaNominaPercepcion)).ToList());


                var hayajustenuevacontrato = NominaTrabajador.ListaVariablesNominaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
               && z.Concepto == "ajustepercepciones").FirstOrDefault();
                if (hayajustenuevacontrato != null)
                {
                    NominaTrabajador.trabajadornomina.DiasDeAjuste = System.Convert.ToInt32(hayajustenuevacontrato.Importe);
                }

                var idperceAjustessueldo = NominaTrabajador.PlantillaNominaPercepciones
                    .Where(x => x.Percepciones_ctPercepcion.Percepcion.Contains("AJUSTE")
                    || x.Percepciones_ctPercepcion.Percepcion.Contains("DEVOLUCIÓN")
                    || x.Percepciones_ctPercepcion.Percepcion.Contains("DIFERENCIA")
                ).Select(z => z.IdPlantillaNominaPercepcion).ToArray();

                decimal difsueldos= NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
                && idperceAjustessueldo.Contains(v.IdPlantillaNominaPercepcion)
                && (v.Concepto.Contains("SUELDO") || v.Concepto.Contains("QUINQUENIO")) ).ToList());

                decimal restardifsueldos = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaDeduccionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
                && (v.Concepto.Contains("SUELDO") || v.Concepto.Contains("QUINQUENIO"))).ToList());

                sueldobrutosueldo = (sueldobrutosueldo + difsueldos)- restardifsueldos;

                //if (idquinqueniopercepcion != null)
                if (idquinqueniopercepcion.Count() > 0)
                    NominaTrabajador.trabajadornomina.SueldoBrutoQuinquenioDiario = sueldobrutosueldo + NominaTrabajador.ListaPercepcionesTrabajadores.Where(g => g.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && idquinqueniopercepcion.Contains(g.IdPlantillaNominaPercepcion)).Sum(r => r.Importe);
//                    NominaTrabajador.trabajadornomina.SueldoBrutoQuinquenioDiario = sueldobrutosueldo + NominaTrabajador.ListaPercepcionesTrabajadores.Where(g => g.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && idquinqueniopercepcion.IdPlantillaNominaPercepcion == g.IdPlantillaNominaPercepcion).Sum(r => r.Importe);
                else
                    NominaTrabajador.trabajadornomina.SueldoBrutoQuinquenioDiario = sueldobrutosueldo;

                if (NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
                {
                    NominaTrabajador.trabajadornomina.SumaPercepcionesVariables = NominaTrabajador.trabajadornomina.SueldoBruto;
                }
                else
                {
                    NominaTrabajador.trabajadornomina.SumaPercepcionesVariables = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && v.EsVariable == true).ToList());
                }
                NominaTrabajador.trabajadornomina.SalarioBrutoGravable = NominaTrabajador.trabajadornomina.SumaPercepcionesVariables;

                NominaTrabajador.trabajadornomina.BaseGravable = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "BASE GRAVABLE" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();

                //NominaTrabajador.trabajadornomina.EsDevolucion = false;
                if (NominaTrabajador.EsRecalculoPorTrabajador)
                {
                    NominaTrabajador.trabajadornomina.EsMedioRecibo = true;
                    NominaTrabajador.trabajadornomina.IdNominaTrabajadorEstatus = this.NominaTrabajador.IdNominaTrabajadorEstatusRecalculo;
                }

                var trabajadorFechaingreso = NominaTrabajador.QuinquenioTrabajadorAntiguedad.getAntiguedadPorTrabajador(item.Convenios_stConvenioLaboralTrabajador.IdTrabajador);

                NominaTrabajador.trabajadornomina.FechaIngreso = trabajadorFechaingreso.FechaIngreso;
                NominaTrabajador.trabajadornomina.EsAlta = item.EsPrimerCalculo;

                NominaTrabajador.Nomina_stNominaTrabajadorLista.Add(NominaTrabajador.trabajadornomina);


                ///IMSS/////
                var diasqnaimss = NominaTrabajador.ListaVariablesNominaTrabajador.Where(a => a.Concepto == "DiasQuincenaIMSS"
                 && a.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                var diascalendario = (NominaTrabajador.Nomina_stNomina.FechaTermino - NominaTrabajador.Nomina_stNomina.FechaInicio).Days + 1;

                NominaTrabajador.trabajadornomina.DiasRetencion = 0;
                if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO"))
                {
                    if (diasqnaimss != null)
                    {
                        if (diasqnaimss.Importe >= diascalendario)
                            NominaTrabajador.trabajadornomina.DiasRetencion = 0;
                        else
                            NominaTrabajador.trabajadornomina.DiasRetencion = (short)diasqnaimss.Importe;
                    }
                    else
                        NominaTrabajador.trabajadornomina.DiasRetencion = (short)diascalendario;
                }


                var totalDIASIncidencias = NominaTrabajador.ListaVariablesNominaTrabajador.Where(v => v.Concepto == "INCIDENCIA_DIAS_IMSS" && v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
         ).Sum(a => a.Importe);

                NominaTrabajador.trabajadornomina.DiasIncapacidadImss = (short)totalDIASIncidencias;


                var CesantiaVejezTrabajador = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaVariablesNominaTrabajador.Where(v => v.Concepto == "CesantiaVejezTrabajador" && v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
           ).ToList());


                NominaTrabajador.trabajadornomina.Obrero_RCV = CesantiaVejezTrabajador;


                var imss = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaVariablesNominaTrabajador.Where(v => v.Concepto == "deduccionimss" && v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
           ).ToList());


                NominaTrabajador.trabajadornomina.Obrero_IMSS = imss;

                ///IMSS/////
                ///

                var diasfaltas = NominaTrabajador.ListaVariablesNominaTrabajador
   .FirstOrDefault(x => x.Concepto == "TOTAL_FALTAS_QNA"
                    && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria);
                if (diasfaltas != null)
                {
                    NominaTrabajador.trabajadornomina.DiasFaltas = (int)diasfaltas.Importe;
                }
            }
            NominaTrabajador.GrabarNominaBaseDatos();
        }


        public override void CalcularSueldo()
        {
            if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
            {

                this.NominaTrabajador.getPercepcionesRetroactivo();
            }



            foreach (var item in this.NominaTrabajador.TrabajadoresVigentes)
            {



                int IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                int IdTrabajador = item.Convenios_stConvenioLaboralTrabajador.IdTrabajador;

                this.NominaTrabajador.setIncidenciaTrabajador(IdTrabajador);

                this.NominaTrabajador.setParametrosCreditosTrabajador(IdTrabajador);
                this.NominaTrabajador.setPensionesTrabajador(IdTrabajador);
                this.NominaTrabajador.setPercepcionesPersonalizadas(IdConvenioLaboralTrabajadorCategoria, this.NominaTrabajador.Nomina.Nomina_ctPlantillaNomina.IdPeriodoNomina);
                //this.NominaTrabajador.setCostoHoraJornada(item.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Plazas_ctCostoHoraJornada.IdCostoHoraJornada);
                //this.NominaTrabajador.setBimestreAnteriorPagadasTrabajador(IdConvenioLaboralTrabajadorCategoria);



                Nova.Models.Calculos.Percepciones.Sueldo sueldo = new Nova.Models.Calculos.Percepciones.Sueldo();
                sueldo.Calcular(item, this.NominaTrabajador, null);

            }



        }


        public override void CalcularAyudaDespensa()
        {
            if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
            {

                this.NominaTrabajador.getPercepcionesRetroactivo();
            }



            foreach (var item in this.NominaTrabajador.TrabajadoresVigentes)
            {



                int IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                int IdTrabajador = item.Convenios_stConvenioLaboralTrabajador.IdTrabajador;

                this.NominaTrabajador.setIncidenciaTrabajador(IdConvenioLaboralTrabajadorCategoria);

                this.NominaTrabajador.setParametrosCreditosTrabajador(IdTrabajador);
                this.NominaTrabajador.setPensionesTrabajador(IdTrabajador);
                this.NominaTrabajador.setPercepcionesPersonalizadas(IdConvenioLaboralTrabajadorCategoria, this.NominaTrabajador.Nomina.Nomina_ctPlantillaNomina.IdPeriodoNomina);
                //this.NominaTrabajador.setCostoHoraJornada(item.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Plazas_ctCostoHoraJornada.IdCostoHoraJornada);
                //this.NominaTrabajador.setBimestreAnteriorPagadasTrabajador(IdConvenioLaboralTrabajadorCategoria);



                Nova.Models.Calculos.Percepciones.AyudaDespensa Ayuda = new Nova.Models.Calculos.Percepciones.AyudaDespensa();
                Ayuda.Calcular(item, this.NominaTrabajador, null);

            }



        }


    }
}