﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;
using Nova.Models.Calculos.Percepciones;
using System.Data.Entity;

namespace Nova.Models.Calculos.Deducciones
{
   
    public class PermisoSinGoceSueldoBase : IDeduccionBehavior
    {
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            
            if (NominaTrabajador.IncidenciaTrabajador != null)
            {
                var faltastrabajador = NominaTrabajador.IncidenciaTrabajador.Where(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                    && s.Catalogos_ctTipoIncidencia.Incidencia == "LICENCIA SIN GOCE DE SUELDO" && (
                    ( s.FechaInicio<=NominaTrabajador.Nomina_stNomina.FechaInicio && NominaTrabajador.Nomina_stNomina.FechaTermino<= s.FechaTermino)
                    || (s.FechaInicio >= NominaTrabajador.Nomina_stNomina.FechaInicio && s.FechaTermino<= NominaTrabajador.Nomina_stNomina.FechaTermino )
                    || (s.FechaInicio >= NominaTrabajador.Nomina_stNomina.FechaInicio && s.FechaTermino > NominaTrabajador.Nomina_stNomina.FechaTermino) )
                  

                    ).OrderBy(g => g.FechaInicio).ToList();



                int diasapagar = NominaTrabajador.DiasNomina;
                Plazas_stDistribucionPlazaCategoria plazas = new Plazas_stDistribucionPlazaCategoria();
                using (var basenova = new bdNovaEntities())
                {
                    basenova.Database.Connection.Open();
                    plazas = basenova.Plazas_stDistribucionPlazaCategoria.AsNoTracking().Where(a => a.IdDistribucionPlazaCategoria == ConvenioLaboralTrabajadorCategoria.IdDistribucionPlazaCategoria).FirstOrDefault();
                         
                        
                    basenova.Database.Connection.Close();
                }


                Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == plazas.IdCategoria).FirstOrDefault();
                foreach (var item in faltastrabajador)
                {
                  

                    
                   

                    for (DateTime dateTime = item.FechaInicio;
                         dateTime < item.FechaTermino;
                           dateTime += TimeSpan.FromDays(1))
                    {

                    if (dateTime>=NominaTrabajador.Nomina_stNomina.FechaInicio && dateTime<=NominaTrabajador.Nomina_stNomina.FechaTermino) 
                             diasapagar--;
                       
                    }




                   
                }

                if (diasapagar > 0)
                {
                    NominaTrabajador.DiasPagados = (short)diasapagar;
                    //VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();

                    //vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    //vnt.Concepto = "PERMISOGOCESUELDO";
                    //vnt.Importe = diasapagar;

                    //NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt);
                }

            }
        }

    }

}