﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;

namespace Nova.Models.Calculos.Deducciones
{

    public class Maternidad : IDeduccionBehavior
    {
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

            if (NominaTrabajador.PlantillaNominaDeducciones.Where(z => z.Deducciones_ctDeduccion.Deduccion == "MATERNIDAD").SingleOrDefault() != null)
            {

                //var faltastrabajador = NominaTrabajador.IncidenciaTrabajador.Where
                //    (i => i.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                //        && i.EsAplicada == false
                //        && i.IdIncidenciaJustificacion == 0
                //        && i.Catalogos_ctTipoIncidencia.Incidencia == "INCAPACIDAD POR MATERNIDAD"
                //        && (
                //            (NominaTrabajador.Nomina.FechaInicio > i.FechaInicio && NominaTrabajador.Nomina.FechaInicio < i.FechaTermino)
                //            || (NominaTrabajador.Nomina.FechaTermino > i.FechaInicio && NominaTrabajador.Nomina.FechaInicio < i.FechaTermino) ||
                //            (i.FechaInicio < NominaTrabajador.Nomina.FechaInicio && i.FechaTermino < NominaTrabajador.Nomina.FechaTermino)
                //            || (NominaTrabajador.Nomina.FechaInicio > i.FechaInicio && i.FechaInicio < NominaTrabajador.Nomina.FechaInicio)
                //            )
                //        ).OrderBy(j => j.FechaInicio).ToList();

                var faltastrabajador = NominaTrabajador.IncidenciaTrabajador.Where
                  (i => i.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                      && i.EsAplicada == false
                      && i.Catalogos_ctTipoIncidencia.Incidencia == "INCAPACIDAD POR MATERNIDAD"
                         ).OrderBy(j => j.FechaInicio).ToList();

                 
 


                foreach (var incidencia in faltastrabajador)
                {
                    var existesaldo = db.Nomina_IncidenciasSaldos.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                      && s.IdIncidenciaTrabajador == incidencia.IdIncidenciaTrabajador && s.Saldo == 0).FirstOrDefault();

                    if (existesaldo == null)
                    {
                        var percepciones = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(c => c.Percepciones_ctPercepcion.EsOrdinaria == true).Select(x => x.IdPlantillaNominaPercepcion).ToArray();

                        var totalpercepciones = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => percepciones.Contains(v.IdPlantillaNominaPercepcion) && v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe);

                        var ImporteTotalIncidencias = totalpercepciones * incidencia.DiasIncapacidad;

                       

                        Decimal Saldo = ImporteTotalIncidencias;
                        var saldoRegistro = db.Nomina_IncidenciasSaldos.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                     && s.IdIncidenciaTrabajador == incidencia.IdIncidenciaTrabajador ).OrderByDescending(s=> s.Nomina_stNomina.FechaTermino).FirstOrDefault();

                        if (saldoRegistro != null)
                        {
                            Saldo = saldoRegistro.Saldo;
                            Saldo = Saldo - totalpercepciones;
                        }
                        else
                        {
                            Saldo = ImporteTotalIncidencias - totalpercepciones;

                        }



                        

                        Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();

                        VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();
                        vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        vnt.Concepto = "MATERNIDAD_SALDO";
                        vnt.IdIncidenciaTrabajador = incidencia.IdIncidenciaTrabajador;
                        vnt.Importe = Saldo;
                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt);

                        
                       
 

                        
                    }

                }
                 
                       

                
            }

        }


        private Boolean EsUnaQna(DateTime FechaIncial, DateTime FechaFinal, Nomina_stNominaTrabajador NominaTrabajador)
        {

            if (FechaIncial >= NominaTrabajador.Nomina.FechaInicio && FechaFinal <= NominaTrabajador.Nomina.FechaTermino)
                return false;
            else
                return true;

        }
        private int DiasIncidenciaQuincena(DateTime FechaIncial, DateTime FechaFinal, Nomina_stNominaTrabajador NominaTrabajador)
        {
            int diasincidencia = 0;
            if ((FechaIncial >= NominaTrabajador.Nomina.FechaInicio && FechaFinal <= NominaTrabajador.Nomina.FechaTermino)
                || (FechaIncial <= NominaTrabajador.Nomina.FechaInicio && FechaFinal >= NominaTrabajador.Nomina.FechaInicio)
                || (FechaIncial <= NominaTrabajador.Nomina.FechaInicio && FechaIncial <= NominaTrabajador.Nomina.FechaInicio))
            {
                diasincidencia = (int)(FechaFinal - FechaIncial).Days + 1;
                //aplicar = true;
                return diasincidencia;
            }

            if (FechaIncial <= NominaTrabajador.Nomina.FechaTermino && FechaFinal >= NominaTrabajador.Nomina.FechaTermino)
            {
                diasincidencia = (int)(FechaIncial - NominaTrabajador.Nomina.FechaTermino).Days + 1;
                //aplicar = true;
                return diasincidencia;
            }

            diasincidencia = (int)(NominaTrabajador.Nomina.FechaTermino - FechaIncial).Days + 1;
            //aplicar = false;
            return diasincidencia;
        }
        //private void GuardaDiasPago(long IdIA, int da, string idquincenames, Boolean esaplicada)
        private void GuardaDiasPago(long IdIT, int da, int dp100, int dp40, string quincenames, short año, decimal percepciondiaria)
        {
            //bdNovaEntities bd = new bdNovaEntities();
            //IncidenciaPermiso_stIncidenciaTrabajador it = bd.IncidenciaPermiso_stIncidenciaTrabajador.Find(IdIA);
            //it.DiasAcumulados = da;

            //it.EsAplicada = esaplicada;

            //it.QuincenasCalculadas = it.QuincenasCalculadas + idquincenames + "-" + da.ToString() + ",";
            //bd.Entry(it).State = System.Data.Entity.EntityState.Modified;
            //bd.SaveChanges();
            bdNovaEntities bd = new bdNovaEntities();
            Nomina_IncidenciaPermisoCalculo it = new Nomina_IncidenciaPermisoCalculo();

            it.IdIncidenciaTrabajador = IdIT;
            it.DiasAcumulados = da;
            it.DiasPagados100 = dp100;
            it.DiasPagados40 = dp40;
            it.PercepcionDiaria = percepciondiaria;
            it.QuincenaMes = quincenames;
            it.Año = año;
            bd.Nomina_IncidenciaPermisoCalculo.Add(it);
            bd.SaveChanges();
        }

    }




    //    TimeSpan intervalo;

    //    int totaldiasfaltas = 0;
    //    var faltastrabajador = NominaTrabajador.IncidenciaTrabajador.Where(s =>s.FechaInicio <= NominaTrabajador.Nomina.FechaTermino && s.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && s.EsAplicada == false && s.Catalogos_ctTipoIncidencia.Incidencia == "MATERNIDAD").ToList();
    //    Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();

    //    foreach (var item in faltastrabajador)
    //    {
    //        int diasfaltas = 0;
    //        FaltasTrabajador ft = new FaltasTrabajador();
    //        if (item.FechaTermino  >= NominaTrabajador.Nomina_stNomina.FechaInicio) 
    //        {

    //            if (item.FechaInicio < NominaTrabajador.Nomina_stNomina.FechaInicio)
    //            {
    //                intervalo = item.FechaTermino - NominaTrabajador.Nomina_stNomina.FechaInicio;
    //                diasfaltas = System.Convert.ToInt32(intervalo.TotalDays) + 1;
    //            }
    //            else
    //            {
    //                intervalo = NominaTrabajador.Nomina_stNomina.FechaTermino - item.FechaInicio;
    //                diasfaltas = System.Convert.ToInt32(intervalo.TotalDays) + 1;
    //            }

    //            //diasfaltas = System.Convert.ToInt32(intervalo.TotalDays) + 1;
    //            //totaldiasfaltas = totaldiasfaltas + diasfaltas;
    //            //ft.Importe = costos.Catalogos_ctJornadaLaboral.HorasMinimo * costos.CostoPorHora * diasfaltas;
    //            //ft.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
    //            //ft.IdDeduccion = NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Deducciones_stPlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "MATERNIDAD").FirstOrDefault().IdDeduccion;
    //            //ft.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
    //            //NominaTrabajador.ListaFaltasTrabajador.Add(ft);
    //        }
    //        else
    //            if (item.FechaInicio < NominaTrabajador.Nomina_stNomina.FechaInicio)
    //            {
    //                intervalo = item.FechaTermino - NominaTrabajador.Nomina_stNomina.FechaInicio;
    //                diasfaltas = System.Convert.ToInt32(intervalo.TotalDays) + 1;
    //            }
    //            else
    //            {
    //                intervalo = NominaTrabajador.Nomina_stNomina.FechaTermino - item.FechaInicio;
    //                diasfaltas = System.Convert.ToInt32(intervalo.TotalDays) + 1;
    //            }



    //        totaldiasfaltas = totaldiasfaltas + diasfaltas;
    //    }

    //    if (totaldiasfaltas>0)
    //    {


    //    DeduccionesNominaTrabajador falta = new DeduccionesNominaTrabajador();
    //    falta.EsImprimibleRecibo = true;
    //    falta.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
    //    falta.IdNomina = NominaTrabajador.Nomina.IdNomina;
    //    falta.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "MATERNIDAD").FirstOrDefault().IdPlantillaNominaDeduccion;
    //    falta.Importe = totaldiasfaltas * costos.Catalogos_ctJornadaLaboral.HorasMinimo * costos.CostoPorHora;
    //    NominaTrabajador.ListaDeduccionesTrabajadores.Add(falta);
    //  //  NominaTrabajador.DiasEfectivosLaborados = (short)(NominaTrabajador.DiasPagados - totaldiasfaltas);
    //    NominaTrabajador.DiasPagados = (short)(NominaTrabajador.DiasPagados - totaldiasfaltas);

    //    if (NominaTrabajador.DiasPagados < 0)
    //        NominaTrabajador.DiasPagados = 0;
    //     }

}





