﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;

namespace Nova.Models.Calculos.Deducciones
{

    public class Incapacidad : IDeduccionBehavior
    {
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            TimeSpan intervalo;
            int diasfaltas = 0;
            int totaldiasfaltas = 0;
            var faltastrabajador = NominaTrabajador.IncidenciaTrabajador.Where(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && s.EsAplicada == false && s.Catalogos_ctTipoIncidencia.Incidencia == "RIESGO DE TRABAJO").ToList();
            foreach (var item in faltastrabajador)
            {
                FaltasTrabajador ft = new FaltasTrabajador();
                if (item.FechaTermino  >= NominaTrabajador.Nomina_stNomina.FechaInicio) 
                {

                    if (item.FechaInicio < NominaTrabajador.Nomina_stNomina.FechaInicio)
                    {
                        intervalo = item.FechaTermino.Value - NominaTrabajador.Nomina_stNomina.FechaInicio;
                    }
                    else
                        intervalo = NominaTrabajador.Nomina_stNomina.FechaTermino - item.FechaInicio;


                    diasfaltas = System.Convert.ToInt32(intervalo.TotalDays) + 1;
                    totaldiasfaltas = totaldiasfaltas + diasfaltas;
                    ft.Importe = NominaTrabajador.JornadaLaboral.HorasMinimo * NominaTrabajador.CostoHoraJornada.CostoPorHora * diasfaltas;
                    ft.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                    ft.IdDeduccion = NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Deducciones_stPlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "RIESGO DE TRABAJO").FirstOrDefault().IdDeduccion;
                    ft.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    NominaTrabajador.ListaFaltasTrabajador.Add(ft);
                }
                
            }


            DeduccionesNominaTrabajador falta = new DeduccionesNominaTrabajador();
            falta.EsImprimibleRecibo = true;
            falta.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
            falta.IdNomina = NominaTrabajador.Nomina.IdNomina;
            falta.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "RIESGO DE TRABAJO").FirstOrDefault().IdPlantillaNominaDeduccion;
            falta.Importe = totaldiasfaltas * NominaTrabajador.JornadaLaboral.HorasMinimo * NominaTrabajador.CostoHoraJornada.CostoPorHora;
            NominaTrabajador.ListaDeduccionesTrabajadores.Add(falta);
            NominaTrabajador.DiasEfectivosLaborados = (short)(NominaTrabajador.DiasPagados - totaldiasfaltas);
            NominaTrabajador.DiasPagados = (short)(NominaTrabajador.DiasPagados - totaldiasfaltas);

            if (NominaTrabajador.DiasPagados < 0)
                NominaTrabajador.DiasPagados = 0;

            //VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();
            //vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
            //vnt.Concepto = "INCIDENCIAS";
            //vnt.Importe = falta.Importe;
            //NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt);


        }


    }



}