﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;
using System.EnterpriseServices;

using Microsoft.Ajax.Utilities;

using DevExpress.PivotGrid.OLAP.AdoWrappers;
using System.Data.Entity;

namespace Nova.Models.Calculos.Deducciones
{

    public class FaltasDocente : IDeduccionBehavior
    {
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            if ((NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("ODES")
                && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("BASE"))
                || (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("CONTRATO")
                && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO"))
                )
                if (!NominaTrabajador.TrabajadorConIncapacipdadActiva)
                    if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA SUELDO").FirstOrDefault() != null)
                    {
                        TimeSpan intervalo;
                        int horasfalta = 0;
                        int totalhorasfaltas = 0;
                        double horasdias = 0;
                        bool existeenAries = false;



                        int HorasJornada = 0;
                        int HorasAsesoria = 0;
                        int HorasComplementarias = 0;
                        int contador = 0;

                        int HorasExcedentes = 0;
                        int HorasRezago = 0;

                        int totaleshoras = 0;
                        int totaleshorasinterinas = 0;

                        int horassemanames = 0;


                        if (NominaTrabajador.IncidenciaTrabajador.Where(a => a.Catalogos_ctTipoIncidencia.Catalogos_ctTipoIncidenciaPermiso.TipoIncidenciaPermiso == "INCIDENCIA").Count() > 0)
                        {
                            Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();

                            var hsmt = NominaTrabajador.ListaVariablesNominaTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                                 && v.Concepto == "HorasSemanaMes").FirstOrDefault();

                            var hsmte = NominaTrabajador.ListaVariablesNominaTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                                && v.Concepto == "HorasExcedentes").FirstOrDefault();

                            var hsmti = NominaTrabajador.ListaVariablesNominaTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                                && v.Concepto == "HorasInterinas").FirstOrDefault();

                            var hclub = NominaTrabajador.ListaVariablesNominaTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                        && v.Concepto == "HorasClub").FirstOrDefault();

                            var hayhorasexcedendetesplantilla = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO HORAS EXCEDENTE").FirstOrDefault();

               
                            var horasjornada = NominaTrabajador.ListaVariablesNominaTrabajador.Where(v => v.Concepto == "HorasSemanaMes" && v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                            // linea de codigo para hjacer null a la variable sueldohorasexcedentes
                            var sueldohorasexcedentes = NominaTrabajador.ListaPercepcionesTrabajadores.Where(w => w.IdConvenioLaboralTrabajadorCategoria == 0).FirstOrDefault();
                            if (hayhorasexcedendetesplantilla != null)
                            {
                                sueldohorasexcedentes = NominaTrabajador.ListaPercepcionesTrabajadores.Where(w => w.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                                   && w.IdPlantillaNominaPercepcion == hayhorasexcedendetesplantilla.IdPlantillaNominaPercepcion).FirstOrDefault();
                            }


                     
                            var sueldopercep = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion.Contains("SUELDO") && !x.Percepciones_ctPercepcion.Percepcion.Contains("CLUB")).Select(c => c.IdPlantillaNominaPercepcion).ToList();
                            var sueldopercephoraclub = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion.Contains("SUELDO") && x.Percepciones_ctPercepcion.Percepcion.Contains("CLUB")).Select(c => c.IdPlantillaNominaPercepcion).ToList();

                            var sueldohorasjornada = NominaTrabajador.ListaPercepcionesTrabajadores.Where(w => w.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                            && sueldopercep.Contains(w.IdPlantillaNominaPercepcion)).Sum(z => z.Importe);

                   
                            //hobas club
                            

                            var materialpercep = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion.Contains("MATERIAL") && !x.Percepciones_ctPercepcion.Percepcion.Contains("CLUB")).Select(c => c.IdPlantillaNominaPercepcion).ToList();
                            var materialperhorasclub = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion.Contains("MATERIAL") && x.Percepciones_ctPercepcion.Percepcion.Contains("CLUB")).Select(c => c.IdPlantillaNominaPercepcion).ToList();

                            var sueldomaterial = NominaTrabajador.ListaPercepcionesTrabajadores.Where(w => w.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                            && materialpercep.Contains(w.IdPlantillaNominaPercepcion)).Sum(z => z.Importe);

                    
                            var eficienciapercep = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion.Contains("EFICIENCIA")).Select(c => c.IdPlantillaNominaPercepcion).ToList();

                            var sueldoeficiencia = NominaTrabajador.ListaPercepcionesTrabajadores.Where(w => w.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                             && eficienciapercep.Contains(w.IdPlantillaNominaPercepcion)).Sum(z => z.Importe);

                            //falta QUINQUENIO

                            var quinqueniopercep = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion.Contains("QUINQUENIO")).Select(c => c.IdPlantillaNominaPercepcion).ToList();

                            var sueldoquinquenio = NominaTrabajador.ListaPercepcionesTrabajadores.Where(w => w.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                             && quinqueniopercep.Contains(w.IdPlantillaNominaPercepcion)).Sum(z => z.Importe);

                            var cappercep = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion.Contains("COMPENSACION POR ACTUACION Y PRODUCTIVIDAD")).Select(c => c.IdPlantillaNominaPercepcion).ToList();

                            var sueldocap= NominaTrabajador.ListaPercepcionesTrabajadores.Where(w => w.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                             && cappercep.Contains(w.IdPlantillaNominaPercepcion)).Sum(z => z.Importe);

                            


                            var sueldohorasinterinas = NominaTrabajador.ListaPercepcionesTrabajadores.Where(w => w.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                   && w.IdPlantillaNominaPercepcion == NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO HORAS INTERINAS").FirstOrDefault().IdPlantillaNominaPercepcion).FirstOrDefault();

                            decimal sueldopromedio = 0;
                            decimal materialpromedio = 0;
                            decimal eficienciapromedio = 0;
                            decimal quinqueniopromedio = 0;
                            //  decimal sueldoquinquenio= 0;

                            decimal sueldopromediointerinas = 0;
                            decimal sueldohorasjornadapromedio = 0;

                         

                            if (sueldohorasjornada > 0)
                            {
                                sueldohorasjornadapromedio = sueldohorasjornada;
                            }

                            

                            decimal totalhoras = 0;
                            if (hsmt.Importe > 0)
                            {
                                totalhoras = hsmt.Importe;

                                if (sueldohorasexcedentes != null)
                                {
                                    totalhoras = totalhoras + hsmte.Importe;

                                }
                                
                            }

                         


                            var faltastrabajador = NominaTrabajador.IncidenciaTrabajador.Where(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
&& s.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA")
&& s.QuincenaParaNomina == NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes
&& s.AñoParaNomina == NominaTrabajador.Nomina_stNomina.Año

).OrderBy(g => g.FechaInicio).ToList();


                            foreach (var item in faltastrabajador)
                            {
//                                Plazas_ctCostoHoraJornada costosCeyte1 = NominaTrabajador.Plazas_ctCostoHoraJornadaTodos
//.Where(d => d.Plazas_ctCategoria.Categoria == "PROF. CECYT I"
//&& d.FechaInicio.Date <= item.FechaInicio.Date
//&& d.FechaTermino.Date >= item.FechaTermino.Value.Date).FirstOrDefault();

                                Plazas_ctCostoHoraJornada costosCeyte1 = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes
.Where(d => d.Plazas_ctCategoria.Categoria == "PROF. CECYT I").FirstOrDefault();


                                if (costosCeyte1 == null)
                                {
                                    throw new Exception($"No hay horas club para poder determinar la falta del ide {ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador}");
                                }

                                var sueldohorasclub = costosCeyte1.CostoPorHoraInterina;

                                var sueldomaterialhorasclub= costosCeyte1.CostoMaterialDidactico;

                                FaltasTrabajador ft = new FaltasTrabajador();
                                FaltasTrabajador fthc = new FaltasTrabajador();
                                FaltasTrabajador faltaAyuda = new FaltasTrabajador();
                                FaltasTrabajador faltaEficiencia = new FaltasTrabajador();
                                FaltasTrabajador faltaquinquenio = new FaltasTrabajador();
                                FaltasTrabajador faltacap= new FaltasTrabajador();
                                FaltasTrabajador faltamaterialhc = new FaltasTrabajador();
                                 
                                    intervalo = item.FechaTermino.Value - item.FechaInicio;
                                 
                                
                                horasfalta = item.Horas;
                                totalhorasfaltas = totalhorasfaltas + horasfalta;

                                if (horasfalta > 0)
                                {
                                    if (item.Catalogos_ctTipoIncidencia.Incidencia.Contains("CLUB")
                                        && hclub != null && sueldomaterialhorasclub != null)
                                    {
                                        
                                        var sueldohorasclubtrabajador = sueldohorasclub;

                                        fthc.Importe = ((sueldohorasclub * horasfalta));

                                    
                                        fthc.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                                        fthc.IdDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA SUELDO HORAS CLUB").FirstOrDefault().IdDeduccion;
                                        fthc.Deduccion = "FALTA SUELDO HORAS CLUB";
                                        fthc.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                        if (fthc.Importe > 0)
                                            NominaTrabajador.ListaFaltasTrabajador.Add(fthc);

                                        if (sueldomaterialhorasclub > 0)
                                        {
                                            //ft.Importe = factorsueldo * horasfalta;
                                            // faltamaterialhc.Importe = ((sueldomaterialhorasclub * horasfalta) /   hclub.Importe) / 2;
                                            faltamaterialhc.Importe = (sueldomaterialhorasclub * horasfalta);
                                            faltamaterialhc.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                                            faltamaterialhc.IdDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA AYUDA PARA MATERIAL DIDÁCTICO HORAS CLUB").FirstOrDefault().IdDeduccion;
                                            faltamaterialhc.Deduccion = "FALTA AYUDA PARA MATERIAL DIDÁCTICO HORAS CLUB";
                                            faltamaterialhc.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                            if (faltamaterialhc.Importe > 0)
                                                NominaTrabajador.ListaFaltasTrabajador.Add(faltamaterialhc);
                                        }
                                    }
                                    else
                                    {
                                        //falta sueldo
                                        if (totalhoras > 0)
                                        {
                                            //ft.Importe = factorsueldo * horasfalta;
                                            ft.Importe = ((sueldohorasjornada * horasfalta) / totalhoras) / 2;
                                            ft.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                                            ft.IdDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA SUELDO").FirstOrDefault().IdDeduccion;
                                            ft.Deduccion = "FALTA SUELDO";
                                            ft.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                            NominaTrabajador.ListaFaltasTrabajador.Add(ft);

                                            // falta material
                                            if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "MATERIAL DIDACTICO DE JORNADA").FirstOrDefault() != null)
                                            {
                                                //faltaAyuda.Importe = factormaterial  * horasfalta;
                                                faltaAyuda.Importe = ((sueldomaterial * horasfalta) / totalhoras) / 2;
                                                faltaAyuda.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                                                faltaAyuda.IdDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA MATERIAL DIDACTICO").FirstOrDefault().IdDeduccion;
                                                faltaAyuda.Deduccion = "FALTA MATERIAL DIDACTICO";
                                                faltaAyuda.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                                if (faltaAyuda.Importe > 0)
                                                    NominaTrabajador.ListaFaltasTrabajador.Add(faltaAyuda);
                                            }


                                            //falta eficiencia
                                            if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO DE JORNADA").FirstOrDefault() != null)
                                            {
                                                //faltaEficiencia.Importe = factoreficiencia * horasfalta;
                                                faltaEficiencia.Importe = Math.Round(((sueldoeficiencia * horasfalta) / totalhoras) / 2, 2);
                                                faltaEficiencia.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                                                faltaEficiencia.IdDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA EFICIENCIA EN EL TRABAJO").FirstOrDefault().IdDeduccion;
                                                faltaEficiencia.Deduccion = "FALTA EFICIENCIA EN EL TRABAJO";
                                                faltaEficiencia.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                                //if (faltaEficiencia.Importe > 0)
                                                // en eficiencia el costo por hora suele ser muy bajo por eso 
                                                //sedeja hasta centavos
                                                NominaTrabajador.ListaFaltasTrabajador.Add(faltaEficiencia);
                                            }

                                            //falta quinquenio
                                            if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "QUINQUENIO DE JORNADA").FirstOrDefault() != null)
                                            {
                                                // faltaquinquenio.Importe = factorequinquenio * horasfalta;
                                                faltaquinquenio.Importe = ((sueldoquinquenio * horasfalta) / totalhoras) / 2;
                                                faltaquinquenio.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                                                faltaquinquenio.IdDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA QUINQUENIO").FirstOrDefault().IdDeduccion;
                                                faltaquinquenio.Deduccion = "FALTA QUINQUENIO";
                                                faltaquinquenio.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                                if (faltaquinquenio.Importe > 0)
                                                    NominaTrabajador.ListaFaltasTrabajador.Add(faltaquinquenio);
                                            }
                                            //COMPENSACION POR ACTUACION Y PRODUCTIVIDAD

                                            if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "COMPENSACION POR ACTUACION Y PRODUCTIVIDAD").FirstOrDefault() != null)
                                            {
                                                // faltaquinquenio.Importe = factorequinquenio * horasfalta;
                                                faltacap.Importe = ((sueldocap * horasfalta) / totalhoras) / 2;
                                                faltacap.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                                                faltacap.IdDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA COMPENSACION POR ACTUACION Y PRODUCTIVIDAD").FirstOrDefault().IdDeduccion;
                                                faltacap.Deduccion = "FALTA COMPENSACION POR ACTUACION Y PRODUCTIVIDAD";
                                                faltacap.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                                if (faltacap.Importe > 0)
                                                    NominaTrabajador.ListaFaltasTrabajador.Add(faltacap);
                                            }
                                        }
                                    }
                                }
                            }

                            if (totalhorasfaltas>0)
                            { 
                            decimal totalincidencias = 0;
                            totalincidencias = GuardaFalta(ref NominaTrabajador, ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria, "FALTA SUELDO HORAS CLUB");
                            totalincidencias = totalincidencias + GuardaFalta(ref NominaTrabajador, ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria, "FALTA AYUDA PARA MATERIAL DIDÁCTICO HORAS CLUB");
                            totalincidencias = totalincidencias + GuardaFalta(ref NominaTrabajador, ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria, "FALTA SUELDO");
                            totalincidencias = totalincidencias + GuardaFalta(ref NominaTrabajador, ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria, "FALTA MATERIAL DIDACTICO");
                            totalincidencias = totalincidencias + GuardaFalta(ref NominaTrabajador, ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria, "FALTA QUINQUENIO");
                            totalincidencias = totalincidencias + GuardaFalta(ref NominaTrabajador, ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria, "FALTA EFICIENCIA EN EL TRABAJO");
                            totalincidencias = totalincidencias + GuardaFalta(ref NominaTrabajador, ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria, "FALTA COMPENSACION POR ACTUACION Y PRODUCTIVIDAD");

                           
                            //VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();

                            //vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            //vnt.Concepto = "INCIDENCIAS";
                            //vnt.Importe = totalincidencias;

                                var variableExistente = NominaTrabajador.ListaVariablesNominaTrabajador
    .FirstOrDefault(x => x.Concepto == "TOTAL_FALTAS_QNA"
                     && x.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria);

                                if (variableExistente != null)
                                {
                                    // Si existe, actualizar el importe
                                    variableExistente.Importe += totalhorasfaltas;
                                }
                                else
                                {
                                    // Si no existe, crear nueva variable y agregarla
                                    VariablesNominaTrabajador vnt1 = new VariablesNominaTrabajador();
                                    vnt1.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                    vnt1.Concepto = "TOTAL_FALTAS_QNA";
                                    vnt1.Importe = totalhorasfaltas;
                                    NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt1);
                                }

                                //NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt);
                           }

                        }


                    }
        }



        private decimal GuardaFalta(ref Nomina_stNominaTrabajador NominaTrabajador, int IdConvenioLaboralTrabajadorCategoria, string incidencia)
        {
            DeduccionesNominaTrabajador falta = new DeduccionesNominaTrabajador();
            var tfaltascclub = NominaTrabajador.ListaFaltasTrabajador.Where(a => a.IdConvenioLaboralTrabajadorCategoria
            ==IdConvenioLaboralTrabajadorCategoria && a.Deduccion == incidencia).Sum(s => s.Importe);
            if (tfaltascclub > 0)
            {

                falta.EsImprimibleRecibo = true;
                falta.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                falta.IdNomina = NominaTrabajador.Nomina.IdNomina;
                falta.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == incidencia).FirstOrDefault().IdPlantillaNominaDeduccion;
                falta.Importe = tfaltascclub;

                if (falta.Importe > 0)
                    NominaTrabajador.ListaDeduccionesTrabajadores.Add(falta);
            }

            return tfaltascclub;


        }
    }
}
