﻿using Nova.Models.Nomina;
using System;
using System.Data;
using System.Data.Entity;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;
using Nova.Libraries;
using System.Web.Mvc;
using System.Transactions;
using Dapper;
using DevExpress.Web.Internal;
using DevExpress.Web.ASPxHtmlEditor.Internal;
using Nova.Models.Calculos.Percepciones;

namespace Nova.Models.Calculos.Deducciones
{

    public class EnfermedadGeneral : IDeduccionBehavior
    {
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {

            if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "ENFERMEDAD GENERAL").FirstOrDefault() != null)

            {
                Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();
                String qna = NominaTrabajador.Nomina.Catalogos_ctQuincenaMes.QuincenaMes;
                string año = NominaTrabajador.Nomina.FechaInicio.Year.ToString();
                //actualiza cálculo de INCAPACIDAD POR ENFERMEDAD GENERAL para la quincena calculada de todos los trabajadores
                //short[] idapoyo = new short[1] { 0 };

                var percepcionesQuitarlas = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(c =>
             c.Percepciones_ctPercepcion.Percepcion.Contains("ONOMÁSTICO") ||
             c.Percepciones_ctPercepcion.Percepcion.Contains("GUARDERIA")
       ).Select(x => x.IdPercepcion).ToArray();

                var contarestaspercepcione = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(s => !s.Nomina_ctPlantillaNomina.Plantilla.Contains("PROPORCIONALES") && (s.Percepciones_ctPercepcion.Percepcion == "VALES DE DESPENSA" || s.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA DESPENSA")).Select(d => d.IdPlantillaNominaPercepcion).ToArray();


                var totalpercepciones = NominaTrabajador.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v =>
              v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
              && (v.EsGrabable == true || (contarestaspercepcione.Contains(v.IdPlantillaNominaPercepcion) || v.TratamientoEspecialIncapacidadesSueldoIsr==true))
              && !percepcionesQuitarlas.Contains(v.IdPercepcion)
              ).ToList());
                var totalpercepcionesmaximoadescontar = totalpercepciones;
                //if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral == "ADMINISTRATIVO"
                //   && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == "BASE")
                //    idapoyo = NominaTrabajador.PlantillaNominaPercepciones.Where(f => f.Percepciones_ctPercepcion.Percepcion == "APOYO PARA LA CULTURA Y EL DEPORTE").Select(h => h.IdPlantillaNominaPercepcion).ToArray();


                //var totalpercepciones = NominaTrabajador.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                //&& (idapoyo.Contains(v.IdPlantillaNominaPercepcion)
                //|| v.EsGrabable == true)).ToList());

                Nova.Models.Calculos.Percepciones.PercepcionPersonalizada percepcionpersonalizada = new Nova.Models.Calculos.Percepciones.PercepcionPersonalizada();
                percepcionpersonalizada.Calcular(ConvenioLaboralTrabajadorCategoria, NominaTrabajador, "INCAPACIDADES", "GASTO ADMINISTRATIVO");
                percepcionpersonalizada.Calcular(ConvenioLaboralTrabajadorCategoria, NominaTrabajador, "INCAPACIDADES", "APOYO ZONA MARGINAL");
                //// AYUDA PARA LA CULTURA Y DEPORTE
                ApoyoCulturaDeporte apoyoculturadeporte = new ApoyoCulturaDeporte();
                apoyoculturadeporte.Calcular(ConvenioLaboralTrabajadorCategoria, NominaTrabajador, "INCAPACIDADES");

                //// AYUDA PARA TRANSPORTE
                AyudaTransporte ayudatransporte = new AyudaTransporte();
                ayudatransporte.Calcular(ConvenioLaboralTrabajadorCategoria, NominaTrabajador, "INCAPACIDADES");



               
              

                totalpercepciones = totalpercepciones +NominaTrabajador.ListaPercepcionesTrabajadoresCCTIMSS.Where(v =>
                   v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                   &&
                !percepcionesQuitarlas.Contains(v.IdPercepcion)
               ).Sum(a=> a.Importe);


                var valoresEspeciales = NominaTrabajador.PrestacionesIncapacidadesSueldoIsr(ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria);

                totalpercepciones = totalpercepciones + valoresEspeciales;


                var saldoEnfermedad = NominaTrabajador.Nomina_IncidenciasSaldosBd.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                && s.IncidenciaPermiso_stIncidenciaTrabajador.Catalogos_ctTipoIncidencia.Incidencia == "INCAPACIDAD POR ENFERMEDAD GENERAL"
                  && s.Saldo > 0).OrderBy(s => s.IncidenciaPermiso_stIncidenciaTrabajador.FechaInicio).FirstOrDefault();


                decimal saldoRemanente = 0;
                bool SeActualizoSaldo = false;
                bool SaldosNuevoYActualizado = false;
                bool TerminaPago = false;

                decimal ImporteSaldoEnfermedad = 0;

                long IdNuevaIncidencia = 0;
                long IdSaldoIncidencia = 0;
                decimal saldonuevaincidencia = 0;

                var diaslaborados = NominaTrabajador.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "DIASLABORADOS").FirstOrDefault().Importe;

                Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();

                if (saldoEnfermedad != null)
                {
                    ImporteSaldoEnfermedad = saldoEnfermedad.Saldo;
                    IdSaldoIncidencia = saldoEnfermedad.IdIncidenciaTrabajador;
                }
                decimal montomaximo = 0;

                var egq = NominaTrabajador.IncidenciasTrabajadores.Where
                                (i => i.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                                    //|| ((i.FechaInicio <= NominaTrabajador.Nomina.FechaInicio && i.FechaTermino <= NominaTrabajador.Nomina.FechaTermino) || (i.FechaInicio <= NominaTrabajador.Nomina.FechaTermino && i.FechaTermino <= NominaTrabajador.Nomina.FechaTermino))
                                    && i.FechaAplicacionIncapacidad==NominaTrabajador.Nomina_stNomina.FechaInicio
                                    && i.Catalogos_ctTipoIncidencia.Incidencia == "INCAPACIDAD POR ENFERMEDAD GENERAL"
                                    //&& i.EsAplicada == false
                                    ).OrderBy(j => j.FechaInicio).ToList();

                EnfermedadControl enfermedad = new EnfermedadControl();

                  montomaximo = totalpercepcionesmaximoadescontar;

                var totaldiassaldo = db.Nomina_IncidenciasSaldos.AsNoTracking().Where(a => a.IncidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                 && a.DiasSaldo>0).FirstOrDefault();


                if (egq.Count() > 0)
                {
                    IdNuevaIncidencia = egq[0].IdIncidenciaTrabajador;

                    var totaldiasimss = db.Nomina_IncidenciaPermisoCalculo.AsNoTracking()
     .Where(a =>
         a.IncidenciaPermiso_stIncidenciaTrabajador != null &&
         a.IncidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria &&
         a.EsAplicada == false &&
         a.IncidenciaPermiso_stIncidenciaTrabajador.FechaAplicacionIncapacidad != null &&
         DbFunctions.TruncateTime(a.IncidenciaPermiso_stIncidenciaTrabajador.FechaAplicacionIncapacidad) == DbFunctions.TruncateTime(NominaTrabajador.Nomina_stNomina.FechaInicio))
     .Select(a => a.DiasPagados100 + a.DiasPagados40)
  .DefaultIfEmpty(0)
  .Sum();


                    // decimal sumapercepcionesquincenales = NominaTrabajador.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).ToList());
                    decimal sumapercepcionesquincenales = totalpercepcionesmaximoadescontar;
                    decimal montomaximodescuento = totalpercepcionesmaximoadescontar;

                    var existedespensa = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(s => !s.Nomina_ctPlantillaNomina.Plantilla.Contains("PROPORCIONALES") && s.Percepciones_ctPercepcion.Percepcion == "VALES DE DESPENSA" && s.Calcular == true).OrderByDescending(q => q.Percepciones_ctPercepcion).FirstOrDefault();

                    Decimal despensacosto = 0M;
                    if (existedespensa != null)
                    {
                         

                        var costoayudatmp = (decimal)((costos.CostoValesDespensa * 7) * diaslaborados) * 2;
                        despensacosto = costoayudatmp / 2;
                        //despensacosto = (decimal)existedespensa.Importe / 2;
                    }

                    // var existeayuda = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(s => !s.Nomina_ctPlantillaNomina.Plantilla.Contains("PROPORCIONALES") && s.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA DESPENSA" && s.Calcular == true).FirstOrDefault();

                    Decimal ayudacosto = 0M;
                    //if (existeayuda != null)
                    //{
                    //    ayudacosto = (decimal)existeayuda.Importe;
                    //}

                    var existeayudabd = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => !x.Nomina_ctPlantillaNomina.Plantilla.Contains("PROPORCIONALES") && x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA DESPENSA").FirstOrDefault();

                    if (existeayudabd != null)
                        if (existeayudabd.Calcular == true)
                                //ayudacosto = (decimal)existeayudabd.Importe;
                                ayudacosto = (decimal)(costos.CostoAyudaDespensa * 7) * diaslaborados;

                    montomaximo = sumapercepcionesquincenales;


                    if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("ODES"))
                        {
                        sumapercepcionesquincenales = sumapercepcionesquincenales + despensacosto + ayudacosto;
                    }
                     

                    
                    decimal percepciondiaria = (totalpercepciones + despensacosto + ayudacosto) / 15M;

                  
                    VariablesNominaTrabajador vnt14 = new VariablesNominaTrabajador();
                    vnt14.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    vnt14.Concepto = "INCIDENCIA_DIAS_IMSS";
                    vnt14.IdIncidenciaTrabajador = IdNuevaIncidencia;
                    vnt14.Importe = totaldiasimss;

                    var diasimsssaldo = 0;
                    if (totaldiasimss>0 && IdNuevaIncidencia>0)
                    {
                        if (totaldiasimss - (int)diaslaborados < 0)
                        {
                            diasimsssaldo = 0;
                        }
                    
                    else
                            diasimsssaldo= totaldiasimss - (int)diaslaborados;


                    NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt14);

                        VariablesNominaTrabajador vnt84 = new VariablesNominaTrabajador();
                        vnt84.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;


                        vnt84.Concepto = "INCIDENCIA_DIAS_SALDO_INSERT";

                        vnt84.IdIncidenciaTrabajador = IdNuevaIncidencia;
                        vnt84.Importe = totaldiasimss;
                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt84);


                        VariablesNominaTrabajador vntP = new VariablesNominaTrabajador();
                        vntP.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        vntP.Concepto = "INCIDENCIA_DIAS_SALDO_UPDATE";

                        vntP.IdIncidenciaTrabajador = IdNuevaIncidencia;

                        vntP.Importe = diasimsssaldo;

                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vntP);
                    }


                    List<EnfermedadControl> enfermedad40 = new List<EnfermedadControl>();
                    if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("BASE"))
                        enfermedad40 = (from c in egq
                                        join o in db.Nomina_IncidenciaPermisoCalculo
                                        on c.IdIncidenciaTrabajador equals o.IdIncidenciaTrabajador
                                        where o.EsAplicada == false
                                        && o.DiasPagados40 > 0
                                        select new EnfermedadControl
                                        {
                                            IdIncidenciaTrabajadorCalculo = o.IdIncidenciaTrabajadorCalculo,
                                            IdConvenioLaboralTrabajadorCategoria = c.IdConvenioLaboralTrabajadorCategoria,
                                            IdIncidenciaTrabajador = o.IdIncidenciaTrabajador,
                                            QuincenaMes = o.QuincenaMes,
                                            DiasPagados40 = o.DiasPagados40
                                        }).ToList();
                    else
                        // se suman ambos dias de 40 y de 100 para confianza
                        enfermedad40 = (from c in egq
                                        join o in db.Nomina_IncidenciaPermisoCalculo
                                        on c.IdIncidenciaTrabajador equals o.IdIncidenciaTrabajador
                                        where o.EsAplicada == false
                                        //&& o.DiasPagados40 > 0
                                        select new EnfermedadControl
                                        {
                                            IdIncidenciaTrabajadorCalculo = o.IdIncidenciaTrabajadorCalculo,
                                            IdConvenioLaboralTrabajadorCategoria = c.IdConvenioLaboralTrabajadorCategoria,
                                            IdIncidenciaTrabajador = o.IdIncidenciaTrabajador,
                                            QuincenaMes = o.QuincenaMes,
                                            DiasPagados40 = o.DiasPagados40 + o.DiasPagados100
                                        }).ToList();


                    List<EnfermedadControl> enfermedad100 = (from c in egq
                                                             join o in db.Nomina_IncidenciaPermisoCalculo
                                                             on c.IdIncidenciaTrabajador equals o.IdIncidenciaTrabajador
                                                             where o.EsAplicada == false && o.DiasPagados100 > 0
                                                             select new EnfermedadControl
                                                             {
                                                                 IdIncidenciaTrabajadorCalculo = o.IdIncidenciaTrabajadorCalculo,
                                                                 IdConvenioLaboralTrabajadorCategoria = c.IdConvenioLaboralTrabajadorCategoria,
                                                                 IdIncidenciaTrabajador = o.IdIncidenciaTrabajador,
                                                                 QuincenaMes = o.QuincenaMes,
                                                                 DiasPagados40 = o.DiasPagados100 + o.DiasPagados40
                                                             }).ToList();

                    foreach (var item in enfermedad100)
                    {

                        Nomina_IncidenciaPermisoCalculo grabarquincena = db.Nomina_IncidenciaPermisoCalculo.Find(item.IdIncidenciaTrabajadorCalculo);
                        grabarquincena.QuincenaMes = qna;
                        grabarquincena.Año = Convert.ToInt16(NominaTrabajador.Nomina.FechaInicio.Year);
                        grabarquincena.PercepcionDiaria = percepciondiaria;
                        db.Entry(grabarquincena).State = EntityState.Modified;
                        db.SaveChanges();

                        //diasenfermedad40 = diasenfermedad40+item.
                    }

                    int diasenfermedad40 = 0;
                    int existe40 = 0;

                    enfermedad = enfermedad40.LastOrDefault();
                    foreach (var item in enfermedad40)
                    {
                        diasenfermedad40 = diasenfermedad40 + item.DiasPagados40;
                        Nomina_IncidenciaPermisoCalculo grabarquincena = db.Nomina_IncidenciaPermisoCalculo.Find(item.IdIncidenciaTrabajadorCalculo);
                        grabarquincena.QuincenaMes = qna;
                        grabarquincena.Año = Convert.ToInt16(NominaTrabajador.Nomina.FechaInicio.Year);
                        grabarquincena.PercepcionDiaria = percepciondiaria;
                        db.Entry(grabarquincena).State = EntityState.Modified;
                        db.SaveChanges();
                    }

                    //if (diasenfermedad40 > 0)
                    //{
                    //    if (diasenfermedad40 < NominaTrabajador.DiasNomina)
                    //        NominaTrabajador.TrabajadorConIncapacipdadActiva = false;
                    //    else
                    //        NominaTrabajador.TrabajadorConIncapacipdadActiva = true;
                    //}
                    if (!NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("BASE"))
                    {
                        if (diasenfermedad40 > 3)
                            diasenfermedad40 = diasenfermedad40 - 3;

                    }

                    saldonuevaincidencia = diasenfermedad40 * percepciondiaria;

                    saldonuevaincidencia = saldonuevaincidencia * 0.60M;

                    ///

                    // if (saldonuevaincidencia > 0)
                    //{

                    // if (saldoEnfermedad.Saldo > 0)

                    //{
                }

                //SeActualizoSaldo = true;
                bool entro = false;


                if (ImporteSaldoEnfermedad + saldonuevaincidencia > 0)
                {
                    NominaTrabajador.TrabajadorConIncapacipdadActivaConcepto = "INCAPACIDAD POR ENFERMEDAD GENERAL";
                    if (ImporteSaldoEnfermedad + saldonuevaincidencia < montomaximo)
                    {
                        NominaTrabajador.TrabajadorConIncapacipdadActiva = false;

                        if (saldoEnfermedad != null)
                        {
                            saldoRemanente = saldoEnfermedad.Saldo - saldoEnfermedad.Saldo;

                            var DIASSALDO = 0;
                            VariablesNominaTrabajador vnt14 = new VariablesNominaTrabajador();
                            vnt14.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            vnt14.Concepto = "INCIDENCIA_DIAS_IMSS";

                            //  vnt14.Importe = totaldiasimss;

                            if (saldoEnfermedad.DiasSaldo > 0)
                            {
                                vnt14.IdIncidenciaTrabajador = saldoEnfermedad.IdIncidenciaTrabajador;
                                vnt14.Importe = (Decimal)saldoEnfermedad.DiasSaldo;
                                if (saldoEnfermedad.DiasSaldo - (int)diaslaborados < 0)
                                {
                                    DIASSALDO = 0;
                                }

                                else
                                    DIASSALDO = (int)saldoEnfermedad.DiasSaldo - (int)diaslaborados;


                                NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt14);



                                VariablesNominaTrabajador vntP = new VariablesNominaTrabajador();
                                vntP.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                vntP.Concepto = "INCIDENCIA_DIAS_SALDO_UPDATE";

                                if (IdNuevaIncidencia > 0)
                                    vntP.IdIncidenciaTrabajador = IdNuevaIncidencia;
                                else
                                    vntP.IdIncidenciaTrabajador = IdNuevaIncidencia = saldoEnfermedad.IdIncidenciaTrabajador;

                                vntP.Importe = DIASSALDO;

                                NominaTrabajador.ListaVariablesNominaTrabajador.Add(vntP);
                            }

                        }

                        //NominaTrabajador.setSaldosIncidencias(ConvenioLaboralTrabajadorCategoria, enfermedad.IdIncidenciaTrabajador, "INCAPACIDAD POR ENFERMEDAD GENERAL", saldoRemanente);
                        if (IdSaldoIncidencia > 0)
                        {
                            VariablesNominaTrabajador vnt1 = new VariablesNominaTrabajador();
                            vnt1.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            vnt1.Concepto = "INCIDENCIA_SALDO_UPDATE";
                            vnt1.IdIncidenciaTrabajador = IdSaldoIncidencia;
                            vnt1.Importe = saldoRemanente;
                            NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt1);
                        }
                        if (saldonuevaincidencia > 0)
                        {
                            //NominaTrabajador.setSaldosIncidencias(ConvenioLaboralTrabajadorCategoria, egq[0].IdIncidenciaTrabajador, "INCAPACIDAD POR ENFERMEDAD GENERAL", saldonuevaincidencia);

                            VariablesNominaTrabajador vnt2 = new VariablesNominaTrabajador();
                            vnt2.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            vnt2.Concepto = "INCIDENCIA_SALDO_INSERT";
                            if (entro)
                            {
                                vnt2.IdIncidenciaTrabajador = 0;
                            }
                            else
                                vnt2.IdIncidenciaTrabajador = egq[0].IdIncidenciaTrabajador;
                            vnt2.Importe = saldonuevaincidencia;
                            NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt2);


                            VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();
                            vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            vnt.Concepto = "INCIDENCIA_SALDO_UPDATE";
                            if (entro)
                            {
                                vnt2.IdIncidenciaTrabajador = 0;
                            }
                            else
                                vnt.IdIncidenciaTrabajador = egq[0].IdIncidenciaTrabajador;
                            vnt.Importe = 0;
                            NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt);
                        }




                        TerminaPago = true;
                        //terminaDepagarRiesgoTrabajo = true;
                        DeduccionesNominaTrabajador isr = new DeduccionesNominaTrabajador();
                        isr.EsImprimibleRecibo = true;
                        isr.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        isr.IdNomina = NominaTrabajador.Nomina_stNomina.IdNomina;
                        isr.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "ENFERMEDAD GENERAL").FirstOrDefault().IdPlantillaNominaDeduccion;
                        isr.Importe = ImporteSaldoEnfermedad + saldonuevaincidencia;

                        NominaTrabajador.ListaDeduccionesTrabajadores.Add(isr);

                    }
                    else
                    {

                        NominaTrabajador.TrabajadorConIncapacipdadActiva = true;
                        DeduccionesNominaTrabajador isr = new DeduccionesNominaTrabajador();
                        isr.EsImprimibleRecibo = true;
                        isr.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        isr.IdNomina = NominaTrabajador.Nomina_stNomina.IdNomina;
                        isr.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "ENFERMEDAD GENERAL").FirstOrDefault().IdPlantillaNominaDeduccion;
                        isr.Importe = montomaximo;

                        NominaTrabajador.ListaDeduccionesTrabajadores.Add(isr);
                        if (ImporteSaldoEnfermedad < montomaximo)
                            saldoRemanente = saldonuevaincidencia - montomaximo;
                        else
                            saldoRemanente = ImporteSaldoEnfermedad - montomaximo;



                        //NominaTrabajador.setSaldosIncidencias(ConvenioLaboralTrabajadorCategoria, enfermedad.IdIncidenciaTrabajador, "INCAPACIDAD POR ENFERMEDAD GENERAL", saldoRemanente);

                        VariablesNominaTrabajador vnt1 = new VariablesNominaTrabajador();
                        vnt1.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        vnt1.Concepto = "INCIDENCIA_SALDO_UPDATE";
                        if (IdSaldoIncidencia>0)
                        vnt1.IdIncidenciaTrabajador = IdSaldoIncidencia;
                        else
                            vnt1.IdIncidenciaTrabajador = IdNuevaIncidencia;
                        vnt1.Importe = saldoRemanente;
                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt1);


                        if (totaldiassaldo!=null )
                {
                    if (totaldiassaldo.DiasSaldo > 0)
                    {

                        VariablesNominaTrabajador vnt14 = new VariablesNominaTrabajador();
                        vnt14.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        vnt14.Concepto = "INCIDENCIA_DIAS_IMSS";
                                if (IdSaldoIncidencia > 0)
                                    vnt1.IdIncidenciaTrabajador = IdSaldoIncidencia;
                                else
                                    vnt1.IdIncidenciaTrabajador = IdNuevaIncidencia;
                                
                        vnt14.Importe = (int)totaldiassaldo.DiasSaldo;

                        var diasimsssaldo = 0;

                        if (totaldiassaldo.DiasSaldo - (int)diaslaborados < 0)
                        {
                            diasimsssaldo = 0;
                        }

                        else
                            diasimsssaldo = (int)totaldiassaldo.DiasSaldo - (int)diaslaborados;

                                
                                NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt14);




                        VariablesNominaTrabajador vntP = new VariablesNominaTrabajador();
                        vntP.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        vntP.Concepto = "INCIDENCIA_DIAS_SALDO_UPDATE";

                                if (IdSaldoIncidencia > 0)
                                    vntP.IdIncidenciaTrabajador = IdSaldoIncidencia;
                                else
                                    vntP.IdIncidenciaTrabajador = IdNuevaIncidencia;

                                vntP.Importe = diasimsssaldo;

                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vntP);
                    }
                    }
                        //NominaTrabajador.setSaldosIncidencias(ConvenioLaboralTrabajadorCategoria, egq[0].IdIncidenciaTrabajador, "INCAPACIDAD POR ENFERMEDAD GENERAL", saldonuevaincidencia);
                        if (saldonuevaincidencia > 0)
                        {
                            VariablesNominaTrabajador vnt2 = new VariablesNominaTrabajador();
                            vnt2.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            vnt2.Concepto = "INCIDENCIA_SALDO_INSERT";
                            //vnt2.IdIncidenciaTrabajador = egq[0].IdIncidenciaTrabajador;
                            if (entro)
                            {
                                vnt2.IdIncidenciaTrabajador = 0;
                            }
                            else
                            {
                                if (egq.Count > 0)
                                    vnt2.IdIncidenciaTrabajador = egq[0].IdIncidenciaTrabajador;
                                else
                                    vnt2.IdIncidenciaTrabajador = saldoEnfermedad.IdIncidenciaTrabajador;
                            }
                            vnt2.Importe = saldonuevaincidencia;
                            NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt2);
                        }

                        if (saldoRemanente == 0)
                        {
                            saldonuevaincidencia = saldonuevaincidencia - (totalpercepciones - ImporteSaldoEnfermedad);
                            VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();
                            vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            vnt.Concepto = "INCIDENCIA_SALDO_UPDATE";
                            //vnt.IdIncidenciaTrabajador = egq[0].IdIncidenciaTrabajador;
                            if (entro)
                            {
                                vnt.IdIncidenciaTrabajador = 0;
                            }
                            else
                            {
                                if (egq.Count > 0)
                                    vnt.IdIncidenciaTrabajador = egq[0].IdIncidenciaTrabajador;
                                else
                                    vnt.IdIncidenciaTrabajador = saldoEnfermedad.IdIncidenciaTrabajador;
                            }




                            vnt.Importe = saldonuevaincidencia;
                            NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt);
                        }
                    }

                }
                else
                    if (totaldiassaldo!=null )
                {
                    if (totaldiassaldo.Saldo > 0)
                    {

                        VariablesNominaTrabajador vnt14 = new VariablesNominaTrabajador();
                        vnt14.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        vnt14.Concepto = "INCIDENCIA_DIAS_IMSS";
                        vnt14.IdIncidenciaTrabajador = IdNuevaIncidencia;
                        vnt14.Importe = (int)totaldiassaldo.DiasSaldo;

                        var diasimsssaldo = 0;

                        if (totaldiassaldo.DiasSaldo - (int)diaslaborados < 0)
                        {
                            diasimsssaldo = 0;
                        }

                        else
                            diasimsssaldo = (int)totaldiassaldo.DiasSaldo - (int)diaslaborados;


                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt14);




                        VariablesNominaTrabajador vntP = new VariablesNominaTrabajador();
                        vntP.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        vntP.Concepto = "INCIDENCIA_DIAS_SALDO_UPDATE";

                        vntP.IdIncidenciaTrabajador = IdNuevaIncidencia;

                        vntP.Importe = diasimsssaldo;

                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vntP);
                    }
                    }

                 


            }

            ////////////








        }
        //public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        //{


        //    if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "ENFERMEDAD GENERAL").FirstOrDefault() != null)

        //    {
        //        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();
        //        String qna = NominaTrabajador.Nomina.Catalogos_ctQuincenaMes.QuincenaMes;
        //        string año = NominaTrabajador.Nomina.FechaInicio.Year.ToString();

        //        var totalpercepciones = NominaTrabajador.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
        //        && v.EsGrabable == true).ToList());

        //        var valoresEspeciales = NominaTrabajador.PrestacionesIncapacidadesSueldoIsr(ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria);

        //        totalpercepciones = totalpercepciones + valoresEspeciales;


        //        var saldoEnfermedad = db.Nomina_IncidenciasSaldos.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
        //        && s.IncidenciaPermiso_stIncidenciaTrabajador.Catalogos_ctTipoIncidencia.Incidencia == "INCAPACIDAD POR ENFERMEDAD GENERAL"
        //          && s.Saldo > 0).OrderByDescending(s => s.Nomina_stNomina.FechaTermino).FirstOrDefault();


        //        decimal saldoRemanente = 0;
        //        bool SeActualizoSaldo = false;
        //        bool SaldosNuevoYActualizado = false;
        //        bool TerminaPago = false;

        //        decimal ImporteSaldoEnfermedad = 0;

        //        long IdNuevaIncidencia = 0;
        //        long IdSaldoIncidencia = 0;
        //        decimal saldonuevaincidencia = 0;

        //        if (saldoEnfermedad != null)
        //        {
        //            ImporteSaldoEnfermedad = saldoEnfermedad.Saldo;
        //            IdSaldoIncidencia = saldoEnfermedad.IdIncidenciaTrabajador;
        //        }
        //        decimal montomaximo = 0;

        //        var egq = NominaTrabajador.IncidenciasTrabajadores.Where
        //                        (i => i.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria

        //                            && i.Catalogos_ctTipoIncidencia.Incidencia == "INCAPACIDAD POR ENFERMEDAD GENERAL"

        //                            ).OrderBy(j => j.FechaInicio).ToList();

        //        EnfermedadControl enfermedad = new EnfermedadControl();

        //        if (egq.Count() > 0)
        //        {


        //            decimal sumapercepcionesquincenales = NominaTrabajador.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).ToList());
        //            decimal montomaximodescuento = sumapercepcionesquincenales;

        //            var existedespensa = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(s => !s.Nomina_ctPlantillaNomina.Plantilla.Contains("PROPORCIONALES") && s.Percepciones_ctPercepcion.Percepcion == "VALES DE DESPENSA" && s.Calcular == true).OrderByDescending(q => q.Percepciones_ctPercepcion).FirstOrDefault();

        //            Decimal despensacosto = 0M;
        //            if (existedespensa != null)
        //            {
        //                despensacosto = (decimal)existedespensa.Importe / 2;
        //            }

        //            var existeayuda = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(s => !s.Nomina_ctPlantillaNomina.Plantilla.Contains("PROPORCIONALES") && s.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA DESPENSA" && s.Calcular == true).FirstOrDefault();

        //            Decimal ayudacosto = 0M;
        //            if (existeayuda != null)
        //            {
        //                ayudacosto = (decimal)existeayuda.Importe;
        //            }

        //            montomaximo = sumapercepcionesquincenales;
        //            sumapercepcionesquincenales = sumapercepcionesquincenales + despensacosto + ayudacosto;

        //            decimal percepciondiaria = sumapercepcionesquincenales / 15M;


        //            //foreach (var item in egq)
        //            //{
        //            List<EnfermedadControl> enfermedad40 = (from c in egq
        //                                join o in db.Nomina_IncidenciaPermisoCalculo
        //                                on c.IdIncidenciaTrabajador equals o.IdIncidenciaTrabajador
        //                                where o.EsAplicada == false && o.DiasPagados40 > 0
        //                                select new EnfermedadControl
        //                                {
        //                                    IdIncidenciaTrabajadorCalculo=o.IdIncidenciaTrabajadorCalculo,
        //                                    IdConvenioLaboralTrabajadorCategoria=c.IdConvenioLaboralTrabajadorCategoria,
        //                                    IdIncidenciaTrabajador=o.IdIncidenciaTrabajador,
        //                                    QuincenaMes=o.QuincenaMes,
        //                                    DiasPagados40=o.DiasPagados40
        //                                }).ToList();

        //            List<EnfermedadControl> enfermedad100 = (from c in egq
        //                                 join o in db.Nomina_IncidenciaPermisoCalculo
        //                                 on c.IdIncidenciaTrabajador equals o.IdIncidenciaTrabajador
        //                                 where o.EsAplicada == false && o.DiasPagados100 > 0
        //                                 select new EnfermedadControl
        //                                 {
        //                                     IdIncidenciaTrabajadorCalculo = o.IdIncidenciaTrabajadorCalculo,
        //                                     IdConvenioLaboralTrabajadorCategoria = c.IdConvenioLaboralTrabajadorCategoria,
        //                                     IdIncidenciaTrabajador = o.IdIncidenciaTrabajador,
        //                                     QuincenaMes = o.QuincenaMes,
        //                                     DiasPagados40 = o.DiasPagados100
        //                                 }).ToList();

        //            foreach (var item in enfermedad100)
        //            {

        //                Nomina_IncidenciaPermisoCalculo grabarquincena = db.Nomina_IncidenciaPermisoCalculo.Find(item.IdIncidenciaTrabajadorCalculo);
        //                grabarquincena.QuincenaMes = qna;
        //                grabarquincena.Año = Convert.ToInt16(NominaTrabajador.Nomina.FechaInicio.Year);
        //                grabarquincena.PercepcionDiaria = percepciondiaria;
        //                db.Entry(grabarquincena).State = EntityState.Modified;
        //                db.SaveChanges();
        //            }

        //            int diasenfermedad40 = 0;
        //            int existe40 = 0;

        //            enfermedad = enfermedad40.LastOrDefault();
        //            foreach (var item in enfermedad40)
        //            {
        //                diasenfermedad40 = diasenfermedad40 + item.DiasPagados40;
        //                Nomina_IncidenciaPermisoCalculo grabarquincena = db.Nomina_IncidenciaPermisoCalculo.Find(item.IdIncidenciaTrabajadorCalculo);
        //                grabarquincena.QuincenaMes = qna;
        //                grabarquincena.Año = Convert.ToInt16(NominaTrabajador.Nomina.FechaInicio.Year);
        //                grabarquincena.PercepcionDiaria = percepciondiaria;
        //                db.Entry(grabarquincena).State = EntityState.Modified;
        //                db.SaveChanges();
        //            }



        //            saldonuevaincidencia = diasenfermedad40 * percepciondiaria * (decimal)0.6;


        //        }



        //        if (ImporteSaldoEnfermedad + saldonuevaincidencia >0)
        //        {
        //            NominaTrabajador.TrabajadorConIncapacipdadActivaConcepto = "INCAPACIDAD POR ENFERMEDAD GENERAL";
        //            if (ImporteSaldoEnfermedad + saldonuevaincidencia < totalpercepciones)
        //                    {
        //                NominaTrabajador.TrabajadorConIncapacipdadActiva = false;

        //                if (saldoEnfermedad!=null)
        //                saldoRemanente = saldoEnfermedad.Saldo - saldoEnfermedad.Saldo;

        //                // 
        //                VariablesNominaTrabajador vnt1 = new VariablesNominaTrabajador();
        //                vnt1.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
        //                vnt1.Concepto = "INCIDENCIA_SALDO_UPDATE";
        //                vnt1.IdIncidenciaTrabajador = IdSaldoIncidencia;
        //                vnt1.Importe = saldoRemanente;
        //                NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt1);

        //                if (saldonuevaincidencia > 0)
        //                {

        //                    VariablesNominaTrabajador vnt2 = new VariablesNominaTrabajador();
        //                    vnt2.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
        //                    vnt2.Concepto = "INCIDENCIA_SALDO_INSERT";
        //                    vnt2.IdIncidenciaTrabajador = egq[0].IdIncidenciaTrabajador;
        //                    vnt2.Importe = saldonuevaincidencia;
        //                    NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt2);


        //                    VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();
        //                    vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
        //                    vnt.Concepto = "INCIDENCIA_SALDO_UPDATE";
        //                    vnt.IdIncidenciaTrabajador = egq[0].IdIncidenciaTrabajador;
        //                    vnt.Importe = 0;
        //                    NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt);
        //                }




        //                        TerminaPago = true;

        //                        DeduccionesNominaTrabajador isr = new DeduccionesNominaTrabajador();
        //                        isr.EsImprimibleRecibo = true;
        //                        isr.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
        //                        isr.IdNomina = NominaTrabajador.Nomina_stNomina.IdNomina;
        //                        isr.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "ENFERMEDAD GENERAL").FirstOrDefault().IdPlantillaNominaDeduccion;
        //                        isr.Importe = ImporteSaldoEnfermedad + saldonuevaincidencia;

        //                        NominaTrabajador.ListaDeduccionesTrabajadores.Add(isr);

        //                    }
        //                    else
        //                    {
        //                        NominaTrabajador.TrabajadorConIncapacipdadActiva = true;
        //                        DeduccionesNominaTrabajador isr = new DeduccionesNominaTrabajador();
        //                        isr.EsImprimibleRecibo = true;
        //                        isr.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
        //                        isr.IdNomina = NominaTrabajador.Nomina_stNomina.IdNomina;
        //                        isr.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "ENFERMEDAD GENERAL").FirstOrDefault().IdPlantillaNominaDeduccion;
        //                        isr.Importe = totalpercepciones;

        //                        NominaTrabajador.ListaDeduccionesTrabajadores.Add(isr);
        //                        if (ImporteSaldoEnfermedad < totalpercepciones)
        //                            saldoRemanente = ImporteSaldoEnfermedad - ImporteSaldoEnfermedad;
        //                        else
        //                            saldoRemanente =  ImporteSaldoEnfermedad- totalpercepciones;



        //                VariablesNominaTrabajador vnt1 = new VariablesNominaTrabajador();
        //                vnt1.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
        //                vnt1.Concepto = "INCIDENCIA_SALDO_UPDATE";
        //                vnt1.IdIncidenciaTrabajador = IdSaldoIncidencia;
        //                vnt1.Importe = saldoRemanente;
        //                NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt1);



        //                if (saldonuevaincidencia > 0)
        //                {
        //                    VariablesNominaTrabajador vnt2 = new VariablesNominaTrabajador();
        //                    vnt2.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
        //                    vnt2.Concepto = "INCIDENCIA_SALDO_INSERT";
        //                    vnt2.IdIncidenciaTrabajador = egq[0].IdIncidenciaTrabajador;
        //                    vnt2.Importe = saldonuevaincidencia;
        //                    NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt2);
        //                }

        //                if (saldoRemanente == 0)
        //                {
        //                    saldonuevaincidencia = saldonuevaincidencia - (totalpercepciones - ImporteSaldoEnfermedad);
        //                    VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();
        //                    vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
        //                    vnt.Concepto = "INCIDENCIA_SALDO_UPDATE";
        //                    vnt.IdIncidenciaTrabajador = egq[0].IdIncidenciaTrabajador;
        //                    vnt.Importe = saldonuevaincidencia;
        //                    NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt);
        //                }
        //                }

        //                }




        //        }





        //}
    }
}