﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Models.Calculos.Deducciones
{
    public class DeduccionesPersonalizadas : IDeduccionBehavior
    {
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {
            if (!NominaTrabajador.TrabajadorConIncapacipdadActiva)
              //  if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Nomina_ctTipoNomina.TipoNomina == "ORDINARIA")

                {
                    foreach (var item in NominaTrabajador.getDeduccionesPersonalizadas().Where(a=> a.IdConvenioLaboralTrabajadorCategoria==ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).ToList())
                    {
                        var percepcionCalculo = NominaTrabajador.PlantillasNominasDeducciones.Where(x => x.IdPlantillaNomina == NominaTrabajador.Nomina.IdPlantillaNomina && x.Deducciones_ctDeduccion.IdDeduccion == item.IdDeduccion).FirstOrDefault();
                        bool esCredito = false;
                        if (percepcionCalculo != null)
                        {
                            bool accesso = false;
                            
                            if (percepcionCalculo.Deducciones_ctDeduccion.Deduccion == "DESCUENTO POR PAGO INDEBIDO"
                                    || percepcionCalculo.Deducciones_ctDeduccion.Deduccion == "AJUSTE"
                                    || percepcionCalculo.Deducciones_ctDeduccion.Deduccion.Contains("FALTA")
                                    || percepcionCalculo.Deducciones_ctDeduccion.Deduccion =="SANCIÓN SINDICAL POR INCUMPLIMIENTO" )
                            {
                            // if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO"))
                            //{
                            // se busca el concepto de la percepcion almacenado en la deuduccion segun la plantilla de la nomina
                            // var percepconcepto = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.IdPlantillaNomina == NominaTrabajador.Nomina.IdPlantillaNomina && x.Percepciones_ctPercepcion.Percepcion == item.Concepto).FirstOrDefault();
                            bool esnominasueldo = false;
                            var percepconcepto = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNomina == NominaTrabajador.Nomina.IdPlantillaNomina && x.Percepciones_ctPercepcion.Percepcion == item.Concepto).FirstOrDefault();
                            if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO")
                                && !NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT"))
                            {
                                esnominasueldo = true;
                            }


                            if (esnominasueldo && item.Concepto.Contains("ESTÍMULO POR PUNTUALIDAD Y ASISTENCIA") ||  item.Concepto.Contains("DÍAS ECONOMICOS NO DISFRUTADOS"))
                            {
                                var percepconceptorellab = NominaTrabajador.PlantillaNominaDeduccionesRelacionLaboral.Where(x => x.IdPlantillaNomina == NominaTrabajador.Nomina.IdPlantillaNomina && x.IdDeduccion == item.IdDeduccion).FirstOrDefault();
                                if(percepconceptorellab!=null)
                                    accesso = true;

                            }else
                            if (percepconcepto != null)
                                    accesso = true;
                                else
                                {

                                //    //var percepconceptodos = NominaTrabajador.PlantillaNominaDeduccionesRelacionLaboral.Where(x => x.IdPlantillaNomina == NominaTrabajador.Nomina.IdPlantillaNomina && x.IdDeduccion == item.IdDeduccion).FirstOrDefault();
                                    var percepconceptodos = NominaTrabajador.PlantillasNominasDeducciones.Where(x => x.IdPlantillaNomina == NominaTrabajador.Nomina.IdPlantillaNomina && x.IdDeduccion == item.IdDeduccion).FirstOrDefault();
                                if (esnominasueldo &&  percepcionCalculo.Deducciones_ctDeduccion.Deduccion == "SANCIÓN SINDICAL POR INCUMPLIMIENTO")
                                {
                                    if (percepconceptodos != null)
                                            { accesso = true; }

                                }
                                else
                                    if (percepconceptodos != null && percepconcepto != null)
                                        accesso = true;

                                }
                             //}
                            }

                            if (
                                     percepcionCalculo.Deducciones_ctDeduccion.Deduccion == "DIFERENCIA")
                            {

                                string concepto = item.Concepto;
                                if (item.Concepto.Contains("CRÉDITO") && !NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT"))
                                {
                                    concepto = "CRÉDITO";
                                    esCredito = true;
                                }

                                var deducconcepto = NominaTrabajador.PlantillaNominaDeduccionesRelacionLaboral.Where(x => x.IdPlantillaNomina == NominaTrabajador.Nomina.IdPlantillaNomina && x.Deducciones_ctDeduccion.Deduccion.Contains(concepto)).FirstOrDefault();
                                if (deducconcepto != null)
                                    accesso = true;
                             
                            }

                        if ( !NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT") && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("ANTICIPO AGUINALDO"))
                        { accesso = true; }

                            if (accesso)
                            {

                                bool esvalida = false;
                                if (Convert.ToInt16(NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes) % 2 == 0 && item.Catalogos_ctPeriodoNomina.PeriodoNomina == "MENSUAL")

                                    esvalida = true;

                                else
                                    if (item.Catalogos_ctPeriodoNomina.PeriodoNomina == "QUINCENAL")
                                    esvalida = true;

                                if (item.FechaTermino != null)
                                    if (item.FechaInicioDeduccion <= NominaTrabajador.Nomina.FechaInicio && item.FechaTermino >= NominaTrabajador.Nomina.FechaTermino)
                                        esvalida = true;
                                    else
                                        esvalida = false;

                                if (item.FechaInicioDeduccion <= NominaTrabajador.Nomina.FechaInicio && esvalida)
                                {



                                    DeduccionesNominaTrabajador deduccioncuotafija = new DeduccionesNominaTrabajador();
                                    deduccioncuotafija.EsImprimibleRecibo = true;
                                    deduccioncuotafija.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                                    deduccioncuotafija.IdNomina = NominaTrabajador.Nomina.IdNomina;
                                    
                                    string deduc = percepcionCalculo.Deducciones_ctDeduccion.Deduccion;
                                    
                                    deduccioncuotafija.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(z => z.Deducciones_ctDeduccion.Deduccion == deduc).SingleOrDefault().IdPlantillaNominaDeduccion;
                                    deduccioncuotafija.Importe = item.Importe;

                                    if (item.Concepto != null)
                                        if (item.Concepto != "")
                                            deduccioncuotafija.Concepto = item.Concepto;


                                    NominaTrabajador.ListaDeduccionesTrabajadores.Add(deduccioncuotafija);

                                if (percepcionCalculo.Deducciones_ctDeduccion.Deduccion == "SE EQUIVOCO OMAR SANCIÓN SINDICAL POR INCUMPLIMIENTO")
                                {
                                    var existeremanente = NominaTrabajador.ListaVariablesNominaTrabajador.Where(q =>
                                     q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                                     && q.Concepto == "SUELDO REMANENTE PENSION"
                                    ).FirstOrDefault();
                                    if (existeremanente != null)
                                    {
                                        VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();
                                        vnt.Concepto = "SUELDO REMANENTE PENSION";
                                        vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                        vnt.Importe = existeremanente.Importe - deduccioncuotafija.Importe;
                                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt);
                                    }
                                    else
                                    {
                                        var difregistro = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "DIFERENCIA").FirstOrDefault();
                                        int iddif = 0;
                                        if (difregistro != null)
                                            iddif = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "DIFERENCIA").FirstOrDefault().IdPlantillaNominaDeduccion;

                                        decimal diferenciasImss = NominaTrabajador.Suma(NominaTrabajador.ListaDeduccionesTrabajadores.Where(z =>
                  z.IdPlantillaNominaDeduccion == iddif && z.Concepto == "IMSS" &&
                  z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).ToList());

                                        var deducaDescontar = NominaTrabajador.PlantillaNominaDeduccionesRelacionLaboral.Where(x => x.Deducciones_ctDeduccion.Deduccion == "IMSS"
                         || x.Deducciones_ctDeduccion.Deduccion == "ISR" || x.Deducciones_ctDeduccion.Deduccion == "RIESGO DE TRABAJO"
                         || x.Deducciones_ctDeduccion.Deduccion == "MATERNIDAD"
                          || x.Deducciones_ctDeduccion.Deduccion == "DESCUENTO POR PAGO INDEBIDO"
                         || x.Deducciones_ctDeduccion.Deduccion == "ENFERMEDAD GENERAL" || x.Deducciones_ctDeduccion.Deduccion.StartsWith("FALTA")).Select(q => q.IdPlantillaNominaDeduccion).ToArray();

                                        var deducciones = NominaTrabajador.Suma(NominaTrabajador.ListaDeduccionesTrabajadores.Where(z =>
                     z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                     && deducaDescontar.Contains(z.IdPlantillaNominaDeduccion)).ToList());

                                        decimal descuentinfonavit = 0M;
                                        // aeste id no se le descuenta el infonavit para su pension
                                        if (ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == 1142)
                                        {
                                            var idcreditoinfonavit = NominaTrabajador.CreditosTrabajador.Where(a => a.Catalogos_ctTipoCredito.TipoCredito == "INFONAVIT").Select(a => a.IdCreditoTrabajador).ToArray();

                                            if (idcreditoinfonavit.Count() > 0)
                                                descuentinfonavit = NominaTrabajador.Suma(NominaTrabajador.ListaCreditosTrabajador.Where(s => idcreditoinfonavit.Contains(s.IdCreditoTrabajador)).ToList());

                                        }

                                        var sueldoremanente = NominaTrabajador.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).ToList()) - (deducciones + descuentinfonavit + diferenciasImss);

                                        VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();
                                        vnt.Concepto = "SUELDO REMANENTE PENSION";
                                        vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                        vnt.Importe = sueldoremanente - deduccioncuotafija.Importe;
                                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt);
                                    }
                                }

                            }
                            }
                        }
                    }
                }




        }

        void IDeduccionBehavior.Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            throw new NotImplementedException();
        }
    }
}