﻿using Dapper;
using Nova.Libraries;
using Nova.Models.Sindicato;
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Data.Entity.Validation;
using System.Linq;
using System.Transactions;
using System.Web;

namespace Nova.Models.AsignarPlaza
{
    public class Resultados
    {
        public bool IsValid { get; set; }
        public string Messsage { get; set; }
    }
    public class SolicitudesContratacion
    {
        private Boolean ValidaHorario(int idkardex, string cicloescolar)
        {
            Boolean regresa = false;

            bdAriesEntities bda = new bdAriesEntities();
            //  var horario=bda.stHorarioNominaDocente.Where(c => c.IdKardex == idkardex && c..IdCicloEscolar == cicloescolar).FirstOrDefault();



            DapperQuery dp = new DapperQuery("bdNovaEntities");

            List<CargaHoraria> model = dp.connection.Query<CargaHoraria>("spObtenCargaHorariaCicloKardex", new { CicloEscolar = cicloescolar.Replace(" ",""), IdKardex = idkardex }, commandType: CommandType.StoredProcedure).ToList();
            if (model.Count() > 0)
                regresa = true;

            return regresa;
        }
        public enum EstutusContratosEnum
        {
            ACEPTABLE,
            CONCARGAHORARIA,
            CONCITA,
            INFORMACIONCOTEJADA,
            ENESPERADECONTRATO,
            CONTRATADO,
            ENCENTROEDUCATIVO,
            NOACEPTABLE,
            PARAEVALUACIÓN
        }
        public void CambiaEstatusSolicitud(int ids, EstutusContratosEnum tipo)
        {
            Resultados rs = new Resultados();
            bdNovaEntities db = new bdNovaEntities();
            var model=db.Kardex_SolicitudEvaluaciones.Find(ids);

            var status = db.Catalogos_ctEstatusContratos.Where(q=> q.EstatusContratos.Replace(" ","")==tipo.ToString()).FirstOrDefault();
            model.IdEstatusContratacion = status.IdEstatusContratos;
            db.Entry(model).State = EntityState.Modified;
            db.SaveChanges();
            
        }
        public Resultados GuardarEnroque(EnroqueComisionModel model)
        {
            Resultados r = new Resultados();
            bdNovaEntities db = new bdNovaEntities();

            if (model.FechaInicio>= model.FechaTermino)
            {
                r.Messsage = "La fecha de inicio debe de ser mayor o igual a la fecha de termino";
                return r;
            }

        


           
            var trabajador1 = db.vwDatosAspirantesTrabajadores.Where(a => a.IdConvenioLaboralTrabajadorCategoria == model.IdConvenioLaboralTrabajadorCategoriaSuplido).FirstOrDefault();
            var trabajador2 = db.vwDatosAspirantesTrabajadores.Where(a => a.IdConvenioLaboralTrabajadorCategoria == model.IdConvenioLaboralTrabajadorCategoriaSuplente).FirstOrDefault();

            var existe = db.Nomina_SuplenciasSolicitudes.Where(x => x.IdKardexSuplente == trabajador1.IdKardex 
            && x.CicloEscolar == model.CicloEscolar ).FirstOrDefault();

            if (existe != null)
            {
                if (existe.FechaTermino >= model.FechaInicio)
                //return JsonView(false, "Ya existe una solicitud que finaliza" + existe.FechaTermino + " para " + existe.Kardex_ctDatosPersonales1.Nombre + " " + existe.Kardex_ctDatosPersonales1.ApellidoPaterno + " " + existe.Kardex_ctDatosPersonales1.ApellidoMaterno + " para el ciclo escolar: " + idce + " verifique su información.");
                {
                    r.Messsage = "Ya existe una solicitud que finaliza" + existe.FechaTermino + " para " + existe.Kardex_ctDatosPersonales1.Nombre + " " + existe.Kardex_ctDatosPersonales1.ApellidoPaterno + " " + existe.Kardex_ctDatosPersonales1.ApellidoMaterno + " para el ciclo escolar: " + model.CicloEscolar + " verifique su información.";
                    return r;
                }
            }

            var existe2 = db.Nomina_SuplenciasSolicitudes.Where(x => x.IdKardexSuplente == trabajador2.IdKardex
            && x.CicloEscolar == model.CicloEscolar ).FirstOrDefault();

            if (existe2 != null)
            {
                if (existe2.FechaTermino >= model.FechaInicio)
                //return JsonView(false, "Ya existe una solicitud que finaliza" + existe.FechaTermino + " para " + existe.Kardex_ctDatosPersonales1.Nombre + " " + existe.Kardex_ctDatosPersonales1.ApellidoPaterno + " " + existe.Kardex_ctDatosPersonales1.ApellidoMaterno + " para el ciclo escolar: " + idce + " verifique su información.");
                {
                    r.Messsage = "Ya existe una solicitud que finaliza" + existe2.FechaTermino + " para " + existe2.Kardex_ctDatosPersonales1.Nombre + " " + existe2.Kardex_ctDatosPersonales1.ApellidoPaterno + " " + existe2.Kardex_ctDatosPersonales1.ApellidoMaterno + " para el ciclo escolar: " + model.CicloEscolar + " verifique su información.";
                    return r;
                }
            }

            if (trabajador1.IdCategoria== trabajador2.IdCategoria)
            {
                r.Messsage = "No pueden ser trabajadores con la misma categoria";
                return r;
            }

            TransactionOptions transactionoptions1 = new TransactionOptions();
            transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadCommitted;

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
            {

                try
                {
            //        IncidenciaPermiso_stIncidenciaTrabajador nuevaincidencia = new IncidenciaPermiso_stIncidenciaTrabajador();

            //nuevaincidencia.IdConvenioLaboralTrabajadorCategoria = (int)trabajador1.IdConvenioLaboralTrabajadorCategoria;
            //nuevaincidencia.FechaCreacion = DateTime.Now;
            //nuevaincidencia.FechaInicio = model.FechaInicio;
            //nuevaincidencia.FechaTermino = model.FechaTermino;
            //nuevaincidencia.Autorizo = true;
            //nuevaincidencia.EsCerrada = true;
            //nuevaincidencia.FechaAutorizacion = DateTime.Now;
 
            //nuevaincidencia.IdTipoIncidencia = 82;


            //nuevaincidencia.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            //nuevaincidencia.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            //nuevaincidencia.IdConvenioLaboralTrabajadorCategoriaAutorizo = Nova.Models.Kardex_ctDatosPersonales.getIdJefeRecursosHumanos();

            //db.IncidenciaPermiso_stIncidenciaTrabajador.Add(nuevaincidencia);
            //db.SaveChanges();

            Nomina_SuplenciasSolicitudes nomina = new Nomina_SuplenciasSolicitudes();
            nomina.CicloEscolar = model.CicloEscolar;
            nomina.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            nomina.IdConvenioLaboralTrabajadorCategoriaCotejo= Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            nomina.EsCotejada = true;
            nomina.IdEstructuraOrganica = (short)trabajador1.IdEstructuraOrganica;
                    if (trabajador1.IdEstructuraOrganica!=trabajador1.IdEstructuraOrganicaFisica)
                        nomina.IdEstructuraOrganicaFisica= (short)trabajador1.IdEstructuraOrganicaFisica;

            nomina.FechaSolicitud = DateTime.Now;
            nomina.FechaAtencion = DateTime.Now;
            nomina.FechaInicio = model.FechaInicio;
            nomina.FechaTermino= model.FechaTermino;
            nomina.FolioOficio= model.Folio;
            nomina.OficioReferencia= model.FolioReferencia;
            nomina.IdCategoria= trabajador1.IdCategoria;
            nomina.IdKardexSuplido = trabajador1.IdKardex;
            nomina.IdKardexSuplente= trabajador2.IdKardex;
           // nomina.IdIncidenciaTrabajador = nuevaincidencia.IdIncidenciaTrabajador;
            nomina.IdTipoSuplencia = 22;

            //IncidenciaPermiso_stIncidenciaTrabajador nuevaincidencia2 = new IncidenciaPermiso_stIncidenciaTrabajador();

            //nuevaincidencia2.IdConvenioLaboralTrabajadorCategoria = (int)trabajador2.IdConvenioLaboralTrabajadorCategoria;
            //nuevaincidencia2.FechaCreacion = DateTime.Now;
            //nuevaincidencia2.FechaInicio = model.FechaInicio;
            //nuevaincidencia2.FechaTermino = model.FechaTermino;
            //nuevaincidencia2.Autorizo = true;
            //nuevaincidencia2.EsCerrada = true;
            //nuevaincidencia2.FechaAutorizacion = DateTime.Now;

            //nuevaincidencia2.IdTipoIncidencia = 82;


            //nuevaincidencia2.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            //nuevaincidencia2.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            //nuevaincidencia2.IdConvenioLaboralTrabajadorCategoriaAutorizo = Nova.Models.Kardex_ctDatosPersonales.getIdJefeRecursosHumanos();

            //db.IncidenciaPermiso_stIncidenciaTrabajador.Add(nuevaincidencia2);
            //db.SaveChanges();

            Nomina_SuplenciasSolicitudes nomina2 = new Nomina_SuplenciasSolicitudes();
            nomina2.CicloEscolar = model.CicloEscolar;
            nomina2.EsCotejada = true;
            nomina2.IdEstructuraOrganica = (short)trabajador2.IdEstructuraOrganica;
                    if (trabajador2.IdEstructuraOrganica != trabajador2.IdEstructuraOrganicaFisica)
                        nomina2.IdEstructuraOrganicaFisica = (short)trabajador2.IdEstructuraOrganicaFisica;

                    nomina2.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            nomina2.IdConvenioLaboralTrabajadorCategoriaCotejo = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            nomina2.FechaAtencion = DateTime.Now;
            nomina2.FechaRevision= DateTime.Now;
            nomina2.FechaSolicitud = DateTime.Now;
            nomina2.FechaInicio = model.FechaInicio;
            nomina2.FechaTermino = model.FechaTermino;
            nomina2.FolioOficio = model.Folio;
            nomina2.OficioReferencia = model.FolioReferencia;
            nomina2.IdCategoria = trabajador2.IdCategoria;
            nomina2.IdKardexSuplido = trabajador2.IdKardex;
            nomina2.IdKardexSuplente = trabajador1.IdKardex;
            nomina2.IdTipoSuplencia = 22;
           // nomina2.IdIncidenciaTrabajador= nuevaincidencia2.IdIncidenciaTrabajador;

               
                 
                    db.Entry(nomina).State = EntityState.Added;
                    db.SaveChanges();

                    db.Entry(nomina2).State = EntityState.Added;
                    db.SaveChanges();

                   
                    r.IsValid = true;
                    r.Messsage = "La comisión por enroque ha sido grabada exitosamente";
                }
                catch (DbEntityValidationException ex)
                {
                    // Obtener todos los errores de validación
                    var errorMessages = ex.EntityValidationErrors
                        .SelectMany(validationError => validationError.ValidationErrors)
                        .Select(validationError => $"<p>{validationError.ErrorMessage}</p>");

                    // Concatenar los mensajes de error en un solo mensaje
                    var errorMessage = string.Join("\n", errorMessages);
                    r.Messsage = errorMessage;
                    
                }
                catch (Exception e)
                {
                    string msg = ExceptionExtensions.GetOriginalException(e).Message;
                    r.Messsage = msg;
                }
                scope.Complete();
                
                
            }

                return r;
        }
            public Resultados GuardarSolicitudComision(int idin, int id, int idts, string fol, int ideo, int idc, string fi, string ff, string idce, string ideof = null, int idkardexeval=0)
        {
            Resultados r = new Resultados();
            bdNovaEntities db = new bdNovaEntities();
            Boolean Traslape = false;
            LicenciasPermisos clincidencias = new LicenciasPermisos();

            DateTime fechainicio = DateTime.Parse(fi);
            DateTime fechatermino = DateTime.Now;
            if (ff != "")
                fechatermino = DateTime.Parse(ff);

            Plazas_ctCategoria categoria = new Plazas_ctCategoria();
            //// si es baja es un movimiento que no existe como incidenciapermiso
            Kardex_SolicitudEvaluaciones solicitudEvaluaciones = new Kardex_SolicitudEvaluaciones();
            if (idkardexeval > 0)
            {
                solicitudEvaluaciones = db.Kardex_SolicitudEvaluaciones.Find(idkardexeval);
            
            }
            categoria = db.Plazas_ctCategoria.Include(a => a.Convenios_stRelacionConvenioLaboral).Where(z => z.IdCategoria == idc).FirstOrDefault();
            //else
            //   categoria = db.Plazas_stDistribucionPlazaCategoria.Where(q => q.IdDistribucionPlazaCategoria == idc).FirstOrDefault().Plazas_ctCategoria;

            

                if (categoria.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("DOCENTE"))
            {
                if (ValidaHorario(id, idce) == false)
                {
                    // return JsonView(false, "Se ha elegido una categoría DOCENTE, para continuar primero asigne un horario al trabajador seleccionado, a traves del sistema ARIES ");
                    
                    r.Messsage = "Se ha elegido una categoría DOCENTE, para continuar primero asigne un horario al trabajador seleccionado, a traves del sistema ARIES ";
                    return r;
                }
            }

            if (fechainicio >= fechatermino && (idts != 5))
            {
                //return JsonView(false, "La fecha de inicio no puede ser igual o mayor a la de término del contrato");
                r.Messsage = "La fecha de inicio no puede ser igual o mayor a la de término del contrato";
                return r;
            }



            int idks, idclt = 0;

          
            var Traslape2 = clincidencias.HayTraslapeContratosHistorial(id, fechainicio, fechatermino, idts);
            if (Traslape2 == true)
            {

                r.IsValid = false;
                r.Messsage = "No se puede agregar la solicitud porque existe traslape  de fechas con CONTRATOS Anteriores ";
                return r;
            }

            var datostrabajador = db.vwDatosAspirantesTrabajadores.Where(z => z.IdKardex == id).FirstOrDefault();

            if (idkardexeval == 0 && idts==7)
            {
                if (categoria.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral == datostrabajador.RelacionConvenioLaboral)
                {
                    r.Messsage = $"Ha elegido un categoria de la misma relacion laboral que tiene el candidato {datostrabajador.RelacionConvenioLaboral}, revise su información";
                    return r;
                }
            }
            idks = datostrabajador.IdKardex;
            var haySolicitudNoAtendida = db.Nomina_SuplenciasSolicitudes.Where(x => x.IdKardexSuplente == idks && x.EsAtendida == false).ToList();
            if (haySolicitudNoAtendida.Count > 0)
            {
                // return JsonView(false, "No se puede agregar la comisión porque existe una solicitud para el trabajador que no ha sido atendida");
                r.Messsage = "No se puede agregar la comisión porque existe una solicitud para el trabajador que no ha sido atendida";
                return r;

            }
            idclt = (int)datostrabajador.IdConvenioLaboralTrabajadorCategoria;
            Kardex_ctDatosPersonales kardex = db.Kardex_ctDatosPersonales.Find(idks);
            // Se generara una incidencia
            //var tipoIncidencia = db.Nomina_SuplenciaTipo.Where(z => z.IdTipoSuplencia == idts).FirstOrDefault();
            //int idTipoIncidencia = db.Catalogos_ctTipoIncidencia.Where(x=>x.Incidencia == tipoIncidencia.TipoSuplencia).FirstOrDefault().IdTipoIncidencia;
            //IncidenciaPermiso_stIncidenciaTrabajador inci = new IncidenciaPermiso_stIncidenciaTrabajador();
            //inci.IdTipoIncidencia = (short)idTipoIncidencia;
            //inci.EsCancelada = false;
            //inci.EsCerrada = false;
            //inci.FechaCreacion = DateTime.Now;
            //inci.FechaInicio = fechainicio;
            //inci.FechaTermino = fechatermino;
            //inci.IdConvenioLaboralTrabajadorCategoria = (int)datostrabajador.IdConvenioLaboralTrabajadorCategoria;
            //inci.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            Traslape = clincidencias.HayTraslapeComision(idks, idclt, fechainicio, fechatermino, idts);
            if (Traslape == true)
            {
                // return JsonView(false, "No se puede agregar la comisión porque existe traslape de fechas");
                r.Messsage = "No se puede agregar la comisión porque existe traslape de fechas";
                return r;


            }


            Nomina_SuplenciasSolicitudes solicitud = new Nomina_SuplenciasSolicitudes();
            solicitud.IdKardexSuplente = idks;

            if (idkardexeval > 0)
            {
                solicitud.IdKardexSuplido = solicitudEvaluaciones.Convenios_stConvenioLaboralTrabajadorCategoria1.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.IdKardex;
                var incidencia = db.vwLicenciasTrabajadores
                    .Where(a=> a.IdConvenioLaboralTrabajadorCategoria==solicitudEvaluaciones.IdConvenioLaboralTrabajadorCategoriaaCubrir 
                    && a.Incidencia==solicitudEvaluaciones.Nomina_SuplenciaTipo.TipoSuplencia
                    && a.ESTATUS=="ACTIVA").FirstOrDefault();
                if (incidencia != null)
                    solicitud.IdIncidenciaTrabajador = incidencia.IdIncidenciaTrabajador;
                else
                {
                    r.Messsage = "No se encuentra una comisión activa para el personal de base, revise su información";
                    return r;
                }
            }
            else
            {
                solicitud.IdKardexSuplido = idks;
                solicitud.IdIncidenciaTrabajador = null;
            }

            solicitud.CicloEscolar = idce;
            solicitud.FechaInicio = fechainicio;

            if (ff != "")
                solicitud.FechaTermino = fechatermino;
            else
                solicitud.FechaTermino = null;

            solicitud.FechaSolicitud = DateTime.Now;
            solicitud.FolioOficio = fol;

            if (idts == 6)
                solicitud.IdCategoria = (short)idc;
            else
                solicitud.IdCategoria = categoria.IdCategoria;

            solicitud.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            solicitud.IdEstructuraOrganica = (short)ideo;

            if (ideof != null)
                if (ideof != "")
                    solicitud.IdEstructuraOrganicaFisica = Libraries.ConvertToInt.ConvertToInt16(ideof);

            solicitud.IdTipoSuplencia = idts;
           
            solicitud.EsCotejada = true;
            solicitud.IdConvenioLaboralTrabajadorCategoriaCotejo = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            solicitud.FechaRevision = DateTime.Now;
            try
            {
                //db.Entry(inci).State = EntityState.Added;
                //db.SaveChanges();
                //solicitud.IdIncidenciaTrabajador = inci.IdIncidenciaTrabajador;
                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadCommitted;

                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {
                    db.Entry(solicitud).State = EntityState.Added;
                    db.SaveChanges();

                    if (idkardexeval > 0)
                    {

                        CambiaEstatusSolicitud(idkardexeval, EstutusContratosEnum.ENESPERADECONTRATO);
                    }
                    // SendPushNotification("Ha generado una solicitud de comisión para: " + kardex.Nombre + " " + kardex.ApellidoPaterno, TypePushNotification.success, "Nómina,ServiciosDocentes");
                    scope.Complete();
                }

                //return JsonView(true, "Se ha generado exitosamente la solicitud de comisión");
                r.IsValid = true;
                r.Messsage = "Ha generado una solicitud de comisión para: " + kardex.Nombre + " " + kardex.ApellidoPaterno;
                return r;
            }
            catch (Exception e)
            {

                string msg = ExceptionExtensions.GetOriginalException(e).Message;
                if (msg.IndexOf("UK_") > -1)
                {
                    //   return JsonView(false, "Ya existe una solicitud con los datos proporcionados, revise su información");
                    r.Messsage = "Ya existe una solicitud con los datos proporcionados, revise su información";
                    return r;
                }
                else
                {
                    //return JsonView(false, msg);
                    r.Messsage = msg;
                    return r;
                }
            }

        }

        public Resultados GuardarSolicitud(int idin, int id, int idts, string fol, int ideo, int idc, string fi, string ff, string idce, string ideof = null, int idkardexeval = 0)
        {
            Resultados r = new Resultados();

            bdNovaEntities db = new bdNovaEntities();

            DateTime fechainicio = DateTime.Parse(fi);
            DateTime fechatermino = DateTime.Now;
            if (ff != "")
                fechatermino = DateTime.Parse(ff);

            IncidenciaPermiso_stIncidenciaTrabajador incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(idin);
            Plazas_ctCategoria categoria = new Plazas_ctCategoria();
            //// si es baja es un movimiento que no existe como incidenciapermiso
            if (idts == 5 && idkardexeval==0)
            {
                ideo = incidencia.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.IdEstructuraOrganica;
                categoria = db.Plazas_ctCategoria.Find(incidencia.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.IdCategoria);
                idc = categoria.IdCategoria;
            }
            else
            {
                categoria = db.Plazas_ctCategoria.Find(idc);
            }


            if (categoria.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("DOCENTE"))
            {
                if (ValidaHorario(id, idce) == false)
                {
                    // return JsonView(false, "Se ha elegido una categoría DOCENTE, para continuar primero asigne un horario al trabajador seleccionado, a traves del sistema ARIES ");
                    r.Messsage = "Se ha elegido una categoría DOCENTE, para continuar primero asigne un horario al trabajador seleccionado, a traves del sistema ARIES ";
                    return r;
                }
            }

            if (fechainicio >= fechatermino && (idts != 5))
            {
                // return JsonView(false, "La fecha de inicio no puede ser igual o mayor a la de término del contrato");
                r.Messsage = "La fecha de inicio no puede ser igual o mayor a la de término del contrato";
                return r;
            }


            if (fechainicio < incidencia.FechaInicio && (idts != 5))
            {
                //return JsonView(false, "La fecha de inicio de la propuesta no puede ser menor a la de inicio del permiso y/o licencia");
                r.Messsage = "La fecha de inicio de la propuesta no puede ser menor a la de inicio del permiso y/o licencia";
                return r;
            }

            if (ff != "")
                if (fechatermino > incidencia.FechaTermino && (idts != 5))
                {
                    //return JsonView(false, "La fecha de termino de la propuesta no puede ser mayor a la de término del permiso y/o licencia");
                    r.Messsage = "La fecha de termino de la propuesta no puede ser mayor a la de término del permiso y/o licencia";
                    return r;
                }

            int idks = 0;


            //    Kardex_stEstatusTrabajador kardexBaja = db.Kardex_stEstatusTrabajador.Find(idin);

            //    idks = kardexBaja.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;

            //}
            //else
            //{
            //int idks


            idks = incidencia.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            //}

            //var existe=db.Nomina_SuplenciasSolicitudes.Where(x => x.IdKardexSuplido == idks && x.CicloEscolar == idce).FirstOrDefault();

            //if (existe!=null)
            //{
            //    return JsonView(false, "Ya existe una solicitud para "+existe.Kardex_ctDatosPersonales.Nombre+" "+ existe.Kardex_ctDatosPersonales.ApellidoPaterno+" "+ existe.Kardex_ctDatosPersonales.ApellidoMaterno+" para el ciclo escolar: "+idce+" verifique su información.");
            //}

            Kardex_ctDatosPersonales kardex = db.Kardex_ctDatosPersonales.Find(id);

            LicenciasPermisos clincidencias = new LicenciasPermisos();
            var Traslape = clincidencias.HayTraslapeContratosHistorial(id, fechainicio, fechatermino, idts);
            if (Traslape == true)
            {

                r.IsValid = false;
                r.Messsage = "No se puede agregar la solicitud porque existe traslape  de fechas con CONTRATOS Anteriores ";
                return r;
            }

            Nomina_SuplenciasSolicitudes solicitud = new Nomina_SuplenciasSolicitudes();
            solicitud.IdKardexSuplente = id;

            solicitud.IdKardexSuplido = idks;

            solicitud.CicloEscolar = idce;
            solicitud.FechaInicio = fechainicio;

            if (ff != "")
                solicitud.FechaTermino = fechatermino;
            else
                solicitud.FechaTermino = null;

            solicitud.FechaSolicitud = DateTime.Now;
            solicitud.FolioOficio = fol;

            solicitud.IdCategoria = (short)idc;

            solicitud.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            solicitud.IdEstructuraOrganica = (short)ideo;

            if (ideof != null)
                if (ideof != "")
                    solicitud.IdEstructuraOrganicaFisica = Libraries.ConvertToInt.ConvertToInt16(ideof);

            solicitud.IdTipoSuplencia = idts;
            solicitud.IdIncidenciaTrabajador = idin;

            if (categoria.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("ADMINISTRATIVO") )
            {
                solicitud.EsCotejada = true;
                solicitud.IdConvenioLaboralTrabajadorCategoriaCotejo = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                solicitud.FechaRevision = DateTime.Now;
            }

                try
            {
                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadCommitted;

                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {
                    if (idkardexeval > 0)
                    {
                        solicitud.IdKardexSolicitudEvaluacion = idkardexeval;
                    }

                    db.Entry(solicitud).State = EntityState.Added;
                    db.SaveChanges();
                    if (idkardexeval > 0)
                    {
                       
                            CambiaEstatusSolicitud(idkardexeval, EstutusContratosEnum.ENESPERADECONTRATO);
                    }

                    scope.Complete();

                }
                
                //SendPushNotification("Ha generado una solicitud de contratación para: " + kardex.Nombre + " " + kardex.ApellidoPaterno, TypePushNotification.success, "Nómina,ServiciosDocentes");
                r.IsValid = true;
                r.Messsage = "Ha generado una solicitud de contratación para: " + kardex.Nombre + " " + kardex.ApellidoPaterno;
                return r;
                // return JsonView(true, "Se ha generado exitosamente la solicitud de contratación");
            }
            catch (Exception e)
            {

                string msg = ExceptionExtensions.GetOriginalException(e).Message;
                if (msg.IndexOf("UK_") > -1)
                {//return JsonView(false, "Ya existe una solicitud con los datos proporcionados, revise su información");

                    r.Messsage = "Ya existe una solicitud con los datos proporcionados, revise su información";
                    return r;
                }
                else
                {
                    r.Messsage = msg;
                    return r;
                    //   return JsonView(false, msg);
                }
            }


            //return r;
        }
        public Resultados GuardarIncorporacion(int id, int idts, string fol, int ideo, int idc, string fi, string ff, string idce, string ofsin, string obs,string ideof = null, int idkardexeval = 0)
        {
            bdNovaEntities db = new bdNovaEntities();

            Resultados t = new Resultados();

            DateTime fechainicio = DateTime.Parse(fi);
            DateTime fechatermino = new DateTime();
            if (ff.Trim() != "")
                fechatermino = DateTime.Parse(ff);

            var categoria = db.Plazas_ctCategoria.Find(idc);

            LicenciasPermisos clincidencias = new LicenciasPermisos();
            var Traslape = clincidencias.HayTraslapeContratosHistorial(id, fechainicio, fechatermino, idts);
            if (Traslape == true)
            {
                
                t.IsValid = false;
                t.Messsage = "No se puede agregar la solicitud porque existe traslape  de fechas con CONTRATOS Anteriores ";
                return t;
            }

            if (categoria.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("DOCENTE"))
            {
                if (ValidaHorario(id, idce) == false)
                {
                    //return JsonView(false, "Se ha elegido una categoría DOCENTE, para continuar primero asigne un horario al trabajador seleccionado para el ciclo escolar " + idce + ", a traves del sistema ARIES ");
                    t.IsValid = false;
                        t.Messsage="Se ha elegido una categoría DOCENTE, para continuar primero asigne un horario al trabajador seleccionado para el ciclo escolar " + idce + ", a traves del sistema ARIES ";
                    return t;
                }
            }

            if (ff.Trim() != "")
                if (fechainicio >= fechatermino)
                {
                    t.Messsage = "La fecha de inicio no puede ser igual o mayor a la de término del contrato";
                    return t;
                }

            var existe = db.Nomina_SuplenciasSolicitudes.Where(x => x.IdKardexSuplente == id && x.CicloEscolar == idce && x.EsAtendida).FirstOrDefault();

            if (existe != null)
            {
                if (existe.FechaTermino >= fechainicio)
                //return JsonView(false, "Ya existe una solicitud que finaliza" + existe.FechaTermino + " para " + existe.Kardex_ctDatosPersonales1.Nombre + " " + existe.Kardex_ctDatosPersonales1.ApellidoPaterno + " " + existe.Kardex_ctDatosPersonales1.ApellidoMaterno + " para el ciclo escolar: " + idce + " verifique su información.");
                {
                    t.Messsage = "Ya existe una solicitud que finaliza" + existe.FechaTermino + " para " + existe.Kardex_ctDatosPersonales1.Nombre + " " + existe.Kardex_ctDatosPersonales1.ApellidoPaterno + " " + existe.Kardex_ctDatosPersonales1.ApellidoMaterno + " para el ciclo escolar: " + idce + " verifique su información.";
                    return t;
                }
            }


            Kardex_ctDatosPersonales kardex = db.Kardex_ctDatosPersonales.Find(id);



            Nomina_SuplenciasSolicitudes solicitud = new Nomina_SuplenciasSolicitudes();

            solicitud.IdKardexSuplente = id;
            if (idts == 6)
            {
                solicitud.IdKardexSuplido = id;
            }
            else
            {
                solicitud.IdKardexSuplido = null;
            }

            if (ideof != "")
                solicitud.IdEstructuraOrganicaFisica = Nova.Libraries.ConvertToInt.ConvertToInt16(ideof);

            solicitud.CicloEscolar = idce;
            solicitud.FechaInicio = fechainicio;

            if (ff.Trim() != "")
                solicitud.FechaTermino = fechatermino;
            else
                solicitud.FechaTermino = null;

            solicitud.FechaSolicitud = DateTime.Now;
            solicitud.FolioOficio = fol;
            solicitud.IdCategoria = (short)categoria.IdCategoria;

            solicitud.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            solicitud.IdEstructuraOrganica = (short)ideo;
            solicitud.IdIncidenciaTrabajador = null;
            solicitud.IdTipoSuplencia = idts;
            solicitud.IdIncidenciaTrabajador = null;

            solicitud.OficioReferencia = ofsin;

            solicitud.ObservacionFinal = obs;

            
                solicitud.EsCotejada = true;
                solicitud.IdConvenioLaboralTrabajadorCategoriaCotejo = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                solicitud.FechaRevision = DateTime.Now;
           

            try
            {
                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadCommitted;

                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {

                    if (idkardexeval > 0)
                    {
                        solicitud.IdKardexSolicitudEvaluacion = idkardexeval;
                    }

                db.Entry(solicitud).State = EntityState.Added;
                db.SaveChanges();
                if (idkardexeval > 0)
                {
                    
                  
                        CambiaEstatusSolicitud(idkardexeval, EstutusContratosEnum.ENESPERADECONTRATO);
                }

                    scope.Complete();

                }

                t.IsValid = true;
                // SendPushNotification("Ha generado una solicitud de contratación para: " + kardex.Nombre + " " + kardex.ApellidoPaterno, TypePushNotification.success, "Nómina,ServiciosDocentes");
                t.Messsage= "Ha generado una solicitud de contratación para: " + kardex.Nombre + " " + kardex.ApellidoPaterno;
                return t;
                //return JsonView(true, "Se ha generado exitosamente la solicitud de contratación");
            }
            catch (Exception e)
            {
                string msg = ExceptionExtensions.GetOriginalException(e).Message;

                if (msg.IndexOf("UK_") > -1)
                    //return JsonView(false, "Ya existe una solicitud con los datos proporcionados, revise su información");
                    t.Messsage = "Ya existe una solicitud con los datos proporcionados, revise su información";
                else
                    //return JsonView(false, msg);
                    t.Messsage = msg;

                return t;
            }

            return t;
        }
        
            public Resultados GuardarSolicitudLicencia(int idin, int id, int idts, string fol, int ideo, int idc, string fi, string ff, string idce, string ideof = null,int idkardexeval=0)
        {
            Resultados r = new Resultados();
            bdNovaEntities db = new bdNovaEntities();
            Boolean Traslape = false;
            LicenciasPermisos clincidencias = new LicenciasPermisos();

            Plazas_ctCategoria plaza = new Plazas_ctCategoria();

            plaza = db.Plazas_ctCategoria.Find(idc);

            var tipoIncidencia = db.Nomina_SuplenciaTipo.Where(z => z.IdTipoSuplencia == idts).FirstOrDefault();

            DateTime fechainicio = DateTime.Parse(fi);
            DateTime fechatermino = DateTime.Now;
            if (ff != "")
                fechatermino = DateTime.Parse(ff);
            var datosescalafon = db.IncidenciaPermiso_stIncidenciaTrabajador
                .Include(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador)
                .Where(z => z.IdIncidenciaTrabajador == idin).FirstOrDefault();
            //// si es baja es un movimiento que no existe como incidenciapermiso

            if (fechainicio >= fechatermino && (idts != 5))
            {
                // return JsonView(false, "La fecha de inicio no puede ser igual o mayor a la de término de la solicitud");
                 r.Messsage="La fecha de inicio no puede ser igual o mayor a la de término de la solicitud";
                return r;
            }
            if ((fechainicio < datosescalafon.FechaInicio && fechatermino > datosescalafon.FechaTermino && datosescalafon.FechaTermino != null)
                || (fechainicio < datosescalafon.FechaInicio && fechatermino > datosescalafon.FechaTermino && datosescalafon.FechaTermino != null)
                || (fechainicio < datosescalafon.FechaInicio && fechatermino < datosescalafon.FechaTermino && datosescalafon.FechaTermino != null)
                || (fechainicio < datosescalafon.FechaInicio && datosescalafon.FechaTermino == null)
                 || (fechatermino < datosescalafon.FechaTermino)
                  || (fechainicio < datosescalafon.FechaInicio)
                )
            {
                //return JsonView(false, "El periodo de fechas de la solicitud está fuera del periodo de la licencia");
                r.Messsage = "El periodo de fechas de la solicitud está fuera del periodo de la licencia";
                return r;

            }


            int idks, idclt = 0;

            //if (id == 0 && datosescalafon.Catalogos_ctTipoIncidencia.Incidencia == tipoIncidencia.TipoSuplencia)
            if (id == 0)
                id = datosescalafon.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            if (idts != 11)
                if (datosescalafon.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex == id)
                {
                    //return JsonView(false, "No es posible realizar una solicitud cuyo suplente es el mismo trabajador");
                    r.Messsage = "No es posible realizar una solicitud cuyo suplente es el mismo trabajador";
                    return r;

                }

          
            var Traslape2 = clincidencias.HayTraslapeContratosHistorial(id, fechainicio, fechatermino, idts);
            if (Traslape2 == true)
            {

                r.IsValid = false;
                r.Messsage = "No se puede agregar la solicitud porque existe traslape  de fechas con CONTRATOS Anteriores ";
                return r;
            }
            var datostrabajador = db.vwDatosAspirantesTrabajadores.Where(z => z.IdKardex == id).FirstOrDefault();
            idks = datostrabajador.IdKardex;
            var haySolicitudNoAtendida = db.Nomina_SuplenciasSolicitudes.Where(x => x.IdKardexSuplente == idks && x.EsAtendida == false).ToList();
            if (haySolicitudNoAtendida.Count > 0)
            {
                //return JsonView(false, "No se puede la solicitud porque existe una solicitud  que no ha sido atendida");
                r.Messsage = "No se puede la solicitud porque existe una solicitud  que no ha sido atendida";
                return r;

            }
            var datossuplido = db.vwDatosAspirantesTrabajadores.Where(x => x.IdKardex == datosescalafon.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex).FirstOrDefault();

            if (idts == 7)
            {

                if (datostrabajador.RelacionLaboral == datossuplido.RelacionLaboral)
                {
                    //return JsonView(false, "No se puede generar la solicitud porque la relación-conveniolaboral del trabajador suplente (" + datostrabajador.RelacionLaboral + ") es igual al del trabajador suplido (" + datossuplido.RelacionLaboral + ")");
                    r.Messsage = "No se puede generar la solicitud porque la relación-conveniolaboral del trabajador suplente (" + datostrabajador.RelacionLaboral + ") es igual al del trabajador suplido (" + datossuplido.RelacionLaboral + ")";
                    return r;

                }
            }

            if (datossuplido.RelacionConvenioLaboral.Contains("DOCENTE") && idts != 11)
            {
                if (ValidaHorario(id, idce) == false)
                {
                    // return JsonView(false, "Se ha elegido una categoría DOCENTE, para continuar primero asigne un horario al trabajador seleccionado, a traves del sistema ARIES ");
                    r.Messsage = "Se ha elegido una categoría DOCENTE, para continuar primero asigne un horario al trabajador seleccionado, a traves del sistema ARIES ";
                    return r;
                }
            }

            Traslape = clincidencias.HayTraslapeLicencia(datossuplido.IdKardex, fechainicio, fechatermino, idts);
            if (Traslape == true)
            {
                //return JsonView(false, "No se puede agregar la solicitud porque existe traslape  de fechas con otra solicitud no atendida");
                r.Messsage = "No se puede agregar la solicitud porque existe traslape  de fechas con otra solicitud no atendida";
                return r;

            }

            idclt = (int)datostrabajador.IdConvenioLaboralTrabajadorCategoria;
            Kardex_ctDatosPersonales kardex = db.Kardex_ctDatosPersonales.Find(idks);

            int idTipoIncidencia = db.Catalogos_ctTipoIncidencia.Where(x => x.Incidencia == tipoIncidencia.TipoSuplencia).FirstOrDefault().IdTipoIncidencia;
            IncidenciaPermiso_stIncidenciaTrabajador inci = new IncidenciaPermiso_stIncidenciaTrabajador();
            inci.IdTipoIncidencia = (short)idTipoIncidencia;
            inci.EsCancelada = false;
            inci.EsCerrada = true;
            inci.FechaCreacion = DateTime.Now;
            inci.FechaInicio = fechainicio;
            inci.FechaTermino = null;
            if (ff != "")
                inci.FechaTermino = fechatermino;

            inci.IdConvenioLaboralTrabajadorCategoria = (int)datostrabajador.IdConvenioLaboralTrabajadorCategoria;
            inci.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            Traslape = clincidencias.HayTraslapeComision(idks, idclt, fechainicio, fechatermino, idts);
            if (Traslape == true && idts != 11)
            {
                //return JsonView(false, "No se puede agregar la incidencia y/o permiso porque existe traslape de fechas");
                r.Messsage = "No se puede agregar la incidencia y/o permiso porque existe traslape de fechas";
                return r;


            }

            //if (idts==7)
            //    if (datostrabajador.RelacionLaboral== plaza.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral)
            //        return JsonView(false, "No se puede completar la comision debido a que no se eligio una nomina diferente a que tiene actualmente el trabajador");

            Nomina_SuplenciasSolicitudes solicitud = new Nomina_SuplenciasSolicitudes();
            solicitud.IdKardexSuplente = idks;


            solicitud.IdKardexSuplido = datosescalafon.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;

            solicitud.CicloEscolar = idce;
            solicitud.FechaInicio = fechainicio;

            if (ff != "")
                solicitud.FechaTermino = fechatermino;
            else
                solicitud.FechaTermino = null;

            solicitud.FechaSolicitud = DateTime.Now;
            solicitud.FolioOficio = fol;



            solicitud.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            if (idts != 11 && idts != 7)
            {
                solicitud.IdCategoria = datosescalafon.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria;
                solicitud.IdEstructuraOrganica = datosescalafon.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.IdEstructuraOrganica;
                solicitud.IdEstructuraOrganicaFisica = datosescalafon.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica;

            }
            else
            if (idts == 11)
            {
                solicitud.IdCategoria = (short)idc;
                solicitud.IdEstructuraOrganica = (short)ideo;
                if (ideof != "")
                    solicitud.IdEstructuraOrganicaFisica = Nova.Libraries.ConvertToInt.ConvertToInt16(ideof);
            }
            else
            {
                solicitud.IdCategoria = datossuplido.IdCategoria;
                solicitud.IdEstructuraOrganica = (short)datossuplido.IdEstructuraOrganica;

                solicitud.IdEstructuraOrganicaFisica = datossuplido.IdEstructuraOrganicaFisica;

            }
            //if (ideof != null)
            //    if (ideof != "")
            //        solicitud.IdEstructuraOrganicaFisica = Libraries.ConvertToInt.ConvertToInt16(ideof);

            solicitud.IdTipoSuplencia = idts;
            solicitud.IdIncidenciaTrabajador = null;
            solicitud.EsCotejada = true;
            solicitud.IdConvenioLaboralTrabajadorCategoriaCotejo = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            solicitud.FechaRevision = DateTime.Now;
            var solicitudpadre = db.Nomina_SuplenciasSolicitudes.Where(z => z.IdIncidenciaTrabajador == datosescalafon.IdIncidenciaTrabajador).FirstOrDefault(); ;
            if (solicitudpadre != null)
                solicitud.IdSuplenciaSolicitudPadre = solicitudpadre.IdSuplenciaSolicitud;


            try
            {
                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadCommitted;

                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {
                    if (Traslape == true && idts != 11)
                    // idts=11 es licenci para ocupar una plza de confianza
                    //no se graba otra incidencia
                    {
                        db.Entry(inci).State = EntityState.Added;
                        db.SaveChanges();

                        if (idts != 7)
                            // si es comision por cambio de nomina no se actuliza al referencia de la incindencia
                            // ya que no sea crea una incidencia
                            solicitud.IdIncidenciaTrabajador = inci.IdIncidenciaTrabajador;
                    }
                    else
                    {
                        solicitud.IdIncidenciaTrabajador = datosescalafon.IdIncidenciaTrabajador;
                    }

                    if (idkardexeval > 0)
                    {
                        solicitud.IdKardexSolicitudEvaluacion = idkardexeval;
                    }

                    db.Entry(solicitud).State = EntityState.Added;
                    db.SaveChanges();
                    if (idkardexeval > 0)
                    {

                        //if (datossuplenteeval.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral == "DOCENTE" )

                        CambiaEstatusSolicitud(idkardexeval, EstutusContratosEnum.ENESPERADECONTRATO);
                    }

                    // SendPushNotification("Ha generado una solicitud de escalafón para: " + kardex.Nombre + " " + kardex.ApellidoPaterno, TypePushNotification.success, "Nómina,ServiciosDocentes");
                    r.IsValid = true;
                    r.Messsage = "Ha generado una solicitud de escalafón para: " + kardex.Nombre + " " + kardex.ApellidoPaterno;
                    return r;

                    scope.Complete();
                }

                //return JsonView(true, "Se ha generado exitosamente la solicitud de suplencia por licencia");
            }
            catch (Exception e)
            {

                string msg = ExceptionExtensions.GetOriginalException(e).Message;
                if (msg.IndexOf("UK_") > -1)
                {
                    //return JsonView(false, "Ya existe una solicitud con los datos proporcionados, revise su información");
                    r.Messsage = "Ya existe una solicitud con los datos proporcionados, revise su información";
                    return r;
                }
                else
                {
                    //return JsonView(false, msg);
                    r.Messsage = msg;
                    return r;
                }

                
            }

        }
        public Resultados GuardarSolicitudEscalafon(int idin, int id, int idts, string fol, int ideo, int idc, string fi, string ff, string idce,int idkardexeval=0, string ideof = null, string folref = null)
        {
            Resultados rs = new Resultados();

            bdNovaEntities db = new bdNovaEntities();
            Boolean Traslape = false;
            LicenciasPermisos clincidencias = new LicenciasPermisos();

            DateTime fechainicio = DateTime.Parse(fi);
            DateTime fechatermino = DateTime.Now;
            IncidenciaPermiso_stIncidenciaTrabajador datosescalafon=null;
            if (ff != "")
                fechatermino = DateTime.Parse(ff);
            if (idkardexeval == 0 || idin>0)
            {
                 datosescalafon = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdIncidenciaTrabajador == idin).FirstOrDefault();
                if (datosescalafon.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex == id)
                {
                    // return JsonView(false, "No es posible realizar una solicitud cuyo suplente es el mismo trabajador");
                    rs.IsValid = false;
                    rs.Messsage = "No es posible realizar una solicitud cuyo suplente es el mismo trabajador";
                }
            }
            //// si es baja es un movimiento que no existe como incidenciapermiso
            ///
            Kardex_SolicitudEvaluaciones datossuplenteeval = new Kardex_SolicitudEvaluaciones();
            vwDatosAspirantesTrabajadores datosuplente;
            if (idkardexeval > 0)
            {
                  datossuplenteeval = db.Kardex_SolicitudEvaluaciones.Find(idkardexeval);

                datosuplente = db.vwDatosAspirantesTrabajadores.Where(a => a.IdKardex == datossuplenteeval.IdKardexCandidato).FirstOrDefault();
                if (datossuplenteeval.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral=="DOCENTE" && idts != 18)
                    {
                    if (ValidaHorario(id, idce) == false)
                    {
                        //return JsonView(false, "Se ha elegido una categoría DOCENTE, para continuar primero asigne un horario al trabajador seleccionado, a traves del sistema ARIES ");
                        rs.IsValid = false;
                        rs.Messsage = "Se ha elegido una categoría DOCENTE, para continuar primero asigne un horario al trabajador seleccionado, a traves del sistema ARIES ";
                    }
                }
            }
            else
            {
                
                if (idts == 17)
                {
                    datosuplente = db.vwDatosAspirantesTrabajadores.Where(z => z.IdKardex == id && z.Incidencia == "LICENCIA SIN GOCE DE SUELDO POR CAMBIO DE NOMINA").FirstOrDefault();
                }
                else
                    datosuplente = db.vwDatosAspirantesTrabajadores.Where(z => z.IdKardex == id && z.RestringirMenu == null).FirstOrDefault();

                if (datosuplente == null && idts != 17)
                {
                    //  return JsonView(false, "Se ha elegido a un trabajdor con alguna comisión, incapacidad o licencia, revise su información");
                    rs.IsValid = false;
                    rs.Messsage = "Se ha elegido a un trabajdor con alguna comisión, incapacidad o licencia, revise su información";
                }

                if (datosuplente != null)
                if (datosuplente.RelacionConvenioLaboral != null && idts != 18)
                    if (datosuplente.RelacionConvenioLaboral.Contains("DOCENTE"))
                    {
                        if (ValidaHorario(id, idce) == false)
                        {
                            //return JsonView(false, "Se ha elegido una categoría DOCENTE, para continuar primero asigne un horario al trabajador seleccionado, a traves del sistema ARIES ");
                            rs.IsValid = false;
                            rs.Messsage = "Se ha elegido una categoría DOCENTE, para continuar primero asigne un horario al trabajador seleccionado, a traves del sistema ARIES ";
                        }
                    }
            }

            if (fechainicio >= fechatermino && (idts != 5))
            {
                //  return JsonView(false, "La fecha de inicio no puede ser igual o mayor a la de término del contrato");
                rs.IsValid = false;
                rs.Messsage = "La fecha de inicio no puede ser igual o mayor a la de término del contrato";
            }

            if (datosescalafon !=null)
            {
                if ((fechainicio < datosescalafon.FechaInicio && fechatermino > datosescalafon.FechaTermino && datosescalafon.FechaTermino != null)
                   || (fechainicio > datosescalafon.FechaInicio && fechatermino > datosescalafon.FechaTermino && datosescalafon.FechaTermino != null)
                   || (fechainicio < datosescalafon.FechaInicio && fechatermino < datosescalafon.FechaTermino && datosescalafon.FechaTermino != null)
                   || (fechainicio < datosescalafon.FechaInicio && datosescalafon.FechaTermino == null)
                    || (fechatermino > datosescalafon.FechaTermino)
                     || (fechainicio < datosescalafon.FechaInicio)

                   )
                {
                    // return JsonView(false, "El periodo de fechas de la solicitud está fuera del periodo de la licencia");
                    rs.IsValid = false;
                    rs.Messsage = "El periodo de fechas de la solicitud está fuera del periodo de la licencia";

                }
            }

            int idks, idclt = 0;
            
            var Traslape2 = clincidencias.HayTraslapeContratosHistorial(id, fechainicio, fechatermino, idts);
            if (Traslape2 == true)
            {

                rs.IsValid = false;
                rs.Messsage = "No se puede agregar la solicitud porque existe traslape  de fechas con CONTRATOS Anteriores ";
                return rs;
            }

            var datostrabajador = db.vwDatosAspirantesTrabajadores.Where(z => z.IdKardex == id).FirstOrDefault();
            idks = datostrabajador.IdKardex;
            var haySolicitudNoAtendida = db.Nomina_SuplenciasSolicitudes.Where(x => x.IdKardexSuplente == idks && (x.EsAtendida == false)).ToList();
            if (haySolicitudNoAtendida.Count > 0)

            {
                // return JsonView(false, "No se puede agregar el escalafón porque existe una solicitud  que no ha sido atendida");
                rs.IsValid = false;
                rs.Messsage = "No se puede agregar el escalafón porque existe una solicitud  que no ha sido atendida";
            }

            if (datostrabajador.FechaTermino != null)
                if (datostrabajador.FechaTermino >= fechainicio)
                {
                    // return JsonView(false, $"El aspirante: {datostrabajador.Nombre} {datostrabajador.ApellidoPaterno} tiene un contrato qeu termina : {datostrabajador.FechaTermino} cuya fecha es mayo= igual a la fecha de incio {fechainicio}");
                    rs.IsValid = false;
                    rs.Messsage = $"El aspirante: {datostrabajador.Nombre} {datostrabajador.ApellidoPaterno} tiene un contrato qeu termina : {datostrabajador.FechaTermino} cuya fecha es mayo= igual a la fecha de incio {fechainicio}";

                }

            if (datostrabajador.IdConvenioLaboralTrabajadorCategoria != null)
                idclt = (int)datostrabajador.IdConvenioLaboralTrabajadorCategoria;

            Kardex_ctDatosPersonales kardex = db.Kardex_ctDatosPersonales.Find(idks);
            Traslape = clincidencias.HayTraslapeComision(idks, idclt, fechainicio, fechatermino, idts);
            if (Traslape == true)
            {
                //return JsonView(false, "No se puede agregar la incidencia y/o permiso porque existe traslape de fechas");
                rs.IsValid = false;
                rs.Messsage = "No se puede agregar la incidencia y/o permiso porque existe traslape de fechas";


            }

            Nomina_SuplenciasSolicitudes solicitud = new Nomina_SuplenciasSolicitudes();
            solicitud.IdKardexSuplente = idks;

            if (idkardexeval == 0 && datosescalafon != null)
            {
                solicitud.IdKardexSuplido = datosescalafon.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            }
            else
                if (idkardexeval>0)
            {
                var cubierto = db.vwDatosAspirantesTrabajadores.Where(a => a.IdConvenioLaboralTrabajadorCategoria == datossuplenteeval.IdConvenioLaboralTrabajadorCategoriaaCubrir).FirstOrDefault();
                solicitud.IdKardexSuplido = cubierto.IdKardex;
            }

            solicitud.CicloEscolar = idce;
            solicitud.FechaInicio = fechainicio;

            if (ff != "")
                solicitud.FechaTermino = fechatermino;
            else
                solicitud.FechaTermino = null;

            solicitud.FechaSolicitud = DateTime.Now;
            solicitud.FolioOficio = fol;
            if (folref != null)
                solicitud.OficioReferencia = folref;

            if (idts == 8 )
                //&& datosuplente.RelacionConvenioLaboral.Contains("DOCENTE"))
            {
                solicitud.IdCategoria = datostrabajador.IdCategoria;
                solicitud.IdEstructuraOrganica = (short)datostrabajador.IdEstructuraOrganica;

                solicitud.IdEstructuraOrganicaFisica = (short)datosescalafon.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica;
            }



            if (idts == 18)
            {
                solicitud.IdCategoria = (short)idc;
                solicitud.IdEstructuraOrganica = (short)ideo;
                if (ideof != "")
                    solicitud.IdEstructuraOrganicaFisica = Nova.Libraries.ConvertToInt.ConvertToInt16(ideof);
            }

            else
            if (idkardexeval > 0)
            {
                solicitud.IdCategoria = datossuplenteeval.IdCategoriaAspirante;
                solicitud.IdEstructuraOrganica = (short)datossuplenteeval.IdEstructuraOrganicaAdscripcion;
                solicitud.IdEstructuraOrganicaFisica = (short)datossuplenteeval.IdEstructuraOrganicaLaboraFisicamente;

            }
            else
                if (datosescalafon != null && datosuplente != null)
            {

                if ((idts == 20 || idts == 14 || idts == 1) && (datosuplente.EstatusTrabajador == "ASPIRANTE" || datosuplente.EstatusTrabajador == "BAJA")
                    || (idts == 20 && datosuplente.EstatusTrabajador == "ALTA" || datosuplente.EstatusTrabajador == "BAJA")
                    || (idts == 16 && datosuplente.EstatusTrabajador == "ASPIRANTE" &&
                    datosescalafon.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == "BASE")
                    )
                {
                    if (datosescalafon.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral == "ADMINISTRATIVO")
                    {
                        var categoriacontrato = db.Plazas_ctCategoria.Where(s => s.Categoria == datosescalafon.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria
                        && s.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == "CONTRATO").FirstOrDefault();
                        if (categoriacontrato == null)
                        {
                            //  return JsonView(false, $"No se existe la categoria administrativa {datosescalafon.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria} para contrato en este centro");
                            rs.IsValid = false;
                            rs.Messsage = $"No se existe la categoria administrativa {datosescalafon.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria} para contrato en este centro";


                        }
                        solicitud.IdCategoria = categoriacontrato.IdCategoria;
                    }
                    else
                    {
                        var categoriacontrato = db.Plazas_ctCategoria.Where(s => s.Categoria == "PROF. CECYT I"
                         && s.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == "CONTRATO").FirstOrDefault();
                        if (categoriacontrato == null)
                        {
                            // return JsonView(false, $"No se existe la categoria docente PROF. CECYT I para contrato en este centro");
                            rs.IsValid = false;
                            rs.Messsage = $"No se existe la categoria docente PROF. CECYT I para contrato en este centro";

                        }
                        solicitud.IdCategoria = categoriacontrato.IdCategoria;
                    }
                }
                else
                if (idts != 8 && !datosuplente.RelacionConvenioLaboral.Contains("DOCENTE"))
                {
                    solicitud.IdCategoria = datosescalafon.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria;
                }
                if (idts != 8 && !datosuplente.RelacionConvenioLaboral.Contains("DOCENTE"))
                {
                    solicitud.IdEstructuraOrganica = datosescalafon.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.IdEstructuraOrganica;
                    solicitud.IdEstructuraOrganicaFisica = datosescalafon.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica;
                }
            }
            else
            {
                if (datosescalafon.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral == "ADMINISTRATIVO")
                {
                    if (idts == 17)
                    {
                        

                        solicitud.IdCategoria = datosescalafon.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria;
                    }

                    if (idts != 8 )
                    {
                        solicitud.IdEstructuraOrganica = datosescalafon.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.IdEstructuraOrganica;
                        solicitud.IdEstructuraOrganicaFisica = datosescalafon.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica;
                    }
                }
            }
            solicitud.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;


            //if (ideof != null)
            //    if (ideof != "")
            //        solicitud.IdEstructuraOrganicaFisica = Libraries.ConvertToInt.ConvertToInt16(ideof);

            solicitud.IdTipoSuplencia = idts;
            if (idin > 0)
                solicitud.IdIncidenciaTrabajador = idin;
            else
                solicitud.IdIncidenciaTrabajador = null;

            solicitud.EsCotejada = true;
            solicitud.FechaAtencion = DateTime.Now;
            solicitud.IdConvenioLaboralTrabajadorCategoriaCotejo = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            if (idin > 0)
            {
                var solicitudpadre = db.Nomina_SuplenciasSolicitudes.Where(z => z.IdIncidenciaTrabajador == datosescalafon.IdIncidenciaTrabajador).FirstOrDefault(); ;
                if (solicitudpadre != null)
                    solicitud.IdSuplenciaSolicitudPadre = solicitudpadre.IdSuplenciaSolicitud;
            }
            try
            {
                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadCommitted;

                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {
                    if (idkardexeval > 0)
                    {
                        solicitud.IdKardexSolicitudEvaluacion = idkardexeval;
                    }

                    var tiposuplencia = db.Nomina_SuplenciaTipo.Find(idts);

                    

                            ////si es de una baja se crea una incidencia para que se puedan crear escalafones
                            //var escalafon = db.Catalogos_ctTipoIncidencia.Where(a => a.Incidencia == "ESCALAFON PROVISIONAL").FirstOrDefault();

                 

                            //IncidenciaPermiso_stIncidenciaTrabajador nuevaincidencia = new IncidenciaPermiso_stIncidenciaTrabajador();

                            //nuevaincidencia.IdConvenioLaboralTrabajadorCategoria = (int)datostrabajador.IdConvenioLaboralTrabajadorCategoria;
                            //nuevaincidencia.FechaCreacion = DateTime.Now;
                            //nuevaincidencia.FechaInicio = fechainicio;


                            //nuevaincidencia.FechaTermino = fechatermino;

                            //nuevaincidencia.Autorizo = true;
                            //nuevaincidencia.EsCerrada = true;
                            //nuevaincidencia.FechaAutorizacion = DateTime.Now;

                            
                            //    nuevaincidencia.IdTipoIncidencia = escalafon.IdTipoIncidencia;


                            //nuevaincidencia.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                            //nuevaincidencia.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

                            //nuevaincidencia.IdConvenioLaboralTrabajadorCategoriaAutorizo = Nova.Models.Kardex_ctDatosPersonales.getIdJefeRecursosHumanos();

                            //db.IncidenciaPermiso_stIncidenciaTrabajador.Add(nuevaincidencia);
                            //db.SaveChanges();

                 //   solicitud.IdIncidenciaTrabajador = nuevaincidencia.IdIncidenciaTrabajador;
                       

                    db.Entry(solicitud).State = EntityState.Added;
                    db.SaveChanges();

                    if (idts == 8 && datosuplente.RelacionConvenioLaboral.Contains("DOCENTE"))
                    {
                        //cuando es un escalafon docente se qeuda como autorizada ya que solo es un cambio de estrucutrua fisica
                        solicitud.EsAtendida = true;
                        solicitud.FechaAtencion = DateTime.Now;
                        solicitud.IdConvenioLaboralTrabajadorCategoriaAtendio = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                        var convendiolabtrabcat = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(datosuplente.IdConvenioLaboralTrabajadorCategoria);
                        convendiolabtrabcat.IdEstructuraOrganica = (short)solicitud.IdEstructuraOrganicaFisica;
                        db.Entry(convendiolabtrabcat).State = EntityState.Modified;
                        db.SaveChanges();


                        Convenios_SuplenciasControl suplenciacontrol = new Convenios_SuplenciasControl();

                        suplenciacontrol.IdConvenioLaboralTrabajadorCategoria = (int)datosuplente.IdConvenioLaboralTrabajadorCategoria;
                        suplenciacontrol.IdConvenioLaboralTrabajadorCategoriaAnterior = (int)datosuplente.IdConvenioLaboralTrabajadorCategoria;
                        if (idin > 0)
                        {
                            suplenciacontrol.IdIncidenciaTrabajador = (int)idin;
                            var incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Find((int)idin);
                            suplenciacontrol.IdConvenioLaboralTrabajadorCategoriaCubierto = incidencia.IdConvenioLaboralTrabajadorCategoria;
                        }
                        else
                        {       suplenciacontrol.IdConvenioLaboralTrabajadorCategoriaCubierto = datostrabajador.IdConvenioLaboralTrabajadorCategoria;
                            }
                        suplenciacontrol.IdSuplenciaSolicitud = solicitud.IdSuplenciaSolicitud;
                      

                        db.Entry(suplenciacontrol).State = EntityState.Added;
                        db.SaveChanges();
                    }
                    if (idkardexeval > 0)
                    {
                        
                        //if (datossuplenteeval.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral == "DOCENTE" )
 
                            CambiaEstatusSolicitud(idkardexeval, EstutusContratosEnum.ENESPERADECONTRATO);
                    }

                    scope.Complete();

                }
                   

                //return JsonView(true, "Se ha generado exitosamente la solicitud de escalafón");
                rs.IsValid = true;
                rs.Messsage = "Ha generado una solicitud de escalafón para: " + kardex.Nombre + " " + kardex.ApellidoPaterno;
            }
            catch (Exception e)
            {

                string msg = ExceptionExtensions.GetOriginalException(e).Message;
                if (msg.IndexOf("UK_") > -1)
                {
                    //  return JsonView(false, "Ya existe una solicitud con los datos proporcionados, revise su información");
                    rs.IsValid = false;
                    rs.Messsage = "Ya existe una solicitud con los datos proporcionados, revise su información";
                }
                else
                {
                    //   return JsonView(false, msg);
                    rs.IsValid = false;
                    rs.Messsage = msg;
                }
            }

            return rs;
        }
    }
}