﻿using DevExpress.Web.ASPxHtmlEditor.Internal;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Dapper;
using Nova.Libraries;
using Nova.Models.Kardex;


namespace Nova.Models
{

    public class ResponsableDTO
    {
        public int IdKardex { get; set; }
        public string NombreResponsable { get; set; }
        public string ApellidoPaternoResponsable { get; set; }
        public string ApellidoMaternoResponsable { get; set; }

        public string NombreCompleto => $"{NombreResponsable} {ApellidoPaternoResponsable} {ApellidoMaternoResponsable}";
    }
    public class DatosArchivos
    {           
        public int IdArchivoDocumental { get; set; }
        public int IdEstructuraOrganicaSeccionResponsable { get; set; }
        public int IdKardexResponsableEstructuraSeccion { get; set; }
        
        public string ClaveExpediente { get; set; }
        public string Contenido { get; set; }
        public DateTime FechaElaboracion { get; set; }
        public DateTime FechaUltimaModificacion { get; set; }
        public DateTime FechaValidacion { get; set; }
        public string EstructuraOrganica { get; set; }
        public string Direccion { get; set; }
        public string NombreResponsable { get; set; }
        public string ApellidoPaternoResponsable { get; set; }
        public string ApellidoMaternoResponsable { get; set; }
        public string Seccion { get; set; }
        public string NombreSeccion { get; set; }
        public string Serie { get; set; }
        public string NombreSerie { get; set; }
        public string Subserie { get; set; }
        public string NombreSubserie { get; set; }   
        public bool ValosDocumental_Administrativo { get; set; }
        public bool ValosDocumental_Legal { get; set; }
        public bool ValosDocumental_Fiscal { get; set; }
        public bool Clasificacion_Publica { get; set; }
        public bool Clasificacion_Reservada { get; set; }
        public bool Clasificacion_Confidencial { get; set; }
        public int VigenciaDoc_Tramite { get; set; }
        public int VigenciaDoc_Concentrado { get; set; }
        public bool EsVigente { get; set; }
        public int Anio { get; set; }
        public int IdCaja { get; set; }
        public string Caja { get; set; }
        public string NombreCreador { get; set; }
        public string ApellidoPaternoCreador { get; set; }
        public string ApellidoMaternoCreador { get; set; }
        public string NombreActualizo { get; set; }
        public string ApellidoPaternoActualizo { get; set; }
        public string ApellidoMaternoActualizo { get; set; }
        public string NombreElaboro { get; set; }
        public string ApellidoPaternoElaboro { get; set; }
        public string ApellidoMaternoElaboro { get; set; }
        public string Estatus { get; set; }
        public string UbicacionTopografica { get; set; }
        public string Observaciones { get; set; }        
        public int IdKardexElaboro { get; set; }
        public bool Validado { get; set; }
        public decimal Medida { get; set; }
        public string Capacidad { get; set; }
		public int NumeroProgresivo { get; set; }
	
	    public string NumTransferencia { get; set; }
		public int NumeroFojas { get; set; }
		public DateTime FechaApertura { get; set; }
		public DateTime FechaCierre { get; set; }
		public int Orden { get; set; }
		public string Transferencia { get; set; }
		public string DestinoFinal { get; set; }
		public string Fojas { get; set; }
		public string CajaInventario { get; set; }
		public string Anaqueles { get; set; }
		public string ValorSecundario { get; set; }
		public DateTime FechaTerminoVigencia { get; set; }

		public string DescripcionExpediente { get; set; }
		public DateTime FechaDictamen { get; set; }
		public DateTime FechaActa { get; set; }
		public DateTime FechaBaja { get; set; }
		public DateTime FechaHistorico { get; set; }
		public DateTime FechaConcentracion { get; set; }
	


	}


	public class ValorArchivoDTO
	{
		public int Id { get; set; }
		public int Valor { get; set; }
	}


}