﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data.Entity.Core.EntityClient;
using System.Data.SqlClient;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Imaging;
using System.IO;
using System.Linq;
using System.Web;
namespace Nova.Models
{
    public static class Repositorio
    {
        public static byte[] RedimensionarImagen(byte[] Foto)
        {
            double _width = 0.0, _height = 0.0;
            MemoryStream ms = new MemoryStream(Foto, 0, Foto.Length);
            ms.Write(Foto, 0, Foto.Length);
            try
            {
                Image image = Image.FromStream(ms, true);

                _width = image.Width;
                _height = image.Height;
                if (image.Width > 300)
                {
                    do
                    {
                        _width *= 0.90;
                        _height *= 0.90;
                    } while (_width > 300);
                }
                var destRect = new Rectangle(0, 0, (int)_width, (int)_height);
                var destImage = new Bitmap((int)_width, (int)_height);
                destImage.SetResolution(image.HorizontalResolution, image.VerticalResolution);

                using (var graphics = Graphics.FromImage(destImage))
                {
                    graphics.CompositingMode = CompositingMode.SourceCopy;
                    graphics.CompositingQuality = CompositingQuality.HighQuality;
                    graphics.InterpolationMode = InterpolationMode.HighQualityBicubic;
                    graphics.SmoothingMode = SmoothingMode.HighQuality;
                    graphics.PixelOffsetMode = PixelOffsetMode.HighQuality;

                    using (var wrapMode = new ImageAttributes())
                    {
                        wrapMode.SetWrapMode(WrapMode.TileFlipXY);
                        graphics.DrawImage(image, destRect, 0, 0, image.Width, image.Height, GraphicsUnit.Pixel, wrapMode);
                    }
                }
                using (var stream = new MemoryStream())
                {
                    destImage.Save(stream, System.Drawing.Imaging.ImageFormat.Jpeg);
                    return stream.ToArray();
                }
            }
            catch (Exception e)
            {
                throw new System.ArgumentException(@"Error al procesar fotografía. " + ExceptionExtensions.GetOriginalException(e).Message);

            }


        }
        public static byte[] FromFile(string path)
        {
            int f = path.IndexOf("/Content/imagenes");

            if (f >= 0)
            {
                path = path.Substring(f);
                path = "~" + path;
            }
            return ReadFully(File.OpenRead(HttpContext.Current.Server.MapPath(@path)));

        }

        public static byte[] ReadFully(this Stream input)
        {
            using (MemoryStream ms = new MemoryStream())
            {
                input.CopyTo(ms);
                return ms.ToArray();
            }
        }
    }
}