﻿using Nova.Models;

using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Libraries;
using Dapper;
using System.Text;
using System.Drawing;


namespace Nova.Models
{

    public class CredencialesMarcadas
    {
        public string FechaImpresion { get; set; }
        public string HoraImpresion { get; set; }
        public string NumeroNombre { get; set; }
        public string NombreLargo { get; set; }
        public string Curp { get; set; }
        public string ApPaterno { get; set; }
        public string ApMaterno { get; set; }
        public string Nombre { get; set; }
        public string CicloEscolarOrden { get; set; }

        public string ResponsableImpresion { get; set; }

    }


    public class AlumnoInformacionFotografia
    {
        public string Curp { get; set; }
        public string Nombre { get; set; }
        public string ApPaterno { get; set; }
        public string ApMaterno { get; set; }
        public string CentroEducativo { get; set; }
        public string Semestre { get; set; }
        public byte[] Foto { get; set; }
        public string Formato { get; set; }
        public double TamañoBytes { get; set; }
    }
    public class AlumnosAprovechamiento
    {
        public short grado { get; set; }
        public decimal ay { get; set; }
        public decimal by { get; set; }
        public decimal aValue { get; set; }
        public decimal bValue { get; set; }

    }

    public class AlumnosAprovechamientoArea
    {
        public string area { get; set; }
        public decimal promedio { get; set; }
        public string color { get; set; }


    }
    public class AlumnosRanking
    {
        public short Grado { get; set; }
        public decimal Promedio { get; set; }
        public string Nombre { get; set; }
        public string PlanEstudio { get; set; }
        public string Curp { get; set; }


    }



    public class AlumnosCalificacionPeriodos
    {
        public string Curp { get; set; }
        public string Matricula { get; set; }
        public short IdCicloEscolar { get; set; }
        public int IdPlanEstudioAsignatura { get; set; }
        public short IdCursoPeriodoMomento { get; set; }

        public string Calificacion { get; set; }
        public string Periodo { get; set; }
        public bool EsReprobada { get; set; }
        public bool NoConsiderarEnPromedioGeneral { get; set; }
    }

    public class AlumnosCalificacionFinalModulos
    {
        public short IdAsignaturaPadre { get; set; }
        public int IdPlanEstudio { get; set; }
        public short IdCicloEscolar { get; set; }
        public short IdValorCiclo { get; set; }
        public short IdCursoPeriodoMomento { get; set; }
        public string Curp { get; set; }
        public string Matricula { get; set; }
        public decimal Calificacion { get; set; }
        public bool Renunciada { get; set; }
        public bool Dictaminada { get; set; }
        public bool EsReprobada { get; set; }
        public short IdGrupoNombre { get; set; }
        public short IdCampus { get; set; }
        public bool EsActualizacionPlanEstudio { get; set; }
        public bool EsNp { get; set; }
        public string rptCalificacion { get; set; }
        public string Asignatura { get; set; }
        public string Nivel { get; set; }
        public string Componente { get; set; }
        public short OrdenAsignatura { get; set; }
        public bool NoConsiderarEnPromedioGeneral { get; set; }

    }

    public class CalificacionesAlumno
    {

        public long IdHorarioAlumno { get; set; }
        public string Curp { get; set; }
        public string Matricula { get; set; }
        public short IdValorCiclo { get; set; }
        public short IdCicloEscolar { get; set; }
        public string Calificacion { get; set; }
        public bool EsNp { get; set; }
        public bool EsReprobada { get; set; }
        public bool EsReprobadaSinPago { get; set; }
        public string Curso { get; set; }
        public string Periodo { get; set; }
        public string Momento { get; set; }
        public string Evaluacion { get; set; }

        public int IdPlanEstudioAsignatura { get; set; }
        public short Orden { get; set; }

    }

    public class KardexAlumno
    {

        public long IdHorarioAlumno { get; set; }
        public string Curp { get; set; }
        public string Matricula { get; set; }
        public short IdValorCiclo { get; set; }
        public short IdCicloEscolar { get; set; }
        public string Calificacion { get; set; }
        public bool EsNp { get; set; }
        public bool EsReprobada { get; set; }
        public bool EsReprobadaSinPago { get; set; }
        public string Curso { get; set; }
        public string Periodo { get; set; }
        public string Momento { get; set; }
        public string Evaluacion { get; set; }
        public int IdPlanEstudioAsignatura { get; set; }
        public short OrdenEvaluacion { get; set; }
        public string Asignatura { get; set; }
        public string Componente { get; set; }
        public string Nivel { get; set; }
        public short OrdenAsignatura { get; set; }
        public short Orden { get; set; }
        public short IdReglamento { get; set; }
        public bool Recursada { get; set; }
        public string Grupo { get; set; }
        public string Campus { get; set; }
        public int IdAsignaturaPadre { get; set; }
        public string CicloEscolar { get; set; }
        public string Nombre { get; set; }
        public string Tutor { get; set; }
        public string PlanEstudio { get; set; }
        public string ReportePeriodo { get; set; }
        public bool EsSubmodulo { get; set; }
        public bool NoConsiderarEnPromedioGeneral { get; set; }

    }

    public class GrupoAlumnos
    {

        public short IdCicloEscolar { get; set; }
        public string Curp { get; set; }
        public string Matricula { get; set; }


    }

    public class GrupoAlumnosEvaluaciones
    {

        public short IdCicloEscolar { get; set; }
        public string Curp { get; set; }
        public string Matricula { get; set; }
        public string Periodo { get; set; }


    }
    public class CalificacionesFinalesAlumno
    {


        public string Curp { get; set; }
        public string Matricula { get; set; }
        public short IdValorCiclo { get; set; }
        public short IdCicloEscolar { get; set; }
        public string Calificacion { get; set; }


    }

    public class HorarioAlumno
    {

        public long IdHorarioAlumno { get; set; }
        public string CicloEscolar { get; set; }
        public string Curp { get; set; }
        public string Matricula { get; set; }
        public short IdValorCiclo { get; set; }
        public string PlanEstudio { get; set; }
        public string Asignatura { get; set; }
        public string TipoComponente { get; set; }
        public string Docente { get; set; }
        public string CurpDocente { get; set; }


    }

    public class SemestresAlumno
    {
        public short IdValorCiclo { get; set; }
        public string Ciclo { get; set; }
    }


    public class HorarioAsignatura
    {
        public short IdDia { get; set; }
        public string Dia { get; set; }
        public string HoraInicio { get; set; }
        public string HoraFin { get; set; }
    }

    public class   HorariosVigentes
    {
        public List<HorarioVigente> Vigente { get; set; } = new List<HorarioVigente>();
        public List<HorarioVigente> Anterior { get; set; }= new List<HorarioVigente>();
    }
        public class HorarioVigente
    {
        public string Grupo { get; set; }
        public string Asignatura { get; set; }
        public int IdAsignatura { get; set; }
        public short IdDia { get; set; }
        public string Dia { get; set; }
        public string HoraInicio { get; set; }
        public string HoraFin { get; set; }
        public string Docente { get; set; }
        public string CurpDocente { get; set; }
        public Nullable<System.DateTime> FechaInicioPago { get; set; }

        public Nullable<System.DateTime> FechaFinalPago { get; set; }




    }

    public class OrdenesPago
    {
        public string Campus { get; set; }
        public string LineaCaptura { get; set; }
        public string Documento { get; set; }
        public Nullable<System.DateTime> FechaRegistro { get; set; }
        public Nullable<System.DateTime> FechaPago { get; set; }
        public string Servicio { get; set; }
        public Nullable<short> Cantidad { get; set; }
        public decimal Descuento { get; set; }
        public decimal ImporteBruto { get; set; }
        public decimal ImporteNeto { get; set; }



    }

    public class Alumnos
    {




        public static List<OrdenesPago> getOrdenesPago(string curp)
        {
            DapperQuery dp = new DapperQuery("bdAriesEntities");

            string query;

            query = @"select  d.NumeroNombre as Campus,
a.LineaCaptura,a.Documento,a.FechaRegistro,a.FechaPago,c.Nombre as Servicio
,b.Cantidad,b.Descuento,b.ImporteBruto,b.ImporteNeto
 from ptOrdenes a inner join stPagosServicios b on a.IdOrden=b.IdOrden and a.IdCampus=b.IdCampus
inner join ctPagoServicio c on b.IdPagoServicio=c.IdPagoServicio
inner join ctCampus d on a.IdCampus=d.IdCampus
where Curp='" + curp + @"' and a.FechaCancelada is null 
order by a.FechaRegistro desc";




            var t = (List<OrdenesPago>)dp.connection.Query<OrdenesPago>(query);

            dp.Close();
            return t;

        }


        public static List<AlumnosAprovechamiento> getAprovechamiento(string curp, string matricula)
        {
            DapperQuery dp = new DapperQuery("bdAriesEntities");
            string query;

            query = @" SELECT IdCalificacionGrado
      ,IdCicloEscolar
      ,IdValorCiclo
      ,Curp
      ,Matricula
      ,Calificacion
      ,EsReprobada
      ,rptCalificacion
      ,IdCampus
      ,IdGrupoNombre
      ,EsRegular
  FROM Acreditacion_stAlumnosCalificacionGrado b
where b.Curp='" + curp + "' and b.matricula='" + matricula + "' order by IdValorCiclo";




            var calificacionesgrado = (List<Acreditacion_stAlumnosCalificacionGrado>)dp.connection.Query<Acreditacion_stAlumnosCalificacionGrado>(query);

            dp.Close();
            List<AlumnosAprovechamiento> datos = new List<AlumnosAprovechamiento>();
            int total = calificacionesgrado.Count;

            decimal PromedioSecundaria = 0;
            if (Usuario.Rol() == "Alumnos")
            {
                PromedioSecundaria = (decimal)Usuario.Alumno().PromedioSecundaria;
                
            }
            else
                if (Usuario.Rol() == "Tutores")
                {
                    PromedioSecundaria = (decimal)Usuario.Tutor().PromedioSecundaria;
                }


            for (int i = 1; i <= total; i++)
            {
                AlumnosAprovechamiento ele = new AlumnosAprovechamiento();
                if (i == 1)
                {
                    var item = calificacionesgrado.ElementAt(i - 1);
                    var acumulado = Math.Round((decimal)((item.Calificacion +PromedioSecundaria) / 2), 1);
                    ele.grado = item.IdValorCiclo;
                    ele.ay = item.Calificacion;
                    ele.by = (decimal)acumulado;
                    ele.aValue = item.Calificacion;
                    ele.bValue = (decimal)acumulado;
                    datos.Add(ele);
                }
                else
                {
                    var item = calificacionesgrado.ElementAt(i - 1);
                    decimal acumulado = 0;
                    int y = 0;
                    for (int j = 0; j < i; j++)
                    {
                        acumulado = acumulado + calificacionesgrado.ElementAt(j).Calificacion;
                        y++;
                    }
                    acumulado = Math.Round((decimal)(acumulado / y), 1);

                    ele.grado = item.IdValorCiclo;
                    ele.ay = item.Calificacion;
                    ele.by = acumulado;
                    ele.aValue = item.Calificacion;
                    ele.bValue = acumulado;
                    datos.Add(ele);
                }
            }

            return datos;

        }

        private static readonly System.Random rand = new System.Random();

        private static string GetRandomColour()
        {
            var c = Color.FromArgb(rand.Next(256), rand.Next(256), rand.Next(256));
            var y = "#" + c.R.ToString("X2") + c.G.ToString("X2") + c.B.ToString("X2");
            return y;


        }




        public static List<AlumnosRanking> getRankingCampus(string curp, string matricula)
        {
            DapperQuery dp = new DapperQuery("bdAriesEntities");
            string query;



            short idcicloescolar = dp.connection.ExecuteScalar<short>("SELECT b.IdModalidadEstudio from ctAlumnos a inner join CtPlanEstudio b on a.IdPlanEstudio=b.IdPlanEstudio");

            short vigentecicloescolarplantel = dp.connection.ExecuteScalar<short>("SELECT dbo.fnObtenCicloEscolarAnterior(" + idcicloescolar + ")");


            query = @" select  max(r.IdValorCiclo) as Grado,  AVG(t.Calificacion) as Promedio,max(r.ApPaterno) +' '+max(r.ApMaterno) +' '+max(r.Nombre) as Nombre,MAX(j.Nombre) as PlanEstudio, max(r.Curp)as Curp  from (
select IdCicloEscolar
      ,IdValorCiclo
      ,Curp
      ,Matricula
      ,Calificacion
      ,EsReprobada
      ,rptCalificacion
      ,IdCampus
      ,IdGrupoNombre
      ,EsRegular 
from Acreditacion_stAlumnosCalificacionGrado a
where Curp in (
select Curp  from Acreditacion_stAlumnosCalificacionGrado  b
where  IdCampus in (select IdCampus  from ctAlumnos s where s.Curp='" + curp + @"' and s.matricula='" + matricula + @"' )
 and b.IdCicloEscolar=" + vigentecicloescolarplantel + @" and b.EsRegular=1)
 ) as t
 inner join ctAlumnos r on t.Curp=r.Curp and r.Matricula=t.Matricula
 inner join CtPlanEstudio f on f.IdPlanEstudio=r.IdPlanEstudio
inner join ctCarrera j on j.IdCarrera=f.IdCarrera
 group by t.Curp order by 2 desc,3";





            var calificacionesgrado = (List<AlumnosRanking>)dp.connection.Query<AlumnosRanking>(query);

            dp.Close();


            return calificacionesgrado;

        }

        public static List<AlumnosRanking> getRankingCarrera(string curp, string matricula)
        {
            DapperQuery dp = new DapperQuery("bdAriesEntities");
            string query;


           
            int idplanestudio =0;
            int IdValorCiclo = 0;

            
            if (Usuario.Rol() == "Alumnos")
            {
                var x = Usuario.Alumno();
                 idplanestudio = x.IdPlanEstudio;
                 IdValorCiclo = x.IdValorCiclo - 1;

            }
            else
                if (Usuario.Rol() == "Tutores")
                {
                    var x = Usuario.Tutor();
                    idplanestudio = x.IdPlanEstudio;
                    IdValorCiclo = x.IdValorCiclo - 1;
                }


            short idmodalidad = dp.connection.ExecuteScalar<short>("SELECT b.IdModalidadEstudio from ctAlumnos a inner join CtPlanEstudio b on a.IdPlanEstudio=b.IdPlanEstudio where a.curp='" + curp + "' and a.matricula='" + matricula + "'");

            short vigentecicloescolarplantel = dp.connection.ExecuteScalar<short>("SELECT dbo.fnObtenCicloEscolarAnterior(" + idmodalidad + ")");



            query = @" select  max(r.IdValorCiclo) as Grado,  AVG(t.Calificacion) as Promedio,max(r.ApPaterno) +' '+max(r.ApMaterno) +' '+max(r.Nombre) as Nombre,MAX(j.Nombre) as PlanEstudio,max(r.Curp)as Curp from (
select IdCicloEscolar
      ,IdValorCiclo
      ,Curp
      ,Matricula
      ,Calificacion
      ,EsReprobada
      ,rptCalificacion
      ,IdCampus
      ,IdGrupoNombre
      ,EsRegular 
from Acreditacion_stAlumnosCalificacionGrado a
where Curp in (
select Curp  from Acreditacion_stAlumnosCalificacionGrado  b
where  IdCampus in (select IdCampus  from ctAlumnos s where s.Curp='" + curp + @"' and s.matricula='" + matricula + @"' )
 and b.IdCicloEscolar=" + vigentecicloescolarplantel + @" and b.EsRegular=1 and b.IdValorCiclo=" + IdValorCiclo + @")
 ) as t
 inner join ctAlumnos r on t.Curp=r.Curp and r.Matricula=t.Matricula
 inner join CtPlanEstudio f on f.IdPlanEstudio=r.IdPlanEstudio
inner join ctCarrera j on j.IdCarrera=f.IdCarrera
where f.IdPlanEstudio=" + idplanestudio + " group by t.Curp order by 2 desc,3";





            var calificacionesgrado = (List<AlumnosRanking>)dp.connection.Query<AlumnosRanking>(query);

            dp.Close();


            return calificacionesgrado;

        }

        public static List<AlumnosAprovechamientoArea> getAprovechamientoArea(string curp, string matricula)
        {
            DapperQuery dp = new DapperQuery("bdAriesEntities");
            string query;

            query = @" select d.Nombre as area,AVG(a.Calificacion) as promedio from Acreditacion_stAlumnosCalificacionFinal a inner join stPlanEstudioAsignatura
b on a.IdPlanEstudioAsignatura=b.IdPlanEstudioAsignatura inner join ctAsignatura c on b.IdAsignatura=c.IdAsignatura
inner join ctAreaConocimiento d on d.IdAreaConocimiento=c.IdAreaConocimiento
where a.Curp='" + curp + "' and a.matricula='" + matricula + "' and a.Dictaminada=0 and Renunciada=0 group by d.Nombre order by 2 desc";





            var calificacionesgrado = (List<AlumnosAprovechamientoArea>)dp.connection.Query<AlumnosAprovechamientoArea>(query);

            dp.Close();

            foreach (var item in calificacionesgrado)
            {
                item.color = GetRandomColour();
            }
            return calificacionesgrado;


        }
        public static List<HorarioVigente> getHorarioVigente(string curp, string matricula)
        {
            DapperQuery dp = new DapperQuery("bdAriesEntities");
            string query;

            query = @" select q.Nombre as Grupo, x.Nombre as Asignatura, x.IdAsignatura, d.IdDia, d.Nombre as Dia,HoraInicio,HoraFin
,xx.Nombre+' '+xx.ApPaterno +' '+xx.ApMaterno  as Docente,xx.Curp as CurpDocente
 from stHorarioAlumno a inner join stHorario b on a.IdHorario=b.IdHorario
 inner join ctPersonal xx on xx.IdEmpleado=b.IdEmpleado
inner join stHorarioDetalle c on c.IdHorario=b.IdHorario
inner join ctDia d on d.IdDia=c.IdDia
inner join stPlanEstudioAsignatura z on z.IdPlanEstudioAsignatura=b.IdPlanEstudioAsignatura
inner join ctAsignatura x on z.IdAsignatura=x.IdAsignatura
inner join ctGrupoCampus y on y.IdGrupoCampus=b.IdGrupoCampus
inner join ctGrupoNombre q on q.IdGrupoNombre=y.IdGrupoNombre
where IdHorarioAlumno in (
select IdHorarioAlumno from stHorario a inner join stHorarioAlumno b on a.IdHorario=b.IdHorario
inner join Acreditacion_ctReglamento c on a.IdReglamento=c.IdReglamento
inner join stCicloEscolar d on d.IdCicloEscolar=a.IdCicloEscolar and d.IdModalidadEstudio=c.IdModalidadEstudio
where b.Curp='" + curp + @"' and b.matricula='" + matricula + @"'
and a.IdCicloEscolar=dbo.fnObtenCicloEscolarVigente(c.IdModalidadEstudio) and a.Autorizado =1
--and a.IdCicloEscolar=27
)
order by c.IdDia,HoraInicio";




            var t = (List<HorarioVigente>)dp.connection.Query<HorarioVigente>(query);

            dp.Close();
            return t;

        }

   
        public static HorariosVigentes getHorarioDocenteVigente(int id,string fecha)
        {
            Nomina_stNominaTrabajador NominaTrabajador = new Nomina_stNominaTrabajador();
            NominaTrabajador.setHorariosDocentes(fecha,false,false,true,id);


            HorariosVigentes hv = new HorariosVigentes();

            //if (NominaTrabajador.NominaHorariosDocentesDetalle.Count == 0)
            //{
            //    NominaTrabajador.getHorarioDocenteAnterior(id);
            //    if (NominaTrabajador.NominaHorariosDocentesDetalleAnterior.Count> 0)

            //        NominaTrabajador.NominaHorariosDocentesDetalle = NominaTrabajador.NominaHorariosDocentesDetalleAnterior;
            //}


           var horario = NominaTrabajador.getHorarioActualDocente(id, 0,null,true);

            var horariodocentepordia = horario.NominaHorariosDocentesDetalle
                .Select(a=>  new HorarioVigente
                {
                    FechaInicioPago=a.FechaInicioPago,FechaFinalPago=a.FechaFinalPago,
                    Grupo="1",Asignatura=a.TipoHoras, IdAsignatura=a.IdDia, IdDia =(short) a.IdDia,Docente = "",Dia=a.Dia.ToString(), HoraInicio=a.HoraInicio,HoraFin=a.HoraFinal, 
                CurpDocente=""}).OrderBy(d=> d.Dia )
                
                .ToList();

            hv.Vigente = horariodocentepordia;

            if (horario.HorarioVigente)
            {
                var horariodocentepordiaAnterior = horario.NominaHorariosDocentesDetalleAnterior
                   .Select(a => new HorarioVigente
                   {
                       FechaInicioPago = a.FechaInicioPago,
                       FechaFinalPago = a.FechaFinalPago,
                       Grupo = "1",
                       Asignatura = a.TipoHoras,
                       IdAsignatura = a.IdDia,
                       IdDia = (short)a.IdDia,
                       Docente = "",
                       Dia = a.Dia.ToString(),
                       HoraInicio = a.HoraInicio,
                       HoraFin = a.HoraFinal,
                       CurpDocente = ""
                   }).OrderBy(d => d.Dia)

                   .ToList();
                hv.Anterior = horariodocentepordiaAnterior;
            }
            //string query;
            //var t = new List<HorarioVigente>();
            //DapperQuery dp = new DapperQuery("bdAriesEntities");

            //query = @" select q.Nombre as Grupo, x.Nombre as Asignatura, x.IdAsignatura, d.IdDia, d.Nombre as Dia,HoraInicio,HoraFin
            //    ,xx.Nombre+' '+xx.ApPaterno +' '+xx.ApMaterno  as Docente,xx.Curp as CurpDocente
            //     from stHorarioAlumno a inner join stHorario b on a.IdHorario=b.IdHorario
            //     inner join ctPersonal xx on xx.IdEmpleado=b.IdEmpleado
            //    inner join stHorarioDetalle c on c.IdHorario=b.IdHorario
            //    inner join ctDia d on d.IdDia=c.IdDia
            //    inner join stPlanEstudioAsignatura z on z.IdPlanEstudioAsignatura=b.IdPlanEstudioAsignatura
            //    inner join ctAsignatura x on z.IdAsignatura=x.IdAsignatura
            //    inner join ctGrupoCampus y on y.IdGrupoCampus=b.IdGrupoCampus
            //    inner join ctGrupoNombre q on q.IdGrupoNombre=y.IdGrupoNombre
            //    where IdHorarioAlumno in (
            //    select IdHorarioAlumno from stHorario a inner join stHorarioAlumno b on a.IdHorario=b.IdHorario
            //    inner join Acreditacion_ctReglamento c on a.IdReglamento=c.IdReglamento
            //    inner join stCicloEscolar d on d.IdCicloEscolar=a.IdCicloEscolar and d.IdModalidadEstudio=c.IdModalidadEstudio
            //    where xx.IdNova=" + id + @"
            //    and a.IdCicloEscolar=dbo.fnObtenCicloEscolarVigente(c.IdModalidadEstudio) and a.Autorizado =1
            //    )
            //    order by c.IdDia,HoraInicio";
            //t = (List<HorarioVigente>)dp.connection.Query<HorarioVigente>(query);
            //dp.Close();

            return hv;

        }
        public static List<HorarioVigente> getHorarioEspecialVigente(int id)
        {
            DapperQuery dpn = new DapperQuery("bdNovaEntities");
            string query;
            var t = new List<HorarioVigente>();
            query = @" select Grupo,Asignatura,IdAsignatura,IdDia,Dia,HoraInicio,HoraFin,Docente,CurpDocente
from ( select '1' as Grupo, '*' as Asignatura, c.IdDia as IdAsignatura, c.IdDia, c.Nombre as Dia,cast(b.Entrada as nvarchar(5)) as HoraInicio,cast(b.Salida as nvarchar(5)) HoraFin
                ,a.Nombre+' '+a.ApellidoPaterno +' '+a.ApellidoMaterno  as Docente,a.CURP as CurpDocente
                 from vwDatosAspirantesTrabajadores a
                 inner join Nomina_HorariosEspeciales b 
                     on a.IdTrabajador=b.IdTrabajador
                 inner join bdCtlEscSeg.dbo.ctDia c on b.Dia=c.IdDia 
                where a.IdKardex=" + id + @"  and a.RestringirMenu is null and ((b.FechaInicio<=GETDATE() and b.FechaTermino>=GETDATE()) or b.FechaTermino is null ) ) as q
                group by Grupo,Asignatura,IdAsignatura,IdDia,Dia,HoraInicio,HoraFin,Docente,CurpDocente";
            t = (List<HorarioVigente>)dpn.connection.Query<HorarioVigente>(query);
            dpn.Close();

            return t;

        }
        public static List<HorarioVigente> getHorarioConvenioVigente(int id)
        {
            DapperQuery dpn = new DapperQuery("bdNovaEntities");
            string query;
            var t = new List<HorarioVigente>();
            query = @"select '1' as Grupo, '*' as Asignatura, '1' as IdAsignatura, c.IdDia, c.Nombre as Dia,cast(b.Entrada as nvarchar(5)) as HoraInicio,cast(b.Salida as nvarchar(5)) as HoraFin
                ,a.Nombre+' '+a.ApellidoPaterno +' '+a.ApellidoMaterno  as Docente,a.CURP as CurpDocente
                 from vwDatosAspirantesTrabajadores a
                 inner join Nomina_HorariosConvenioConfiguracion b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
                 inner join bdCtlEscSeg.dbo.ctDia c on b.Dia=c.IdDia 
                where a.IdKardex=" + id + @" and a.RestringirMenu is null order by c.IdDia,c.Nombre,b.Entrada";
            t = (List<HorarioVigente>)dpn.connection.Query<HorarioVigente>(query);

            dpn.Close();

            return t;

        }

        public static List<HorarioAsignatura> getHorarioAsignatura(long Id)
        {
            DapperQuery dp = new DapperQuery("bdAriesEntities");
            string query;

            query = @"select d.IdDia, d.Nombre as Dia,HoraInicio,HoraFin from stHorarioAlumno a inner join stHorario b on a.IdHorario=b.IdHorario
inner join stHorarioDetalle c on c.IdHorario=b.IdHorario
inner join ctDia d on d.IdDia=c.IdDia
where IdHorarioAlumno=" + Id + " and b.Autorizado =1 order by c.IdDia";




            var t = (List<HorarioAsignatura>)dp.connection.Query<HorarioAsignatura>(query);

            dp.Close();
            return t;

        }

        public static List<HorarioAlumno> getHorarios(string Curp)
        {
            DapperQuery dp = new DapperQuery("bdAriesEntities");
            string query;

            query = @"select a.IdHorarioAlumno,
j.Nombre as CicloEscolar,
a.Curp,a.Matricula,a.IdValorCiclo,d.Nombre as PlanEstudio, 
e.Nombre as Asignatura,
g.Nombre as TipoComponente
,h.Nombre + ' '+h.ApPaterno +' '+h.ApMaterno as Docente,h.Curp as CurpDocente
 
from stHorarioAlumno a inner join stHorario b on a.IdHorario=b.IdHorario
inner join stPlanEstudioAsignatura c on b.IdPlanEstudioAsignatura=c.IdPlanEstudioAsignatura
inner join CtPlanEstudio d on d.IdPlanEstudio=c.IdPlanEstudio
inner join ctAsignatura e on e.IdAsignatura=c.IdAsignatura
--inner join ctAreaConocimiento f on f.IdAreaConocimiento=e.IdAreaConocimiento
inner join ctTipoComponente g on g.IdTipoComponente=e.IdTipoComponente
inner join ctPersonal h on h.IdEmpleado=b.IdEmpleado
inner join Acreditacion_ctReglamento x on x.IdReglamento=b.IdReglamento
--inner join stCicloEscolar i on i.IdCicloEscolar=b.IdCicloEscolar and x.IdModalidadEstudio=i.IdModalidadEstudio
inner join ctCicloescolar j on j.IdCicloEscolar=b.IdCicloEscolar
where a.Curp='" + Curp + @"' and  b.Autorizado =1 order by a.IdValorCiclo desc,c.Orden asc";




            var t = (List<HorarioAlumno>)dp.connection.Query<HorarioAlumno>(query);

            dp.Close();
            return t;

        }



        public static List<KardexAlumno> getBoleta(string curp, string matricula, short cicloescolar, string periodo)
        {
            DapperQuery dp = new DapperQuery("bdAriesEntities");
            string query;

            query = @"select a.IdHorarioAlumno,a.Curp,a.Matricula,a.IdValorCiclo,b.IdCicloEscolar,
c.rptCalificacion as Calificacion,c.EsNp,EsReprobada,EsReprobadaSinPago,f.Nombre as Curso,
g.Nombre as Periodo,h.Nombre as Momento,i.Nombre as Evaluacion, b.IdPlanEstudioAsignatura,e.Orden as OrdenEvaluacion
,k.Nombre As Asignatura,l.Nombre as Componente,k.Nivel,j.Orden as OrdenAsignatura, 0 as Orden,b.IdReglamento,a.Recursada
,n.Nombre as Grupo,o.NombreLargo as Campus,k.IdAsignaturaPadre,bb.Nombre as CicloEscolar
,nn.ApPaterno+' '+nn.ApMaterno +' '+nn.Nombre   as Nombre
,nn.ApPaternoTutor+' '+nn.ApMaternoTutor+' '+nn.NombreTutor as Tutor,mm.Nombre as PlanEstudio
,k.NoConsiderarEnPromedioGeneral
from stHorarioAlumno a inner join stHorario b on a.IdHorario=b.IdHorario
inner join Acreditacion_stMomentoEvaluacionCalificacion c on c.IdHorarioAlumno=a.IdHorarioAlumno
inner join Acreditacion_stMomentoEvaluacion d on c.IdMomentoEvaluacion=d.IdMomentoEvaluacion
inner join Acreditacion_stCursoPeriodoMomento e on e.IdCursoPeriodoMomento=d.IdCursoPeriodoMomento
inner join Acreditacion_ctCurso f on f.IdCurso =e.IdCurso
inner join Acreditacion_ctPeriodo g on g.IdPeriodo=e.IdPeriodo
inner join Acreditacion_ctMomento h on h.IdMomento=e.IdMomento
inner join Acreditacion_ctEvaluacion i  on i.IdEvaluacion=d.IdEvaluacion
inner join stPlanEstudioAsignatura j on j.IdPlanEstudioAsignatura=b.IdPlanEstudioAsignatura
inner join ctAsignatura k on k.IdAsignatura=j.IdAsignatura
inner join ctTipoComponente l on l.IdTipoComponente=k.IdTipoComponente
inner join ctGrupoCampus m on m.IdGrupoCampus=b.IdGrupoCampus
inner join ctGrupoNombre n on n.IdGrupoNombre=m.IdGrupoNombre
inner join ctCampus o on o.IdCampus=m.IdCampus
inner join ctCicloescolar bb on bb.IdCicloEscolar=b.IdCicloEscolar
inner join ctAlumnos nn on nn.Curp=a.Curp and nn.Matricula=a.Matricula
inner join ctPlanEstudio mm on mm.IdPlanEstudio=j.IdPlanEstudio
where a.Curp='" + curp + "' and a.Matricula='" + matricula + "' and b.IdCicloEscolar=" + cicloescolar + " and b.Autorizado =1 order by b.IdCicloEscolar,j.Orden,e.Orden";




            var momentos = (List<KardexAlumno>)dp.connection.Query<KardexAlumno>(query);


            query = @"SELECT   IdPlanEstudioAsignatura
      ,IdCicloEscolar
      ,IdValorCiclo
      ,IdCursoPeriodoMomento
      ,Curp
      ,Matricula
      ,Calificacion
      ,Renunciada
      ,Dictaminada
      ,EsReprobada
      ,EsNp
      ,IdGrupoNombre
      ,IdCampus
      ,EsActualizacionPlanEstudio
      ,rptCalificacion
  FROM Acreditacion_stAlumnosCalificacionFinal where curp='" + curp + @"' and Matricula='" + matricula + "' and IdCicloEscolar=" + cicloescolar + " and Dictaminada=0 and Renunciada=0";
            dp.Close();
            var finales = (List<Acreditacion_stAlumnosCalificacionFinal>)dp.connection.Query<Acreditacion_stAlumnosCalificacionFinal>(query);


            query = @"SELECT IdCicloEscolar
      ,IdValorCiclo
      ,Curp
      ,Matricula
      ,Calificacion
      ,EsReprobada
      ,rptCalificacion
      ,IdCampus
      ,IdGrupoNombre
      ,EsRegular
  FROM  Acreditacion_stAlumnosCalificacionGrado
 l where curp='" + curp + @"' and Matricula='" + matricula + "' and IdCicloEscolar=" + cicloescolar + " ";
            var finalesgrados = (List<Acreditacion_stAlumnosCalificacionGrado>)dp.connection.Query<Acreditacion_stAlumnosCalificacionGrado>(query);





            query = @"SELECT a.IdAsignaturaPadre
      ,IdPlanEstudio
      ,IdCicloEscolar
      ,IdValorCiclo
      ,IdCursoPeriodoMomento
      ,Curp
      ,Matricula
      ,Calificacion
      ,Renunciada
      ,Dictaminada
      ,EsReprobada
      ,IdGrupoNombre
      ,IdCampus
      ,EsActualizacionPlanEstudio
      ,EsNp
,rptCalificacion,b.Nombre as Asignatura,b.Nivel,c.Nombre as Componente
   ,(select MIN(orden)-1 from stPlanEstudioAsignatura where IdAsignatura in (
  select IdAsignatura from ctAsignatura xx where xx.IdAsignaturaPadre=a.IdAsignaturaPadre)
  ) as OrdenAsignatura
 ,b.NoConsiderarEnPromedioGeneral
  FROM  Acreditacion_stAlumnosCalificacionFinalModulos a
  inner join ctAsignatura b on a.IdAsignaturaPadre=b.IdAsignatura
  inner join ctTipoComponente c on c.IdTipoComponente=b.IdTipoComponente
  where a.curp='" + curp + @"' and a.Matricula='" + matricula + "' and a.Dictaminada=0 and a.Renunciada=0 and a.IdCicloEscolar=" + cicloescolar + "";
            var finalesmodulos = (List<AlumnosCalificacionFinalModulos>)dp.connection.Query<AlumnosCalificacionFinalModulos>(query);




            query = @"  select 
  bb.Curp,bb.Matricula,cc.IdCicloEscolar,cc.IdPlanEstudioAsignatura
      ,aa.IdCursoPeriodoMomento
      ,rptCalificacion as Calificacion,kk.Nombre as Periodo,aa.EsReprobada
      from Acreditacion_stPeriodoCalificacion aa 
  inner join stHorarioAlumno bb on bb.IdHorarioAlumno=aa.IdHorarioAlumno
  inner join stHorario cc on cc.IdHorario=bb.IdHorario
  inner join Acreditacion_stCursoPeriodoMomento gg on gg.IdCursoPeriodoMomento=aa.IdCursoPeriodoMomento
  inner join Acreditacion_ctPeriodo kk on kk.IdPeriodo=gg.IdPeriodo
    where bb.curp='" + curp + @"' and bb.Matricula='" + matricula + "' and cc.IdCicloEscolar=" + cicloescolar + " and cc.Autorizado =1";
            var periodos = (List<AlumnosCalificacionPeriodos>)dp.connection.Query<AlumnosCalificacionPeriodos>(query);

            dp.Close();



            List<KardexAlumno> momentosfinales = new List<KardexAlumno>();

            List<KardexAlumno> sinfinal = new List<KardexAlumno>();

            if (momentos.Count > 0)
            {
                List<Acreditacion_stAlumnosCalificacionFinal> final = finales.Where(w => w.Curp == momentos[0].Curp && w.Matricula == momentos[0].Matricula && w.IdCicloEscolar == cicloescolar).ToList();

                var listadefinales = final.Select(f => f.IdPlanEstudioAsignatura).ToArray();
                sinfinal = momentos.Where(t => !listadefinales.Contains(t.IdPlanEstudioAsignatura)).ToList();

                foreach (var item in final)
                {
                    KardexAlumno periodomaximo = new KardexAlumno();
                    var ordenperiodo = momentos.Where(b => b.Periodo == periodo).OrderByDescending(t => t.OrdenEvaluacion).FirstOrDefault();

                    var mayormomento = momentos.Where(b => b.IdPlanEstudioAsignatura == item.IdPlanEstudioAsignatura && b.Curp == item.Curp && b.Matricula == item.Matricula && b.Periodo == periodo).OrderByDescending(b => b.OrdenEvaluacion).FirstOrDefault();
                    if (mayormomento != null)
                    {
                        periodomaximo = momentos.Where(b => b.IdPlanEstudioAsignatura == item.IdPlanEstudioAsignatura && b.Curp == item.Curp && b.Matricula == item.Matricula && b.OrdenEvaluacion == mayormomento.OrdenEvaluacion).FirstOrDefault();
                    }
                    else
                    {
                        if (ordenperiodo != null)
                            periodomaximo = mayormomento = momentos.Where(b => b.IdPlanEstudioAsignatura == item.IdPlanEstudioAsignatura && b.Curp == item.Curp && b.Matricula == item.Matricula && b.OrdenEvaluacion < ordenperiodo.OrdenEvaluacion).OrderByDescending(d => d.OrdenEvaluacion).FirstOrDefault();
                        else
                            periodomaximo = mayormomento = momentos.Where(b => b.IdPlanEstudioAsignatura == item.IdPlanEstudioAsignatura && b.Curp == item.Curp && b.Matricula == item.Matricula).OrderByDescending(d => d.OrdenEvaluacion).FirstOrDefault();
                    }
                    var x = periodomaximo.IdCicloEscolar;
                    var calificacionperiodo = periodos.Where(b => b.Periodo == periodomaximo.Periodo && b.IdPlanEstudioAsignatura == periodomaximo.IdPlanEstudioAsignatura && b.Curp == periodomaximo.Curp && b.Matricula == periodomaximo.Matricula && b.IdCicloEscolar == periodomaximo.IdCicloEscolar).OrderByDescending(r => r.IdCursoPeriodoMomento).FirstOrDefault();
                    KardexAlumno cf = new KardexAlumno();
                    cf.IdPlanEstudioAsignatura = item.IdPlanEstudioAsignatura;
                    cf.OrdenAsignatura = periodomaximo.OrdenAsignatura;
                    cf.IdValorCiclo = item.IdValorCiclo;

                    if (calificacionperiodo != null)
                    {
                        cf.EsReprobada = calificacionperiodo.EsReprobada;
                    cf.Calificacion = calificacionperiodo.Calificacion;
                }
                else{
                    cf.EsReprobada = false;
                    cf.Calificacion = "";
                }
                    cf.Evaluacion = "CF";
                    cf.OrdenEvaluacion = periodomaximo.OrdenEvaluacion;
                    cf.Orden = 1;
                    cf.Periodo = periodomaximo.Periodo;
                    cf.Asignatura = (periodomaximo.Nivel != "" && periodomaximo.Nivel != null) ? "Submodulo " + periodomaximo.Nivel + " " + periodomaximo.Asignatura : periodomaximo.Asignatura;
                    cf.EsSubmodulo =(periodomaximo.Nivel != "" && periodomaximo.Nivel != null ) ? true: false;
                    cf.Grupo = periodomaximo.Grupo;
                    cf.CicloEscolar = periodomaximo.CicloEscolar;
                    cf.Nombre = periodomaximo.Nombre;
                    cf.PlanEstudio = periodomaximo.PlanEstudio;
                    cf.Tutor = periodomaximo.Tutor;
                    cf.Curp = periodomaximo.Curp;
                    cf.Matricula = periodomaximo.Matricula;
                    cf.Campus = periodomaximo.Campus;
                    cf.ReportePeriodo = periodo;
                    momentosfinales.Add(cf);
                }

            }

            //agrega las materias qeu no tiene finales
                foreach (var item in sinfinal)
                {
                    KardexAlumno periodomaximo = new KardexAlumno();
                    var ordenperiodo = momentos.Where(b => b.Periodo == periodo).OrderByDescending(t => t.OrdenEvaluacion).FirstOrDefault();

                    var mayormomento = momentos.Where(b => b.IdPlanEstudioAsignatura == item.IdPlanEstudioAsignatura && b.Curp == item.Curp && b.Matricula == item.Matricula && b.Periodo == periodo).OrderByDescending(b => b.OrdenEvaluacion).FirstOrDefault();
                    if (mayormomento != null)
                    {
                        periodomaximo = momentos.Where(b => b.IdPlanEstudioAsignatura == item.IdPlanEstudioAsignatura && b.Curp == item.Curp && b.Matricula == item.Matricula && b.OrdenEvaluacion == mayormomento.OrdenEvaluacion).FirstOrDefault();
                    }
                    else
                    {
                        if (ordenperiodo != null)
                            periodomaximo = mayormomento = momentos.Where(b => b.IdPlanEstudioAsignatura == item.IdPlanEstudioAsignatura && b.Curp == item.Curp && b.Matricula == item.Matricula && b.OrdenEvaluacion < ordenperiodo.OrdenEvaluacion).OrderByDescending(d => d.OrdenEvaluacion).FirstOrDefault();
                        else
                            periodomaximo = mayormomento = momentos.Where(b => b.IdPlanEstudioAsignatura == item.IdPlanEstudioAsignatura && b.Curp == item.Curp && b.Matricula == item.Matricula).OrderByDescending(d => d.OrdenEvaluacion).FirstOrDefault();
                    }

                    var calificacionperiodo = periodos.Where(b => b.Periodo == periodomaximo.Periodo && b.IdPlanEstudioAsignatura == periodomaximo.IdPlanEstudioAsignatura && b.Curp == periodomaximo.Curp && b.Matricula == periodomaximo.Matricula && b.IdCicloEscolar == periodomaximo.IdCicloEscolar).OrderByDescending(r => r.IdCursoPeriodoMomento).FirstOrDefault();
                    KardexAlumno cf = new KardexAlumno();
                    cf.IdPlanEstudioAsignatura = item.IdPlanEstudioAsignatura;
                    cf.OrdenAsignatura = periodomaximo.OrdenAsignatura;
                    cf.IdValorCiclo = item.IdValorCiclo;

                    if (calificacionperiodo != null)
                    {
                        cf.EsReprobada = calificacionperiodo.EsReprobada;
                        cf.Calificacion = calificacionperiodo.Calificacion;
                    }
                    else
                    {
                        cf.EsReprobada = false;
                        cf.Calificacion = "";
                    }
                    cf.Evaluacion = "CF";
                    cf.OrdenEvaluacion = periodomaximo.OrdenEvaluacion;
                    cf.Orden = 1;
                    cf.Periodo = periodomaximo.Periodo;
                    cf.Asignatura = (periodomaximo.Nivel != "" && periodomaximo.Nivel != null) ? "Submodulo " + periodomaximo.Nivel + " " + periodomaximo.Asignatura : periodomaximo.Asignatura;
                    cf.EsSubmodulo = (periodomaximo.Nivel != "" && periodomaximo.Nivel != null) ? true : false;
                    cf.Grupo = periodomaximo.Grupo;
                    cf.CicloEscolar = periodomaximo.CicloEscolar;
                    cf.Nombre = periodomaximo.Nombre;
                    cf.PlanEstudio = periodomaximo.PlanEstudio;
                    cf.Tutor = periodomaximo.Tutor;
                    cf.Curp = periodomaximo.Curp;
                    cf.Matricula = periodomaximo.Matricula;
                    cf.Campus = periodomaximo.Campus;
                    cf.ReportePeriodo = periodo;
                    momentosfinales.Add(cf);
                    cf.NoConsiderarEnPromedioGeneral = periodomaximo.NoConsiderarEnPromedioGeneral;
                }

        
            foreach (var item in finalesmodulos)
            {

                KardexAlumno cf = new KardexAlumno();

                KardexAlumno periodomaximo = new KardexAlumno();
                var mayormomento = momentos.Where(b => b.IdAsignaturaPadre == item.IdAsignaturaPadre && b.Curp == item.Curp && b.Matricula == item.Matricula && b.Periodo == periodo).FirstOrDefault();
                if (mayormomento != null)
                {
                    periodomaximo = momentos.Where(b => b.IdAsignaturaPadre == item.IdAsignaturaPadre && b.Curp == item.Curp && b.Matricula == item.Matricula && b.OrdenEvaluacion == mayormomento.OrdenEvaluacion).FirstOrDefault();
                }
                else
                    periodomaximo = mayormomento = momentos.Where(b => b.IdAsignaturaPadre == item.IdAsignaturaPadre && b.Curp == item.Curp && b.Matricula == item.Matricula).OrderByDescending(d => d.OrdenEvaluacion).FirstOrDefault();

               
                    cf.IdPlanEstudioAsignatura = item.IdAsignaturaPadre;
                    cf.OrdenAsignatura = 0;
                    cf.IdValorCiclo = item.IdValorCiclo;
                    cf.Calificacion = item.rptCalificacion;
                    cf.Evaluacion = "CF";
                    cf.OrdenEvaluacion = 0;
                    cf.Orden = 0;
                    cf.Componente = "MODULO";
                    cf.Asignatura = "Modulo " + item.Nivel + " " + item.Asignatura;
                    cf.OrdenAsignatura = item.OrdenAsignatura;
                    cf.IdCicloEscolar = item.IdCicloEscolar;
                    cf.Periodo = periodomaximo.Periodo;
                    cf.Grupo = periodomaximo.Grupo;
                    cf.CicloEscolar = periodomaximo.CicloEscolar;
                    cf.Nombre = periodomaximo.Nombre;
                    cf.PlanEstudio = periodomaximo.PlanEstudio;
                    cf.Tutor = periodomaximo.Tutor;
                    cf.Curp = periodomaximo.Curp;
                    cf.Matricula = periodomaximo.Matricula;
                    cf.Campus = periodomaximo.Campus;
                    cf.ReportePeriodo = periodo;
                    cf.NoConsiderarEnPromedioGeneral = periodomaximo.NoConsiderarEnPromedioGeneral;
                    momentosfinales.Add(cf);
                
            }


            foreach (var item in finalesgrados)
            {

                KardexAlumno cf = new KardexAlumno();
                cf.IdPlanEstudioAsignatura = -1;
                cf.OrdenAsignatura = 0;
                cf.IdValorCiclo = item.IdValorCiclo;
                cf.Calificacion = item.rptCalificacion;
                cf.Evaluacion = "CF";
                cf.OrdenEvaluacion = 100;
                cf.Orden = 2;
                cf.ReportePeriodo = periodo;
                momentosfinales.Add(cf);
            }


            if (momentosfinales.Where(d => d.Periodo == periodo).ToList().Count == 0)
                momentosfinales.Clear();

            return momentosfinales;


        }

        public static List<GrupoAlumnos> getAlumnosPorGrupo(short idgruponombre, short idcampus, short cicloescolar)
        {


            DapperQuery dp = new DapperQuery("bdAriesEntities");
            string query;

            query = @"select b.IdCicloEscolar,a.Curp,a.Matricula
from stHorarioAlumno a inner join stHorario b on a.IdHorario=b.IdHorario
inner join ctGrupoCampus m on m.IdGrupoCampus=b.IdGrupoCampus
inner join ctGrupoNombre n on n.IdGrupoNombre=m.IdGrupoNombre
inner join ctCampus o on o.IdCampus=m.IdCampus
inner join ctAlumnos l on l.curp=a.Curp and a.matricula=l.matricula
where b.IdCicloEscolar=" + cicloescolar + " and n.IdGrupoNombre=" + idgruponombre + " and m.IdCampus=" + idcampus + @" and b.Autorizado =1 
group by b.IdCicloEscolar,a.Curp,a.Matricula order by max(n.Nombre),max(l.ApPaterno),max(l.ApMaterno),max(l.Nombre)";





            var alumnos = (List<GrupoAlumnos>)dp.connection.Query<GrupoAlumnos>(query);
            dp.Close();

            return alumnos;
        }
        public static List<GrupoAlumnosEvaluaciones> getAlumnosCiclos(string curp, string matricula)
        {


            DapperQuery dp = new DapperQuery("bdAriesEntities");
            string query;

            query = @"select b.IdCicloEscolar,a.Curp,a.Matricula,i.Nombre as Periodo
from stHorarioAlumno a inner join stHorario b on a.IdHorario=b.IdHorario
inner join ctGrupoCampus m on m.IdGrupoCampus=b.IdGrupoCampus
inner join ctGrupoNombre n on n.IdGrupoNombre=m.IdGrupoNombre
inner join ctCampus o on o.IdCampus=m.IdCampus
inner join Acreditacion_stPeriodoCalificacion g on g.IdHorarioAlumno=a.IdHorarioAlumno
inner join Acreditacion_stCursoPeriodoMomento h on h.IdCursoPeriodoMomento=g.IdCursoPeriodoMomento
inner join Acreditacion_ctPeriodo i on i.IdPeriodo=h.IdPeriodo
 where b.Autorizado=1 and a.Curp='" + curp + "'  and a.Matricula='" + matricula + @"' and b.Autorizado =1 group by b.IdCicloEscolar,a.Curp,a.Matricula,i.Nombre
order by 1 desc ,max(h.Orden)";





            var alumnos = (List<GrupoAlumnosEvaluaciones>)dp.connection.Query<GrupoAlumnosEvaluaciones>(query);
            dp.Close();

            return alumnos;
        }

        public static List<KardexAlumno> getKardex(string curp, string matricula)
        {
            DapperQuery dp = new DapperQuery("bdAriesEntities");
            string query;

            query = @"select a.IdHorarioAlumno,a.Curp,a.Matricula,a.IdValorCiclo,b.IdCicloEscolar,
c.rptCalificacion as Calificacion,c.EsNp,EsReprobada,EsReprobadaSinPago,f.Nombre as Curso,
g.Nombre as Periodo,h.Nombre as Momento,i.Nombre as Evaluacion, b.IdPlanEstudioAsignatura,e.Orden as OrdenEvaluacion
,k.Nombre As Asignatura,l.Nombre as Componente,k.Nivel,j.Orden as OrdenAsignatura, 0 as Orden,b.IdReglamento,a.Recursada
,n.Nombre as Grupo,o.NumeroNombre as Campus,k.IdAsignaturaPadre,bb.Nombre as CicloEscolar
,nn.ApPaterno+' '+nn.ApMaterno +' '+nn.Nombre   as Nombre
,nn.ApPaternoTutor+' '+nn.ApMaternoTutor+' '+nn.NombreTutor as Tutor,mm.Nombre as PlanEstudio
from stHorarioAlumno a inner join stHorario b on a.IdHorario=b.IdHorario
inner join Acreditacion_stMomentoEvaluacionCalificacion c on c.IdHorarioAlumno=a.IdHorarioAlumno
inner join Acreditacion_stMomentoEvaluacion d on c.IdMomentoEvaluacion=d.IdMomentoEvaluacion
inner join Acreditacion_stCursoPeriodoMomento e on e.IdCursoPeriodoMomento=d.IdCursoPeriodoMomento
inner join Acreditacion_ctCurso f on f.IdCurso =e.IdCurso
inner join Acreditacion_ctPeriodo g on g.IdPeriodo=e.IdPeriodo
inner join Acreditacion_ctMomento h on h.IdMomento=e.IdMomento
inner join Acreditacion_ctEvaluacion i  on i.IdEvaluacion=d.IdEvaluacion
inner join stPlanEstudioAsignatura j on j.IdPlanEstudioAsignatura=b.IdPlanEstudioAsignatura
inner join ctAsignatura k on k.IdAsignatura=j.IdAsignatura
inner join ctTipoComponente l on l.IdTipoComponente=k.IdTipoComponente
inner join ctGrupoCampus m on m.IdGrupoCampus=b.IdGrupoCampus
inner join ctGrupoNombre n on n.IdGrupoNombre=m.IdGrupoNombre
inner join ctCampus o on o.IdCampus=m.IdCampus
inner join ctCicloescolar bb on bb.IdCicloEscolar=b.IdCicloEscolar
inner join ctAlumnos nn on nn.Curp=a.Curp and nn.Matricula=a.Matricula
inner join ctPlanEstudio mm on mm.IdPlanEstudio=j.IdPlanEstudio
where a.Curp='" + curp + "' and a.Matricula='" + matricula + "' and b.Autorizado =1 order by b.IdCicloEscolar,j.Orden,e.Orden";




            var momentos = (List<KardexAlumno>)dp.connection.Query<KardexAlumno>(query);


            query = @"SELECT   IdPlanEstudioAsignatura
      ,IdCicloEscolar
      ,IdValorCiclo
      ,IdCursoPeriodoMomento
      ,Curp
      ,Matricula
      ,Calificacion
      ,Renunciada
      ,Dictaminada
      ,EsReprobada
      ,EsNp
      ,IdGrupoNombre
      ,IdCampus
      ,EsActualizacionPlanEstudio
      ,rptCalificacion
  FROM Acreditacion_stAlumnosCalificacionFinal where curp='" + curp + @"' and Matricula='" + matricula + "' and Dictaminada=0 and Renunciada=0";
            dp.Close();
            var finales = (List<Acreditacion_stAlumnosCalificacionFinal>)dp.connection.Query<Acreditacion_stAlumnosCalificacionFinal>(query);


            query = @"SELECT IdCicloEscolar
      ,IdValorCiclo
      ,Curp
      ,Matricula
      ,Calificacion
      ,EsReprobada
      ,rptCalificacion
      ,IdCampus
      ,IdGrupoNombre
      ,EsRegular
  FROM  Acreditacion_stAlumnosCalificacionGrado
 l where curp='" + curp + @"' and Matricula='" + matricula + "' ";
            var finalesgrados = (List<Acreditacion_stAlumnosCalificacionGrado>)dp.connection.Query<Acreditacion_stAlumnosCalificacionGrado>(query);





            query = @"SELECT a.IdAsignaturaPadre
      ,IdPlanEstudio
      ,IdCicloEscolar
      ,IdValorCiclo
      ,IdCursoPeriodoMomento
      ,Curp
      ,Matricula
      ,Calificacion
      ,Renunciada
      ,Dictaminada
      ,EsReprobada
      ,IdGrupoNombre
      ,IdCampus
      ,EsActualizacionPlanEstudio
      ,EsNp
,rptCalificacion,b.Nombre as Asignatura,b.Nivel,c.Nombre as Componente
   ,(select MIN(orden)-1 from stPlanEstudioAsignatura where IdAsignatura in (
  select IdAsignatura from ctAsignatura xx where xx.IdAsignaturaPadre=a.IdAsignaturaPadre)
  ) as OrdenAsignatura
  FROM  Acreditacion_stAlumnosCalificacionFinalModulos a
  inner join ctAsignatura b on a.IdAsignaturaPadre=b.IdAsignatura
  inner join ctTipoComponente c on c.IdTipoComponente=b.IdTipoComponente
  where a.curp='" + curp + @"' and a.Matricula='" + matricula + "' and a.Dictaminada=0 and a.Renunciada=0";
            var finalesmodulos = (List<AlumnosCalificacionFinalModulos>)dp.connection.Query<AlumnosCalificacionFinalModulos>(query);



            List<KardexAlumno> momentosfinales = new List<KardexAlumno>();
            bool hayfinales = false;
            if (momentos.Count > 0)
            {
                List<Acreditacion_stAlumnosCalificacionFinal> final = finales.Where(w => w.Curp == momentos[0].Curp && w.Matricula == momentos[0].Matricula).ToList();
                foreach (var item in final)
                {
                    hayfinales = true;
                    KardexAlumno cf = new KardexAlumno();
                    cf.IdPlanEstudioAsignatura = item.IdPlanEstudioAsignatura;
                    cf.OrdenAsignatura = 0;
                    cf.IdValorCiclo = item.IdValorCiclo;
                    cf.Calificacion = item.rptCalificacion;
                    cf.Evaluacion = "CF";
                    cf.OrdenEvaluacion = 100;
                    cf.Orden = 1;
                    momentosfinales.Add(cf);
                }

            }

            foreach (var item in finalesmodulos)
            {
                hayfinales = true;
                KardexAlumno cf = new KardexAlumno();
                cf.IdPlanEstudioAsignatura = item.IdAsignaturaPadre;
                cf.OrdenAsignatura = 0;
                cf.IdValorCiclo = item.IdValorCiclo;
                cf.Calificacion = item.rptCalificacion;
                cf.Evaluacion = "CF";
                cf.OrdenEvaluacion = 0;
                cf.Orden = 0;
                cf.Componente = "MODULO";
                cf.Asignatura = item.Asignatura;
                cf.OrdenAsignatura = item.OrdenAsignatura;
                cf.IdCicloEscolar = item.IdCicloEscolar;
                momentosfinales.Add(cf);
            }

            foreach (var item in finalesgrados)
            {
                hayfinales = true;
                KardexAlumno cf = new KardexAlumno();
                cf.IdPlanEstudioAsignatura = -1;
                cf.OrdenAsignatura = 0;
                cf.IdValorCiclo = item.IdValorCiclo;
                cf.Calificacion = item.rptCalificacion;
                cf.Evaluacion = "CF";
                cf.OrdenEvaluacion = 100;
                cf.Orden = 2;
                momentosfinales.Add(cf);
            }

            if (hayfinales)
            {


                foreach (var item in momentos)
                {

                    momentosfinales.Add(item);
                }


                return momentosfinales;
            }
            else
                return momentos;

        }


        public static List<CalificacionesAlumno> getCalificaciones(long IdHorarioAlumno)
        {
            DapperQuery dp = new DapperQuery("bdAriesEntities");
            string query;

            query = @"select a.IdHorarioAlumno,a.Curp,a.Matricula,a.IdValorCiclo,b.IdCicloEscolar,
c.rptCalificacion as Calificacion,c.EsNp,EsReprobada,EsReprobadaSinPago,f.Nombre as Curso,
g.Nombre as Periodo,h.Nombre as Momento,i.Nombre as Evaluacion, b.IdPlanEstudioAsignatura,0 as Orden
from stHorarioAlumno a inner join stHorario b on a.IdHorario=b.IdHorario
inner join Acreditacion_stMomentoEvaluacionCalificacion c on c.IdHorarioAlumno=a.IdHorarioAlumno
inner join Acreditacion_stMomentoEvaluacion d on c.IdMomentoEvaluacion=d.IdMomentoEvaluacion
inner join Acreditacion_stCursoPeriodoMomento e on e.IdCursoPeriodoMomento=d.IdCursoPeriodoMomento
inner join Acreditacion_ctCurso f on f.IdCurso =e.IdCurso
inner join Acreditacion_ctPeriodo g on g.IdPeriodo=e.IdPeriodo
inner join Acreditacion_ctMomento h on h.IdMomento=e.IdMomento
inner join Acreditacion_ctEvaluacion i  on i.IdEvaluacion=d.IdEvaluacion
where a.IdHorarioAlumno=" + IdHorarioAlumno + @" and b.Autorizado =1 order by e.Orden";




            var momentos = (List<CalificacionesAlumno>)dp.connection.Query<CalificacionesAlumno>(query);


            query = @"SELECT   IdPlanEstudioAsignatura
      ,IdCicloEscolar
      ,IdValorCiclo
      ,IdCursoPeriodoMomento
      ,Curp
      ,Matricula
      ,Calificacion
      ,Renunciada
      ,Dictaminada
      ,EsReprobada
      ,EsNp
      ,IdGrupoNombre
      ,IdCampus
      ,EsActualizacionPlanEstudio
      ,rptCalificacion
  FROM Acreditacion_stAlumnosCalificacionFinal where curp+matricula in (select a.Curp+a.Matricula
from stHorarioAlumno a inner join stHorario b on a.IdHorario=b.IdHorario
where a.IdHorarioAlumno=" + IdHorarioAlumno + @" and b.Autorizado =1 group by a.Curp,a.Matricula)";
            dp.Close();
            var finales = (List<Acreditacion_stAlumnosCalificacionFinal>)dp.connection.Query<Acreditacion_stAlumnosCalificacionFinal>(query);
            CalificacionesAlumno cf = new CalificacionesAlumno();

            List<CalificacionesAlumno> momentosfinales = new List<CalificacionesAlumno>();

            if (momentos.Count > 0)
            {
                Acreditacion_stAlumnosCalificacionFinal final = finales.Where(w => w.Curp == momentos[0].Curp && w.Matricula == momentos[0].Matricula && w.IdCicloEscolar == momentos[0].IdCicloEscolar && w.IdValorCiclo == momentos[0].IdValorCiclo && w.IdPlanEstudioAsignatura == momentos[0].IdPlanEstudioAsignatura).FirstOrDefault();
                if (final != null)
                {

                    cf.Calificacion = final.rptCalificacion;
                    cf.Evaluacion = "CF";
                    cf.Orden = 1;
                }
            }


            if (cf != null)
            {


                foreach (var item in momentos)
                {

                    momentosfinales.Add(item);
                }

                momentosfinales.Add(cf);
                return momentosfinales;
            }
            else
                return momentos;

        }

        public static List<SemestresAlumno> getSemestres(string Curp)
        {
            bdAriesEntities bd = new bdAriesEntities();
            return bd.stHorarioAlumno.Where(e => e.stHorario.Autorizado == true && e.ctAlumnos.Curp == Curp).GroupBy(r => r.IdValorCiclo).Select(t => new SemestresAlumno { Ciclo = "Semestre", IdValorCiclo = t.Key }).ToList();
        }


        //get fotogram of one student
        public static byte[] getFotografia(string Id, ref string tipo, List<stAlumnosFotos> bdfotos)
        {
            //            bdAriesEntities bd = new bdAriesEntities();

            //            DapperQuery dp = new DapperQuery("bdAriesEntities");
            //            string query;
            byte[] w = null;
            //             query = @"SELECT curp,foto,TipoImagen,Qrcodigo FROM stAlumnosFotos 
            //where  Curp='" + Id.ToString() + "' ";
            stAlumnosFotos ultimo = bdfotos.Where(x => x.Curp == Id).FirstOrDefault();

            if (ultimo != null)
            {
                w = ultimo.Foto;
                tipo = ultimo.TipoImagen;
            }




            return w;
        }
        public static byte[] getFotografiaDocente(string Id, ref string tipo, Kardex_ctDatosPersonalesFotografias bdfotos)
        {

            byte[] w = null;

            //Kardex_ctDatosPersonales ultimo = bdfotos.Where(x => x.CURP == Id).FirstOrDefault();

            if (bdfotos != null)
            {
                w = bdfotos.Fotografia;
                tipo = "jpg";
            }




            return w;
        }
        //get type fotogram
        public static string getTipoFotografia(string Id)
        {
            bdAriesEntities bd = new bdAriesEntities();
            string t = bd.stAlumnosFotos.Where(a => a.Curp == Id).Select(f => f.TipoImagen).SingleOrDefault();
            return t;
        }

//        public static HorariosVigentes getHorarioDocenteVigente(int id, string fecha)
//        {
//            Nomina_stNominaTrabajador NominaTrabajador = new Nomina_stNominaTrabajador();
//            NominaTrabajador.setHorariosDocentes(fecha);


//            HorariosVigentes hv = new HorariosVigentes();

//            //if (NominaTrabajador.NominaHorariosDocentesDetalle.Count == 0)
//            //{
//            //    NominaTrabajador.getHorarioDocenteAnterior(id);
//            //    if (NominaTrabajador.NominaHorariosDocentesDetalleAnterior.Count> 0)

//            //        NominaTrabajador.NominaHorariosDocentesDetalle = NominaTrabajador.NominaHorariosDocentesDetalleAnterior;
//            //}


//            var horario = NominaTrabajador.getHorarioActualDocente(id, 0, null, true);

//            var horariodocentepordia = horario.NominaHorariosDocentesDetalle
//                .Select(a => new HorarioVigente
//                {
//                    FechaInicioPago = a.FechaInicioPago,
//                    FechaFinalPago = a.FechaFinalPago,
//                    Grupo = "1",
//                    Asignatura = a.TipoHoras,
//                    IdAsignatura = a.IdDia,
//                    IdDia = (short)a.IdDia,
//                    Docente = "",
//                    Dia = a.Dia.ToString(),
//                    HoraInicio = a.HoraInicio,
//                    HoraFin = a.HoraFinal,
//                    CurpDocente = ""
//                }).OrderBy(d => d.Dia)

//                .ToList();

//            hv.Vigente = horariodocentepordia;

//            if (horario.HorarioVigente)
//            {
//                var horariodocentepordiaAnterior = horario.NominaHorariosDocentesDetalleAnterior
//                   .Select(a => new HorarioVigente
//                   {
//                       FechaInicioPago = a.FechaInicioPago,
//                       FechaFinalPago = a.FechaFinalPago,
//                       Grupo = "1",
//                       Asignatura = a.TipoHoras,
//                       IdAsignatura = a.IdDia,
//                       IdDia = (short)a.IdDia,
//                       Docente = "",
//                       Dia = a.Dia.ToString(),
//                       HoraInicio = a.HoraInicio,
//                       HoraFin = a.HoraFinal,
//                       CurpDocente = ""
//                   }).OrderBy(d => d.Dia)

//                   .ToList();
//                hv.Anterior = horariodocentepordiaAnterior;
//            }
//            //string query;
//            //var t = new List<HorarioVigente>();
//            //DapperQuery dp = new DapperQuery("bdAriesEntities");

//            //query = @" select q.Nombre as Grupo, x.Nombre as Asignatura, x.IdAsignatura, d.IdDia, d.Nombre as Dia,HoraInicio,HoraFin
//            //    ,xx.Nombre+' '+xx.ApPaterno +' '+xx.ApMaterno  as Docente,xx.Curp as CurpDocente
//            //     from stHorarioAlumno a inner join stHorario b on a.IdHorario=b.IdHorario
//            //     inner join ctPersonal xx on xx.IdEmpleado=b.IdEmpleado
//            //    inner join stHorarioDetalle c on c.IdHorario=b.IdHorario
//            //    inner join ctDia d on d.IdDia=c.IdDia
//            //    inner join stPlanEstudioAsignatura z on z.IdPlanEstudioAsignatura=b.IdPlanEstudioAsignatura
//            //    inner join ctAsignatura x on z.IdAsignatura=x.IdAsignatura
//            //    inner join ctGrupoCampus y on y.IdGrupoCampus=b.IdGrupoCampus
//            //    inner join ctGrupoNombre q on q.IdGrupoNombre=y.IdGrupoNombre
//            //    where IdHorarioAlumno in (
//            //    select IdHorarioAlumno from stHorario a inner join stHorarioAlumno b on a.IdHorario=b.IdHorario
//            //    inner join Acreditacion_ctReglamento c on a.IdReglamento=c.IdReglamento
//            //    inner join stCicloEscolar d on d.IdCicloEscolar=a.IdCicloEscolar and d.IdModalidadEstudio=c.IdModalidadEstudio
//            //    where xx.IdNova=" + id + @"
//            //    and a.IdCicloEscolar=dbo.fnObtenCicloEscolarVigente(c.IdModalidadEstudio) and a.Autorizado =1
//            //    )
//            //    order by c.IdDia,HoraInicio";
//            //t = (List<HorarioVigente>)dp.connection.Query<HorarioVigente>(query);
//            //dp.Close();

//            return hv;

//        }
//        public static List<HorarioVigente> getHorarioEspecialVigente(int id)
//        {
//            DapperQuery dpn = new DapperQuery("bdNovaEntities");
//            string query;
//            var t = new List<HorarioVigente>();
//            query = @" select Grupo,Asignatura,IdAsignatura,IdDia,Dia,HoraInicio,HoraFin,Docente,CurpDocente
//from ( select '1' as Grupo, '*' as Asignatura, c.IdDia as IdAsignatura, c.IdDia, c.Nombre as Dia,cast(b.Entrada as nvarchar(5)) as HoraInicio,cast(b.Salida as nvarchar(5)) HoraFin
//                ,a.Nombre+' '+a.ApellidoPaterno +' '+a.ApellidoMaterno  as Docente,a.CURP as CurpDocente
//                 from vwDatosAspirantesTrabajadores a
//                 inner join Nomina_HorariosEspeciales b 
//                     on a.IdTrabajador=b.IdTrabajador
//                 inner join bdCtlEscSeg.dbo.ctDia c on b.Dia=c.IdDia 
//                where a.IdKardex=" + id + @"  ) as q
//                group by Grupo,Asignatura,IdAsignatura,IdDia,Dia,HoraInicio,HoraFin,Docente,CurpDocente";
//            t = (List<HorarioVigente>)dpn.connection.Query<HorarioVigente>(query);
//            dpn.Close();

//            return t;

//        }
        //public static List<HorarioVigente> getHorarioConvenioVigente(int id)
        //{
        //    DapperQuery dpn = new DapperQuery("bdNovaEntities");
        //    string query;
        //    var t = new List<HorarioVigente>();
        //    query = @"select '1' as Grupo, '*' as Asignatura, '1' as IdAsignatura, c.IdDia, c.Nombre as Dia,cast(b.Entrada as nvarchar(5)) as HoraInicio,cast(b.Salida as nvarchar(5)) as HoraFin
        //        ,a.Nombre+' '+a.ApellidoPaterno +' '+a.ApellidoMaterno  as Docente,a.CURP as CurpDocente
        //         from vwDatosAspirantesTrabajadores a
        //         inner join Nomina_HorariosConvenioConfiguracion b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
        //         inner join bdCtlEscSeg.dbo.ctDia c on b.Dia=c.IdDia 
        //        where a.IdKardex=" + id + @" order by c.IdDia,c.Nombre,b.Entrada";
        //    t = (List<HorarioVigente>)dpn.connection.Query<HorarioVigente>(query);

        //    dpn.Close();

        //    return t;

        //}
    }

     
}