﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using Nova.Models;
using Nova.Libraries;
using Dapper;

namespace Nova.Models
{

    public  class Acreditacion_stMomentoEvaluacionCalificacionBd
    {
        public long IdMomentoEvaluacionCalificacion { get; set; }
        public long IdHorarioAlumno { get; set; }
        public short IdMomentoEvaluacion { get; set; }
        public decimal Calificacion { get; set; }
        public bool EsReprobada { get; set; }
        public bool EsNp { get; set; }
        public bool EsDefinitiva { get; set; }
        public bool EsReprobadaSinPago { get; set; }
        public string rptCalificacion { get; set; }
        public string Nombre { get; set; }

        
    }

    public class IdHorariosAlumnos
    {

        public long IdHorario { get; set; }
        public long IdHorarioAlumno;
        public string Curp { get; set; }
        public int IdPlanEstudioAsignatura { get; set; }
        public string Matricula { get; set; }
        public short IdCicloEscolar { get; set; }
        public short IdValorCiclo { get; set; }


    }


    public class CalificacionesPermitidasEvaluacion
    {


        public string Evaluacion { get; set; }
        public int CalificacionMinima { get; set; }
        public int CalificacionMaxima { get; set; }


    }

    public enum TipoPromedio
    {
        Periodo,
        Final,
        Grado,
        Evaluacion
    }


    public class EvaluacionesAlumnos
    {

        public Nullable<long> IdMomentoEvaluacionCalificacion { get; set; }
        public Nullable<long> IdHorarioAlumno { get; set; }
        public short IdMomentoEvaluacion { get; set; }
        public short IdCursoPeriodoMomento { get; set; }

        public Nullable<decimal> Calificacion { get; set; }
        public Nullable<bool> EsReprobada { get; set; }
        public Nullable<bool> EsNp { get; set; }
        public Nullable<bool> EsDefinitiva { get; set; }
        public Nullable<bool> EsReprobadaSinPago { get; set; }
        public string rptCalificacion { get; set; }
        public string Evaluacion { get; set; }
        public virtual stHorarioAlumno stHorarioAlumno { get; set; }


    }


    class ReglamentoEvaluacion
    {
        //This could be any userNumber from User. But it must be greater than 9
        // public int calificacionreprobatoria = 5;
        // that would be the answer you can show to your user or friend
        // private int idhorarioalumno = 0;
        // that would be your calculated  userNumber against user userNumber  
        // public int calificacion = 0;

        public virtual void CrearReglas()
        { }


        public string MascaraNumericaCalificacionFinal { get; set; }
        public string MascaraNumericaCalificacionGrado { get; set; }
        public string MascaraNumericaCalificacionPeriodo { get; set; }

        public string MascaraNumericaCalificacionEvaluacion{ get; set; }

        public int MaximoSubModulosReprobadasOrdinario { get; set; }
        public int MaximoReprobadasRegularizacion { get; set; }
        public int MaximoReprobadasExtraOrdinario { get; set; }
        public int MaximoReprobadasEE { get; set; }
        public int MaximoReprobadasCI { get; set; }
        public int MaximoReprobadasOrdinario { get; set; }
        public int MaximoReprobadasPorCiclo { get; set; }
        public int MaximoReprobadasPorEstancia { get; set; }
        public int MaximoGradoEstancia { get; set; }



        private double _calificacion;
        private long _idhorarioalumno;
        private double _calificacionmaxima;
        private double _calificacionminima;
        private bool _esreprobada;
        private decimal _calificacionReprobatoria;
        private decimal _calificacionNP;

        public Int16 _IdReglamento;

        protected internal bool _esNp { get; set; }

        public bool EsNp
        {
            get { return _esNp; }
            set { _esNp = value; }
        }


        public double CalificacionMaxima
        {
            get { return _calificacionmaxima; }
            set { _calificacionmaxima = value; }
        }

        public double CalificacionMinima
        {
            get { return _calificacionminima; }
            set { _calificacionminima = value; }
        }


        public long IdHorarioAlumno
        {
            get { return _idhorarioalumno; }
            set { _idhorarioalumno = value; }
        }

        public double Calificacion
        {
            get { return _calificacion; }
            set { _calificacion = value; }
        }

        public decimal CalificacionReprobatoria
        {
            get { return _calificacionReprobatoria; }
            set { _calificacionReprobatoria = value; }
        }

        public decimal CalificacionNPoReprobatoria
        {
            get { return _calificacionNP; }
            set { _calificacionNP = value; }
        }



        public List<Acreditacion_stMomentoEvaluacionCalificacion> _stMomentoEvaluacionCalificacion = new List<Acreditacion_stMomentoEvaluacionCalificacion>();
        public List<Acreditacion_stMomentoEvaluacionCalificacionBd> stMomentoEvaluacionCalificacionBaseDatos = new List<Acreditacion_stMomentoEvaluacionCalificacionBd>();

        public List<Acreditacion_stMomentoEvaluacionCalificacion> EvaluacionesAEliminar = new List<Acreditacion_stMomentoEvaluacionCalificacion>();
        public List<Acreditacion_stMomentoEvaluacionCalificacion> EvaluacionesAActualizar = new List<Acreditacion_stMomentoEvaluacionCalificacion>();
        public List<Acreditacion_stMomentoEvaluacionCalificacion> EvaluacionesAInsertar = new List<Acreditacion_stMomentoEvaluacionCalificacion>();
        public List<CalificacionesPermitidasEvaluacion> CalificacionesPermitidasEvaluacion = new List<CalificacionesPermitidasEvaluacion>();



        public List<Acreditacion_stPeriodoCalificacion> PeriodosEvaluacionesAInsertar = new List<Acreditacion_stPeriodoCalificacion>();
        public List<Acreditacion_stPeriodoCalificacion> PeriodosEvaluacionesAEliminar = new List<Acreditacion_stPeriodoCalificacion>();

        public List<Acreditacion_stAlumnosCalificacionFinal> CalificacionesFianlesAEliminar = new List<Acreditacion_stAlumnosCalificacionFinal>();
        public List<Acreditacion_stAlumnosCalificacionFinal> CalificacionesFinalesAInsertar = new List<Acreditacion_stAlumnosCalificacionFinal>();


        public List<Acreditacion_stAlumnosCalificacionGrado> CalificacionesFianlGradoAEliminar = new List<Acreditacion_stAlumnosCalificacionGrado>();
        public List<Acreditacion_stAlumnosCalificacionGrado> CalificacionesFinalGradoAInsertar = new List<Acreditacion_stAlumnosCalificacionGrado>();

        //  public List<Acreditacion_stMomentoEvaluacionCalificacion> _stHorarioCalificacion;

        //public List<Acreditacion_stAlumnosCalificacionFinal> _stAlumnosCalificacionFinal;

        public List<Acreditacion_stMomentoEvaluacion> _Acreditacion_stMomentoEvaluacion;

        public List<ctAlumnos> AlumnosIrregularesAActualizar = new List<ctAlumnos>();
        public List<ctAlumnos> AlumnosEstatusAActualizar = new List<ctAlumnos>();

        public List<IdHorariosAlumnos> Alumnos;
        public List<EvaluacionesAlumnos> EvaluacionesDelAlumno = new List<EvaluacionesAlumnos>();

        public List<Acreditacion_stPeriodoCalificacion> CalificacionesTotalesPeriodosAlumnos = new List<Acreditacion_stPeriodoCalificacion>();

        public virtual stHorarioAlumno stHorarioAlumno { get; set; }
        // Strategy aggregation
        //IEvaluar strategy = new Parcial1();
        IEvaluar _strategy;

        public IEvaluar Strategy
        {
            get
            { return _strategy; }
            set { _strategy = value; }
        }

        IReglamento _estrategia;

        public IReglamento Estrategia
        {
            get
            { return _estrategia; }
            set { _estrategia = value; }
        }

        public void ObtenerIdHorariosAlumnos()
        {
            var q = from alu in _stMomentoEvaluacionCalificacion
                    group alu by new { alu.stHorarioAlumno.stHorario.IdHorario, alu.stHorarioAlumno.Curp, alu.IdHorarioAlumno, alu.stHorarioAlumno.stHorario.IdPlanEstudioAsignatura, alu.stHorarioAlumno.Matricula, alu.stHorarioAlumno.stHorario.IdCicloEscolar, alu.stHorarioAlumno.IdValorCiclo } into grupo

                    orderby grupo.Key.IdHorarioAlumno
                    select new IdHorariosAlumnos { IdHorario = grupo.Key.IdHorario, IdHorarioAlumno = grupo.Key.IdHorarioAlumno, Curp = grupo.Key.Curp, IdPlanEstudioAsignatura = grupo.Key.IdPlanEstudioAsignatura, Matricula = grupo.Key.Matricula, IdCicloEscolar = grupo.Key.IdCicloEscolar, IdValorCiclo = grupo.Key.IdValorCiclo };

            Alumnos = q.ToList();
            var idhorariosalumnos = q.Select(f => f.IdHorarioAlumno).ToArray();
            if (idhorariosalumnos.Count() > 0)
            {
                String arrTostr = idhorariosalumnos.Select(a => a.ToString()).Aggregate((i, j) => i + "," + j);

                DapperQuery dp = new DapperQuery("bdAriesEntities");
                string query;

                query = @" SELECT  IdMomentoEvaluacionCalificacion
      ,IdHorarioAlumno
      ,a.IdMomentoEvaluacion
      ,Calificacion
      ,EsReprobada
      ,EsNp
      ,EsDefinitiva
      ,EsReprobadaSinPago
      ,rptCalificacion
      ,c.Nombre 
  FROM  Acreditacion_stMomentoEvaluacionCalificacion a
  inner join Acreditacion_stMomentoEvaluacion b on a.IdMomentoEvaluacion=b.IdMomentoEvaluacion
  inner join Acreditacion_ctEvaluacion c on c.IdEvaluacion=b.IdEvaluacion  where a.IdHorarioAlumno in (" + arrTostr + ")";



                stMomentoEvaluacionCalificacionBaseDatos = (List<Acreditacion_stMomentoEvaluacionCalificacionBd>)dp.connection.Query<Acreditacion_stMomentoEvaluacionCalificacionBd>(query);
            }
        }

        public string CalificacionCadena(decimal calificacion, TipoPromedio tipoFormato,string mascara=null)
        {
            string valor = "";
            string numerosmascara = "";
            string concatenacion = "";
            string ValorMascaraNumerica = "";
            string numero = calificacion.ToString();
            //   string MascaraNumericaCalificacionFinal = "99";
            //string MascaraNumericaCalificacionGrado = "99.9";
            //string MascaraNumericaCalificacionPeriodo = "99";

            if (mascara == null)
            {
                switch (tipoFormato)
                {
                    case TipoPromedio.Final:
                        ValorMascaraNumerica = MascaraNumericaCalificacionFinal;
                        break;
                    case TipoPromedio.Grado:
                        ValorMascaraNumerica = MascaraNumericaCalificacionGrado;
                        break;
                    case TipoPromedio.Periodo:
                        ValorMascaraNumerica = MascaraNumericaCalificacionPeriodo;

                        break;

                }
            }

            else
            {
                ValorMascaraNumerica = "99";
                if (System.Convert.ToInt32(mascara) > 0)
                    ValorMascaraNumerica = ValorMascaraNumerica +"."+ string.Concat(Enumerable.Repeat("9", System.Convert.ToInt32(mascara))); ;
            }


            if (numero.Length > 0)
            {

                int dato = ValorMascaraNumerica.IndexOf(".");
                if (dato > -1)
                {
                    numerosmascara = ValorMascaraNumerica.Substring(0, dato);
                }
                else
                {
                    numerosmascara = ValorMascaraNumerica;
                }

                numerosmascara = numerosmascara.Replace("9", "*");

                int puntonumero = 0;
                string tempo = "";
                int numerodecimales = 0;

                if (dato > 0)
                {
                    tempo = ValorMascaraNumerica.Substring(dato + 1);

                    numerodecimales = tempo.Length;


                    puntonumero = numero.IndexOf(".");

                    if (puntonumero > -1)
                    {
                        valor = numero.Substring(0, puntonumero);
                    }
                    else
                    {
                        valor = numero;
                    }
                    concatenacion = numerosmascara.Substring(0, numerosmascara.Length - valor.Length);
                    concatenacion = concatenacion.Replace("*", "");

                    valor = concatenacion + valor;

                    if (puntonumero == -1)
                    {
                        string ceros = ValorMascaraNumerica.Substring(dato);
                        dynamic puntonumeroMascara = ValorMascaraNumerica.IndexOf(".");
                        if (puntonumeroMascara > -1)
                        {
                            valor = valor + ceros.Replace("9", "0");
                        }
                        else
                        {
                            valor = valor + ceros.Replace("9", "");
                        }

                    }
                    else
                    {
                        valor = valor + numero.Substring(puntonumero, numerodecimales + 1);
                    }

                    //numerodecimales = numero.IndexOf(".")
                    //valor = numero.Substring(0, numerodecimales)
                }
                else
                {
                    int pos = 0;
                    //Dim tempo As String
                    pos = numero.IndexOf(".");
                    if (pos > 0 & numerosmascara.Length > 0)
                    {
                        concatenacion = numero.Substring(0, pos);

                        valor = numerosmascara.Substring(0, numerosmascara.Length - concatenacion.Length);
                        valor = valor + concatenacion;
                        valor = valor.Replace("*", " ");
                    }
                    else
                    {
                        valor = numero;
                    }
                }

            }
            return valor.Trim();

        }

        public void ObtenerEvaluacionesReglamentoAlumnos(long idhorarioalumno)
        {

            //var query = from person in people
            //            join pet in pets on person equals pet.Owner into gj
            //            from subpet in gj.DefaultIfEmpty()
            //            select new { person.FirstName, PetName = (subpet == null ? String.Empty : subpet.Name) };

            // EvaluacionesDeAlumnos.Clear();

            var LeftJoin = from emp in _Acreditacion_stMomentoEvaluacion
                           join midepto in _stMomentoEvaluacionCalificacion.Where(f => f.IdHorarioAlumno == idhorarioalumno)
                           on emp.IdMomentoEvaluacion equals midepto.IdMomentoEvaluacion into JoinedEmpDept
                           from dept in JoinedEmpDept.DefaultIfEmpty()
                           //orderby emp.Orden
                           select new EvaluacionesAlumnos
                           {
                               IdHorarioAlumno = dept != null ? dept.IdHorarioAlumno : 0,
                               IdMomentoEvaluacionCalificacion = dept != null ? dept.IdMomentoEvaluacionCalificacion : 0,

                               IdCursoPeriodoMomento = emp.IdCursoPeriodoMomento,
                               IdMomentoEvaluacion = emp.IdMomentoEvaluacion,
                               Calificacion = dept != null ? dept.Calificacion : -1,
                               EsReprobada = dept != null && dept.Calificacion <= this.CalificacionReprobatoria ? true : false,

                               EsNp = dept != null ? dept.EsNp : false,

                               EsDefinitiva = dept != null ? dept.EsDefinitiva : false,
                               EsReprobadaSinPago = dept != null ? dept.EsReprobadaSinPago : false,
                               rptCalificacion = dept != null ? dept.rptCalificacion : String.Empty,

                               Evaluacion = emp.Acreditacion_ctEvaluacion.Nombre,
                               stHorarioAlumno = dept != null ? dept.stHorarioAlumno : null,

                           };

            //foreach (var item in LeftJoin)
            //{
            //    EvaluacionesAlumnos t = new EvaluacionesAlumnos();

            //    t.IdHorarioAlumno = (long?)item.IdHorarioAlumno;
            //    t.IdMomentoEvaluacion = item.IdMomentoEvaluacion;
            //    t.Calificacion = (decimal?)item.Calificacion;
            //    t.EsReprobada = (bool?)item.EsReprobada;
            //    t.EsNp = (bool?)item.EsNp;
            //    t.EsDefinitiva = (bool?)item.EsDefinitiva;
            //    t.EsReprobadaSinPago = (bool?)item.EsReprobadaSinPago;
            //    t.rptCalificacion = item != null ? item.rptCalificacion : String.Empty;

            //    t.Evaluacion = item.Evaluacion;

            //    EvaluacionesDeAlumnos.Add(t);
            //}

            EvaluacionesDelAlumno.Clear();
            EvaluacionesDelAlumno.AddRange(LeftJoin.ToList());
            this.stHorarioAlumno = null;
            foreach (var item in EvaluacionesDelAlumno)
            {
                try 
	                {
                        if (this.stHorarioAlumno == null && item.stHorarioAlumno!=null)
		                this.stHorarioAlumno=item.stHorarioAlumno;
	                }
	            catch (Exception)
	            {
		
		
	            }
        
            }



        }

        public void ObtenerCalificacionesTotalesPeriodosAlumnos()
        {
            bdAriesEntities bd = new bdAriesEntities();


            var inner2 = from tt in Alumnos select tt.Curp;
            CalificacionesTotalesPeriodosAlumnos = bd.Acreditacion_stPeriodoCalificacion.Where(d => inner2.Contains(d.stHorarioAlumno.Curp)).ToList();




        }


        /// <summary>
        /// Este metodo evalua si en base a la califacion de una evalación en la base de datos se debe de eliminar otra, y de igual manera en la lista de calificaciones nuevas que 
        /// el usuario ha capturado en la interfaz
        /// </summary>
        /// <param name="evaluacion"></param>
        /// <param name="esreprobada"></param>
        /// <param name="idhorarioalumno"></param>

        public void ObtenerEvaluacionAEliminar(string evaluacion, bool esreprobada, bool esreprobadaEvaluacionComparada, long idhorarioalumno)
        {
            if (esreprobada == false)
            {
                bdAriesEntities data = new bdAriesEntities();

                //Acreditacion_stMomentoEvaluacionCalificacion f = EvaluacionesDelAlumno.Where(g => g.Evaluacion == evaluacion && g.IdMomentoEvaluacionCalificacion > 0).Select(t =>
                //               new Acreditacion_stMomentoEvaluacionCalificacion
                var f = data.Acreditacion_stMomentoEvaluacionCalificacion.Where(g => g.Acreditacion_stMomentoEvaluacion.Acreditacion_ctEvaluacion.Nombre == evaluacion && g.IdHorarioAlumno == idhorarioalumno).Select(t =>
     new
     {


         IdMomentoEvaluacionCalificacion = (long)t.IdMomentoEvaluacionCalificacion,
         IdHorarioAlumno = (long)t.IdHorarioAlumno,


         IdMomentoEvaluacion = (short)t.IdMomentoEvaluacion,
         Calificacion = (decimal)t.Calificacion,
         EsReprobada = (bool)t.EsReprobada,

         EsNp = (bool)t.EsNp,

         EsDefinitiva = (bool)t.EsDefinitiva,
         EsReprobadaSinPago = (bool)t.EsReprobadaSinPago,
         rptCalificacion = (string)t.rptCalificacion,

         stHorarioAlumno = t.stHorarioAlumno

     }).ToList();

                if (f.Count > 0)
                {


                    foreach (var item in f)
                    {
                        Acreditacion_stMomentoEvaluacionCalificacion x = new Acreditacion_stMomentoEvaluacionCalificacion();


                        x.IdMomentoEvaluacionCalificacion = item.IdMomentoEvaluacionCalificacion;
                        x.IdHorarioAlumno = item.IdHorarioAlumno;


                        x.IdMomentoEvaluacion = item.IdMomentoEvaluacion;
                        x.Calificacion = item.Calificacion;
                        x.EsReprobada = item.EsReprobada;

                        x.EsNp = item.EsNp;

                        x.EsDefinitiva = item.EsDefinitiva;
                        x.EsReprobadaSinPago = item.EsReprobadaSinPago;
                        x.rptCalificacion = item.rptCalificacion;
                        x.stHorarioAlumno = item.stHorarioAlumno;

                        var existe = EvaluacionesAEliminar.Where(d => d.IdMomentoEvaluacionCalificacion == item.IdMomentoEvaluacionCalificacion).Select(k => k.IdMomentoEvaluacionCalificacion).FirstOrDefault();
                        if (existe == 0)
                            EvaluacionesAEliminar.Add(x);
                    }



                }
                //else
                if (esreprobadaEvaluacionComparada == false)
                {
                    var itemToRemove = this._stMomentoEvaluacionCalificacion.Where(r => r.Acreditacion_stMomentoEvaluacion.Acreditacion_ctEvaluacion.Nombre == evaluacion && r.IdHorarioAlumno == idhorarioalumno).FirstOrDefault();
                    if (itemToRemove != null)
                    {
                        this._stMomentoEvaluacionCalificacion.Remove(itemToRemove);
                        // this.EvaluacionesDelAlumno.RemoveAll(d => d.IdHorarioAlumno == itemToRemove.IdHorarioAlumno && d.IdMomentoEvaluacion == itemToRemove.IdMomentoEvaluacion);
                    }
                }
            }
            else
            {
                if (esreprobadaEvaluacionComparada == false)
                {
                    var itemToRemove = this._stMomentoEvaluacionCalificacion.Where(r => r.Acreditacion_stMomentoEvaluacion.Acreditacion_ctEvaluacion.Nombre == evaluacion && r.IdHorarioAlumno == idhorarioalumno).FirstOrDefault();
                    if (itemToRemove != null)
                    {
                        this._stMomentoEvaluacionCalificacion.Remove(itemToRemove);
                        //  this.EvaluacionesDelAlumno.RemoveAll(d => d.IdHorarioAlumno == itemToRemove.IdHorarioAlumno && d.IdMomentoEvaluacion == itemToRemove.IdMomentoEvaluacion);
                    }
                }
            }

        }
    }

}