﻿using Dapper;
using Nova.Models;

using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Models
{

    public sealed class HorariosAlumnos
    {

        private static volatile HorariosAlumnos instance;
        private static object syncRoot = new Object();
        private static bdAriesEntities db = new bdAriesEntities();
        private static bdNovaEntities dbNova = new bdNovaEntities();
        private static bdPersonalEntities dbpersonal = new bdPersonalEntities();

        public List<ctPersonal> ctPersonal;
        public List<stHorarioAlumno> HorarioAlumnos;
        public List<Acreditacion_stMomentoEvaluacionCalificacion> stMomentoEvaluacionCalificacion;
        public List<vwCampus> campus;
        public List<vwPlanesEstudioAsignaturas> asignaturas;

        public List<Kardex_ctDatosPersonales> Kardex_ctDatosPersonales;

        public List<Kardex_ctTrabajador>  Kardex_ctTrabajador ;



        public List<stPlanEstudioAsignatura> stPlanEstudioAsignatura;
        public List<ctStatusAlumno> ctStatusAlumno;

        private void setHorarioAlumnos()
        {

            Libraries.DapperQuery dp = new Libraries.DapperQuery("bdNovaEntities");
            string query;
            query = @"use bdCtlEscSeg 
                        select bdCtlEscSeg.dbo.fnObtenCicloEscolarVigente(1) ";
            int id1 = dp.connection.ExecuteScalar<int>(query);
            dp.Close();
            query = @"use bdCtlEscSeg 
                        select bdCtlEscSeg.dbo.fnObtenCicloEscolarAnterior(1) ";
            int id2 = dp.connection.ExecuteScalar<int>(query);
            dp.Close();

            dbNova.Database.CommandTimeout = 0;
            this.asignaturas = db.vwPlanesEstudioAsignaturas.ToList();
            this.Kardex_ctDatosPersonales = dbNova.Kardex_ctDatosPersonales.ToList();

            this.Kardex_ctTrabajador = dbNova.Kardex_ctTrabajador.ToList();

            this.ctPersonal = dbpersonal.ctPersonal.ToList();

            HorarioAlumnos = db.stHorarioAlumno.Include("stHorario").Where(r => r.stHorario.Autorizado == true && (r.stHorario.IdCicloEscolar == id1 || r.stHorario.IdCicloEscolar == id2)).OrderBy(w => new { w.IdHorario, w.ctAlumnos.ApPaterno, w.ctAlumnos.ApMaterno, w.ctAlumnos.Nombre }).ToList();

            ctStatusAlumno = db.ctStatusAlumno.ToList();
            stPlanEstudioAsignatura = db.stPlanEstudioAsignatura.ToList();
        }
        public void Reset()
        {
            instance = new HorariosAlumnos();
        }
        private HorariosAlumnos()
        {

            setHorarioAlumnos();

        }

        public static HorariosAlumnos Instance
        {
            get
            {
                if (instance == null)
                {
                    lock (syncRoot)
                    {
                        if (instance == null)
                            instance = new HorariosAlumnos();
                    }
                }

                return instance;
            }
        }

        public List<stHorarioAlumno> getHorariosAlumnos(long IdHorario)
        {

            return HorarioAlumnos.Where(s => s.IdHorario == IdHorario).ToList();
        }

        public List<stHorarioAlumno> getHorariosPorAlumno(string curp, short idcicloescolar)
        {

            return HorarioAlumnos.Where(s => s.Curp == curp && s.stHorario.IdCicloEscolar == idcicloescolar
            && s.stHorario.stPlanEstudioAsignatura.ctAsignatura.NoRequiereEvaluacion ==false
            ).OrderBy(b => b.IdHorarioAlumno).ToList();
        }
        public List<Acreditacion_stMomentoEvaluacionCalificacion> getEvaluacionesPorHorario(long idhorario)
        {
            List<long> FiltroHorarioAlumnos = HorarioAlumnos.Where(d => d.IdHorario == idhorario).Select(f => f.IdHorarioAlumno).ToList();

            bdAriesEntities bb = new bdAriesEntities();
            var w = bb.Acreditacion_stMomentoEvaluacionCalificacion.Where(s => FiltroHorarioAlumnos.Contains(s.IdHorarioAlumno)).ToList();


            //var rows = from hor in FiltroHorarioAlumnos 
            //       join toto in db.Acreditacion_stMomentoEvaluacionCalificacion on hor.IdHorarioAlumno equals  toto.IdHorarioAlumno

            //       select toto;


            return w.ToList();
        }

        public List<Acreditacion_stAlumnosCalificacionFinal> getCalificacionesFinales(List<Acreditacion_stMomentoEvaluacionCalificacion> calificacioneshorario)
        {
            bdAriesEntities bd = new bdAriesEntities();

            var inner2 = from tt in calificacioneshorario select tt.stHorarioAlumno.Curp;
            var calif = from tt in calificacioneshorario
                        select new
                        {
                            Curp = tt.stHorarioAlumno.Curp,
                            IdPlanEstudioAsignatura = tt.stHorarioAlumno.stHorario.IdPlanEstudioAsignatura,
                            Matricula = tt.stHorarioAlumno.Matricula,
                            IdCicloEscolar = tt.stHorarioAlumno.stHorario.IdCicloEscolar
                        };

            var finales = bd.Acreditacion_stAlumnosCalificacionFinal.Where(d => inner2.Contains(d.Curp)).ToList();


            var fin = finales.Join(calif, x => new { x.Curp, x.IdPlanEstudioAsignatura, x.Matricula, x.IdCicloEscolar },
                y => new { y.Curp, y.IdPlanEstudioAsignatura, y.Matricula, y.IdCicloEscolar }, (x, y) => x).AsEnumerable()
                .Select(x =>

                   x.IdAlumnoCalificacionFinal

                ).ToList();



            var Califfinales = bd.Acreditacion_stAlumnosCalificacionFinal.Where(d => fin.Contains(d.IdAlumnoCalificacionFinal));


            return Califfinales.ToList();
        }




    }

}