﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Web;

public class UrlEncryptor
{
    public string EncryptedQueryString { get; set; }

    public UrlEncryptor(object parameters)
    {
        var dictionary = ObjectToDictionary(parameters);
        EncryptedQueryString = EncryptQueryString(dictionary);
    }

    private Dictionary<string, string> ObjectToDictionary(object parameters)
    {
        var dictionary = new Dictionary<string, string>();
        if (parameters != null)
        {
            foreach (var property in parameters.GetType().GetProperties())
            {
                var key = property.Name;
                var value = property.GetValue(parameters)?.ToString() ?? string.Empty;
                dictionary[key] = value;
            }
        }
        return dictionary;
    }

    public static string EncryptQueryString(Dictionary<string, string> parameters)
    {

        StringBuilder queryStringBuilder = new StringBuilder("?");
        foreach (var kvp in parameters)
        {
            queryStringBuilder.Append(HttpUtility.UrlEncode(kvp.Key) + "=" + HttpUtility.UrlEncode(kvp.Value) + "&");
        }

        string queryString = queryStringBuilder.ToString().TrimEnd('&');
        string sharedKey = "MySecretKey123";
        string encryptedText = SimpleXOREncryption.Encrypt(queryString, sharedKey);
        string encodedEncryptedText = HttpUtility.UrlEncode(Convert.ToBase64String(Encoding.UTF8.GetBytes(encryptedText)));

        return encodedEncryptedText;
    }

    public static string DecryptQueryString(string encryptedQueryString)
    {
        string sharedKey = "MySecretKey123";
        string decodedEncryptedText = Encoding.UTF8.GetString(Convert.FromBase64String(HttpUtility.UrlDecode(encryptedQueryString)));
        string decryptedText = SimpleXOREncryption.Decrypt(decodedEncryptedText, sharedKey);

        return decryptedText;
    }
}

public class SimpleXOREncryption
{
    public static string Encrypt(string text, string key)
    {
        byte[] textBytes = Encoding.UTF8.GetBytes(text);
        byte[] keyBytes = Encoding.UTF8.GetBytes(key);

        byte[] encryptedBytes = new byte[textBytes.Length];

        for (int i = 0; i < textBytes.Length; i++)
        {
            encryptedBytes[i] = (byte)(textBytes[i] ^ keyBytes[i % keyBytes.Length]);
        }

        return Convert.ToBase64String(encryptedBytes);
    }

    public static string Decrypt(string encryptedText, string key)
    {
        byte[] encryptedBytes = Convert.FromBase64String(encryptedText);
        byte[] keyBytes = Encoding.UTF8.GetBytes(key);

        byte[] decryptedBytes = new byte[encryptedBytes.Length];

        for (int i = 0; i < encryptedBytes.Length; i++)
        {
            decryptedBytes[i] = (byte)(encryptedBytes[i] ^ keyBytes[i % keyBytes.Length]);
        }

        return Encoding.UTF8.GetString(decryptedBytes);
    }
}
