﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Libraries
{
    public class StringHelper
    {
        public static string ObtenerIniciales(string input)
        {
            if (string.IsNullOrWhiteSpace(input))
            {
                return string.Empty;
            }

            // Separar las palabras de la cadena de entrada
            string[] words = input.Split(' ', (char)StringSplitOptions.RemoveEmptyEntries);

            // Asegurarse de que haya al menos dos palabras
            if (words.Length < 2)
            {
                return string.Empty;
            }

            // Obtener las primeras letras de las dos primeras palabras
            string initials = words[0][0].ToString().ToUpper() + words[1][0].ToString().ToUpper();

            return initials;
        }
    }

   

}