﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Web;

namespace Nova.Libraries
{
    
        public static class StreamHelpers
        {
            public static byte[] ReadFully(this Stream input)
            {
                using (MemoryStream ms = new MemoryStream())
                {
                    input.CopyTo(ms);
                    return ms.ToArray();
                }
            }

            public static byte[] FromFile(string path)
            {
                //Bitmap image1 = (Bitmap)Image.FromStream(@path);

                int f = path.IndexOf("/Content/UploadControl/UploadFolder/");
                if (f >= 0)
                {
                    path = path.Substring(f);
                    path = "~" + path;
                }
                return ReadFully(File.OpenRead(HttpContext.Current.Server.MapPath(@path)));
            
            }
        
    }
}