﻿using System.Data.Entity;
using Nova.Models;
public static class EntityFrameworkExtensions
{
    public static void SaveChanges (ref bdNovaEntities context,int count, int commitCount, bool recreateContext)
    {
        if (count == 1)
        {
            context.Configuration.AutoDetectChangesEnabled = false;
            context.Configuration.ValidateOnSaveEnabled = false;
        }

        context.SaveChanges();

        if (count % commitCount == 0)
        {
           
            if (recreateContext)
            {
                context.Dispose();
                //context = contextCreator.Invoke();
                context = null;
                context = new bdNovaEntities();
                context.Configuration.AutoDetectChangesEnabled = false;
                context.Configuration.ValidateOnSaveEnabled = false;
            }
        }
        
    }
}