﻿using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Libraries
{

    public static class SystemMessage
    {
        public static string SuccesSave { get; set; } = "Se ha grabado exitosamente la información";
        public static string SuccesEdit { get; set; } = "Se ha editado exitosamente la información";
        public static string SuccesDelete { get; set; } = "Se ha eliminado exitosamente el registro";
        public static string CompleteFields { get; set; } = "Debe de completar la informacíon de los campos marcados";



    }

    public enum TipoMensaje { Error, Information, Warning, Success };
    public enum TipoVentana { DialogoModal, DialogoNormal, EmbebidaHTML };

    public class MessageBox
    {



        internal static void Show(ViewDataDictionary ViewData, TipoMensaje tipoMensaje, string mensaje, string titulo = null, string url=null)
        {

            //Inicia los valores por default
            //
            ViewData["VentanaEmbebidaMsgCtrlMvc"] = "False";
            ViewData["HtmlParentMsgCtrlMvc"] = "#body";
            //&ViewData["TipoVentanaMsgCtrlMvc"] = tipoventana.ToString();
            //////


            //if (jquerySelectorParent != "" && jquerySelectorParent != null)

            //    ViewData["HtmlParentMsgCtrlMvc"] = jquerySelectorParent;
            if (url != null)
            {
                ViewData["Url"] = url;
            }
            if (titulo == null || titulo == "")
                titulo = "Mensaje del Sistema";

            ViewData["MensajeMsgCtrlMvc"] = mensaje;
            ViewData["TituloMsgCtrlMvc"] = titulo;




            //if (tipoventana == TipoVentana.EmbebidaHTML)
            //    ViewData["VentanaEmbebidaMsgCtrlMvc"] = "True";



            switch (tipoMensaje)
            {
                case TipoMensaje.Error:
                    //if (tipoventana != TipoVentana.EmbebidaHTML)
                    //    ViewData["TipoErrorMsgBoxMvc"] = "ui-icon ui-icon-close";
                    //else
                    ViewData["TipoErrorMsgBoxMvc"] = "error";
                    break;
                case TipoMensaje.Information:

                    //if (tipoventana != TipoVentana.EmbebidaHTML)
                    //    ViewData["TipoErrorMsgBoxMvc"] = "ui-icon ui-icon-info";
                    //else
                    ViewData["TipoErrorMsgBoxMvc"] = "info";
                    break;
                case TipoMensaje.Warning:

                    //if (tipoventana != TipoVentana.EmbebidaHTML)
                    //    ViewData["TipoErrorMsgBoxMvc"] = "ui-icon ui-icon-alert";
                    //else
                    ViewData["TipoErrorMsgBoxMvc"] = "warning";
                    break;
                case TipoMensaje.Success:

                    //if (tipoventana != TipoVentana.EmbebidaHTML)
                    //    ViewData["TipoErrorMsgBoxMvc"] = "ui-icon ui-icon-check";
                    //else
                    ViewData["TipoErrorMsgBoxMvc"] = "success";
                    break;
                default:
                    break;
            }

        }
    }
}