﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Web;

namespace Nova.Libraries
{
    public class Dias
    {
        
        public static string Nombre(int numero)
        {
            String dia = "Desconocido";
            switch (numero)
            {
                case 1:
                    dia = "Lunes";
                    break;
                case 2:
                    dia = "Martes";
                    break;
                case 3:
                    dia = "Miércoles";
                    break;
                case 4:
                    dia = "Jueves";
                    break;
                case 5:
                    dia = "Viernes";
                    break;
                case 6:
                    dia = "Sábado";
                    break;
                case 7:
                    dia = "Domingo";
                    break;
                default:
                    break;
            }
            return dia;

        }
        public static string AbreviaturaDiaSemana(System.DayOfWeek diasemana)
        {
            String dia = "Uk";
            switch ((int)diasemana)
            {
                case 1:
                    dia = "Lu";
                    break;
                case 2:
                    dia = "Ma";
                    break;
                case 3:
                    dia = "Mi";
                    break;
                case 4:
                    dia = "Ju";
                    break;
                case 5:
                    dia = "Vi";
                    break;
                case 6:
                    dia = "Sá";
                    break;
                case 0:
                    dia = "Do";
                    break;
                default:
                    break;
            }
            return dia;

        }

    }
    public class Meses
    {

        public static string Nombre(int numeroMes)
        {
            try
            {
                DateTimeFormatInfo formatoFecha = CultureInfo.CurrentCulture.DateTimeFormat;
                string nombreMesAbreviado = formatoFecha.GetMonthName(numeroMes).ToUpper();
                return nombreMesAbreviado;
            }
            catch
            {
                return "Desconocido";
            }
        }
        public static string NombreAbreviadoMayusculaPrimerLetra(int numeroMes)
        {
                DateTimeFormatInfo formatoFecha = CultureInfo.CurrentCulture.DateTimeFormat;
                string nombreMesAbreviado = formatoFecha.GetAbbreviatedMonthName(2);

                TextInfo textInfo = new CultureInfo("es-MX", false).TextInfo;

                nombreMesAbreviado = textInfo.ToTitleCase(nombreMesAbreviado.ToLower());
                return nombreMesAbreviado;
            
        }
        public static string NombreAbreviado(int numeroMes)
        {
            try
            {
                DateTimeFormatInfo formatoFecha = CultureInfo.CurrentCulture.DateTimeFormat;
                string nombreMesAbreviado = formatoFecha.GetAbbreviatedMonthName(numeroMes).ToUpper();
                return nombreMesAbreviado;
            }
            catch
            {
                return "Desconocido";
            }
        }

        public static int SumarDiasSiEsFebreroa30(DateTime start, DateTime end)
        {
            var mesInicio = start.Month;
            var mesFin = end.Month;
            int TotalDias = 0;
            var diasEnFebrero = System.DateTime.DaysInMonth(end.Year,2);
            var diaultimomes = end.Day;

            if ((mesInicio == 2 || mesFin==2) && diasEnFebrero==end.Day)
                TotalDias = 30 - diasEnFebrero;
            else
                if (mesFin > 2 && mesInicio<=2)
                    TotalDias = 30 - diasEnFebrero;

            return TotalDias;
        }
            public static int NumeroDeMesesCon31Dias(DateTime start,DateTime end)
        {
            int dias = 0;
            //var start = new DateTime(2010, 11, 1);
            //var end = new DateTime(2011, 11, 30);
            if (start.Month != end.Month)
            {
                var diff = Enumerable.Range(0, 13).Select(a => start.AddMonths(a))
                           .TakeWhile(a => a <= end)
                           .Select(a => a.ToString("MM"));

                foreach (var ele in diff)
                {
                    var date = DateTime.Parse(DateTime.Now.Year + "-" + ele + "-01");
                    if (DateTime.DaysInMonth(date.Year, date.Month) == 31)
                    {
                        if (Libraries.ConvertToInt.ConvertToInt32(ele) == end.Month)
                        {
                            if (end.Day == 31)
                                dias = dias + 1;
                        }
                        else
                         
                                dias = dias + 1;
                         
                    }

                }
            }
            else
             if (end.Day == 31)
                dias = dias + 1;

            return dias;
        }
        public static string GetNombreMes(int numeroMes)
        {
            string nombreMes="";
            switch (numeroMes)
            {
                case 1:
                    nombreMes = "ENERO";
                    break;
                case 2:
                    nombreMes = "FEBRERO";
                    break;
                case 3:
                    nombreMes = "MARZO";
                    break;
                case 4:
                    nombreMes = "ABRIL";
                    break;
                case 5:
                    nombreMes = "MAYO";
                    break;
                case 6:
                    nombreMes = "JUNIO";
                    break;
                case 7:
                    nombreMes = "JULIO";
                    break;
                case 8:
                    nombreMes = "AGOSTO";
                    break;
                case 9:
                    nombreMes = "SEPTIEMBRE";
                    break;
                case 10:
                    nombreMes = "OCTUBRE";
                    break;
                case 11:
                    nombreMes = "NOVIEMBRE";
                    break;
                case 12:
                    nombreMes = "DICIEMBRE";
                    break;
            }
            return nombreMes;
        }

    }
}