﻿using Nova.Controllers;
using System;
using System.Net;
using System.Web;
using System.Web.Hosting;
using System.Web.Mvc;
using System.Web.Optimization;
using System.Web.Routing;

namespace Nova
{
    public class MvcApplication : System.Web.HttpApplication
    {
        protected void Application_Start()
        {
            // Forzar TLS 1.2 globalmente
            System.Net.ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12;

            // Inicializa los componenetes grid y gridview del DevExpress para permitir los formatos de fecha
            ModelBinders.Binders.DefaultBinder = new DevExpress.Web.Mvc.DevExpressEditorsBinder();
            AreaRegistration.RegisterAllAreas();
            FilterConfig.RegisterGlobalFilters(GlobalFilters.Filters);
            RouteConfig.RegisterRoutes(RouteTable.Routes);
            BundleConfig.RegisterBundles(BundleTable.Bundles);

            DevExpress.Web.ASPxWebControl.CallbackError += Application_Error;

            ViewEngines.Engines.Clear();

            IViewEngine razorEngine = new RazorViewEngine() { FileExtensions = new string[] { "cshtml" } };
            // Agregar encabezados para proteger contra ClickJacking
            GlobalFilters.Filters.Add(new ClickJackingProtectionFilter());

            ViewEngines.Engines.Add(razorEngine);
            //ChangeDefaultDateFormat();

            // Eliminar la cabecera X-AspNet-Version
            HttpContext.Current.Response.Headers.Remove("X-AspNet-Version");

            // Eliminar la cabecera X-AspNetMvc-Version
            MvcHandler.DisableMvcResponseHeader = true;
        }

        //private void ChangeDefaultDateFormat()
        //{
        //    CultureInfo ci = new CultureInfo("es-ES");
        //    ci.DateTimeFormat.ShortDatePattern = "dd-MM-yyyy";
        //    ci.DateTimeFormat.DateSeparator = "-";
        //    System.Threading.Thread.CurrentThread.CurrentCulture = ci;
        //    System.Threading.Thread.CurrentThread.CurrentUICulture = ci;
        //    // Set the default model binder to use the new date format
        //    ModelBinders.Binders.DefaultBinder = new DevExpress.Web.Mvc.DevExpressEditorsBinder();
        //}
        protected void Application_BeginRequest()
        {
            // Agregar la cabecera X-Content-Type-Options
            HttpContext.Current.Response.Headers.Add("X-Content-Type-Options", "nosniff");
        }
        protected void Application_Error(object sender, EventArgs e)
        {
            Exception lastError = Server.GetLastError();
            Server.ClearError();

            int statusCode = 0;

            if (lastError.GetType() == typeof(HttpException))
            {
                statusCode = ((HttpException)lastError).GetHttpCode();
            }
            else
            {
                // Not an HTTP related error so this is a problem in our code, set status to
                // 500 (internal server error)
                statusCode = 500;
            }

            HttpContextWrapper contextWrapper = new HttpContextWrapper(this.Context);

            RouteData routeData = new RouteData();
            routeData.Values.Add("controller", "Error");
            routeData.Values.Add("action", "Index");
            routeData.Values.Add("statusCode", statusCode);
            routeData.Values.Add("exception", lastError);
            routeData.Values.Add("isAjaxRequet", contextWrapper.Request.IsAjaxRequest());

            IController controller = new ErrorController();

            RequestContext requestContext = new RequestContext(contextWrapper, routeData);

            controller.Execute(requestContext);
            Response.End();
        }

        //protected void Application_BeginRequest(Object sender, EventArgs e)
        //{
        //    CultureInfo ci = new CultureInfo("es-ES");
        //    ci.DateTimeFormat.ShortDatePattern = "dd-MM-yyyy";
        //    ci.DateTimeFormat.DateSeparator = "-";
        //    System.Threading.Thread.CurrentThread.CurrentCulture = ci;
        //    System.Threading.Thread.CurrentThread.CurrentUICulture = ci;
        //}

     
    }

    // Agregar encabezados para proteger contra ClickJacking
    public class ClickJackingProtectionFilter : ActionFilterAttribute
    {
        public override void OnResultExecuting(ResultExecutingContext filterContext)
        {
            filterContext.HttpContext.Response.Headers.Add("X-Frame-Options", "DENY");
            filterContext.HttpContext.Response.Headers.Add("Content-Security-Policy", "frame-ancestors 'self'");
            base.OnResultExecuting(filterContext);
        }
    }

    


}
