﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class ZonaSalarioMinimoController : Controller
    {
        //
        // GET: /ZonaSalarioMinimo/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvZonaSalarioMinimo()
        {
            var model = db.Catalogos_ctZonaSalarioMinimo;
            return PartialView("_pvZonaSalarioMinimo", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvZonaSalarioMinimoAddNew(Nova.Models.Catalogos_ctZonaSalarioMinimo item)
        {
            var model = db.Catalogos_ctZonaSalarioMinimo;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvZonaSalarioMinimo", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvZonaSalarioMinimoUpdate(Nova.Models.Catalogos_ctZonaSalarioMinimo item)
        {
            var model = db.Catalogos_ctZonaSalarioMinimo;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdZonaSalarioMinimo == item.IdZonaSalarioMinimo);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvZonaSalarioMinimo", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvZonaSalarioMinimoDelete(System.Int16 IdZonaSalarioMinimo)
        {
            var model = db.Catalogos_ctZonaSalarioMinimo;
            if (IdZonaSalarioMinimo != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdZonaSalarioMinimo == IdZonaSalarioMinimo);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;

                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            return PartialView("_pvZonaSalarioMinimo", model.ToList());
        }
    }
}
