﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class TipoIncidenciaController : Controller
    {
        //
        // GET: /TipoIncidencia/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvTipoIncidencia()
        {
            var model = db.Catalogos_ctTipoIncidencia;
            return PartialView("_pvTipoIncidencia", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvTipoIncidenciaAddNew(Nova.Models.Catalogos_ctTipoIncidencia item)
        {
            var model = db.Catalogos_ctTipoIncidencia;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvTipoIncidencia", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvTipoIncidenciaUpdate(Nova.Models.Catalogos_ctTipoIncidencia item)
        {
            var model = db.Catalogos_ctTipoIncidencia;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdTipoIncidencia == item.IdTipoIncidencia);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvTipoIncidencia", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvTipoIncidenciaDelete(System.Int16 IdTipoIncidencia)
        {
            var model = db.Catalogos_ctTipoIncidencia;
            if (IdTipoIncidencia != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdTipoIncidencia == IdTipoIncidencia);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            return PartialView("_pvTipoIncidencia", model.ToList());
        }
    }
}
