﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class SpdConvocatoriasSedesController : Controller
    {
        //
        // GET: /SpdConvocatoriasSedes/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvSpdConvocatoriasSedes()
        {
            var model = db.spd_stConvocatoriaSede;
            return PartialView("_pvSpdConvocatoriasSedes", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvSpdConvocatoriasSedesAddNew(Nova.Models.spd_stConvocatoriaSede item)
        {
            var model = db.spd_stConvocatoriaSede;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvSpdConvocatoriasSedes", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvSpdConvocatoriasSedesUpdate(Nova.Models.spd_stConvocatoriaSede item)
        {
            var model = db.spd_stConvocatoriaSede;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdConvocatoriaSede == item.IdConvocatoriaSede);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvSpdConvocatoriasSedes", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvSpdConvocatoriasSedesDelete(System.Int16 IdConvocatoriaSede)
        {
            var model = db.spd_stConvocatoriaSede;
            if (IdConvocatoriaSede != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdConvocatoriaSede == IdConvocatoriaSede);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;

                }
            }
            return PartialView("_pvSpdConvocatoriasSedes", model.ToList());
        }
    }
}
