﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Nova.Libraries;
using Seguridad;
using System.Transactions;

namespace Nova.Controllers.Spd
{
    
       [AllowAnonymous]
       [Authorize]
    public class SpdController : Controller
    {
        bdNovaEntities db = new bdNovaEntities();
        // GET: Spd
        public ActionResult Index()
        {
            return View();
        }

        private List<spd_stConvocatoriaSede> getCursos()
        {
            int idkardex = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.IdConvenioLaboralTrabajador;

            //List<Capacitacion_stConvocatoriasCursos> cursosaulas = spd_stConvocatoriaSede.getConvocagoriasDisponibles(Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.IdTrabajador, Identidad.Usuario().Catalogos_ctEstructuraOrganica.IdEstructuraOrganica, Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.IdCategoria, Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.IdRelacionLaboral, Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.IdConvenioLaboral, Identidad.Usuario().Catalogos_ctEstructuraOrganica.IdEstructuraOrganicaPadre);
            var missedes = db.spd_stConvocatoriaKardex.Where(f => f.IdKardex == idkardex).Select(g => g.IdConvocatoria).ToArray();
            List<spd_stConvocatoriaSede> cursosaulas = db.spd_stConvocatoriaSede.Where(h => missedes.Contains(h.IdConvocatoria)).ToList();

            var inscritoen = db.spd_stInscripcionConvocatoriaSede.Where(i => i.IdConvenioLaboralTrabajadorCategoria == idkardex).Select(t => t.spd_stConvocatoriaSede.IdConvocatoriaSede);

            var cursos = cursosaulas.Where(r => !inscritoen.Contains(r.IdConvocatoriaSede)).Select(b => b.IdConvocatoriaSede);

            //var disponibles = cursosaulas.Select(b => b.IdConvocatoriaCursos);

            List<spd_stConvocatoriaSede> lista = db.spd_stConvocatoriaSede.Where(r => cursos.Contains(r.IdConvocatoriaSede)).ToList();
            return lista;
        }
           [AllowAnonymous]
        public ActionResult Inscripcion(string mensaje = null)
        {
            if (mensaje != null)
                MessageBox.Show(ViewData, TipoMensaje.Error, mensaje);


            return View(getCursos());
        }

           [AllowAnonymous]
        [HttpPost]
        public ActionResult Inscribirme(FormCollection form)
        {

            Int16 icsa = System.Convert.ToInt16(Request["hfidcursosedeaula"]);


            spd_stConvocatoriaSede aula = db.spd_stConvocatoriaSede.Find(icsa);

            spd_stInscripcionConvocatoriaSede participante = new spd_stInscripcionConvocatoriaSede();

            participante.IdConvocatoriaSede = icsa;
            participante.IdUsuario= Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            participante.IdConvenioLaboralTrabajadorCategoria = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            participante.FechaRegistro = DateTime.Now;
     
            
            participante.spd_stConvocatoriaSede = aula;




            if (participante.ValidaModelo().IsValid)
            {
                db.spd_stInscripcionConvocatoriaSede.Add(participante);

                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {

                    try
                    {
                        db.SaveChanges();

                   



                        
                    }
                    catch (Exception e)
                    {
                        
                            if (ExceptionExtensions.GetOriginalException(e).Message.IndexOf("duplicada ")!= -1)
                                throw new ApplicationException("Ya estas dado de alta en una sede para esta convocatoria");
                            else
                        throw new ApplicationException(ExceptionExtensions.GetOriginalException(e).Message);
                    }

                    scope.Complete();
                }
                MessageBox.Show(ViewData, TipoMensaje.Success, "Se ha realizado la inscripción satisfactoriamente a la sede");
                return View("Inscripcion", getCursos());
            }
            else
            {

                MessageBox.Show(ViewData, TipoMensaje.Error, participante.ValidaModelo().Mensaje);
                //RedirectToAction("Inscripcion", new { id = icsa, mensaje = participante.ValidaModelo().Mensaje });
                return View("Inscripcion", getCursos());
            }


        }
           [AllowAnonymous]
        public ActionResult CursosTomados()
        {
            int IdConvenioLaboralTrabajadorCategoria = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            var tomados = db.spd_stInscripcionConvocatoriaSede.Where(h => h.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).Select(g => g.IdConvocatoriaSede).ToList();
            List<spd_stConvocatoriaSede> cursos = db.spd_stConvocatoriaSede.Where(r => tomados.Contains(r.IdConvocatoriaSede)).ToList();
            return PartialView(cursos);
        }
    }
}