﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.IO;
using System.Linq;
using System.Net;
using System.Transactions;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

using Dapper;

namespace Nova.Controllers.SistemaArchivos.Catalogos
{
    public class SistemaArchivos_CatalogoValorDocumentalController :  BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: SistemaArchivos_CatalogoValorDocumental
        public ActionResult Index()
        {
            return View(db.ArchivoConcentracion_ctValorDocumental.OrderByDescending(x=> x.IdValorDocumental).ToList());
        }

        // GET: SistemaArchivos_CatalogoValorDocumental/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ArchivoConcentracion_ctValorDocumental archivoConcentracion_ctValorDocumental = db.ArchivoConcentracion_ctValorDocumental.Find(id);
            if (archivoConcentracion_ctValorDocumental == null)
            {
                return HttpNotFound();
            }
            return View(archivoConcentracion_ctValorDocumental);
        }

        // GET: SistemaArchivos_CatalogoValorDocumental/Create
        public ActionResult Create()
        {
           
            return PartialView();
        }

        // POST: SistemaArchivos_CatalogoValorDocumental/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdValorDocumental,ValorDocumental")] ArchivoConcentracion_ctValorDocumental archivoConcentracion_ctValorDocumental)
        {



           

            if (ModelState.IsValid)
            {

                var RegistrosRepetidos = db.ArchivoConcentracion_ctValorDocumental.Where(g => g.IdValorDocumental == archivoConcentracion_ctValorDocumental.IdValorDocumental).ToArray();
                int valor = RegistrosRepetidos.Count();
                if (valor > 0)
                {


                    return Json(new { Valid = false, Message = "Ya existe un  archivo igual " });
                }

                else
                {

                    try
                    {
                                                   
                            db.ArchivoConcentracion_ctValorDocumental.Add(archivoConcentracion_ctValorDocumental);
                            db.SaveChanges();

                            return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                        
                    }
                    catch (Exception e)
                    {

                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    }


                    return JsonView(ModelState.IsValid, "El archivo no fue agregado satisfactoriamente");
                }



            }

            //ViewBag.IdTipoAnexoDocumento = new SelectList(db.Oficialia_ctTipoAnexoDocumento, "IdTipoAnexoDocumento", "TipoAnexoDocumento", oficialia_stAnexoDocumentoSalida.IdTipoAnexoDocumento);
            return JsonView(ModelState.IsValid, "El archivo se agregado satisfactoriamente");


        }


        // GET: SistemaArchivos_CatalogoValorDocumental/Edit/5
        public ActionResult Edit(int id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ArchivoConcentracion_ctValorDocumental archivoConcentracion_ctValorDocumental = db.ArchivoConcentracion_ctValorDocumental.Find(id);
            if (archivoConcentracion_ctValorDocumental == null)
            {
                return HttpNotFound();
            }
            return View(archivoConcentracion_ctValorDocumental);
        }

        // POST: SistemaArchivos_CatalogoValorDocumental/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdValorDocumental,ValorDocumental")] ArchivoConcentracion_ctValorDocumental archivoConcentracion_ctValorDocumental)
        {
           

            if (ModelState.IsValid)
            {

                try
                {

                    
                        db.Entry(archivoConcentracion_ctValorDocumental).State = EntityState.Modified;
                        db.SaveChanges();

                        return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                    


                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
               
            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // GET: SistemaArchivos_CatalogoValorDocumental/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ArchivoConcentracion_ctValorDocumental archivoConcentracion_ctValorDocumental = db.ArchivoConcentracion_ctValorDocumental.Find(id);
            if (archivoConcentracion_ctValorDocumental == null)
            {
                return HttpNotFound();
            }
            return View(archivoConcentracion_ctValorDocumental);
        }

        // POST: SistemaArchivos_CatalogoValorDocumental/Delete/5
        [HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            ArchivoConcentracion_ctValorDocumental archivoConcentracion_ctValorDocumental = db.ArchivoConcentracion_ctValorDocumental.Find(id);
            db.ArchivoConcentracion_ctValorDocumental.Remove(archivoConcentracion_ctValorDocumental);
            string msj = "El registro ha sido eliminado existosamente!";
            if (ModelState.IsValid)
            {

                try
                {
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
