﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.IO;
using System.Linq;
using System.Net;
using System.Transactions;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

using Dapper;

namespace Nova.Controllers.SistemaArchivos.Catalogos
{
    public class SistemaArchivos_CatalogoFojasController :  BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: SistemaArchivos_CatalogoTipoArchivo
        public ActionResult Index()
        {
            return View(db.ArchivoConcentracion_ctFojas.OrderByDescending(x=> x.IdFojas).ToList());
        }

        // GET: SistemaArchivos_CatalogoTipoArchivo/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ArchivoConcentracion_ctFojas archivoconcentracion_ctFojas = db.ArchivoConcentracion_ctFojas.Find(id);
            if (archivoconcentracion_ctFojas == null)
            {
                return HttpNotFound();
            }
            return View(archivoconcentracion_ctFojas);
        }

        // GET: SistemaArchivos_CatalogoTipoArchivo/Create
        public ActionResult Create()
        {
           
            return PartialView();
        }

        // POST: SistemaArchivos_CatalogoTipoArchivo/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdFojas,Fojas")] ArchivoConcentracion_ctFojas archivoconcentracion_ctFojas)
        {



           

            if (ModelState.IsValid)
            {

                var RegistrosRepetidos = db.ArchivoConcentracion_ctFojas.Where(g => g.IdFojas == archivoconcentracion_ctFojas.IdFojas).ToArray();
                int valor = RegistrosRepetidos.Count();
                if (valor > 0)
                {


                    return Json(new { Valid = false, Message = "Ya existe un  archivo igual " });
                }

                else
                {

                    try
                    {
                                                   
                            db.ArchivoConcentracion_ctFojas.Add(archivoconcentracion_ctFojas);
                            db.SaveChanges();

                            return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                        
                    }
                    catch (Exception e)
                    {

                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    }


                    return JsonView(ModelState.IsValid, "El archivo no fue agregado satisfactoriamente");
                }



            }

            //ViewBag.IdTipoAnexoDocumento = new SelectList(db.Oficialia_ctTipoAnexoDocumento, "IdTipoAnexoDocumento", "TipoAnexoDocumento", oficialia_stAnexoDocumentoSalida.IdTipoAnexoDocumento);
            return JsonView(ModelState.IsValid, "El archivo se agregado satisfactoriamente");


        }


        // GET: SistemaArchivos_CatalogoTipoArchivo/Edit/5
        public ActionResult Edit(int id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ArchivoConcentracion_ctFojas archivoconcentracion_ctFojas = db.ArchivoConcentracion_ctFojas.Find(id);
            if (archivoconcentracion_ctFojas == null)
            {
                return HttpNotFound();
            }
            return View(archivoconcentracion_ctFojas);
        }

        // POST: SistemaArchivos_CatalogoTipoArchivo/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdFojas,Fojas")] ArchivoConcentracion_ctFojas archivoconcentracion_ctFojas)
        {
           

            if (ModelState.IsValid)
            {

                try
                {

                    
                        db.Entry(archivoconcentracion_ctFojas).State = EntityState.Modified;
                        db.SaveChanges();

                        return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                    


                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
               
            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // GET: SistemaArchivos_CatalogoTipoArchivo/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ArchivoConcentracion_ctFojas archivoconcentracion_ctFojas = db.ArchivoConcentracion_ctFojas.Find(id);
            if (archivoconcentracion_ctFojas == null)
            {
                return HttpNotFound();
            }
            return View(archivoconcentracion_ctFojas);
        }

        // POST: SistemaArchivos_CatalogoTipoArchivo/Delete/5
        [HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            ArchivoConcentracion_ctFojas archivoconcentracion_ctFojas = db.ArchivoConcentracion_ctFojas.Find(id);
            db.ArchivoConcentracion_ctFojas.Remove(archivoconcentracion_ctFojas);
            string msj = "El registro ha sido eliminado existosamente!";
            if (ModelState.IsValid)
            {

                try
                {
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
