﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.IO;
using System.Linq;
using System.Net;
using System.Transactions;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

using Dapper;

namespace Nova.Controllers.SistemaArchivos.Catalogos
{
    public class SistemaArchivos_CatalogoEstatusController :  BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: SistemaArchivos_CatalogoEstatus
        public ActionResult Index()
        {
            return View(db.ArchivoConcentracion_ctEstatus.OrderByDescending(x=> x.IdEstatus).ToList());
        }

        // GET: SistemaArchivos_CatalogoEstatus/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ArchivoConcentracion_ctEstatus archivoConcentracion_ctEstatus = db.ArchivoConcentracion_ctEstatus.Find(id);
            if (archivoConcentracion_ctEstatus == null)
            {
                return HttpNotFound();
            }
            return View(archivoConcentracion_ctEstatus);
        }

        // GET: SistemaArchivos_CatalogoEstatus/Create
        public ActionResult Create()
        {
           
            return PartialView();
        }

        // POST: SistemaArchivos_CatalogoEstatus/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdEstatus,Estatus")] ArchivoConcentracion_ctEstatus archivoConcentracion_ctEstatus)
        {



           

            if (ModelState.IsValid)
            {

                var RegistrosRepetidos = db.ArchivoConcentracion_ctEstatus.Where(g => g.IdEstatus == archivoConcentracion_ctEstatus.IdEstatus).ToArray();
                int valor = RegistrosRepetidos.Count();
                if (valor > 0)
                {


                    return Json(new { Valid = false, Message = "Ya existe un  archivo igual " });
                }

                else
                {

                    try
                    {
                                                   
                            db.ArchivoConcentracion_ctEstatus.Add(archivoConcentracion_ctEstatus);
                            db.SaveChanges();

                            return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                        
                    }
                    catch (Exception e)
                    {

                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    }


                    return JsonView(ModelState.IsValid, "El archivo no fue agregado satisfactoriamente");
                }



            }

            //ViewBag.IdTipoAnexoDocumento = new SelectList(db.Oficialia_ctTipoAnexoDocumento, "IdTipoAnexoDocumento", "TipoAnexoDocumento", oficialia_stAnexoDocumentoSalida.IdTipoAnexoDocumento);
            return JsonView(ModelState.IsValid, "El archivo se agregado satisfactoriamente");


        }


        // GET: SistemaArchivos_CatalogoEstatus/Edit/5
        public ActionResult Edit(int id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ArchivoConcentracion_ctEstatus archivoConcentracion_ctEstatus = db.ArchivoConcentracion_ctEstatus.Find(id);
            if (archivoConcentracion_ctEstatus == null)
            {
                return HttpNotFound();
            }
            return View(archivoConcentracion_ctEstatus);
        }

        // POST: SistemaArchivos_CatalogoEstatus/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdEstatus,Estatus")] ArchivoConcentracion_ctEstatus archivoConcentracion_ctEstatus)
        {
           

            if (ModelState.IsValid)
            {

                try
                {

                    
                        db.Entry(archivoConcentracion_ctEstatus).State = EntityState.Modified;
                        db.SaveChanges();

                        return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                    


                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
               
            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // GET: KardexGradoAcademico/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ArchivoConcentracion_ctEstatus archivoConcentracion_ctEstatus = db.ArchivoConcentracion_ctEstatus.Find(id);
            if (archivoConcentracion_ctEstatus == null)
            {
                return HttpNotFound();
            }
            return View(archivoConcentracion_ctEstatus);
        }

        // POST: KardexGradoAcademico/Delete/5
        [HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            ArchivoConcentracion_ctEstatus archivoConcentracion_ctEstatus = db.ArchivoConcentracion_ctEstatus.Find(id);
            db.ArchivoConcentracion_ctEstatus.Remove(archivoConcentracion_ctEstatus);
            string msj = "El registro ha sido eliminado existosamente!";
            if (ModelState.IsValid)
            {

                try
                {
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
