﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.IO;
using System.Linq;
using System.Net;
using System.Transactions;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

using Dapper;

namespace Nova.Controllers.SistemaArchivos.Catalogos
{
    public class SistemaArchivos_CatalogoDestinoFinalController :  BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: SistemaArchivos_CatalogoDestinoFinal
        public ActionResult Index()
        {
            return View(db.ArchivoConcentracion_ctDestinoFinal.OrderByDescending(x=> x.IdDestinoFinal).ToList());
        }

        // GET: SistemaArchivos_CatalogoDestinoFinal/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ArchivoConcentracion_ctDestinoFinal archivoConcentracion_ctDestinoFinal = db.ArchivoConcentracion_ctDestinoFinal.Find(id);
            if (archivoConcentracion_ctDestinoFinal == null)
            {
                return HttpNotFound();
            }
            return View(archivoConcentracion_ctDestinoFinal);
        }

        // GET: SistemaArchivos_CatalogoDestinoFinal/Create
        public ActionResult Create()
        {
           
            return PartialView();
        }

        // POST: SistemaArchivos_CatalogoDestinoFinal/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdDestinoFinal,DestinoFinal")] ArchivoConcentracion_ctDestinoFinal archivoConcentracion_ctDestinoFinal)
        {



           

            if (ModelState.IsValid)
            {

                var RegistrosRepetidos = db.ArchivoConcentracion_ctDestinoFinal.Where(g => g.IdDestinoFinal == archivoConcentracion_ctDestinoFinal.IdDestinoFinal).ToArray();
                int valor = RegistrosRepetidos.Count();
                if (valor > 0)
                {


                    return Json(new { Valid = false, Message = "Ya existe un  archivo igual " });
                }

                else
                {

                    try
                    {
                                                   
                            db.ArchivoConcentracion_ctDestinoFinal.Add(archivoConcentracion_ctDestinoFinal);
                            db.SaveChanges();

                            return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                        
                    }
                    catch (Exception e)
                    {

                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    }


                    return JsonView(ModelState.IsValid, "El archivo no fue agregado satisfactoriamente");
                }



            }

            //ViewBag.IdTipoAnexoDocumento = new SelectList(db.Oficialia_ctTipoAnexoDocumento, "IdTipoAnexoDocumento", "TipoAnexoDocumento", oficialia_stAnexoDocumentoSalida.IdTipoAnexoDocumento);
            return JsonView(ModelState.IsValid, "El archivo se agregado satisfactoriamente");


        }


        // GET: SistemaArchivos_CatalogoDestinoFinal/Edit/5
        public ActionResult Edit(int id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ArchivoConcentracion_ctDestinoFinal archivoConcentracion_ctTipoArchivo = db.ArchivoConcentracion_ctDestinoFinal.Find(id);
            if (archivoConcentracion_ctTipoArchivo == null)
            {
                return HttpNotFound();
            }
            return View(archivoConcentracion_ctTipoArchivo);
        }

        // POST: SistemaArchivos_CatalogoDestinoFinal/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdDestinoFinal,DestinoFinal")] ArchivoConcentracion_ctDestinoFinal archivoConcentracion_ctTipoArchivo)
        {
           

            if (ModelState.IsValid)
            {

                try
                {

                    
                        db.Entry(archivoConcentracion_ctTipoArchivo).State = EntityState.Modified;
                        db.SaveChanges();

                        return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                    


                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
               
            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // GET: SistemaArchivos_CatalogoDestinoFinal/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ArchivoConcentracion_ctDestinoFinal archivoConcentracion_ctTipoArchivo = db.ArchivoConcentracion_ctDestinoFinal.Find(id);
            if (archivoConcentracion_ctTipoArchivo == null)
            {
                return HttpNotFound();
            }
            return View(archivoConcentracion_ctTipoArchivo);
        }

        // POST: SistemaArchivos_CatalogoDestinoFinal/Delete/5
        [HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            ArchivoConcentracion_ctDestinoFinal archivoConcentracion_ctTipoArchivo = db.ArchivoConcentracion_ctDestinoFinal.Find(id);
            db.ArchivoConcentracion_ctDestinoFinal.Remove(archivoConcentracion_ctTipoArchivo);
            string msj = "El registro ha sido eliminado existosamente!";
            if (ModelState.IsValid)
            {

                try
                {
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
