﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.IO;
using System.Linq;
using System.Net;
using System.Transactions;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

using Dapper;
using Seguridad;
using Nova.Models.Kardex;
using DevExpress.Xpo.Helpers;
using Rotativa;
using System.Web.Razor.Parser.SyntaxTree;

namespace Nova.Controllers.SistemaArchivos.Catalogos
{
    public class SistemaArchivos_DocumentalTramiteController :  BaseController
    {
        int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
        private bdNovaEntities db = new bdNovaEntities();
       

        string query = @"select a.IdArchivoDocumental,b.IdKardexResponsableEstructuraSeccion,a.ClaveExpediente, a.Contenido, a.FechaElaboracion, a.FechaUltimaModificacion, a.FechaValidacion,a.Anio, h.EstructuraOrganica
                        , h.Direccion,a.UbicacionTopografica,a.Observaciones
                        , j.Nombre as NombreResponsable, j.ApellidoPaterno as ApellidoPaternoResponsable, j.ApellidoMaterno as ApellidoMaternoResponsable
                        ,b.Seccion, b.NombreSeccion, b.Serie, b.NombreSerie, b.Subserie, b.NombreSubserie, b.ValosDocumental_Administrativo, b.ValosDocumental_Legal, b.ValosDocumental_Fiscal
                        , b.Clasificacion_Publica, b.Clasificacion_Reservada, b.Clasificacion_Confidencial, b.VigenciaDoc_Tramite, b.VigenciaDoc_Concentrado, b.EsVigente, 
                        b.Anio, c.Caja,
                        d.Nombre as NombreCreador, d.ApellidoPaterno as ApellidoPaternoCreador, d.ApellidoMaterno as ApellidoMaternoCreador
                        , j.Nombre as NombreActualizo, j.ApellidoPaterno as ApellidoPaternoActualizo, j.ApellidoMaterno as ApellidoMaternoActualizo
                        ,g.Estatus,a.Medida,a.Capacidad
                        ,k.Nombre as NombreElaboro, k.ApellidoPaterno as ApellidoPaternoElaboro, k.ApellidoMaterno as ApellidoMaternoElaboro,a.IdKardexElaboro,a.NumeroProgresivo
                        
                        ,x1.NumTransferencia,x.NumeroFojas,x.FechaApertura,x.FechaCierre,x .Orden
						,x1.Transferencia,x2.DestinoFinal,x3.Fojas,x4.Caja as CajaInventario ,x5.Anaqueles,x6.ValorSecundario
						,x.FechaTerminoVigencia,x.DescripcionExpediente,x.FechaDictamen,x.FechaActa,x.FechaBaja, x.FechaHistorico,x.FechaConcentracion
                         from ArchivoConcentracion_ptArchivoDocumental a
                        
                        inner join ArchivoConcentracion_ptEstructuraOrganicaSeccionResponsable b on a.IdEstructuraOrganicaSeccionResponsable = b.IdEstructuraOrganicaSeccionResponsable
                        inner join Catalogos_ctEstructuraOrganica h on b.IdEstructuraOrganica = h.IdEstructuraOrganica
                        inner join ArchivoConcentracion_ctCajas c on a.IdCaja = c.IdCaja
                        inner join Kardex_ctDatosPersonales d on a.IdKardexCreador = d.IdKardex
                        inner join Kardex_ctDatosPersonales f on a.IdKardexActualizo = f.IdKardex
                        inner join Kardex_ctDatosPersonales k on a.IdKardexElaboro = k.IdKardex
                        inner join Kardex_ctDatosPersonales j on b.IdKardexResponsableEstructuraSeccion = j.IdKardex
                        inner join ArchivoConcentracion_ctEstatus g on a.IdEstatus = g.IdEstatus
                        left join ArchivoConcentracion_ptInventarioDocumental x on a.IdArchivoDocumental = x.IdArchivoDocumental
						 left join ArchivoConcentracion_ctTransferencia x1 on x1.IdTransferencia = x.IdTransferencia
						  left join ArchivoConcentracion_ctDestinoFinal x2 on x2.IdDestinoFinal = x.IdDestinoFinal
						 left join ArchivoConcentracion_ctFojas x3 on x3.IdFojas = x.IdFojas
						 left join ArchivoConcentracion_ctCajas x4 on x4.IdCaja = x.IdCaja
						  left join ArchivoConcentracion_ctAnaqueles x5 on x5.IdAnaqueles = x.IdAnaquel
						  left join ArchivoConcentracion_ctValorSecundario x6 on x6.IdValorSecundario = x.IdValorSecundario
                         where b.IdKardexResponsableEstructuraSeccion = @IdKardex {0}
                        order by a.NumeroProgresivo, a.IdArchivoDocumental asc ";
        string queryordenar = @"select a.IdArchivoDocumental,b.IdKardexResponsableEstructuraSeccion,b.Seccion,b.Serie,a.ClaveExpediente, a.Contenido, 
                        b.Anio, g.Estatus, a.NumeroProgresivo                       
                         from ArchivoConcentracion_ptArchivoDocumental a                        
                        inner join ArchivoConcentracion_ptEstructuraOrganicaSeccionResponsable b on a.IdEstructuraOrganicaSeccionResponsable = b.IdEstructuraOrganicaSeccionResponsable
                        inner join Catalogos_ctEstructuraOrganica h on b.IdEstructuraOrganica = h.IdEstructuraOrganica
                        inner join ArchivoConcentracion_ctCajas c on a.IdCaja = c.IdCaja inner join ArchivoConcentracion_ctEstatus g on a.IdEstatus = g.IdEstatus
                        where b.IdKardexResponsableEstructuraSeccion =  @IdKardex and g.Estatus='Trámite'
                        order by a.NumeroProgresivo,  a.IdArchivoDocumental asc";
        





        // GET: SistemaArchivos_CatalogoVigenciaDocumental
        public ActionResult Index(int? idEstatus)
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            //int IdKardex = 252;

			ViewBag.IdEstatus = new SelectList(db.ArchivoConcentracion_ctEstatus, "IdEstatus", "Estatus", idEstatus);
			Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

			// Agregar condición si hay estatus seleccionado
			string filtroEstatus = "";
			if (idEstatus.HasValue)
			{
				filtroEstatus = "AND g.IdEstatus = @IdEstatus";
			}

			query = string.Format(query, filtroEstatus);

			var datosArchivos = dp.connection.Query<DatosArchivos>(query, new { IdKardex, IdEstatus = idEstatus }).ToList();

			//var datosArchivos = (List<DatosArchivos>)dp.connection.Query<DatosArchivos>(query, new { IdKardex });
            dp.Close();

            return View(datosArchivos.ToList());  // Ordenar por IdVigenciaDocumental de forma descendente

            

        }

		public ActionResult Ordenamiento()
		{
			int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
			//int IdKardex = 252;
			Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

			var datosArchivos = (List<DatosArchivos>)dp.connection.Query<DatosArchivos>(queryordenar, new { IdKardex });
			dp.Close();

			return View(datosArchivos.ToList());  // Ordenar por IdVigenciaDocumental de forma descendente



		}


		[HttpPost]
		public ActionResult GuardarValores(List<ValorArchivoDTO> Valores)
		{
			foreach (var item in Valores)
			{
				var registro = db.ArchivoConcentracion_ptArchivoDocumental
								 .FirstOrDefault(a => a.IdArchivoDocumental == item.Id);
				if (registro != null)
				{
					registro.NumeroProgresivo = item.Valor;
				}
			}

			db.SaveChanges();
			return RedirectToAction("Index");
		}


		public ActionResult ReporteArchivosTramitePdf()
        {
            int? idEstatus = db.ArchivoConcentracion_ctEstatus.Where(a=> a.Estatus == "Trámite").FirstOrDefault().IdEstatus;
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
        
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            //int IdKardex = 252;
			// Agregar condición si hay estatus seleccionado
			string filtroEstatus = "";
			if (idEstatus.HasValue)
			{
				filtroEstatus = "AND g.IdEstatus = @IdEstatus";
			}

			query = string.Format(query, filtroEstatus);

			var result = (List<DatosArchivos>)dp.connection.Query<DatosArchivos>(query, new { IdKardex, IdEstatus = idEstatus });

	

			dp.Close();

            string modalidad = "ReporteArchivosTramite" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;
            

            ////return View("IncidenciasporAplicar", result.ToList());
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

    
        }


		public ActionResult ReporteArchivosConcentracionPdf()
		{
			int? idEstatus = db.ArchivoConcentracion_ctEstatus.Where(a => a.Estatus == "Concentración").FirstOrDefault().IdEstatus;
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
			ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
			ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

			Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
			//int IdKardex = 252;
			// Agregar condición si hay estatus seleccionado
			string filtroEstatus = "";
			if (idEstatus.HasValue)
			{
				filtroEstatus = "AND g.IdEstatus = @IdEstatus";
			}

			query = string.Format(query, filtroEstatus);

			var result = (List<DatosArchivos>)dp.connection.Query<DatosArchivos>(query, new { IdKardex, IdEstatus = idEstatus });



			dp.Close();

			string modalidad = "ReporteArchivosConcentracion" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";


			Rotativa.Options.Margins m = new Rotativa.Options.Margins();
			m.Bottom = 0;
			m.Left = 4;
			m.Right = 4;
			m.Top = 7;


			////return View("IncidenciasporAplicar", result.ToList());
			return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };


		}



		public ActionResult ReporteArchivosHistoricoPdf()
		{
			int? idEstatus = db.ArchivoConcentracion_ctEstatus.Where(a => a.Estatus == "Histórico").FirstOrDefault().IdEstatus;
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
			ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
			ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

			Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
			//int IdKardex = 252;
			// Agregar condición si hay estatus seleccionado
			string filtroEstatus = "";
			if (idEstatus.HasValue)
			{
				filtroEstatus = "AND g.IdEstatus = @IdEstatus";
			}

			query = string.Format(query, filtroEstatus);

			var result = (List<DatosArchivos>)dp.connection.Query<DatosArchivos>(query, new { IdKardex, IdEstatus = idEstatus });



			dp.Close();

			string modalidad = "ReporteArchivosHistorico" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";


			Rotativa.Options.Margins m = new Rotativa.Options.Margins();
			m.Bottom = 0;
			m.Left = 4;
			m.Right = 4;
			m.Top = 7;


			////return View("IncidenciasporAplicar", result.ToList());
			return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };


		}

		public ActionResult ReporteArchivosBajaPdf()
		{
			int? idEstatus = db.ArchivoConcentracion_ctEstatus.Where(a => a.Estatus == "Baja").FirstOrDefault().IdEstatus;
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
			ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
			ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

			Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
			//int IdKardex = 252;
			// Agregar condición si hay estatus seleccionado
			string filtroEstatus = "";
			if (idEstatus.HasValue)
			{
				filtroEstatus = "AND g.IdEstatus = @IdEstatus";
			}

			query = string.Format(query, filtroEstatus);

			var result = (List<DatosArchivos>)dp.connection.Query<DatosArchivos>(query, new { IdKardex, IdEstatus = idEstatus });



			dp.Close();

			string modalidad = "ReporteArchivosBaja" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";


			Rotativa.Options.Margins m = new Rotativa.Options.Margins();
			m.Bottom = 0;
			m.Left = 4;
			m.Right = 4;
			m.Top = 7;


			////return View("IncidenciasporAplicar", result.ToList());
			return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };


		}


		// GET: SistemaArchivos_CatalogoVigenciaDocumental/Details/5
		public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ArchivoConcentracion_ptArchivoDocumental archivoconcentracion_ptArchivoDocumental = db.ArchivoConcentracion_ptArchivoDocumental.Find(id);
            if (archivoconcentracion_ptArchivoDocumental == null)
            {
                return HttpNotFound();
            }
            return View(archivoconcentracion_ptArchivoDocumental);
        }

        // GET: SistemaArchivos_CatalogoVigenciaDocumental/Create
        public ActionResult Create()
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            var IdEstructuraOrgResp = db.ArchivoConcentracion_ptEstructuraOrganicaSeccionResponsable.Where(a => a.IdKardexResponsableEstructuraSeccion == IdKardex).ToList();

            // Supón que "nombres" es tu lista original
            var nombres = db.vwDatosAspirantesTrabajadores
                                .Where(e => e.EstatusTrabajador == "ALTA" && e.IdModalidadEstudio == 0)
                                .ToList();
            var nombrecompleto = nombres.Select(n => new
            {
                IdKardexElaboro = n.IdKardex,
                NombreCompleto = n.Nombre + " " + n.ApellidoPaterno + " " + n.ApellidoMaterno   // Concatenar NombreCompleto y Apellido
            }).ToList();

            // Concatenar los campos NombreCompleto y Apellido
            var IdEstructuraOrganicaResp = IdEstructuraOrgResp.Select(n => new
            {
                IdEstructuraOrganicaSeccionResponsable = n.IdEstructuraOrganicaSeccionResponsable,
                SeccionSerie = n.Serie + " " + n.NombreSerie + " / " + n.Anio  // Concatenar NombreCompleto y Apellido
            }).ToList();

            // Crear el SelectList con la propiedad concatenada
            ViewBag.IdEstructuraOrganicaSeccionResponsable = new SelectList(IdEstructuraOrganicaResp, "IdEstructuraOrganicaSeccionResponsable", "SeccionSerie");
            ViewBag.IdKardexElaboro = new SelectList(nombrecompleto, "IdKardexElaboro", "NombreCompleto");
            ViewBag.IdCaja = new SelectList(db.ArchivoConcentracion_ctCajas, "IdCaja", "Caja");
            
        
            return PartialView();
        }

        // POST: SistemaArchivos_CatalogoVigenciaDocumental/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdArchivoDocumental, IdEstructuraOrganicaSeccionResponsable, ClaveExpediente, Contenido, IdCaja, IdKardexCreador, FechaElaboracion, FechaUltimaModificacion, FechaValidacion, IdKardexActualizo, Anio, IdEstatus,UbicacionTopografica,Observaciones,Validado,IdKardexElaboro,Medida, Capacidad")] ArchivoConcentracion_ptArchivoDocumental archivoconcentracion_ptArchivoDocumental)
        {

            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            ArchivoConcentracion_ptArchivoDocumental ptArchivoDocumental = new ArchivoConcentracion_ptArchivoDocumental();
            ArchivoConcentracion_ptArchivoDocumentalHistoriales ptArchivoDocumentalHistorial = new ArchivoConcentracion_ptArchivoDocumentalHistoriales();
            int IdEstatus = db.ArchivoConcentracion_ctEstatus.Where(x => x.Estatus == "Trámite").FirstOrDefault().IdEstatus;
            var existe = db.ArchivoConcentracion_ptArchivoDocumental.Where(s => s.ClaveExpediente == archivoconcentracion_ptArchivoDocumental.ClaveExpediente && s.Contenido == archivoconcentracion_ptArchivoDocumental.Contenido && s.Anio == archivoconcentracion_ptArchivoDocumental.Anio).ToList();

            if (ModelState.IsValid)
            {

                var RegistrosRepetidos = db.ArchivoConcentracion_ptArchivoDocumental.Where(g => g.IdArchivoDocumental == archivoconcentracion_ptArchivoDocumental.IdArchivoDocumental).ToArray();
                int valor = RegistrosRepetidos.Count();
                if (valor > 0)
                {


                    return Json(new { Valid = false, Message = "Ya existe un  archivo igual " });
                }

                else
                {

                    try
                    {
                        
                            using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                            {

                                ptArchivoDocumental.IdEstructuraOrganicaSeccionResponsable = archivoconcentracion_ptArchivoDocumental.IdEstructuraOrganicaSeccionResponsable;
                                ptArchivoDocumental.ClaveExpediente = archivoconcentracion_ptArchivoDocumental.ClaveExpediente;
                                ptArchivoDocumental.Contenido = archivoconcentracion_ptArchivoDocumental.Contenido;
                                ptArchivoDocumental.IdCaja = archivoconcentracion_ptArchivoDocumental.IdCaja;
                                ptArchivoDocumental.IdKardexCreador = IdKardex;
                                ptArchivoDocumental.FechaElaboracion = DateTime.Now;
                                ptArchivoDocumental.FechaUltimaModificacion = DateTime.Now;
                                ptArchivoDocumental.IdKardexActualizo = IdKardex;
                                ptArchivoDocumental.Anio = archivoconcentracion_ptArchivoDocumental.Anio;
                                ptArchivoDocumental.IdEstatus = IdEstatus;
                                ptArchivoDocumental.UbicacionTopografica = archivoconcentracion_ptArchivoDocumental.UbicacionTopografica;
                                ptArchivoDocumental.Observaciones = archivoconcentracion_ptArchivoDocumental.Observaciones;
                                ptArchivoDocumental.IdKardexElaboro = archivoconcentracion_ptArchivoDocumental.IdKardexElaboro;
                                ptArchivoDocumental.Medida = archivoconcentracion_ptArchivoDocumental.Medida;
                            ptArchivoDocumental.Capacidad = archivoconcentracion_ptArchivoDocumental.Capacidad;
                            //ptArchivoDocumental.Validado = false;
                            db.ArchivoConcentracion_ptArchivoDocumental.Add(ptArchivoDocumental);
                                db.SaveChanges();

                                ptArchivoDocumentalHistorial.IdArchivoDocumental = ptArchivoDocumental.IdArchivoDocumental;
                                ptArchivoDocumentalHistorial.UbicacionTopografica = archivoconcentracion_ptArchivoDocumental.UbicacionTopografica;
                                ptArchivoDocumentalHistorial.Observaciones = archivoconcentracion_ptArchivoDocumental.Observaciones;                                
                                ptArchivoDocumentalHistorial.Anio = archivoconcentracion_ptArchivoDocumental.Anio;
                                ptArchivoDocumentalHistorial.IdKardexActualizo = IdKardex;
                                ptArchivoDocumentalHistorial.FechaModificacion = DateTime.Now;
                                ptArchivoDocumentalHistorial.ClaveExpediente = ptArchivoDocumental.ClaveExpediente;
                                ptArchivoDocumentalHistorial.IdEstatus = ptArchivoDocumental.IdEstatus;
                                ptArchivoDocumentalHistorial.IdKardexElaboro = archivoconcentracion_ptArchivoDocumental.IdKardexElaboro;
                                ptArchivoDocumentalHistorial.Medida = archivoconcentracion_ptArchivoDocumental.Medida;
                            ptArchivoDocumentalHistorial.Capacidad = archivoconcentracion_ptArchivoDocumental.Capacidad;
                            db.ArchivoConcentracion_ptArchivoDocumentalHistoriales.Add(ptArchivoDocumentalHistorial);
                                db.SaveChanges();

                                trans.Complete();

                            }
                           

                        
                        return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });

                    }
                    catch (Exception e)
                    {

                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    }


                    return JsonView(ModelState.IsValid, "El archivo no fue agregado satisfactoriamente");
                }



            }

            //ViewBag.IdTipoAnexoDocumento = new SelectList(db.Oficialia_ctTipoAnexoDocumento, "IdTipoAnexoDocumento", "TipoAnexoDocumento", oficialia_stAnexoDocumentoSalida.IdTipoAnexoDocumento);
            return JsonView(ModelState.IsValid, "El archivo se agregado satisfactoriamente");


        }


        // GET: SistemaArchivos_CatalogoVigenciaDocumental/Edit/5
        public ActionResult Edit(int id)
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;


            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }

            ArchivoConcentracion_ptArchivoDocumental archivoconcentracion_ptArchivoDocumental = db.ArchivoConcentracion_ptArchivoDocumental.Find(id);
            var IdEstructuraOrgResp = db.ArchivoConcentracion_ptEstructuraOrganicaSeccionResponsable.Where(a => a.IdKardexResponsableEstructuraSeccion == IdKardex).ToList();


            
            var IdEstructuraOrganicaResp = IdEstructuraOrgResp.Select(n => new
            {
                IdEstructuraOrganicaSeccionResponsable = n.IdEstructuraOrganicaSeccionResponsable,
                SeccionSerie = n.Serie + " " + n.NombreSerie   // Concatenar NombreCompleto y Apellido
            }).ToList();

            // Supón que "nombres" es tu lista original
            var nombres = db.vwDatosAspirantesTrabajadores
                                .Where(e => e.EstatusTrabajador == "ALTA" && e.IdModalidadEstudio == 0)
                                .ToList();
            var nombrecompleto = nombres.Select(n => new
            {
                IdKardexElaboro = n.IdKardex,
                NombreCompleto = n.Nombre + " " + n.ApellidoPaterno + " " + n.ApellidoMaterno   // Concatenar NombreCompleto y Apellido
            }).ToList();

            // Crear el SelectList con la propiedad concatenada
            ViewBag.IdEstructuraOrganicaSeccionResponsable = new SelectList(IdEstructuraOrganicaResp, "IdEstructuraOrganicaSeccionResponsable", "SeccionSerie", archivoconcentracion_ptArchivoDocumental.IdEstructuraOrganicaSeccionResponsable);

            ViewBag.IdKardexElaboro = new SelectList(nombrecompleto, "IdKardexElaboro", "NombreCompleto",archivoconcentracion_ptArchivoDocumental.IdKardexElaboro);
            ViewBag.IdCaja = new SelectList(db.ArchivoConcentracion_ctCajas, "IdCaja", "Caja",archivoconcentracion_ptArchivoDocumental.IdCaja);

            ViewBag.IdEstatus = new SelectList(db.ArchivoConcentracion_ctEstatus, "IdEstatus", "Estatus", archivoconcentracion_ptArchivoDocumental.IdEstatus);


            if (archivoconcentracion_ptArchivoDocumental == null)
            {
                return HttpNotFound();
            }
            return View(archivoconcentracion_ptArchivoDocumental);
        }

        // POST: SistemaArchivos_CatalogoVigenciaDocumental/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdArchivoDocumental, IdEstructuraOrganicaSeccionResponsable, ClaveExpediente, Contenido, IdCaja, IdKardexCreador, FechaElaboracion, FechaUltimaModificacion, FechaValidacion, IdKardexActualizo, Anio, IdEstatus,UbicacionTopografica,Observaciones,Validado,IdKardexElaboro,Medida, Capacidad")] ArchivoConcentracion_ptArchivoDocumental archivoconcentracion_ptArchivoDocumental)
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            //ArchivoConcentracion_ptArchivoDocumental ptArchivoDocumental = new ArchivoConcentracion_ptArchivoDocumental();
            ArchivoConcentracion_ptArchivoDocumentalHistoriales ptArchivoDocumentalHistorial = new ArchivoConcentracion_ptArchivoDocumentalHistoriales();

            if (ModelState.IsValid)
            {
                var ptArchivoDocumental = db.ArchivoConcentracion_ptArchivoDocumental
                .FirstOrDefault(x => x.IdArchivoDocumental == archivoconcentracion_ptArchivoDocumental.IdArchivoDocumental);
                try
                {
                    if (ptArchivoDocumental == null)
                    {
                        return Json(new { Valid = false, Message = "El archivo no fue encontrado en la base de datos." });
                    }
                    using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                    {
                        // Asignar los valores que se han recibido en el modelo de vista
                        ptArchivoDocumental.ClaveExpediente = archivoconcentracion_ptArchivoDocumental.ClaveExpediente;
                        ptArchivoDocumental.UbicacionTopografica = archivoconcentracion_ptArchivoDocumental.UbicacionTopografica;
                        ptArchivoDocumental.Contenido = archivoconcentracion_ptArchivoDocumental.Contenido;
                        ptArchivoDocumental.IdCaja = archivoconcentracion_ptArchivoDocumental.IdCaja;
                        ptArchivoDocumental.IdEstatus = archivoconcentracion_ptArchivoDocumental.IdEstatus;
                        ptArchivoDocumental.Anio = archivoconcentracion_ptArchivoDocumental.Anio;
                        ptArchivoDocumental.Observaciones = archivoconcentracion_ptArchivoDocumental.Observaciones;
                        ptArchivoDocumental.FechaUltimaModificacion = DateTime.Now;
                        ptArchivoDocumental.IdKardexActualizo = IdKardex;
                        ptArchivoDocumental.Validado = false; // Si este es el nuevo valor
                        ptArchivoDocumental.IdKardexElaboro = archivoconcentracion_ptArchivoDocumental.IdKardexElaboro;
                        ptArchivoDocumental.Medida = archivoconcentracion_ptArchivoDocumental.Medida;
                        ptArchivoDocumental.Capacidad = archivoconcentracion_ptArchivoDocumental.Capacidad;
                        // No es necesario usar EntityState.Modified aquí si estás modificando una entidad existente
                        // Entity Framework detectará los cambios automáticamente

                        // Guardar los cambios en la base de datos
                        db.SaveChanges();

                        ptArchivoDocumentalHistorial.IdArchivoDocumental = ptArchivoDocumental.IdArchivoDocumental;
                        ptArchivoDocumentalHistorial.UbicacionTopografica = archivoconcentracion_ptArchivoDocumental.UbicacionTopografica;
                        ptArchivoDocumentalHistorial.Observaciones = archivoconcentracion_ptArchivoDocumental.Observaciones;
                        ptArchivoDocumentalHistorial.Anio = archivoconcentracion_ptArchivoDocumental.Anio;
                        ptArchivoDocumentalHistorial.IdKardexActualizo = IdKardex;
                        ptArchivoDocumentalHistorial.FechaModificacion = DateTime.Now;
                        ptArchivoDocumentalHistorial.ClaveExpediente = ptArchivoDocumental.ClaveExpediente;
                        ptArchivoDocumentalHistorial.IdEstatus = ptArchivoDocumental.IdEstatus;
                        ptArchivoDocumentalHistorial.IdKardexElaboro = archivoconcentracion_ptArchivoDocumental.IdKardexElaboro;
                        ptArchivoDocumentalHistorial.Medida = archivoconcentracion_ptArchivoDocumental.Medida;
                        ptArchivoDocumentalHistorial.Capacidad = archivoconcentracion_ptArchivoDocumental.Capacidad;
                        db.ArchivoConcentracion_ptArchivoDocumentalHistoriales.Add(ptArchivoDocumentalHistorial);
                        db.SaveChanges();
                        trans.Complete();
                    }
                    return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                    


                    
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
               
            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // GET: SistemaArchivos_CatalogoVigenciaDocumental/Edit/5
        public ActionResult EditTransferencia(int id)
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;

            var concatenado = (from a in db.ArchivoConcentracion_ptArchivoDocumental
                               join b in db.ArchivoConcentracion_ptEstructuraOrganicaSeccionResponsable
                                 on a.IdEstructuraOrganicaSeccionResponsable equals b.IdEstructuraOrganicaSeccionResponsable
                               where a.IdArchivoDocumental == id // o el filtro que quieras
                               select b.Seccion + " " + b.Serie + " " + a.ClaveExpediente)
                .FirstOrDefault();

            ViewBag.CadenaConcatenada = concatenado ?? "";
            var resultado = from a in db.ArchivoConcentracion_ptArchivoDocumental
                            join b in db.ArchivoConcentracion_ptEstructuraOrganicaSeccionResponsable
                              on a.IdEstructuraOrganicaSeccionResponsable equals b.IdEstructuraOrganicaSeccionResponsable
                            join c in db.ArchivoConcentracion_ctEstatus
                            on a.IdEstatus equals c.IdEstatus
                            where a.IdArchivoDocumental == id  // filtro aquí
                            select new
                            {
                                a.IdArchivoDocumental,
                                b.IdKardexResponsableEstructuraSeccion,
                                a.ClaveExpediente,
                                a.Contenido,
                                b.Seccion,
                                b.NombreSeccion,
                                b.Serie,
                                b.NombreSerie,
                                b.Subserie,
                                b.NombreSubserie,
                                c.IdEstatus,
                                c.Estatus,
                                Concatenado = b.Seccion + " " + b.Serie + " " + a.ClaveExpediente
                            };


            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }

            ArchivoConcentracion_ptInventarioDocumental archivoconcentracion_ptArchivoDocumental = db.ArchivoConcentracion_ptInventarioDocumental.Where(a => a.IdArchivoDocumental == id).FirstOrDefault();



            ViewBag.IdCaja = new SelectList(db.ArchivoConcentracion_ctCajas, "IdCaja", "Caja", archivoconcentracion_ptArchivoDocumental.IdCaja);

            ViewBag.IdFojas = new SelectList(db.ArchivoConcentracion_ctFojas, "IdFojas", "Fojas", archivoconcentracion_ptArchivoDocumental.IdFojas);
            ViewBag.IdTransferencia = new SelectList(db.ArchivoConcentracion_ctTransferencia, "IdTransferencia", "Transferencia", archivoconcentracion_ptArchivoDocumental.IdTransferencia);
            ViewBag.IdValorSecundario = new SelectList(db.ArchivoConcentracion_ctValorSecundario, "IdValorSecundario", "ValorSecundario", archivoconcentracion_ptArchivoDocumental.IdValorSecundario);

            ViewBag.IdDestinoFinal = new SelectList(db.ArchivoConcentracion_ctDestinoFinal, "IdDestinoFinal", "DestinoFinal", archivoconcentracion_ptArchivoDocumental.IdDestinoFinal);
            ViewBag.DestinoFinal = db.ArchivoConcentracion_ctDestinoFinal.Where(b => b.IdDestinoFinal == archivoconcentracion_ptArchivoDocumental.IdDestinoFinal).FirstOrDefault().DestinoFinal;
            ViewBag.IdArchivoDocumental = id;

            ViewBag.IdEstatus = new SelectList(db.ArchivoConcentracion_ctEstatus, "IdEstatus", "Estatus", archivoconcentracion_ptArchivoDocumental.IdEstatus);
            ViewBag.IdEstatus = resultado.FirstOrDefault().IdEstatus;
            ViewBag.Estatus = resultado.FirstOrDefault().Estatus;
            ViewBag.ClaveExpediente = resultado.FirstOrDefault().Concatenado;
            //ViewBag.ClaveExpediente = db.ArchivoConcentracion_ptArchivoDocumental.Where(a => a.IdArchivoDocumental == id).FirstOrDefault().ClaveExpediente;
            ViewBag.Contenido = db.ArchivoConcentracion_ptArchivoDocumental.Where(a => a.IdArchivoDocumental == id).FirstOrDefault().Contenido;

            if (archivoconcentracion_ptArchivoDocumental == null)
            {
                return HttpNotFound();
            }
            return View(archivoconcentracion_ptArchivoDocumental);
        }

        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult EditTransferencia([Bind(Include = "IdInventario, IdArchivoDocumental, IdCaja, IdAnaquel, IdDestinoFinal, IdTransferencia, FechaElaboracionInventario, IdKardexResponsableInventario, FechaElaboracion, FechaValidacion, UbicacionTopografica,IdEstatus, NumeroFojas, FechaApertura, FechaCierre, Orden, FechaTerminoVigencia, DescripcionExpediente, IdFojas, IdValorSecundario, FechaDictamen, FechaActa, FechaBaja, FechaHistorico, FechaConcentracion")] ArchivoConcentracion_ptInventarioDocumental archivoconcentracion_ptInventarioDocumental)
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            //ArchivoConcentracion_ptArchivoDocumental ptArchivoDocumental = new ArchivoConcentracion_ptArchivoDocumental();


            if (ModelState.IsValid)
            {
                var ptInventarioDocumental = db.ArchivoConcentracion_ptInventarioDocumental
                .FirstOrDefault(x => x.IdArchivoDocumental == archivoconcentracion_ptInventarioDocumental.IdArchivoDocumental);
                try
                {
                    if (ptInventarioDocumental == null)
                    {
                        return Json(new { Valid = false, Message = "El archivo no fue encontrado en la base de datos." });
                    }
                    using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                    {

                        // Asignar los valores que se han recibido en el modelo de vista
                        ptInventarioDocumental.IdCaja = archivoconcentracion_ptInventarioDocumental.IdCaja;
                        ptInventarioDocumental.IdAnaquel = archivoconcentracion_ptInventarioDocumental.IdAnaquel;
                        //ptInventarioDocumental.IdDestinoFinal = archivoconcentracion_ptInventarioDocumental.IdDestinoFinal;
                        ptInventarioDocumental.IdTransferencia = archivoconcentracion_ptInventarioDocumental.IdTransferencia;
                        ptInventarioDocumental.FechaElaboracionInventario = archivoconcentracion_ptInventarioDocumental.FechaElaboracionInventario;
                        ptInventarioDocumental.IdKardexResponsableInventario = archivoconcentracion_ptInventarioDocumental.IdKardexResponsableInventario;
                        ptInventarioDocumental.FechaElaboracion = archivoconcentracion_ptInventarioDocumental.FechaElaboracion;
                        ptInventarioDocumental.FechaValidacion = archivoconcentracion_ptInventarioDocumental.FechaValidacion;
                        ptInventarioDocumental.UbicacionTopografica = archivoconcentracion_ptInventarioDocumental.UbicacionTopografica;
                        ptInventarioDocumental.IdEstatus = archivoconcentracion_ptInventarioDocumental.IdEstatus; // Si este es el nuevo valor
                        ptInventarioDocumental.NumeroFojas = archivoconcentracion_ptInventarioDocumental.NumeroFojas;
                        ptInventarioDocumental.FechaApertura = archivoconcentracion_ptInventarioDocumental.FechaApertura;
                        ptInventarioDocumental.FechaCierre = archivoconcentracion_ptInventarioDocumental.FechaCierre;

                        ptInventarioDocumental.Orden = archivoconcentracion_ptInventarioDocumental.Orden;
                        ptInventarioDocumental.FechaTerminoVigencia = archivoconcentracion_ptInventarioDocumental.FechaTerminoVigencia;
                        ptInventarioDocumental.DescripcionExpediente = archivoconcentracion_ptInventarioDocumental.DescripcionExpediente;
                        ptInventarioDocumental.IdFojas = archivoconcentracion_ptInventarioDocumental.IdFojas;
                        ptInventarioDocumental.IdValorSecundario = archivoconcentracion_ptInventarioDocumental.IdValorSecundario; // Si este es el nuevo valor
                        if (archivoconcentracion_ptInventarioDocumental.FechaDictamen.HasValue)
                        {
                            ptInventarioDocumental.FechaDictamen = archivoconcentracion_ptInventarioDocumental.FechaDictamen;
                        }
                        if (archivoconcentracion_ptInventarioDocumental.FechaActa.HasValue)
                        {
                            ptInventarioDocumental.FechaActa = archivoconcentracion_ptInventarioDocumental.FechaActa;
                        }
                        if (archivoconcentracion_ptInventarioDocumental.FechaBaja.HasValue)
                        {
                            ptInventarioDocumental.FechaBaja = archivoconcentracion_ptInventarioDocumental.FechaBaja;
                        }

                        if (archivoconcentracion_ptInventarioDocumental.FechaHistorico.HasValue)
                        {
                            ptInventarioDocumental.FechaHistorico = archivoconcentracion_ptInventarioDocumental.FechaHistorico;
                        }
                        if (archivoconcentracion_ptInventarioDocumental.FechaConcentracion.HasValue)
                        {
                            ptInventarioDocumental.FechaConcentracion = archivoconcentracion_ptInventarioDocumental.FechaConcentracion;
                        }


                        // No es necesario usar EntityState.Modified aquí si estás modificando una entidad existente
                        // Entity Framework detectará los cambios automáticamente

                        // Guardar los cambios en la base de datos
                        db.SaveChanges();


                        trans.Complete();
                    }
                    return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });






                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }






        // GET: SistemaArchivos_CatalogoVigenciaDocumental/Edit/5
        public ActionResult Transferencia(int id)
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;


            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }

            ArchivoConcentracion_ptArchivoDocumental archivoconcentracion_ptArchivoDocumental = db.ArchivoConcentracion_ptArchivoDocumental.Find(id);
            var IdEstructuraOrgResp = db.ArchivoConcentracion_ptEstructuraOrganicaSeccionResponsable.Where(a => a.IdKardexResponsableEstructuraSeccion == IdKardex).ToList();
            var concatenado = (from a in db.ArchivoConcentracion_ptArchivoDocumental
                               join b in db.ArchivoConcentracion_ptEstructuraOrganicaSeccionResponsable
                                 on a.IdEstructuraOrganicaSeccionResponsable equals b.IdEstructuraOrganicaSeccionResponsable
                               where a.IdArchivoDocumental == id // o el filtro que quieras
                               select b.Seccion + " " + b.Serie + " " + a.ClaveExpediente)
                  .FirstOrDefault();

            ViewBag.CadenaConcatenada = concatenado ?? "";
            var resultado = from a in db.ArchivoConcentracion_ptArchivoDocumental
                            join b in db.ArchivoConcentracion_ptEstructuraOrganicaSeccionResponsable
                              on a.IdEstructuraOrganicaSeccionResponsable equals b.IdEstructuraOrganicaSeccionResponsable
							join c in db.ArchivoConcentracion_ctEstatus
							on a.IdEstatus equals c.IdEstatus
							where a.IdArchivoDocumental == id  // filtro aquí
                            select new
                            {
                                a.IdArchivoDocumental,
                                b.IdKardexResponsableEstructuraSeccion,
                                a.ClaveExpediente,
                                a.Contenido,
                                b.Seccion,
                                b.NombreSeccion,
                                b.Serie,
                                b.NombreSerie,
                                b.Subserie,
                                b.NombreSubserie,
                                c.IdEstatus,
								c.Estatus,
								Concatenado = b.Seccion + " " + b.Serie + " " + a.ClaveExpediente
                            };
			ViewBag.IdEstatus = resultado.FirstOrDefault().IdEstatus;
			ViewBag.Estatus = resultado.FirstOrDefault().Estatus;
			ViewBag.ClaveExpediente = resultado.FirstOrDefault().Concatenado;
            //ViewBag.ClaveExpediente = db.ArchivoConcentracion_ptArchivoDocumental.Where(a => a.IdArchivoDocumental == id).FirstOrDefault().ClaveExpediente;
            ViewBag.Contenido = db.ArchivoConcentracion_ptArchivoDocumental.Where(a => a.IdArchivoDocumental == id).FirstOrDefault().Contenido;
            var IdEstructuraOrganicaResp = IdEstructuraOrgResp.Select(n => new
            {
                IdEstructuraOrganicaSeccionResponsable = n.IdEstructuraOrganicaSeccionResponsable,
                SeccionSerie = n.Serie + " " + n.NombreSerie   // Concatenar NombreCompleto y Apellido
            }).ToList();

            // Supón que "nombres" es tu lista original
            var nombres = db.vwDatosAspirantesTrabajadores
                                .Where(e => e.EstatusTrabajador == "ALTA" && e.IdModalidadEstudio == 0)
                                .ToList();
            var nombrecompleto = nombres.Select(n => new
            {
                IdKardexElaboro = n.IdKardex,
                NombreCompleto = n.Nombre + " " + n.ApellidoPaterno + " " + n.ApellidoMaterno   // Concatenar NombreCompleto y Apellido
            }).ToList();

            // Crear el SelectList con la propiedad concatenada
            ViewBag.IdEstructuraOrganicaSeccionResponsable = new SelectList(IdEstructuraOrganicaResp, "IdEstructuraOrganicaSeccionResponsable", "SeccionSerie", archivoconcentracion_ptArchivoDocumental.IdEstructuraOrganicaSeccionResponsable);

            ViewBag.IdKardexElaboro = new SelectList(nombrecompleto, "IdKardexElaboro", "NombreCompleto", archivoconcentracion_ptArchivoDocumental.IdKardexElaboro);
            ViewBag.IdCaja = new SelectList(db.ArchivoConcentracion_ctCajas, "IdCaja", "Caja");
			ViewBag.IdFojas = new SelectList(db.ArchivoConcentracion_ctFojas, "IdFojas", "Fojas");
			ViewBag.IdTransferencia = new SelectList(db.ArchivoConcentracion_ctTransferencia, "IdTransferencia", "Transferencia");
			ViewBag.IdValorSecundario = new SelectList(db.ArchivoConcentracion_ctValorSecundario, "IdValorSecundario", "ValorSecundario");

			ViewBag.IdDestinoFinal = new SelectList(db.ArchivoConcentracion_ctDestinoFinal, "IdDestinoFinal", "DestinoFinal");
            ViewBag.IdArchivoDocumental = id;

            if (archivoconcentracion_ptArchivoDocumental == null)
            {
                return HttpNotFound();
            }
            return View();
        }

        // POST: SistemaArchivos_CatalogoVigenciaDocumental/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
     //   [HttpPost]
     //   //[ValidateAntiForgeryToken]
     //   public ActionResult Transferencia([Bind(Include = "IdInventario, IdArchivoDocumental, IdCaja, IdAnaquel, IdDestinoFinal, NumeroTranferencia, FechaElaboracionInventario, IdKardexResponsableInventario, FechaElaboracion, FechaValidacion, UbicacionTopografica, Observaciones, IdEstatus, NumeroFojas, FechaApertura, FechaCierre, Orden, FechaTerminoVigencia, DescripcionExpediente, IdFojas")] ArchivoConcentracion_ptInventarioDocumental archivoconcentracion_ptArchivoDocumentalInventario)
     //   {
     //       int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
     //       //ArchivoConcentracion_ptArchivoDocumental ptArchivoDocumental = new ArchivoConcentracion_ptArchivoDocumental();
     //       ArchivoConcentracion_ptArchivoDocumentalHistoriales ptArchivoDocumentalHistorial = new ArchivoConcentracion_ptArchivoDocumentalHistoriales();

     //       if (ModelState.IsValid)
     //       {
     //           var ptArchivoDocumental = db.ArchivoConcentracion_ptInventarioDocumental
     //           .FirstOrDefault(x => x.IdInventario == archivoconcentracion_ptArchivoDocumentalInventario.IdInventario);
     //           try
     //           {
     //               if (ptArchivoDocumental == null)
     //               {
     //                   return Json(new { Valid = false, Message = "El archivo no fue encontrado en la base de datos." });
     //               }
     //               using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
     //               {
     //                   // Asignar los valores que se han recibido en el modelo de vista
     //                   ptArchivoDocumental.ClaveExpediente = archivoconcentracion_ptArchivoDocumentalInventario.ClaveExpediente;
     //                   ptArchivoDocumental.UbicacionTopografica = archivoconcentracion_ptArchivoDocumentalInventario.UbicacionTopografica;
     //                   ptArchivoDocumental.Contenido = archivoconcentracion_ptArchivoDocumentalInventario.Contenido;
     //                   ptArchivoDocumental.IdCaja = archivoconcentracion_ptArchivoDocumentalInventario.IdCaja;
     //                   ptArchivoDocumental.IdEstatus = archivoconcentracion_ptArchivoDocumentalInventario.IdEstatus;
     //                   ptArchivoDocumental.Anio = archivoconcentracion_ptArchivoDocumentalInventario.Anio;
     //                   ptArchivoDocumental.Observaciones = archivoconcentracion_ptArchivoDocumentalInventario.Observaciones;
     //                   ptArchivoDocumental.FechaUltimaModificacion = DateTime.Now;
     //                   ptArchivoDocumental.IdKardexActualizo = IdKardex;
     //                   ptArchivoDocumental.Validado = false; // Si este es el nuevo valor
     //                   ptArchivoDocumental.IdKardexElaboro = archivoconcentracion_ptArchivoDocumentalInventario.IdKardexElaboro;
     //                   ptArchivoDocumental.Medida = archivoconcentracion_ptArchivoDocumentalInventario.Medida;
     //                   ptArchivoDocumental.Capacidad = archivoconcentracion_ptArchivoDocumentalInventario.Capacidad;
					//	// No es necesario usar EntityState.Modified aquí si estás modificando una entidad existente
					//	// Entity Framework detectará los cambios automáticamente
					//	// Insertar el nuevo objeto al contexto
					//	db.ptArchivoDocumental.Add(nuevoArchivoDocumental);
					//	// Guardar los cambios en la base de datos
					//	db.SaveChanges();

     //                   trans.Complete();						



					//}
     //               return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });






     //           }

     //           catch (Exception e)
     //           {


     //               return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
     //           }

     //       }
     //       string messages = string.Join("; ", ModelState.Values
     //                  .SelectMany(x => x.Errors)
     //                  .Select(x => x.ErrorMessage));

     //       return JsonView(ModelState.IsValid, messages, null, null);
     //   }


		[HttpPost]
		//[ValidateAntiForgeryToken]
		public ActionResult Transferencia([Bind(Include = "IdInventario, IdArchivoDocumental, IdCaja, IdAnaquel, IdDestinoFinal, IdTransferencia, FechaElaboracionInventario, IdKardexResponsableInventario, FechaElaboracion, FechaValidacion, UbicacionTopografica, Observaciones, IdEstatus, NumeroFojas, FechaApertura, FechaCierre, Orden, FechaTerminoVigencia, DescripcionExpediente, IdFojas, IdValorSecundario, FechaDictamen, FechaActa, FechaBaja, FechaHistorico, FechaConcentracion")] ArchivoConcentracion_ptInventarioDocumental archivoconcentracion_ptArchivoDocumentalInventario,string TipoTransferencia)
		{
			 int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
			string EstatusTramite = db.ArchivoConcentracion_ctEstatus.Where(a => a.IdEstatus == archivoconcentracion_ptArchivoDocumentalInventario.IdEstatus).FirstOrDefault().Estatus;
	        int IdEstatusTramite = db.ArchivoConcentracion_ctEstatus.Where(a => a.Estatus == TipoTransferencia).FirstOrDefault().IdEstatus;
			if (ModelState.IsValid)
			{
				try
				{
					using (TransactionScope trans = new TransactionScope())
					{
                        if (EstatusTramite == "Concentración")
                        {
							var archivoExistente = db.ArchivoConcentracion_ptInventarioDocumental
	                                 .Where(x => x.IdArchivoDocumental == archivoconcentracion_ptArchivoDocumentalInventario.IdArchivoDocumental)
	                                 .FirstOrDefault();
							// También actualiza el archivo principal si es necesario
							var archivoPrincipal = db.ArchivoConcentracion_ptArchivoDocumental
								.FirstOrDefault(a => a.IdArchivoDocumental == archivoconcentracion_ptArchivoDocumentalInventario.IdArchivoDocumental);
							archivoPrincipal.IdEstatus = IdEstatusTramite;
							archivoPrincipal.FechaUltimaModificacion = DateTime.Now;
							db.SaveChanges();

							if (TipoTransferencia == "Baja")
							{
								archivoExistente.DescripcionExpediente = archivoconcentracion_ptArchivoDocumentalInventario.DescripcionExpediente;
								archivoExistente.FechaBaja = DateTime.Now;
								archivoExistente.FechaTerminoVigencia = archivoconcentracion_ptArchivoDocumentalInventario.FechaTerminoVigencia;
							}
							else if (TipoTransferencia == "Historico")
							{
								archivoExistente.IdValorSecundario = archivoconcentracion_ptArchivoDocumentalInventario.IdValorSecundario;
								archivoExistente.FechaHistorico = DateTime.Now;
							}

							db.SaveChanges();

						}
                        else {
							        string Destino = db.ArchivoConcentracion_ctDestinoFinal.Where(x => x.IdDestinoFinal == archivoconcentracion_ptArchivoDocumentalInventario.IdDestinoFinal).FirstOrDefault().DestinoFinal;
							        string Estatus = db.ArchivoConcentracion_ctEstatus.Where(a => a.Estatus == Destino).FirstOrDefault().Estatus;
							        int IdEstatus = db.ArchivoConcentracion_ctEstatus.Where(a => a.Estatus == Destino).FirstOrDefault().IdEstatus;

							        DateTime? fechaTerminovigencia = archivoconcentracion_ptArchivoDocumentalInventario.FechaTerminoVigencia;
                                    var nuevoArchivoDocumental = new ArchivoConcentracion_ptInventarioDocumental();

                                    if (EstatusTramite != "Concentracion")
                                        { 
                                        nuevoArchivoDocumental.IdArchivoDocumental = archivoconcentracion_ptArchivoDocumentalInventario.IdArchivoDocumental;
                                        nuevoArchivoDocumental.IdCaja = archivoconcentracion_ptArchivoDocumentalInventario.IdCaja;

                                        nuevoArchivoDocumental.IdDestinoFinal = archivoconcentracion_ptArchivoDocumentalInventario.IdDestinoFinal;
                                        nuevoArchivoDocumental.IdTransferencia = archivoconcentracion_ptArchivoDocumentalInventario.IdTransferencia;
                                        nuevoArchivoDocumental.FechaElaboracionInventario = DateTime.Now;
                                        nuevoArchivoDocumental.IdKardexResponsableInventario = IdKardex;
                                        nuevoArchivoDocumental.FechaElaboracion = DateTime.Now;
                                        nuevoArchivoDocumental.FechaValidacion = DateTime.Now;


                                        nuevoArchivoDocumental.IdEstatus = IdEstatus;
                                        nuevoArchivoDocumental.NumeroFojas = archivoconcentracion_ptArchivoDocumentalInventario.NumeroFojas;
                                        nuevoArchivoDocumental.FechaApertura = archivoconcentracion_ptArchivoDocumentalInventario.FechaApertura;
                                        nuevoArchivoDocumental.FechaCierre = archivoconcentracion_ptArchivoDocumentalInventario.FechaCierre;
                                        nuevoArchivoDocumental.Orden = archivoconcentracion_ptArchivoDocumentalInventario.Orden;


                        
                                        nuevoArchivoDocumental.IdFojas = archivoconcentracion_ptArchivoDocumentalInventario.IdFojas;

                     

						
						                }



						                // Asigna las fechas especiales después de crear el objeto
						                if (Estatus == "Baja") {
							                nuevoArchivoDocumental.DescripcionExpediente = archivoconcentracion_ptArchivoDocumentalInventario.DescripcionExpediente;
							                nuevoArchivoDocumental.FechaBaja = DateTime.Now;
                                        nuevoArchivoDocumental.FechaTerminoVigencia = archivoconcentracion_ptArchivoDocumentalInventario.FechaTerminoVigencia;
						                }
						                else if (Estatus == "Histórico") { 
							                nuevoArchivoDocumental.IdValorSecundario = archivoconcentracion_ptArchivoDocumentalInventario.IdValorSecundario;
						                nuevoArchivoDocumental.FechaHistorico = DateTime.Now;
						                }
						                else if (Estatus == "Concentración")
							                nuevoArchivoDocumental.FechaConcentracion = DateTime.Now;



						                db.ArchivoConcentracion_ptInventarioDocumental.Add(nuevoArchivoDocumental);
						                    db.SaveChanges();


						                // Buscar el registro que deseas actualizar
						                var archivo = db.ArchivoConcentracion_ptArchivoDocumental
							                .FirstOrDefault(a => a.IdArchivoDocumental == archivoconcentracion_ptArchivoDocumentalInventario.IdArchivoDocumental);

						                if (archivo != null)
						                {
							                // Actualizar los campos deseados
							                archivo.IdEstatus = IdEstatus;
							                archivo.FechaUltimaModificacion = DateTime.Now;

							                db.SaveChanges();
						                }
						}

						trans.Complete();
					}

					return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente." });
				}
				catch (Exception e)
				{
					return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
				}
			}

			string messages = string.Join("; ", ModelState.Values
				.SelectMany(x => x.Errors)
				.Select(x => x.ErrorMessage));

			return JsonView(false, messages, null, null);
		}


		// GET: SistemaArchivos_CatalogoVigenciaDocumental/Delete/5
		public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ArchivoConcentracion_ptArchivoDocumental archivoconcentracion_ptArchivoDocumental = db.ArchivoConcentracion_ptArchivoDocumental.Find(id);
            if (archivoconcentracion_ptArchivoDocumental == null)
            {
                return HttpNotFound();
            }
            return View(archivoconcentracion_ptArchivoDocumental);
        }

        // POST: SistemaArchivos_CatalogoVigenciaDocumental/Delete/5
        [HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
           
            string msj = "El registro ha sido eliminado existosamente!";
            if (ModelState.IsValid)
            {

                try
                {
                    
                        using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                        {
                           

                            ArchivoConcentracion_ptArchivoDocumental archivoconcentracion_ptArchivoDocumental = db.ArchivoConcentracion_ptArchivoDocumental.Find(id);
                            db.ArchivoConcentracion_ptArchivoDocumental.Remove(archivoconcentracion_ptArchivoDocumental);
                            db.SaveChanges();



                            trans.Complete();
                        }
                    
                   
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
