﻿using Dapper;
using DevExpress.Web.ASPxHtmlEditor.Internal;
using Nova.Models;
using Rotativa;
using Seguridad;
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.IO;
using System.Linq;
using System.Net;
using System.Transactions;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers.SistemaArchivos.Catalogos
{
    public class SistemaArchivos_DocumentalTramiteAdmController :  BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        string query = @"select a.IdArchivoDocumental,b.IdKardexResponsableEstructuraSeccion,a.ClaveExpediente, a.Contenido, a.FechaElaboracion, a.FechaUltimaModificacion, a.FechaValidacion,a.Anio, h.EstructuraOrganica
                        , h.Direccion,a.UbicacionTopografica,a.Observaciones,a.Validado
                        , j.Nombre as NombreResponsable, j.ApellidoPaterno as ApellidoPaternoResponsable, j.ApellidoMaterno as ApellidoMaternoResponsable
                        ,b.Seccion, b.NombreSeccion, b.Serie, b.NombreSerie, b.Subserie, b.NombreSubserie, b.ValosDocumental_Administrativo, b.ValosDocumental_Legal, b.ValosDocumental_Fiscal
                        , b.Clasificacion_Publica, b.Clasificacion_Reservada, b.Clasificacion_Confidencial, b.VigenciaDoc_Tramite, b.VigenciaDoc_Concentrado, b.EsVigente, 
                        b.Anio, c.Caja,
                        d.Nombre as NombreCreador, d.ApellidoPaterno as ApellidoPaternoCreador, d.ApellidoMaterno as ApellidoMaternoCreador
                        , j.Nombre as NombreActualizo, j.ApellidoPaterno as ApellidoPaternoActualizo, j.ApellidoMaterno as ApellidoMaternoActualizo
                        ,g.Estatus,a.Medida,a.Capacidad
                        

                         from ArchivoConcentracion_ptArchivoDocumental a
                        
                        inner join ArchivoConcentracion_ptEstructuraOrganicaSeccionResponsable b on a.IdEstructuraOrganicaSeccionResponsable = b.IdEstructuraOrganicaSeccionResponsable
                        inner join Catalogos_ctEstructuraOrganica h on b.IdEstructuraOrganica = h.IdEstructuraOrganica
                         inner join ArchivoConcentracion_ctCajas c on a.IdCaja = c.IdCaja
                        inner join Kardex_ctDatosPersonales d on a.IdKardexCreador = d.IdKardex
                        inner join Kardex_ctDatosPersonales f on a.IdKardexActualizo = f.IdKardex
                        inner join Kardex_ctDatosPersonales j on b.IdKardexResponsableEstructuraSeccion = j.IdKardex
                        inner join ArchivoConcentracion_ctEstatus g on a.IdEstatus = g.IdEstatus
                        where g.Estatus='Trámite' 
	                    order by a.IdArchivoDocumental asc ";


        string queryreportes = @"select a.IdArchivoDocumental,b.IdKardexResponsableEstructuraSeccion,a.ClaveExpediente, a.Contenido, a.FechaElaboracion, a.FechaUltimaModificacion, a.FechaValidacion,a.Anio, h.EstructuraOrganica
                        , h.Direccion,a.UbicacionTopografica,a.Observaciones
                        , j.Nombre as NombreResponsable, j.ApellidoPaterno as ApellidoPaternoResponsable, j.ApellidoMaterno as ApellidoMaternoResponsable
                        ,b.Seccion, b.NombreSeccion, b.Serie, b.NombreSerie, b.Subserie, b.NombreSubserie, b.ValosDocumental_Administrativo, b.ValosDocumental_Legal, b.ValosDocumental_Fiscal
                        , b.Clasificacion_Publica, b.Clasificacion_Reservada, b.Clasificacion_Confidencial, b.VigenciaDoc_Tramite, b.VigenciaDoc_Concentrado, b.EsVigente, 
                        b.Anio, c.Caja,
                        d.Nombre as NombreCreador, d.ApellidoPaterno as ApellidoPaternoCreador, d.ApellidoMaterno as ApellidoMaternoCreador
                        , j.Nombre as NombreActualizo, j.ApellidoPaterno as ApellidoPaternoActualizo, j.ApellidoMaterno as ApellidoMaternoActualizo
                        ,g.Estatus,a.Medida,a.Capacidad
                        ,k.Nombre as NombreElaboro, k.ApellidoPaterno as ApellidoPaternoElaboro, k.ApellidoMaterno as ApellidoMaternoElaboro,a.IdKardexElaboro,a.NumeroProgresivo
                        
                        ,x1.NumTransferencia,x.NumeroFojas,x.FechaApertura,x.FechaCierre,x .Orden
						,x1.Transferencia,x2.DestinoFinal,x3.Fojas,x4.Caja as CajaInventario ,x5.Anaqueles,x6.ValorSecundario
						,x.FechaTerminoVigencia,x.DescripcionExpediente,x.FechaDictamen,x.FechaActa,x.FechaBaja, x.FechaHistorico,x.FechaConcentracion
                         from ArchivoConcentracion_ptArchivoDocumental a
                        
                        inner join ArchivoConcentracion_ptEstructuraOrganicaSeccionResponsable b on a.IdEstructuraOrganicaSeccionResponsable = b.IdEstructuraOrganicaSeccionResponsable
                        inner join Catalogos_ctEstructuraOrganica h on b.IdEstructuraOrganica = h.IdEstructuraOrganica
                        inner join ArchivoConcentracion_ctCajas c on a.IdCaja = c.IdCaja
                        inner join Kardex_ctDatosPersonales d on a.IdKardexCreador = d.IdKardex
                        inner join Kardex_ctDatosPersonales f on a.IdKardexActualizo = f.IdKardex
                        inner join Kardex_ctDatosPersonales k on a.IdKardexElaboro = k.IdKardex
                        inner join Kardex_ctDatosPersonales j on b.IdKardexResponsableEstructuraSeccion = j.IdKardex
                        inner join ArchivoConcentracion_ctEstatus g on a.IdEstatus = g.IdEstatus
                        left join ArchivoConcentracion_ptInventarioDocumental x on a.IdArchivoDocumental = x.IdArchivoDocumental
						 left join ArchivoConcentracion_ctTransferencia x1 on x1.IdTransferencia = x.IdTransferencia
						  left join ArchivoConcentracion_ctDestinoFinal x2 on x2.IdDestinoFinal = x.IdDestinoFinal
						 left join ArchivoConcentracion_ctFojas x3 on x3.IdFojas = x.IdFojas
						 left join ArchivoConcentracion_ctCajas x4 on x4.IdCaja = x.IdCaja
						  left join ArchivoConcentracion_ctAnaqueles x5 on x5.IdAnaqueles = x.IdAnaquel
						  left join ArchivoConcentracion_ctValorSecundario x6 on x6.IdValorSecundario = x.IdValorSecundario
                         where b.IdKardexResponsableEstructuraSeccion = @IdKardex {0} 
                        order by a.NumeroProgresivo, a.IdArchivoDocumental asc ";


        // 2. Query principal con posible filtro por responsable

        string querytodos = @"
                        SELECT a.IdArchivoDocumental, b.IdKardexResponsableEstructuraSeccion, a.ClaveExpediente, a.Contenido, 
                               a.FechaElaboracion, a.FechaUltimaModificacion, a.FechaValidacion, a.Anio, h.EstructuraOrganica,
                               h.Direccion, a.UbicacionTopografica, a.Observaciones, a.Validado,
                               j.Nombre AS NombreResponsable, j.ApellidoPaterno AS ApellidoPaternoResponsable, j.ApellidoMaterno AS ApellidoMaternoResponsable,
                               b.Seccion, b.NombreSeccion, b.Serie, b.NombreSerie, b.Subserie, b.NombreSubserie, 
                               b.ValosDocumental_Administrativo, b.ValosDocumental_Legal, b.ValosDocumental_Fiscal,
                               b.Clasificacion_Publica, b.Clasificacion_Reservada, b.Clasificacion_Confidencial, 
                               b.VigenciaDoc_Tramite, b.VigenciaDoc_Concentrado, b.EsVigente, 
                               b.Anio, c.Caja,
                               d.Nombre AS NombreCreador, d.ApellidoPaterno AS ApellidoPaternoCreador, d.ApellidoMaterno AS ApellidoMaternoCreador,
                               j.Nombre AS NombreActualizo, j.ApellidoPaterno AS ApellidoPaternoActualizo, j.ApellidoMaterno AS ApellidoMaternoActualizo,
                               g.Estatus
                        FROM ArchivoConcentracion_ptArchivoDocumental a
                        INNER JOIN ArchivoConcentracion_ptEstructuraOrganicaSeccionResponsable b ON a.IdEstructuraOrganicaSeccionResponsable = b.IdEstructuraOrganicaSeccionResponsable
                        INNER JOIN Catalogos_ctEstructuraOrganica h ON b.IdEstructuraOrganica = h.IdEstructuraOrganica
                        INNER JOIN ArchivoConcentracion_ctCajas c ON a.IdCaja = c.IdCaja
                        INNER JOIN Kardex_ctDatosPersonales d ON a.IdKardexCreador = d.IdKardex
                        INNER JOIN Kardex_ctDatosPersonales f ON a.IdKardexActualizo = f.IdKardex
                        INNER JOIN Kardex_ctDatosPersonales j ON b.IdKardexResponsableEstructuraSeccion = j.IdKardex
                        INNER JOIN ArchivoConcentracion_ctEstatus g ON a.IdEstatus = g.IdEstatus
                        WHERE g.Estatus = 'Trámite'
                          AND (@IdResponsable IS NULL OR j.IdKardex = @IdResponsable)
                        ORDER BY a.IdArchivoDocumental ASC";

        string querytodosadm = @"select a.IdArchivoDocumental,b.IdKardexResponsableEstructuraSeccion,a.ClaveExpediente, a.Contenido, a.FechaElaboracion, a.FechaUltimaModificacion, a.FechaValidacion,a.Anio, h.EstructuraOrganica
                        , h.Direccion,a.UbicacionTopografica,a.Observaciones
                        , j.Nombre as NombreResponsable, j.ApellidoPaterno as ApellidoPaternoResponsable, j.ApellidoMaterno as ApellidoMaternoResponsable
                        ,b.Seccion, b.NombreSeccion, b.Serie, b.NombreSerie, b.Subserie, b.NombreSubserie, b.ValosDocumental_Administrativo, b.ValosDocumental_Legal, b.ValosDocumental_Fiscal
                        , b.Clasificacion_Publica, b.Clasificacion_Reservada, b.Clasificacion_Confidencial, b.VigenciaDoc_Tramite, b.VigenciaDoc_Concentrado, b.EsVigente, 
                        b.Anio, c.Caja,
                        d.Nombre as NombreCreador, d.ApellidoPaterno as ApellidoPaternoCreador, d.ApellidoMaterno as ApellidoMaternoCreador
                        , j.Nombre as NombreActualizo, j.ApellidoPaterno as ApellidoPaternoActualizo, j.ApellidoMaterno as ApellidoMaternoActualizo
                        ,g.Estatus,a.Medida,a.Capacidad
                        ,k.Nombre as NombreElaboro, k.ApellidoPaterno as ApellidoPaternoElaboro, k.ApellidoMaterno as ApellidoMaternoElaboro,a.IdKardexElaboro,a.NumeroProgresivo
                        
                        ,x1.NumTransferencia,x.NumeroFojas,x.FechaApertura,x.FechaCierre,x .Orden
						,x1.Transferencia,x2.DestinoFinal,x3.Fojas,x4.Caja as CajaInventario ,x5.Anaqueles,x6.ValorSecundario
						,x.FechaTerminoVigencia,x.DescripcionExpediente,x.FechaDictamen,x.FechaActa,x.FechaBaja, x.FechaHistorico,x.FechaConcentracion
                         from ArchivoConcentracion_ptArchivoDocumental a
                        
                        inner join ArchivoConcentracion_ptEstructuraOrganicaSeccionResponsable b on a.IdEstructuraOrganicaSeccionResponsable = b.IdEstructuraOrganicaSeccionResponsable
                        inner join Catalogos_ctEstructuraOrganica h on b.IdEstructuraOrganica = h.IdEstructuraOrganica
                        inner join ArchivoConcentracion_ctCajas c on a.IdCaja = c.IdCaja
                        inner join Kardex_ctDatosPersonales d on a.IdKardexCreador = d.IdKardex
                        inner join Kardex_ctDatosPersonales f on a.IdKardexActualizo = f.IdKardex
                        inner join Kardex_ctDatosPersonales k on a.IdKardexElaboro = k.IdKardex
                        inner join Kardex_ctDatosPersonales j on b.IdKardexResponsableEstructuraSeccion = j.IdKardex
                        inner join ArchivoConcentracion_ctEstatus g on a.IdEstatus = g.IdEstatus
                        left join ArchivoConcentracion_ptInventarioDocumental x on a.IdArchivoDocumental = x.IdArchivoDocumental
						 left join ArchivoConcentracion_ctTransferencia x1 on x1.IdTransferencia = x.IdTransferencia
						  left join ArchivoConcentracion_ctDestinoFinal x2 on x2.IdDestinoFinal = x.IdDestinoFinal
						 left join ArchivoConcentracion_ctFojas x3 on x3.IdFojas = x.IdFojas
						 left join ArchivoConcentracion_ctCajas x4 on x4.IdCaja = x.IdCaja
						  left join ArchivoConcentracion_ctAnaqueles x5 on x5.IdAnaqueles = x.IdAnaquel
						  left join ArchivoConcentracion_ctValorSecundario x6 on x6.IdValorSecundario = x.IdValorSecundario

                        
                         where   (@IdResponsable IS NULL OR j.IdKardex = @IdResponsable {0})  
                        order by a.NumeroProgresivo, a.IdArchivoDocumental asc ";

        // GET: SistemaArchivos_CatalogoVigenciaDocumental
        public ActionResult Index()
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var datosArchivos = (List<DatosArchivos>)dp.connection.Query<DatosArchivos>(query);
            dp.Close();

            return View(datosArchivos.OrderByDescending(a => a.IdArchivoDocumental).ToList());  // Ordenar por IdVigenciaDocumental de forma descendente
              
           
        }



        public ActionResult ReporteAdmin(int? idResponsable)
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            string queryresponsables = @"SELECT DISTINCT j.IdKardex, 
                             j.Nombre AS NombreResponsable, 
                             j.ApellidoPaterno AS ApellidoPaternoResponsable, 
                             j.ApellidoMaterno AS ApellidoMaternoResponsable
                             FROM ArchivoConcentracion_ptEstructuraOrganicaSeccionResponsable b
                             INNER JOIN Kardex_ctDatosPersonales j ON b.IdKardexResponsableEstructuraSeccion = j.IdKardex ";
            var responsables = (List<ResponsableDTO>)dp.connection.Query<ResponsableDTO>(queryresponsables);
         
            ViewBag.Responsables = new SelectList(responsables, "IdKardex", "NombreCompleto");
           
              

                var datosArchivos = dp.connection
                                      .Query<DatosArchivos>(querytodos, new { IdResponsable = idResponsable })
                                      .ToList();
            dp.Close();
            return View(datosArchivos);
            
        }


        public ActionResult GestionAdmin(int? idResponsable, int? idEstatus)
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            string queryresponsables = @"SELECT DISTINCT j.IdKardex, 
                             j.Nombre AS NombreResponsable, 
                             j.ApellidoPaterno AS ApellidoPaternoResponsable, 
                             j.ApellidoMaterno AS ApellidoMaternoResponsable
                             FROM ArchivoConcentracion_ptEstructuraOrganicaSeccionResponsable b
                             INNER JOIN Kardex_ctDatosPersonales j ON b.IdKardexResponsableEstructuraSeccion = j.IdKardex ";
            var responsables = (List<ResponsableDTO>)dp.connection.Query<ResponsableDTO>(queryresponsables);

            ViewBag.Responsables = new SelectList(responsables, "IdKardex", "NombreCompleto");
            ViewBag.IdEstatus = new SelectList(db.ArchivoConcentracion_ctEstatus, "IdEstatus", "Estatus", idEstatus);

            // Agregar condición si hay estatus seleccionado
            string filtroEstatus = "";
            if (idEstatus.HasValue)
            {
                filtroEstatus = "AND g.IdEstatus = @IdEstatus";
            }

            querytodosadm = string.Format(querytodosadm, filtroEstatus);




            var datosArchivos = dp.connection
                                  .Query<DatosArchivos>(querytodosadm, new { IdResponsable = idResponsable, IdEstatus = idEstatus })
                                  .ToList();
            dp.Close();
            return View(datosArchivos);

        }


        public ActionResult ReporteArchivosTramitePdf(int? idResponsable)
        {
            int? idEstatus = db.ArchivoConcentracion_ctEstatus.Where(a => a.Estatus == "Trámite").FirstOrDefault().IdEstatus;

            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            int? IdKardex = idResponsable;
            // Agregar condición si hay estatus seleccionado
            string filtroEstatus = "";
            if (idEstatus.HasValue)
            {
                filtroEstatus = "AND g.IdEstatus = @IdEstatus";
            }

            queryreportes = string.Format(queryreportes, filtroEstatus);

            var result = (List<DatosArchivos>)dp.connection.Query<DatosArchivos>(queryreportes, new { IdKardex, IdEstatus = idEstatus });



            dp.Close();

            string modalidad = "ReporteArchivosTramite" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";


            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;


            ////return View("IncidenciasporAplicar", result.ToList());
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };


        }


        public ActionResult ReporteArchivosConcentracionPdf(int? idResponsable)
        {
            int? idEstatus = db.ArchivoConcentracion_ctEstatus.Where(a => a.Estatus == "Concentración").FirstOrDefault().IdEstatus;

            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            int? IdKardex = idResponsable;
            // Agregar condición si hay estatus seleccionado
            string filtroEstatus = "";
            if (idEstatus.HasValue)
            {
                filtroEstatus = "AND g.IdEstatus = @IdEstatus";
            }

            queryreportes = string.Format(queryreportes, filtroEstatus);

            var result = (List<DatosArchivos>)dp.connection.Query<DatosArchivos>(queryreportes, new { IdKardex, IdEstatus = idEstatus });



            dp.Close();

            string modalidad = "ReporteArchivosConcentracion" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";


            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;


            ////return View("IncidenciasporAplicar", result.ToList());
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };


        }



        public ActionResult ReporteArchivosHistoricoPdf(int? idResponsable)
        {
            int? idEstatus = db.ArchivoConcentracion_ctEstatus.Where(a => a.Estatus == "Histórico").FirstOrDefault().IdEstatus;

            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            int? IdKardex = idResponsable;
            // Agregar condición si hay estatus seleccionado
            string filtroEstatus = "";
            if (idEstatus.HasValue)
            {
                filtroEstatus = "AND g.IdEstatus = @IdEstatus";
            }

            queryreportes = string.Format(queryreportes, filtroEstatus);

            var result = (List<DatosArchivos>)dp.connection.Query<DatosArchivos>(queryreportes, new { IdKardex, IdEstatus = idEstatus });



            dp.Close();

            string modalidad = "ReporteArchivosHistorico" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";


            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;


            ////return View("IncidenciasporAplicar", result.ToList());
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };


        }

        public ActionResult ReporteArchivosBajaPdf(int? idResponsable)

        {
            int? idEstatus = db.ArchivoConcentracion_ctEstatus.Where(a => a.Estatus == "Baja").FirstOrDefault().IdEstatus;

            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            int? IdKardex = idResponsable;
            // Agregar condición si hay estatus seleccionado
            string filtroEstatus = "";
            if (idEstatus.HasValue)
            {
                filtroEstatus = "AND g.IdEstatus = @IdEstatus";
            }

            queryreportes = string.Format(queryreportes, filtroEstatus);

            var result = (List<DatosArchivos>)dp.connection.Query<DatosArchivos>(queryreportes, new { IdKardex, IdEstatus = idEstatus });



            dp.Close();

            string modalidad = "ReporteArchivosBaja" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";


            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;


            ////return View("IncidenciasporAplicar", result.ToList());
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };


        }


        [HttpPost]
        public ActionResult ReporteArchivosTramitePdfAdmin(int? idResponsable)
        {

            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            //int IdKardex = 252;
            var result = (List<DatosArchivos>)dp.connection.Query<DatosArchivos>(querytodos, new { IdResponsable = idResponsable });




            dp.Close();

            string modalidad = "ReporteArchivosTramite" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";


            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;


            ////return View("IncidenciasporAplicar", result.ToList());
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };


        }


        [HttpPost]
        public ActionResult BorrarIncidenciasSeleccionadas(string valores)
        {
            List<string> valoresLista = valores.Split(',').ToList();

            DapperQuery dp = new DapperQuery("bdNovaEntities");

            var usuario = Seguridad.Identidad.Usuario();

            String updatesql = $@"Update ArchivoConcentracion_ptArchivoDocumental 
            set Validado= 1
            where   IdArchivoDocumental in ({valores})";
            dp.connection.Execute(updatesql);


            dp.Close();

            return JsonView(true, $"Se han validado {valoresLista.Count()} registros en la base de datos");


        }

        [HttpPost]
        public ActionResult AgregarIncidenciasSeleccionadas(string valores)
        {
            List<string> valoresLista = valores.Split(',').ToList();

            DapperQuery dp = new DapperQuery("bdNovaEntities");

            var usuario = Seguridad.Identidad.Usuario();

            String updatesql = $@"Update ArchivoConcentracion_ptArchivoDocumental 
            set Validado= 0
            where   IdArchivoDocumental in ({valores})";
            dp.connection.Execute(updatesql);


            dp.Close();

            return JsonView(true, $"Se han validado {valoresLista.Count()} registros en la base de datos");


        }




        // GET: SistemaArchivos_CatalogoVigenciaDocumental/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ArchivoConcentracion_ptArchivoDocumental archivoconcentracion_ptArchivoDocumental = db.ArchivoConcentracion_ptArchivoDocumental.Find(id);
            if (archivoconcentracion_ptArchivoDocumental == null)
            {
                return HttpNotFound();
            }
            return View(archivoconcentracion_ptArchivoDocumental);
        }

        // GET: SistemaArchivos_CatalogoVigenciaDocumental/Create
        public ActionResult Create()
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            var IdEstructuraOrgResp = db.ArchivoConcentracion_ptEstructuraOrganicaSeccionResponsable.Where(a => a.IdKardexResponsableEstructuraSeccion == IdKardex).ToList();

            // Supón que "nombres" es tu lista original
            var nombres = db.vwDatosAspirantesTrabajadores
                                .Where(e => e.EstatusTrabajador == "ALTA" && e.IdModalidadEstudio == 0)
                                .ToList();

            // Concatenar los campos NombreCompleto y Apellido
            var IdEstructuraOrganicaResp = IdEstructuraOrgResp.Select(n => new
            {
                IdEstructuraOrganicaSeccionResponsable = n.IdEstructuraOrganicaSeccionResponsable,
                SeccionSerie = n.Serie + " " + n.NombreSerie   // Concatenar NombreCompleto y Apellido
            }).ToList();

            // Crear el SelectList con la propiedad concatenada
            ViewBag.IdEstructuraOrganicaSeccionResponsable = new SelectList(IdEstructuraOrganicaResp, "IdEstructuraOrganicaSeccionResponsable", "SeccionSerie");
                     
            ViewBag.IdCaja = new SelectList(db.ArchivoConcentracion_ctCajas, "IdCaja", "Caja");
            
        
            return PartialView();
        }

        //POST: SistemaArchivos_CatalogoVigenciaDocumental/Create
        //Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse.Para obtener
        //más información vea https://go.microsoft.com/fwlink/?LinkId=317598.

       [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdArchivoDocumental, IdEstructuraOrganicaSeccionResponsable, ClaveExpediente, Contenido, IdCaja, IdKardexCreador, FechaElaboracion, FechaUltimaModificacion, FechaValidacion, IdKardexActualizo, Anio, IdEstatus,UbicacionTopografica,Observaciones,Validado")] ArchivoConcentracion_ptArchivoDocumental archivoconcentracion_ptArchivoDocumental)
        {

            DapperQuery dp = new DapperQuery("bdNovaEntities");

                string updatesql = @"
                UPDATE ArchivoConcentracion_ptArchivoDocumental 
                SET FechaValidacion = @FechaValidacion
                ";

            // Ejecutamos la consulta con los parámetros
            dp.connection.Execute(updatesql, new
            {
                FechaValidacion = archivoconcentracion_ptArchivoDocumental.FechaValidacion,
               
            });
            dp.Close();


            return JsonView(ModelState.IsValid, "El archivo se agregado satisfactoriamente");


        }

     



        // GET: SistemaArchivos_CatalogoVigenciaDocumental/Edit/5
        public ActionResult Edit(int id)
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;


            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }

            ArchivoConcentracion_ptArchivoDocumental archivoconcentracion_ptArchivoDocumental = db.ArchivoConcentracion_ptArchivoDocumental.Find(id);
            var IdEstructuraOrgResp = db.ArchivoConcentracion_ptEstructuraOrganicaSeccionResponsable.Where(a => a.IdKardexResponsableEstructuraSeccion == IdKardex).ToList();


            
            var IdEstructuraOrganicaResp = IdEstructuraOrgResp.Select(n => new
            {
                IdEstructuraOrganicaSeccionResponsable = n.IdEstructuraOrganicaSeccionResponsable,
                SeccionSerie = n.Serie + " " + n.NombreSerie   // Concatenar NombreCompleto y Apellido
            }).ToList();

            // Crear el SelectList con la propiedad concatenada
            ViewBag.IdEstructuraOrganicaSeccionResponsable = new SelectList(IdEstructuraOrganicaResp, "IdEstructuraOrganicaSeccionResponsable", "SeccionSerie", archivoconcentracion_ptArchivoDocumental.IdArchivoDocumental);


            ViewBag.IdCaja = new SelectList(db.ArchivoConcentracion_ctCajas, "IdCaja", "Caja",archivoconcentracion_ptArchivoDocumental.IdCaja);

            ViewBag.IdEstatus = new SelectList(db.ArchivoConcentracion_ctEstatus, "IdEstatus", "Estatus", archivoconcentracion_ptArchivoDocumental.IdEstatus);


            if (archivoconcentracion_ptArchivoDocumental == null)
            {
                return HttpNotFound();
            }
            return View(archivoconcentracion_ptArchivoDocumental);
        }

        // POST: SistemaArchivos_CatalogoVigenciaDocumental/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdArchivoDocumental, IdEstructuraOrganicaSeccionResponsable, ClaveExpediente, Contenido, IdCaja, IdKardexCreador, FechaElaboracion, FechaUltimaModificacion, FechaValidacion, IdKardexActualizo, Anio, IdEstatus,UbicacionTopografica,Observaciones,Validado")] ArchivoConcentracion_ptArchivoDocumental archivoconcentracion_ptArchivoDocumental)
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            //ArchivoConcentracion_ptArchivoDocumental ptArchivoDocumental = new ArchivoConcentracion_ptArchivoDocumental();
            ArchivoConcentracion_ptArchivoDocumentalHistoriales ptArchivoDocumentalHistorial = new ArchivoConcentracion_ptArchivoDocumentalHistoriales();

            if (ModelState.IsValid)
            {
                var ptArchivoDocumental = db.ArchivoConcentracion_ptArchivoDocumental
                .FirstOrDefault(x => x.IdArchivoDocumental == archivoconcentracion_ptArchivoDocumental.IdArchivoDocumental);
                try
                {
                    if (ptArchivoDocumental == null)
                    {
                        return Json(new { Valid = false, Message = "El archivo no fue encontrado en la base de datos." });
                    }
                    using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                    {
                        // Asignar los valores que se han recibido en el modelo de vista
                        ptArchivoDocumental.UbicacionTopografica = archivoconcentracion_ptArchivoDocumental.UbicacionTopografica;
                        ptArchivoDocumental.Anio = archivoconcentracion_ptArchivoDocumental.Anio;
                        ptArchivoDocumental.Observaciones = archivoconcentracion_ptArchivoDocumental.Observaciones;
                        ptArchivoDocumental.FechaUltimaModificacion = DateTime.Now;
                        ptArchivoDocumental.IdKardexActualizo = IdKardex;
                        ptArchivoDocumental.Validado = false; // Si este es el nuevo valor

                        // No es necesario usar EntityState.Modified aquí si estás modificando una entidad existente
                        // Entity Framework detectará los cambios automáticamente

                        // Guardar los cambios en la base de datos
                        db.SaveChanges();

                        ptArchivoDocumentalHistorial.IdArchivoDocumental = ptArchivoDocumental.IdArchivoDocumental;
                        ptArchivoDocumentalHistorial.UbicacionTopografica = archivoconcentracion_ptArchivoDocumental.UbicacionTopografica;
                        ptArchivoDocumentalHistorial.Observaciones = archivoconcentracion_ptArchivoDocumental.Observaciones;
                        ptArchivoDocumentalHistorial.Anio = archivoconcentracion_ptArchivoDocumental.Anio;
                        ptArchivoDocumentalHistorial.IdKardexActualizo = IdKardex;
                        ptArchivoDocumentalHistorial.FechaModificacion = DateTime.Now;
                        ptArchivoDocumentalHistorial.ClaveExpediente = ptArchivoDocumental.ClaveExpediente;
                        ptArchivoDocumentalHistorial.IdEstatus = ptArchivoDocumental.IdEstatus;
                        db.ArchivoConcentracion_ptArchivoDocumentalHistoriales.Add(ptArchivoDocumentalHistorial);
                        db.SaveChanges();
                        trans.Complete();
                    }
                    return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                    


                    
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
               
            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // GET: SistemaArchivos_CatalogoVigenciaDocumental/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ArchivoConcentracion_ptArchivoDocumental archivoconcentracion_ptArchivoDocumental = db.ArchivoConcentracion_ptArchivoDocumental.Find(id);
            if (archivoconcentracion_ptArchivoDocumental == null)
            {
                return HttpNotFound();
            }
            return View(archivoconcentracion_ptArchivoDocumental);
        }

        // POST: SistemaArchivos_CatalogoVigenciaDocumental/Delete/5
        [HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
           
            string msj = "El registro ha sido eliminado existosamente!";
            if (ModelState.IsValid)
            {

                try
                {
                    
                        using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                        {
                           

                            ArchivoConcentracion_ptArchivoDocumental archivoconcentracion_ptArchivoDocumental = db.ArchivoConcentracion_ptArchivoDocumental.Find(id);
                            db.ArchivoConcentracion_ptArchivoDocumental.Remove(archivoconcentracion_ptArchivoDocumental);
                            db.SaveChanges();



                            trans.Complete();
                        }
                    
                   
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
